/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerSanJoseUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String SESSIONIDPLACHOLDER = "{session-id}";
    public static final String BITRATEPLACHOLDER = "{bitrate}";
    public static final String KBITRATEPLACHOLDER = "{kbitrate}";
    public static final String BOOTSTRAPIDPLACEHOLDER = "{bootstrapId}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String PLAYLISTPLACHOLDER = "playlist_b{bitrate}_w{session-id}.abst{query}";
    public static final String PLAYSTARTPLACHOLDER = "{playStart}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDuration}";
    public static final String MEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}.abst/";
    public static final String VODMEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}{playStart}{playDuration}.abst/";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "http://{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = Base64.endsWith((String)"k24", (int)(41 * 61));
        switch (n) {
            case 2: {
                string = FileChunk.substring((int)(-41 - 19), (String)"j(6t");
            }
            default: {
                return string;
            }
            case 3: 
        }
        return Base64.endsWith((String)"(fij", (int)(243 / 36));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseEncInfo sanJoseEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingSanJoseBlock> arrayList;
        List<LiveStreamingSanJoseBlock> list;
        Cipher cipher;
        if (sanJoseEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info(Base64.endsWith((String)"[qo\u007fHho{~mQc`o`rnrlxXmcD`ct<ux`e\u007fHxypyim%` &'\u0006*3)+0\t*?9\"*\u000341&&<\".\b+5-59;-za", (int)(25 * 47)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(sanJoseEncInfo.getEncKeyBytes(), FileChunk.substring((int)(-59 - 15), (String)"WRK"));
            long l = liveStreamPacketizerSanJoseChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(FileChunk.substring((int)(20 + 85), (String)"\b\u000f\u0018c\u000e\f\f\u007f\u0001\u0019\u0010\u0007b\u00066<=35;"), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerSanJoseChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingSanJoseBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error(Base64.endsWith((String)"\u001f=#3\u0004,+?:1\r?<+$6*> 4\u0014)'\u0000$?(\u001b;9=!}1;5%!).\u00184(04:!CFW(750)oeo\u007fw\u007fdx}}.5", (int)(47 * 29)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerSanJoseChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = list.get(n);
            n4 += liveStreamingSanJoseBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen()) : cipher.update(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingSanJoseBlock liveStreamingSanJoseBlock2 = new LiveStreamingSanJoseBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingSanJoseBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SanJoseEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.endsWith((String)"i#,3", (int)(23 - -48)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(Base64.endsWith((String)"ptk", (int)(1330 / 225)));
            if (string3 != null || (string3 = (String)object.get(Base64.endsWith((String)":\"8", (int)(3 * 37)))) != null || (string3 = (String)object.get(FileChunk.substring((int)(18 + 61), (String)",%!7! <88+-(>=071'l#&7tt\u007fe<8'"))) != null || (string3 = (String)object.get(Base64.endsWith((String)"leawa`|xxkmh~}pwqg,cfw44?%|xb", (int)(5 * 3)))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.endsWith((String)"mbq", (int)(699 / 110)))) != null || (string2 = (String)object.get(Base64.endsWith((String)"gpvbz}cec~z}up\u007fzzr;v}j+)$0uzy", (int)(-32 - -36)))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() != 32) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.endsWith((String)"OmscT|{oja]ol{tfznpdTmi\u007fihtpp.hljp?&Lmp*gici{x1{}wzde}zn5<Pkl4a &dtpg*0>.?mf|bq1;5'74,<((u}20.&b\u0018", (int)(246 / 70)) + file + FileChunk.substring((int)(39 * 43), (String)"P4/") + string2.length());
                } else {
                    byArray = BufferUtils.decodeHexString((String)string2);
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new SanJoseEncInfo(string2, byArray, string3);
    }
}

