/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYSTR_NODVR_PLACHOLDER = "{query_no_dvr}";
    public static final String RESOLUTIONPLACEHOLDER = "{resolution}";
    public static final String RESOLUTIONWIDTHPLACEHOLDER = "{resolution-width}";
    public static final String RESOLUTIONHEIGHTPLACEHOLDER = "{resolution-height}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String PLAYSTARTNAME = "{playStartName}";
    public static final String PLAYSTARTVALUE = "{playStartValue}";
    public static final String PLAYSTARTPLACHOLDER = "{playStartName}={playStartValue}";
    public static final String PLAYDURATIONNAME = "{playDurationName}";
    public static final String PLAYDURATIONVALUE = "{playDurationValue}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDurationName}={playDurationValue}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCIVPLACEHOLDER = "{encIV}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String ENCKEYSTRWITHIV = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\",IV=\"{encIV}\"";
    public static final String DISCONTINUITYSTR = "#EXT-X-DISCONTINUITY";
    public static final String RESOLUTIONSTR = ",RESOLUTION={resolution-width}x{resolution-height}";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.substring((int)(74 + 32), (String)"d??");
        switch (n) {
            case 2: {
                string = FileChunk.substring((int)(11 * 5), (String)"9ui)");
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.substring((int)(57 * 11), (String)"}545");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingCupertinoBlock> arrayList;
        List<LiveStreamingCupertinoBlock> list;
        Cipher cipher;
        if (cupertinoEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info(Base64.endsWith((String)"\u0013iwgPpwcfeYkhghzfjt`Paeselptt2{rjsiRbgncs{3*jhiL`e\u007fqjWtect|I~\u007fhlv48\u00121+3/#-;pk", (int)(17 * 15)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), FileChunk.substring((int)(-51 - -26), (String)"\u0006\r\u001a"));
            long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(Base64.endsWith((String)"E@U(KKI$\\FM\\'Aswp|xp", (int)(652 / 142)), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerCupertinoChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.endsWith((String)"\u0002&&4\u0001'&07:\b8909)7%esAvt`tsage^xdb|>t|pflfc[qouw'>^ER/26=&bfjxr|yg`~+2", (int)(13 - 31)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(n);
            n4 += liveStreamingCupertinoBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingCupertinoBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + FileChunk.substring((int)(1224 / 220), (String)"+mbq"));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(FileChunk.substring((int)(801 / 115), (String)"sud"));
            if (string3 != null || (string3 = (String)object.get(Base64.endsWith((String)"nnt", (int)(-36 + 95)))) != null || (string3 = (String)object.get(Base64.endsWith((String)"leawa`|xxkmh~}pwqg,cfw44?%|xg", (int)(53 * 51)))) != null || (string3 = (String)object.get(Base64.endsWith((String)"2'#1'\">66)/.8?2ioe.e`u6:1'~~d", (int)(55 * 23)))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.endsWith((String)";4+", (int)(41 + 71)))) != null || (string2 = (String)object.get(Base64.endsWith((String)"\"73!72.&&9?>(/\"9?5~50%fjaw09$", (int)(62 + 35)))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.endsWith((String)"Ka\u007foXx\u007fkn}Asp\u007fpb~b|hXim{mthll*lhn|3*@it.cu\u007fug|5\u007fy{vhiy~j1`\f700e$\"hx|k.4:*#qz`fu5?9+;8(8,,ia.,*\"f\u001c", (int)(19 * 61)) + file + Base64.endsWith((String)"[=(", (int)(807 / 122)) + string2.length());
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new CupertinoEncInfo(string2, byArray, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n > 0) return n;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 2: {
                string = Base64.endsWith((String)"}a&r:!&9", (int)(2 + 14)) + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 10: 
        }
        if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
        return FileChunk.substring((int)(29 + 41), (String)"+7|(d\u007f|c") + mediaCodecInfoAudio.getAudioObjectType();
    }

    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return LiveStreamPacketizerCupertinoUtils.codecInfoVideoToCodecsStr(mediaCodecInfoVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo, boolean bl) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            case 7: {
                if (!bl) break;
                return Base64.endsWith((String)"ese6&?<%?=", (int)(1129 / 226));
            }
            default: {
                return string;
            }
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return Base64.endsWith((String)"wa{(4", (int)(16 + 6)) + n2 + "." + n;
    }
}

