/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;

public class TranscoderSessionBitrateCalculator {
    protected boolean calculating = true;
    protected long startTimecode = -1L;
    protected int bitrateCalculatorDuration = 3000;
    protected int bitrateCalculatorDefaultAudioDuration = 30;
    protected int bitrateCalculatorDefaultVideoDuration = 30;
    protected int bitrateCalculatorMaxAudioDuration = 1000;
    protected int bitrateCalculatorMaxVideoDuration = 1000;
    protected CalculatorValues audioValues = new CalculatorValues();
    protected CalculatorValues videoValues = new CalculatorValues();

    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        WMSProperties wMSProperties = liveStreamTranscoder.getProperties();
        this.bitrateCalculatorDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(87 + -30), (String)"{son|jz\u0003 . 1)'3';\u000e>>,:&??"), this.bitrateCalculatorDuration);
        this.bitrateCalculatorDefaultAudioDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(118 + 56), (String)"lfdcsgqVw{{lvzhrl[%'#6(1\u00072, %\u000f9?/;9><"), this.bitrateCalculatorDefaultAudioDuration);
        this.bitrateCalculatorDefaultVideoDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"0: '7#=\u001a;7?(2>tnpGacgrd}\\bhhaKecsg}zx", (int)(99 + 15)), this.bitrateCalculatorDefaultVideoDuration);
        this.bitrateCalculatorMaxAudioDuration = wMSProperties.getPropertyInt(Base64.endsWith((String)"dn|{k\u007fiNocsd~r`zdZya[nxtq[uscwmjh", (int)(652 / 98)), this.bitrateCalculatorMaxAudioDuration);
        this.bitrateCalculatorMaxVideoDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(497 / 137), (String)"amqtf|lIj`n{cqe}aYtnAq}\u007ftXhl~thmm"), this.bitrateCalculatorMaxVideoDuration);
        String string = liveStreamTranscoder.getAppInstance().getContextStr() + ":" + liveStreamTranscoder.getStreamName();
        this.audioValues.f = this.bitrateCalculatorDefaultAudioDuration;
        this.audioValues.g = this.bitrateCalculatorMaxAudioDuration;
        this.audioValues.h = string + Base64.endsWith((String)";cv`li", (int)(29 * 53));
        this.videoValues.f = this.bitrateCalculatorDefaultVideoDuration;
        this.videoValues.g = this.bitrateCalculatorMaxVideoDuration;
        this.videoValues.h = string + FileChunk.substring((int)(328 / 55), (String)"?pnlle");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        if (this.startTimecode < 0L) {
            this.startTimecode = l;
        }
        int n = aMFPacket.getType();
        switch (n) {
            case 8: {
                if (FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket)) break;
                this.audioValues.handlePacket(iMediaStream, aMFPacket);
                break;
            }
            default: {
                break;
            }
            case 9: {
                if (FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket)) break;
                this.videoValues.handlePacket(iMediaStream, aMFPacket);
            }
        }
        if (l - this.startTimecode <= (long)this.bitrateCalculatorDuration) return;
        this.calculating = false;
    }

    public boolean isCalculating() {
        return this.calculating;
    }

    public void setCalculating(boolean bl) {
        this.calculating = bl;
    }

    public long getVideoBitrate() {
        return this.videoValues.getBitrate();
    }

    public long getAudioBitrate() {
        return this.audioValues.getBitrate();
    }

    class CalculatorValues {
        long a = -1L;
        long b = -1L;
        int c = -1;
        long d = -1L;
        long e = -1L;
        int f = 30;
        int g = 1000;
        String h = "";

        CalculatorValues() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getSize();
            if (this.a < 0L) {
                this.a = l;
            } else {
                long l2 = l - this.b;
                if (l2 < 0L) {
                    l2 = this.f;
                } else if (l2 > (long)this.g) {
                    l2 = this.f;
                }
                this.e += l2;
                this.d += (long)this.c;
            }
            this.b = l;
            this.c = n;
        }

        public long getBitrate() {
            if (this.e <= 0L) {
                return 0L;
            }
            return this.d * 8L * 1000L / this.e;
        }
    }
}

