/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.impl;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkArtifact;
import com.wowza.wms.dvr.DvrManifestChunkEntry;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrStreamStoreBase;
import com.wowza.wms.dvr.IDvrStreamManager;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.impl.DvrPersistedManifest;
import com.wowza.wms.dvr.impl.DvrPurgeControllerFactory;
import com.wowza.wms.dvr.io.DvrChunkReaderUtils;
import com.wowza.wms.dvr.io.DvrFileSystemFactory;
import com.wowza.wms.dvr.io.DvrManifestWriterFactory;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrRecordableStreamStore
extends DvrStreamStoreBase
implements IDvrStreamStore {
    private static final Class<DvrRecordableStreamStore> a = DvrRecordableStreamStore.class;
    protected boolean storageSystemInitialized;
    protected String streamContainer;

    public DvrRecordableStreamStore(IDvrStreamManager iDvrStreamManager, String string) {
        super(iDvrStreamManager, string);
        this.canRecord = true;
        this.canPlay = true;
        IApplicationInstance iApplicationInstance = this.dvrManager.getApplicationInstance();
        this.streamContainer = this.initStreamContainer(iApplicationInstance, string);
    }

    public void init() {
        super.init();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initializeStorageSystem() {
        if (this.storageSystemInitialized) return;
        IApplicationInstance iApplicationInstance = this.dvrManager.getApplicationInstance();
        this.fileSystem = DvrFileSystemFactory.createInstance((IApplicationInstance)iApplicationInstance, (String)this.dvrManager.getDvrFileSystemClass(), (String)this.dvrManager.getDvrStorageDir(), (String)this.streamContainer);
        this.manifestWriter = DvrManifestWriterFactory.createInstance((IApplicationInstance)iApplicationInstance, (String)this.manifestPersisterClass, (IDvrFileSystem)this.fileSystem, (IDvrStreamStore)this);
        if (!this.fileSystem.doesFileSystemExist() && !this.fileSystem.createFileSystem()) {
            String string = String.format(FileChunk.substring((int)(45 * 15), (String)"&w+oia}cj`dtjCe}aursDajn~qF;l\u001daxc\u0011+'%$,j?#m-=50&6t3?;=y)\"/);2`d1"), Base64.endsWith((String)"Bqz[ohc\u007fjnr}w@`gsvuJntnx", (int)(992 / 164)), this.getContextStr(), this.fileSystem);
            WMSLoggerFactory.getLogger(a).error(string);
        }
        this.storageSystemInitialized = true;
    }

    protected void initPurgeController() {
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        dvrRecordableStreamStore.purgeController = DvrPurgeControllerFactory.createInstance(dvrRecordableStreamStore, dvrRecordableStreamStore.purgeControlClass);
    }

    protected String initStreamContainer(IApplicationInstance iApplicationInstance, String string) {
        String string2 = this.normalizeStreamName(string);
        String string3 = iApplicationInstance.getContextStr() + IDvrFileSystem.separator + string2;
        return string3;
    }

    protected DvrChunk retrieveChunkFromDvrStore(DvrManifestChunkEntry dvrManifestChunkEntry) {
        DvrChunk dvrChunk = null;
        DvrChunkArtifact dvrChunkArtifact = dvrManifestChunkEntry.getDvrArtifact();
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        dvrChunk = DvrChunkReaderUtils.retrieveChunk((IDvrStreamStore)dvrRecordableStreamStore, (IApplicationInstance)dvrRecordableStreamStore.dvrManager.getApplicationInstance(), (String)dvrChunkArtifact.getPath());
        return dvrChunk;
    }

    public void createManifest() {
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        this.manifest = new DvrPersistedManifest(dvrRecordableStreamStore, dvrRecordableStreamStore.manifestWriter);
        this.manifest.initialize();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getUniqueContainerSet(SortedSet<String> sortedSet, Collection<DvrManifestEntry> collection) {
        if (collection == null) {
            return;
        }
        Iterator<DvrManifestEntry> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DvrManifestEntry dvrManifestEntry = iterator.next();
            this.addUniqueContainer(sortedSet, dvrManifestEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addUniqueContainer(SortedSet<String> sortedSet, DvrManifestEntry dvrManifestEntry) {
        if (dvrManifestEntry == null) return;
        if (!(dvrManifestEntry instanceof DvrManifestChunkEntry)) return;
        DvrChunkArtifact dvrChunkArtifact = ((DvrManifestChunkEntry)dvrManifestEntry).getDvrArtifact();
        if (dvrChunkArtifact == null) return;
        sortedSet.add(dvrChunkArtifact.container);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void removeArtifacts(Collection<DvrManifestEntry> collection) {
        if (collection == null) return;
        if (collection.isEmpty()) return;
        if (this.fileSystem == null) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        this.getUniqueContainerSet(treeSet, collection);
        Iterator<DvrManifestEntry> iterator = collection.iterator();
        boolean bl = true;
        block0: while (true) {
            DvrManifestEntry dvrManifestEntry;
            if (!bl || (bl = false) || !true) {
                DvrChunkArtifact dvrChunkArtifact = ((DvrManifestChunkEntry)dvrManifestEntry).getDvrArtifact();
                this.fileSystem.delete(dvrChunkArtifact.getPath());
            }
            while (iterator.hasNext()) {
                dvrManifestEntry = iterator.next();
                if (dvrManifestEntry != null && dvrManifestEntry instanceof DvrManifestChunkEntry) continue block0;
            }
            break;
        }
        this.manifestWriter.purgeIndividualManifests(treeSet);
    }

    public String toString() {
        return String.format(Base64.endsWith((String)"\u007f u'{}xnm`@n}t(6g5fewii!9nc", (int)(-30 + 66)), FileChunk.substring((int)(73 + -55), (String)"VefGstwk~z~q{LtsgbiVrhzl"), this.streamName, this.properties);
    }
}

