/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.file;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.HTTPStreamerSanJoseIndex;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IHTTPStreamerSanJoseIndexItem;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IMediaReaderSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.List;

public class HTTPStreamerSanJoseIndexItem {
    protected String metaData = null;
    protected int width = -1;
    protected int height = -1;
    protected int displayWidth = -1;
    protected int displayHeight = -1;
    protected long duration = -1L;
    protected long bitrate = 0L;
    protected long calculatedBitrate = 0L;
    protected int avcLevel = 0;
    protected int avcProfile = 0;
    protected String streamName = null;
    protected String mimeType = FileChunk.substring((int)(98 + -10), (String)".0>>3r3/t");
    protected List<IHTTPStreamerSanJoseIndexItem> items = new ArrayList<IHTTPStreamerSanJoseIndexItem>();
    protected IMediaReaderSanJose mediaReader = null;
    protected HTTPStreamerSanJoseIndex index = null;
    protected boolean resolvePlayAlias = false;
    protected long playStart = 0L;
    protected long playDuration = -1L;

    public HTTPStreamerSanJoseIndexItem(HTTPStreamerSanJoseIndex hTTPStreamerSanJoseIndex) {
        this.index = hTTPStreamerSanJoseIndex;
    }

    public HTTPStreamerSanJoseIndex getIndex() {
        return this.index;
    }

    public int addIndexItem(IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem) {
        this.items.add(iHTTPStreamerSanJoseIndexItem);
        return this.items.size() - 1;
    }

    public int getIndexCount() {
        return this.items.size();
    }

    public IHTTPStreamerSanJoseIndexItem getIndexItem(int n) {
        if (n >= this.items.size()) {
            return null;
        }
        return this.items.get(n);
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        this.metaData = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(long l) {
        this.bitrate = l;
    }

    public long getTrimmedDuration() {
        if (this.items.size() <= 0) {
            return this.duration;
        }
        IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem = this.items.get(0);
        List<IHTTPStreamerSanJoseIndexItem> list = this.items;
        IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem2 = list.get(list.size() - 1);
        return iHTTPStreamerSanJoseIndexItem2.getStopTimecode() - iHTTPStreamerSanJoseIndexItem.getStartTimecode();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession) {
        if (this.mediaReader == null) {
            return;
        }
        this.mediaReader.indexFile(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error(FileChunk.substring((int)(357 / 92), (String)"KPQVT|{ojah|\\q\u007fX|gp_y||bRhxs1cmmpa?&") + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        String string;
        String string2;
        String string3;
        IApplicationInstance iApplicationInstance;
        if (this.mediaReader != null) {
            this.close();
        }
        this.mediaReader = null;
        try {
            iApplicationInstance = this.index.getAppInstance();
            string3 = Base64.subSequence((String)"9%b", (int)(39 - -45));
            string2 = this.streamName;
            string = "";
            if (this.resolvePlayAlias) {
                string2 = ((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string2, this.index.getHttpStreamerSession());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error(Base64.subSequence((String)"A^_\\^z}up\u007fvfFwyRvi~Uszz8\b6&)k)7-'pk", (int)(37 * 53)) + exception.toString());
            return;
        }
        if (string2 == null) return;
        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string2, (String)string3);
        string2 = stringArray[0];
        string3 = stringArray[1];
        boolean bl = string2.indexOf(FileChunk.substring((int)(4 + 91), (String)"eon")) >= 0;
        int n = string2.indexOf("?");
        if (!bl && n >= 0) {
            string = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        String string4 = string3 + Base64.subSequence((String)"kxtqsn{", (int)(65 + -41));
        IApplicationInstance iApplicationInstance2 = iApplicationInstance;
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)iApplicationInstance2, (MediaReaderList)iApplicationInstance2.getStreams().getVHost().getMediaReaders(), (String)string4);
        if (iMediaReader == null) return;
        String string5 = iApplicationInstance.getStreamStoragePath();
        iMediaReader.init(iApplicationInstance, this.index.getStream(), string4, string5, string2);
        iMediaReader.open(string5, string2);
        if (!(iMediaReader instanceof IMediaReaderSanJose)) {
            iMediaReader.close();
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error(Base64.subSequence((String)"NS\\YY\u007f~hobucArz_yd}Pt\u007fyeWkel,lt`h=(Dooel\\jquwa4|e7vvn;}s>L!/\b,7 f\n--#*\u001e(/+5#hs", (int)(1203 / 189)) + this.index.getStreamExt() + ":" + this.streamName);
            return;
        }
        this.mediaReader = (IMediaReaderSanJose)iMediaReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LiveStreamPacketizerSanJoseChunk getChunk(long l) {
        LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk = null;
        try {
            if (this.mediaReader == null) {
                return liveStreamPacketizerSanJoseChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error(Base64.subSequence((String)"O\\]ZXx\u007fkn}t`@u{\\xk|SuxxfV4$/m\",*+\u000b!?%'wn", (int)(25 * 63)) + exception.toString());
            return liveStreamPacketizerSanJoseChunk;
        }
        int n = (int)(l - 1L);
        if (n >= this.items.size()) {
            return liveStreamPacketizerSanJoseChunk;
        }
        IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem = this.items.get(n);
        liveStreamPacketizerSanJoseChunk = new LiveStreamPacketizerSanJoseChunk(n);
        this.mediaReader.fillChunk(iHTTPStreamerSanJoseIndexItem, liveStreamPacketizerSanJoseChunk);
        liveStreamPacketizerSanJoseChunk.addMDATHeader();
        return liveStreamPacketizerSanJoseChunk;
    }

    public int getAvcLevel() {
        return this.avcLevel;
    }

    public void setAvcLevel(int n) {
        this.avcLevel = n;
    }

    public int getAvcProfile() {
        return this.avcProfile;
    }

    public void setAvcProfile(int n) {
        this.avcProfile = n;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public long getCalculatedBitrate() {
        return this.calculatedBitrate;
    }

    public void setCalculatedBitrate(long l) {
        this.calculatedBitrate = l;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int n) {
        this.displayWidth = n;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int n) {
        this.displayHeight = n;
    }

    public boolean isResolvePlayAlias() {
        return this.resolvePlayAlias;
    }

    public void setResolvePlayAlias(boolean bl) {
        this.resolvePlayAlias = bl;
    }

    public long getPlayStart() {
        return this.playStart;
    }

    public void setPlayStart(long l) {
        this.playStart = l;
    }

    public long getPlayDuration() {
        return this.playDuration;
    }

    public void setPlayDuration(long l) {
        this.playDuration = l;
    }
}

