/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogFactor5ErrorDialog;
import org.apache.log4j.lf5.viewer.LogFactor5LoadingDialog;

public class LogFileParser
implements Runnable {
    public static final String RECORD_DELIMITER = "[slf5s.start]";
    public static final String ATTRIBUTE_DELIMITER = "[slf5s.";
    public static final String DATE_DELIMITER = "[slf5s.DATE]";
    public static final String THREAD_DELIMITER = "[slf5s.THREAD]";
    public static final String CATEGORY_DELIMITER = "[slf5s.CATEGORY]";
    public static final String LOCATION_DELIMITER = "[slf5s.LOCATION]";
    public static final String MESSAGE_DELIMITER = "[slf5s.MESSAGE]";
    public static final String PRIORITY_DELIMITER = "[slf5s.PRIORITY]";
    public static final String NDC_DELIMITER = "[slf5s.NDC]";
    private static SimpleDateFormat _sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss,S");
    private LogBrokerMonitor _monitor;
    LogFactor5LoadingDialog _loadDialog;
    private InputStream _in = null;

    public LogFileParser(File file) throws IOException, FileNotFoundException {
        this(new FileInputStream(file));
    }

    public LogFileParser(InputStream inputStream) throws IOException {
        this._in = inputStream;
    }

    public void parse(LogBrokerMonitor logBrokerMonitor) throws RuntimeException {
        this._monitor = logBrokerMonitor;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        this._loadDialog = new LogFactor5LoadingDialog(this._monitor.getBaseFrame(), "Loading file...");
        try {
            LogRecord logRecord;
            String string = this.loadLogFile(this._in);
            while ((n2 = string.indexOf(RECORD_DELIMITER, n)) != -1) {
                logRecord = this.createLogRecord(string.substring(n, n2));
                bl = true;
                if (logRecord != null) {
                    this._monitor.addMessage(logRecord);
                }
                n = n2 + RECORD_DELIMITER.length();
            }
            if (n < string.length() && bl && (logRecord = this.createLogRecord(string.substring(n))) != null) {
                this._monitor.addMessage(logRecord);
            }
            if (!bl) {
                throw new RuntimeException("Invalid log file format");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogFileParser.this.destroyDialog();
                }
            });
        }
        catch (RuntimeException runtimeException) {
            this.destroyDialog();
            this.displayError("Error - Invalid log file format.\nPlease see documentation on how to load log files.");
        }
        catch (IOException iOException) {
            this.destroyDialog();
            this.displayError("Error - Unable to load log file!");
        }
        this._in = null;
    }

    protected void displayError(String string) {
        LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this._monitor.getBaseFrame(), string);
    }

    private void destroyDialog() {
        this._loadDialog.hide();
        this._loadDialog.dispose();
    }

    private String loadLogFile(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n = 0;
        int n2 = bufferedInputStream.available();
        StringBuffer stringBuffer = null;
        stringBuffer = n2 > 0 ? new StringBuffer(n2) : new StringBuffer(1024);
        while ((n = bufferedInputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        bufferedInputStream.close();
        bufferedInputStream = null;
        return stringBuffer.toString();
    }

    private String parseAttribute(String string, String string2) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.getAttribute(n, string2);
    }

    private long parseDate(String string) {
        try {
            String string2 = this.parseAttribute(DATE_DELIMITER, string);
            if (string2 == null) {
                return 0L;
            }
            Date date = _sdf.parse(string2);
            return date.getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    private LogLevel parsePriority(String string) {
        String string2 = this.parseAttribute(PRIORITY_DELIMITER, string);
        if (string2 != null) {
            try {
                return LogLevel.valueOf(string2);
            }
            catch (LogLevelFormatException logLevelFormatException) {
                return LogLevel.DEBUG;
            }
        }
        return LogLevel.DEBUG;
    }

    private String parseThread(String string) {
        return this.parseAttribute(THREAD_DELIMITER, string);
    }

    private String parseCategory(String string) {
        return this.parseAttribute(CATEGORY_DELIMITER, string);
    }

    private String parseLocation(String string) {
        return this.parseAttribute(LOCATION_DELIMITER, string);
    }

    private String parseMessage(String string) {
        return this.parseAttribute(MESSAGE_DELIMITER, string);
    }

    private String parseNDC(String string) {
        return this.parseAttribute(NDC_DELIMITER, string);
    }

    private String parseThrowable(String string) {
        return this.getAttribute(string.length(), string);
    }

    private LogRecord createLogRecord(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Log4JLogRecord log4JLogRecord = new Log4JLogRecord();
        log4JLogRecord.setMillis(this.parseDate(string));
        log4JLogRecord.setLevel(this.parsePriority(string));
        log4JLogRecord.setCategory(this.parseCategory(string));
        log4JLogRecord.setLocation(this.parseLocation(string));
        log4JLogRecord.setThreadDescription(this.parseThread(string));
        log4JLogRecord.setNDC(this.parseNDC(string));
        log4JLogRecord.setMessage(this.parseMessage(string));
        log4JLogRecord.setThrownStackTrace(this.parseThrowable(string));
        return log4JLogRecord;
    }

    private String getAttribute(int n, String string) {
        int n2 = string.lastIndexOf(ATTRIBUTE_DELIMITER, n - 1);
        if (n2 == -1) {
            return string.substring(0, n);
        }
        n2 = string.indexOf("]", n2);
        return string.substring(n2 + 1, n).trim();
    }
}

