/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;

public class TranscoderSessionBitrateCalculator {
    protected boolean calculating = true;
    protected long startTimecode = -1L;
    protected int bitrateCalculatorDuration = 3000;
    protected int bitrateCalculatorDefaultAudioDuration = 30;
    protected int bitrateCalculatorDefaultVideoDuration = 30;
    protected int bitrateCalculatorMaxAudioDuration = 1000;
    protected int bitrateCalculatorMaxVideoDuration = 1000;
    protected CalculatorValues audioValues = new CalculatorValues();
    protected CalculatorValues videoValues = new CalculatorValues();

    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        WMSProperties wMSProperties = liveStreamTranscoder.getProperties();
        this.bitrateCalculatorDuration = wMSProperties.getPropertyInt(Base64.subSequence((String)"amqtf|lIj`n{cqe}aP`dvlpuu", (int)(27 * 25)), this.bitrateCalculatorDuration);
        this.bitrateCalculatorDefaultAudioDuration = wMSProperties.getPropertyInt(Base64.subSequence((String)"og{bpfvWtztmu{osoZzf`wopDscafN~~lzf\u007f\u007f", (int)(39 * 43)), this.bitrateCalculatorDefaultAudioDuration);
        this.bitrateCalculatorDefaultVideoDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(159 / 38), (String)"flrui}oHmamz|pf|fQsqylvoJtzzoEwqeqohf"), this.bitrateCalculatorDefaultVideoDuration);
        this.bitrateCalculatorMaxAudioDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(17 * 63), (String)"mye`r`pUvtzow}iqm\r :\u00021!/(\f<8*8$!!"), this.bitrateCalculatorMaxAudioDuration);
        this.bitrateCalculatorMaxVideoDuration = wMSProperties.getPropertyInt(FileChunk.substring((int)(31 * 25), (String)"ea}xjxhMn|rg\u007fuayeUxbMuy{pDtpbplii"), this.bitrateCalculatorMaxVideoDuration);
        String string = liveStreamTranscoder.getAppInstance().getContextStr() + ":" + liveStreamTranscoder.getStreamName();
        this.audioValues.f = this.bitrateCalculatorDefaultAudioDuration;
        this.audioValues.g = this.bitrateCalculatorMaxAudioDuration;
        this.audioValues.h = string + Base64.subSequence((String)"<f}mcd", (int)(1331 / 199));
        this.videoValues.f = this.bitrateCalculatorDefaultVideoDuration;
        this.videoValues.g = this.bitrateCalculatorMaxVideoDuration;
        this.videoValues.h = string + FileChunk.substring((int)(55 + 62), (String)"o ><<5");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        if (this.startTimecode < 0L) {
            this.startTimecode = l;
        }
        int n = aMFPacket.getType();
        switch (n) {
            case 8: {
                if (FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket)) break;
                this.audioValues.handlePacket(iMediaStream, aMFPacket);
                break;
            }
            default: {
                break;
            }
            case 9: {
                if (FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket)) break;
                this.videoValues.handlePacket(iMediaStream, aMFPacket);
            }
        }
        if (l - this.startTimecode <= (long)this.bitrateCalculatorDuration) return;
        this.calculating = false;
    }

    public boolean isCalculating() {
        return this.calculating;
    }

    public void setCalculating(boolean bl) {
        this.calculating = bl;
    }

    public long getVideoBitrate() {
        return this.videoValues.getBitrate();
    }

    public long getAudioBitrate() {
        return this.audioValues.getBitrate();
    }

    class CalculatorValues {
        long a = -1L;
        long b = -1L;
        int c = -1;
        long d = -1L;
        long e = -1L;
        int f = 30;
        int g = 1000;
        String h = "";

        CalculatorValues() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getSize();
            if (this.a < 0L) {
                this.a = l;
            } else {
                long l2 = l - this.b;
                if (l2 < 0L) {
                    l2 = this.f;
                } else if (l2 > (long)this.g) {
                    l2 = this.f;
                }
                this.e += l2;
                this.d += (long)this.c;
            }
            this.b = l;
            this.c = n;
        }

        public long getBitrate() {
            if (this.e <= 0L) {
                return 0L;
            }
            return this.d * 8L * 1000L / this.e;
        }
    }
}

