/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocaleUtils {
    private static List cAvailableLocaleList;
    private static Set cAvailableLocaleSet;
    private static final Map cLanguagesByCountry;
    private static final Map cCountriesByLanguage;

    public static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n != 2 && n != 5 && n < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        if (c < 'a' || c > 'z' || c2 < 'a' || c2 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        if (n == 2) {
            return new Locale(string, "");
        }
        if (string.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        char c3 = string.charAt(3);
        if (c3 == '_') {
            return new Locale(string.substring(0, 2), "", string.substring(4));
        }
        char c4 = string.charAt(4);
        if (c3 < 'A' || c3 > 'Z' || c4 < 'A' || c4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        if (n == 5) {
            return new Locale(string.substring(0, 2), string.substring(3, 5));
        }
        if (string.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        return new Locale(string.substring(0, 2), string.substring(3, 5), string.substring(6));
    }

    public static List localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List localeLookupList(Locale locale, Locale locale2) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (locale != null) {
            arrayList.add(locale);
            if (locale.getVariant().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), ""));
            }
            if (!arrayList.contains(locale2)) {
                arrayList.add(locale2);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List availableLocaleList() {
        if (cAvailableLocaleList == null) {
            LocaleUtils.initAvailableLocaleList();
        }
        return cAvailableLocaleList;
    }

    private static synchronized void initAvailableLocaleList() {
        if (cAvailableLocaleList == null) {
            List<Locale> list = Arrays.asList(Locale.getAvailableLocales());
            cAvailableLocaleList = Collections.unmodifiableList(list);
        }
    }

    public static Set availableLocaleSet() {
        if (cAvailableLocaleSet == null) {
            LocaleUtils.initAvailableLocaleSet();
        }
        return cAvailableLocaleSet;
    }

    private static synchronized void initAvailableLocaleSet() {
        if (cAvailableLocaleSet == null) {
            cAvailableLocaleSet = Collections.unmodifiableSet(new HashSet(LocaleUtils.availableLocaleList()));
        }
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains(locale);
    }

    public static List languagesByCountry(String string) {
        List<Locale> list = (ArrayList)cLanguagesByCountry.get(string);
        if (list == null) {
            if (string != null) {
                list = new ArrayList();
                List list2 = LocaleUtils.availableLocaleList();
                for (int i = 0; i < list2.size(); ++i) {
                    Locale locale = (Locale)list2.get(i);
                    if (!string.equals(locale.getCountry()) || locale.getVariant().length() != 0) continue;
                    list.add(locale);
                }
                list = Collections.unmodifiableList(list);
            } else {
                list = Collections.EMPTY_LIST;
            }
            cLanguagesByCountry.put(string, list);
        }
        return list;
    }

    public static List countriesByLanguage(String string) {
        List<Locale> list = (ArrayList)cCountriesByLanguage.get(string);
        if (list == null) {
            if (string != null) {
                list = new ArrayList();
                List list2 = LocaleUtils.availableLocaleList();
                for (int i = 0; i < list2.size(); ++i) {
                    Locale locale = (Locale)list2.get(i);
                    if (!string.equals(locale.getLanguage()) || locale.getCountry().length() == 0 || locale.getVariant().length() != 0) continue;
                    list.add(locale);
                }
                list = Collections.unmodifiableList(list);
            } else {
                list = Collections.EMPTY_LIST;
            }
            cCountriesByLanguage.put(string, list);
        }
        return list;
    }

    static {
        cLanguagesByCountry = Collections.synchronizedMap(new HashMap());
        cCountriesByLanguage = Collections.synchronizedMap(new HashMap());
    }
}

