/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class QueryStringAuthGenerator {
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;
    private Long expiresIn = null;
    private Long expires = null;
    private static final Long DEFAULT_EXPIRES_IN = new Long(60000L);

    public QueryStringAuthGenerator(String string, String string2) {
        this(string, string2, true);
    }

    public QueryStringAuthGenerator(String string, String string2, boolean bl) {
        this(string, string2, bl, "s3.amazonaws.com");
    }

    public QueryStringAuthGenerator(String string, String string2, boolean bl, String string3) {
        this(string, string2, bl, string3, bl ? 443 : 80);
    }

    public QueryStringAuthGenerator(String string, String string2, boolean bl, String string3, int n) {
        this(string, string2, bl, string3, n, CallingFormat.getSubdomainCallingFormat());
    }

    public QueryStringAuthGenerator(String string, String string2, boolean bl, String string3, CallingFormat callingFormat) {
        this(string, string2, bl, string3, bl ? 443 : 80, callingFormat);
    }

    public QueryStringAuthGenerator(String string, String string2, boolean bl, String string3, int n, CallingFormat callingFormat) {
        this.awsAccessKeyId = string;
        this.awsSecretAccessKey = string2;
        this.isSecure = bl;
        this.server = string3;
        this.port = n;
        this.callingFormat = callingFormat;
        this.expiresIn = DEFAULT_EXPIRES_IN;
        this.expires = null;
    }

    public void setCallingFormat(CallingFormat callingFormat) {
        this.callingFormat = callingFormat;
    }

    public void setExpires(long l) {
        this.expires = new Long(l);
        this.expiresIn = null;
    }

    public void setExpiresIn(long l) {
        this.expiresIn = new Long(l);
        this.expires = null;
    }

    public String createBucket(String string, Map map) {
        if (!Utils.validateBucketName(string, this.callingFormat, false)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + string);
        }
        HashMap hashMap = new HashMap();
        return this.generateURL("PUT", string, "", hashMap, map);
    }

    public String listBucket(String string, String string2, String string3, Integer n, Map map) {
        return this.listBucket(string, string2, string3, n, null, map);
    }

    public String listBucket(String string, String string2, String string3, Integer n, String string4, Map map) {
        Map map2 = Utils.paramsForListOptions(string2, string3, n, string4);
        return this.generateURL("GET", string, "", map2, map);
    }

    public String deleteBucket(String string, Map map) {
        HashMap hashMap = new HashMap();
        return this.generateURL("DELETE", string, "", hashMap, map);
    }

    public String put(String string, String string2, S3Object s3Object, Map map) {
        Map map2 = null;
        HashMap hashMap = new HashMap();
        if (s3Object != null) {
            map2 = s3Object.metadata;
        }
        return this.generateURL("PUT", string, Utils.urlencode(string2), hashMap, this.mergeMeta(map, map2));
    }

    public String get(String string, String string2, Map map) {
        HashMap hashMap = new HashMap();
        return this.generateURL("GET", string, Utils.urlencode(string2), hashMap, map);
    }

    public String delete(String string, String string2, Map map) {
        HashMap hashMap = new HashMap();
        return this.generateURL("DELETE", string, Utils.urlencode(string2), hashMap, map);
    }

    public String getBucketLogging(String string, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("logging", null);
        return this.generateURL("GET", string, "", hashMap, map);
    }

    public String putBucketLogging(String string, String string2, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("logging", null);
        return this.generateURL("PUT", string, "", hashMap, map);
    }

    public String getBucketACL(String string, Map map) {
        return this.getACL(string, "", map);
    }

    public String getACL(String string, String string2, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("acl", null);
        return this.generateURL("GET", string, Utils.urlencode(string2), hashMap, map);
    }

    public String putBucketACL(String string, String string2, Map map) {
        return this.putACL(string, "", string2, map);
    }

    public String putACL(String string, String string2, String string3, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("acl", null);
        return this.generateURL("PUT", string, Utils.urlencode(string2), hashMap, map);
    }

    public String listAllMyBuckets(Map map) {
        HashMap hashMap = new HashMap();
        return this.generateURL("GET", "", "", hashMap, map);
    }

    public String makeBareURL(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSecure) {
            stringBuffer.append("https://");
        } else {
            stringBuffer.append("http://");
        }
        stringBuffer.append(this.server).append(":").append(this.port).append("/").append(string);
        stringBuffer.append("/").append(Utils.urlencode(string2));
        return stringBuffer.toString();
    }

    private String generateURL(String string, String string2, String string3, Map map, Map map2) {
        String string4;
        long l = 0L;
        if (this.expiresIn != null) {
            l = System.currentTimeMillis() + this.expiresIn;
        } else if (this.expires != null) {
            l = this.expires;
        } else {
            throw new RuntimeException("Illegal expires state");
        }
        String string5 = Utils.makeCanonicalString(string, string2, string3, map, map2, "" + (l /= 1000L));
        String string6 = Utils.encode(this.awsSecretAccessKey, string5, true);
        map.put("Signature", string6);
        map.put("Expires", Long.toString(l));
        map.put("AWSAccessKeyId", this.awsAccessKeyId);
        CallingFormat callingFormat = Utils.getCallingFormatForBucket(this.callingFormat, string2);
        if (this.isSecure && callingFormat != CallingFormat.getPathCallingFormat() && string2.indexOf(".") != -1) {
            System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
        }
        try {
            URL uRL = callingFormat.getURL(this.isSecure, this.server, this.port, string2, string3, map);
            string4 = uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            string4 = "Exception generating url " + malformedURLException;
        }
        return string4;
    }

    private Map mergeMeta(Map map, Map map2) {
        TreeMap treeMap = new TreeMap();
        if (map != null) {
            for (String string : map.keySet()) {
                treeMap.put(string, map.get(string));
            }
        }
        if (map2 != null) {
            for (String string : map2.keySet()) {
                String string2 = "x-amz-meta-" + string;
                if (treeMap.containsKey(string2)) {
                    ((List)treeMap.get(string2)).addAll((List)map2.get(string));
                    continue;
                }
                treeMap.put(string2, map2.get(string));
            }
        }
        return treeMap;
    }
}

