/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.impl;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.CollectionUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkCreator;
import com.wowza.wms.dvr.DvrEncryptionInfoHolder;
import com.wowza.wms.dvr.DvrOnMetadataChunkWriter;
import com.wowza.wms.dvr.DvrPacketHolder;
import com.wowza.wms.dvr.IDvrEncryptionInfo;
import com.wowza.wms.dvr.IDvrPacketConverter;
import com.wowza.wms.dvr.impl.DvrChunkHeader;
import com.wowza.wms.dvr.impl.DvrMediaPacket;
import com.wowza.wms.dvr.impl.DvrPacketHandler;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPacketConverter
implements IDvrPacketConverter {
    /*
     * Enabled aggressive block sorting
     */
    public DvrChunk createDvrAudioChunk(long l, int n, int n2, DvrPacketHolder dvrPacketHolder) {
        DvrChunk dvrChunk = new DvrChunk();
        List<DvrMediaPacket> list = this.a(dvrPacketHolder);
        long l2 = dvrPacketHolder.getPacketTimecode();
        long l3 = dvrPacketHolder.getPacketTimecode90();
        long l4 = dvrPacketHolder.getUtcTimecode();
        dvrChunk.setDvrStart(l);
        dvrChunk.setDuration(n2);
        dvrChunk.setUtcStart(l4);
        dvrChunk.setPacketStart(l2);
        dvrChunk.setPacketStart90(l3);
        dvrChunk.setMediaInfoAudio((MediaCodecInfoAudio)dvrPacketHolder.getCodecInfo());
        int n3 = this.a(n2, list);
        dvrChunk.setBitrate(n3);
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder = new DvrEncryptionInfoHolder();
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder2 = dvrPacketHolder.getEncryptions();
        if (dvrEncryptionInfoHolder2 != null && !CollectionUtils.isEmpty((Collection)dvrEncryptionInfoHolder2.getEncrypts())) {
            for (IDvrEncryptionInfo iDvrEncryptionInfo : dvrEncryptionInfoHolder2.getEncrypts()) {
                dvrEncryptionInfoHolder.addEncryption(iDvrEncryptionInfo);
            }
        }
        dvrChunk.setEncrypts(dvrEncryptionInfoHolder);
        DvrChunkHeader dvrChunkHeader = this.a(l, n, n2, n3, dvrPacketHolder);
        byte[] byArray = this.a(list, dvrChunkHeader);
        dvrChunk.setBytes(byArray);
        return dvrChunk;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private final byte[] a(List<DvrMediaPacket> list, DvrChunkHeader dvrChunkHeader) {
        RTPPacketFragmentList rTPPacketFragmentList = new RTPPacketFragmentList();
        rTPPacketFragmentList.addPacketFragment(dvrChunkHeader.getHeaderData());
        Iterator<DvrMediaPacket> iterator = list.iterator();
        boolean bl = true;
        while (true) {
            Iterator iterator2;
            if (!bl || (bl = false) || !true) {
                if (iterator2.hasNext()) {
                    RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)iterator2.next();
                    rTPPacketFragmentList.addPacketFragment(rTPPacketFragment);
                    continue;
                }
            }
            if (!iterator.hasNext()) {
                return (Iterator<DvrMediaPacket>)rTPPacketFragmentList.toByteArray();
            }
            DvrMediaPacket dvrMediaPacket = iterator.next();
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = dvrMediaPacket.getSmoothMediaPacket();
            RTPPacketFragmentList rTPPacketFragmentList2 = smoothStreamingMediaPacket.getFragmentList();
            List list2 = rTPPacketFragmentList2.getFragments();
            iterator2 = list2.iterator();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public DvrChunk createDvrVideoChunk(long l, int n, int n2, DvrPacketHolder dvrPacketHolder) {
        List<DvrMediaPacket> list = this.a(dvrPacketHolder);
        DvrChunk dvrChunk = new DvrChunk();
        long l2 = dvrPacketHolder.getPacketTimecode();
        long l3 = dvrPacketHolder.getPacketTimecode90();
        long l4 = dvrPacketHolder.getUtcTimecode();
        dvrChunk.setDvrStart(l);
        dvrChunk.setDuration(n2);
        dvrChunk.setUtcStart(l4);
        dvrChunk.setPacketStart(l2);
        dvrChunk.setPacketStart90(l3);
        dvrChunk.setMediaInfoVideo((MediaCodecInfoVideo)dvrPacketHolder.getCodecInfo());
        int n3 = this.a(n2, list);
        dvrChunk.setBitrate(n3);
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder = new DvrEncryptionInfoHolder();
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder2 = dvrPacketHolder.getEncryptions();
        if (dvrEncryptionInfoHolder2 != null && !CollectionUtils.isEmpty((Collection)dvrEncryptionInfoHolder2.getEncrypts())) {
            for (IDvrEncryptionInfo iDvrEncryptionInfo : dvrEncryptionInfoHolder2.getEncrypts()) {
                dvrEncryptionInfoHolder.addEncryption(iDvrEncryptionInfo);
            }
        }
        dvrChunk.setEncrypts(dvrEncryptionInfoHolder);
        DvrChunkHeader dvrChunkHeader = this.a(l, n, n2, n3, dvrPacketHolder);
        byte[] byArray = this.a(list, dvrChunkHeader);
        dvrChunk.setBytes(byArray);
        return dvrChunk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DvrChunkHeader a(long l, int n, int n2, int n3, DvrPacketHolder dvrPacketHolder) {
        DvrChunkHeader dvrChunkHeader = null;
        try {
            List<DvrMediaPacket> list = this.a(dvrPacketHolder);
            ArrayList<SmoothStreamingMediaPacket> arrayList = new ArrayList<SmoothStreamingMediaPacket>(list.size());
            SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = list.iterator();
            while (true) {
                DvrMediaPacket dvrMediaPacket;
                if (!smoothStreamingFragmentWriterContext.hasNext()) {
                    smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
                    dvrMediaPacket = new SmoothStreamingFragmentWriterMedia();
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).packets = arrayList;
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).lastTimecode = ((SmoothStreamingMediaPacket)arrayList.get(0)).getTimecode() + (long)(n2 * 10000);
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).timescaleAdjust = 1L;
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).sequenceNumber = n;
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).startTimecode = l * 10000L;
                    ((SmoothStreamingFragmentWriterMedia)dvrMediaPacket).duration = n2 * 10000;
                    IMediaCodecInfo iMediaCodecInfo = dvrPacketHolder.getCodecInfo();
                    int n4 = DvrChunkCreator.getFragmentSize((SmoothStreamingFragmentWriterMedia)dvrMediaPacket, (DvrPacketHolder)dvrPacketHolder, (boolean)false);
                    int n5 = DvrChunkCreator.getMediaSize((SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    byte[] byArray = new byte[n4];
                    int n6 = 0;
                    n6 = DvrChunkCreator.writeStartMOOF((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
                    int n7 = dvrPacketHolder.getCodec();
                    n6 = DvrChunkCreator.writeAtomUUIDDvrChunkHeader((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (DvrPacketHolder)dvrPacketHolder, (long)l, (int)n2, (int)n3);
                    n6 = DvrChunkCreator.writeAtomUUIDCodecInfo((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (IMediaCodecInfo)iMediaCodecInfo, (int)dvrPacketHolder.getType(), (int)n7);
                    n6 = DvrChunkCreator.writeAtomMFHD((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    n6 = DvrChunkCreator.writeStartTRAF((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
                    n6 = DvrChunkCreator.writeAtomTFHD((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    n6 = DvrChunkCreator.writeAtomTRUN((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    n6 = DvrChunkCreator.writeAtomSDTP((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    n6 = DvrChunkCreator.writeAtomUUID((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (SmoothStreamingFragmentWriterMedia)dvrMediaPacket);
                    n6 = DvrChunkCreator.writeStopTRAF((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
                    n6 = DvrChunkCreator.writeStopMOOF((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
                    n6 = DvrChunkCreator.writeStartMDAT((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
                    n6 = DvrChunkCreator.writeStopMDAT((byte[])byArray, (int)n6, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (int)n5);
                    dvrChunkHeader = new DvrChunkHeader();
                    dvrChunkHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n4));
                    return dvrChunkHeader;
                }
                dvrMediaPacket = smoothStreamingFragmentWriterContext.next();
                arrayList.add(dvrMediaPacket.getSmoothMediaPacket());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DvrPacketHandler.class).error(FileChunk.regionMatches((int)(1118 / 181), (String)"BqzYkhghzL\u007f\u007fdvfase6zh~}i{\\htlhL`gcm{0+") + exception.toString());
            exception.printStackTrace();
            return dvrChunkHeader;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final DvrChunkHeader a(long l, long l2, AMFPacket aMFPacket) {
        DvrChunkHeader dvrChunkHeader = null;
        try {
            SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
            int n = DvrOnMetadataChunkWriter.getFragmentSize((AMFPacket)aMFPacket);
            byte[] byArray = new byte[n];
            int n2 = 0;
            n2 = DvrOnMetadataChunkWriter.writeStartMOOF((byte[])byArray, (int)n2, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
            n2 = DvrOnMetadataChunkWriter.writeAtomUUIDMetadataInfo((byte[])byArray, (int)n2, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext, (AMFPacket)aMFPacket);
            n2 = DvrOnMetadataChunkWriter.writeStopMOOF((byte[])byArray, (int)n2, (SmoothStreamingFragmentWriterContext)smoothStreamingFragmentWriterContext);
            dvrChunkHeader = new DvrChunkHeader();
            dvrChunkHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n));
            return dvrChunkHeader;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DvrPacketHandler.class).error(Base64.substring((String)"\u000541\u0014$%,-=\t$\";+=$4 }7'36,<\u00155\u00118*>d`vbGmsic3*", (int)(48 - -49)) + exception.toString());
            exception.printStackTrace();
            return dvrChunkHeader;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<DvrMediaPacket> a(DvrPacketHolder dvrPacketHolder) {
        ArrayList<DvrMediaPacket> arrayList = new ArrayList<DvrMediaPacket>();
        if (!dvrPacketHolder.isGroup()) {
            arrayList.add(this.b(dvrPacketHolder));
            return arrayList;
        }
        List list = dvrPacketHolder.getHolders();
        if (list == null) return arrayList;
        if (list.isEmpty()) return arrayList;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DvrPacketHolder dvrPacketHolder2 = (DvrPacketHolder)iterator.next();
            arrayList.add(this.b(dvrPacketHolder2));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final DvrMediaPacket b(DvrPacketHolder dvrPacketHolder) {
        DvrMediaPacket dvrMediaPacket = null;
        if (dvrPacketHolder.isGroup()) return dvrMediaPacket;
        SmoothStreamingMediaPacket smoothStreamingMediaPacket = this.a(dvrPacketHolder.getPacket());
        long l = dvrPacketHolder.getPacketTimecode90();
        if (smoothStreamingMediaPacket == null) return dvrMediaPacket;
        dvrMediaPacket = new DvrMediaPacket(smoothStreamingMediaPacket);
        dvrMediaPacket.setTimecode90(l);
        return dvrMediaPacket;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SmoothStreamingMediaPacket a(AMFPacket aMFPacket) {
        int n;
        byte[] byArray;
        long l;
        int n2;
        SmoothStreamingMediaPacket smoothStreamingMediaPacket;
        block7: {
            block6: {
                block5: {
                    int n3;
                    int n4;
                    block3: {
                        block4: {
                            int n5;
                            int n6;
                            block2: {
                                smoothStreamingMediaPacket = null;
                                n6 = aMFPacket.getType();
                                n2 = aMFPacket.getSize();
                                long l2 = aMFPacket.getAbsTimecode();
                                l = l2 * 10000L;
                                byArray = aMFPacket.getData();
                                n5 = byArray[0] & 0xFF;
                                if (n6 != 9) break block2;
                                n4 = FLVUtils.getFrameType((int)n5);
                                int n7 = FLVUtils.getVideoCodec((int)n5);
                                n3 = 0;
                                if (n7 != 7) break block3;
                                break block4;
                            }
                            if (n6 != 8) {
                                if (n6 != 18) return smoothStreamingMediaPacket;
                                smoothStreamingMediaPacket = new SmoothStreamingMediaPacket();
                                smoothStreamingMediaPacket.setType(18);
                                smoothStreamingMediaPacket.setTimecode(l);
                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, 0, n2);
                                smoothStreamingMediaPacket.getFragmentList().addPacketFragment(rTPPacketFragment);
                                return smoothStreamingMediaPacket;
                            }
                            int n8 = FLVUtils.getAudioCodec((int)n5);
                            if (n8 != 10) break block5;
                            break block6;
                        }
                        if (n2 >= 5) {
                            n3 = FLVUtils.getVideoTimecodeOffset((byte[])byArray) * 10000;
                        }
                    }
                    RTPPacketFragmentList rTPPacketFragmentList = null;
                    rTPPacketFragmentList = new RTPPacketFragmentList();
                    RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, 5, n2 - 5);
                    rTPPacketFragmentList.addPacketFragment(rTPPacketFragment);
                    smoothStreamingMediaPacket = new SmoothStreamingMediaPacket();
                    smoothStreamingMediaPacket.setType(9);
                    smoothStreamingMediaPacket.getFragmentList().addPacketFragments(rTPPacketFragmentList);
                    smoothStreamingMediaPacket.setTimecode(l);
                    smoothStreamingMediaPacket.setCTTS(n3);
                    smoothStreamingMediaPacket.setFrameType(n4);
                    return smoothStreamingMediaPacket;
                }
                n = 1;
                break block7;
            }
            n = 2;
        }
        int n9 = n;
        smoothStreamingMediaPacket = new SmoothStreamingMediaPacket();
        smoothStreamingMediaPacket.setType(8);
        smoothStreamingMediaPacket.setTimecode(l);
        RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n9, n2 - n9);
        smoothStreamingMediaPacket.getFragmentList().addPacketFragment(rTPPacketFragment);
        return smoothStreamingMediaPacket;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DvrChunk createDvrDataChunk(long l, int n, int n2, DvrPacketHolder dvrPacketHolder) {
        long l2 = dvrPacketHolder.getPacketTimecode();
        long l3 = dvrPacketHolder.getPacketTimecode90();
        long l4 = dvrPacketHolder.getUtcTimecode();
        List<DvrMediaPacket> list = this.a(dvrPacketHolder);
        DvrChunk dvrChunk = new DvrChunk();
        dvrChunk.setDvrStart(l);
        dvrChunk.setDuration(n2);
        dvrChunk.setUtcStart(l4);
        dvrChunk.setPacketStart(l2);
        dvrChunk.setPacketStart90(l3);
        int n3 = this.a(n2, list);
        dvrChunk.setBitrate(n3);
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder = new DvrEncryptionInfoHolder();
        DvrEncryptionInfoHolder dvrEncryptionInfoHolder2 = dvrPacketHolder.getEncryptions();
        if (dvrEncryptionInfoHolder2 != null && !CollectionUtils.isEmpty((Collection)dvrEncryptionInfoHolder2.getEncrypts())) {
            for (IDvrEncryptionInfo iDvrEncryptionInfo : dvrEncryptionInfoHolder2.getEncrypts()) {
                dvrEncryptionInfoHolder.addEncryption(iDvrEncryptionInfo);
            }
        }
        dvrChunk.setEncrypts(dvrEncryptionInfoHolder);
        DvrChunkHeader dvrChunkHeader = this.a(l, n, n2, n3, dvrPacketHolder);
        byte[] byArray = this.a(list, dvrChunkHeader);
        dvrChunk.setBytes(byArray);
        return dvrChunk;
    }

    public DvrChunk createDvrOnMetadataChunk(long l, long l2, AMFPacket aMFPacket) {
        DvrChunk dvrChunk = new DvrChunk();
        dvrChunk.setPacketStart(l2);
        dvrChunk.setPacketStart90(l2 * 90L);
        dvrChunk.setDvrStart(l);
        dvrChunk.setDuration(0);
        DvrChunkHeader dvrChunkHeader = this.a(l, l2, aMFPacket);
        dvrChunk.setBytes(dvrChunkHeader.getHeaderData().getBuffer());
        return dvrChunk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int a(long l, List<DvrMediaPacket> list) {
        int n = 0;
        long l2 = 0L;
        Iterator<DvrMediaPacket> iterator = list.iterator();
        while (true) {
            block3: {
                block2: {
                    if (!iterator.hasNext()) break block2;
                    break block3;
                }
                if (l <= 0L) return n;
                return (int)(l2 * 8L * 1000L / l);
            }
            DvrMediaPacket dvrMediaPacket = iterator.next();
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = dvrMediaPacket.getSmoothMediaPacket();
            l2 += (long)smoothStreamingMediaPacket.getSize();
        }
    }
}

