/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.util;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FastIntBuffer;
import com.wowza.util.FastIntDirect;
import com.wowza.util.FastLongBuffer;
import com.wowza.util.FastLongDirect;
import com.wowza.util.IFastIntBuffer;
import com.wowza.util.IFastLongBuffer;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadySampleIndex;
import com.wowza.wms.drm.playready.PlayReadyTrackInfo;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import com.wowza.wms.mediareader.h264.atom.QTAtomedts;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtommfhd;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoof;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomsinf;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtkhd;
import com.wowza.wms.mediareader.h264.atom.QTAtomtraf;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTAtomudta;
import com.wowza.wms.mediareader.h264.atom.QTEditListEntry;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.MP4Utils;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class QTUtils {
    public static final boolean debug = false;
    public static final int PLAYREADY_KEYIDSIZE = 16;
    public static final byte[] UUID_TRACKBOX = new byte[]{-119, 116, -37, -50, 123, -25, 76, 81, -124, -7, 113, 72, -7, -120, 37, 84};
    public static final byte[] UUID_FRAGBOX = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
    public static final byte[] UUID_PROTECTIONBOX = new byte[]{-48, -118, 79, 24, 16, -13, 74, -126, -74, -56, 50, -40, -85, -95, -125, -45};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void skipBytesLong(IRandomAccessReader iRandomAccessReader, long l) {
        try {
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            iRandomAccessReader2.seek(iRandomAccessReader2.getFilePointer() + l);
            return;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(111 + 86), (String)"\u000045';pk\u001d\u0019\u001b;9=!}'>?'\u001a .>/\u001111'{b") + exception.toString());
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void skipBytesLong(RandomAccessFile randomAccessFile, long l) {
        try {
            RandomAccessFile randomAccessFile2 = randomAccessFile;
            randomAccessFile2.seek(randomAccessFile2.getFilePointer() + l);
            return;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u000401+7|g\u0019\u001d\u001f?%!=a#:;#\u0016,\"2+\u001555;g~", (int)(-30 - 1)) + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtom readAtomHeader(IRandomAccessReader iRandomAccessReader) throws Exception {
        QTAtom qTAtom = null;
        long l = iRandomAccessReader.getFilePointer();
        int n = 0;
        byte[] byArray = new byte[4];
        iRandomAccessReader.read(byArray, 0, 4);
        long l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
        n += 4;
        iRandomAccessReader.read(byArray, 0, 4);
        n += 4;
        String string = new String(byArray, FileChunk.regionMatches((int)(29 + -5), (String)"MM\\6$"));
        if (l2 != 1L) return new QTAtom(string, l, l2, n);
        byte[] byArray2 = new byte[8];
        iRandomAccessReader.read(byArray2, 0, 8);
        l2 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
        n += 8;
        return new QTAtom(string, l, l2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtom readAtomHeader(RandomAccessFile randomAccessFile) throws Exception {
        QTAtom qTAtom = null;
        long l = randomAccessFile.getFilePointer();
        int n = 0;
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray, 0, 4);
        long l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
        n += 4;
        randomAccessFile.readFully(byArray, 0, 4);
        n += 4;
        String string = new String(byArray, Base64.substring((String)"\u001a\u0004\u0017\u007fk", (int)(86 + -7)));
        if (l2 != 1L) return new QTAtom(string, l, l2, n);
        byte[] byArray2 = new byte[8];
        randomAccessFile.readFully(byArray2, 0, 8);
        l2 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
        n += 8;
        return new QTAtom(string, l, l2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTMediaContainer parseQTMediaContainer(IRandomAccessReader iRandomAccessReader, long l, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom;
        long l2;
        QTMediaContainer qTMediaContainer = null;
        qTMediaContainer = new QTMediaContainer(Base64.substring((String)"RPQV", (int)(344 / 93)), iRandomAccessReader.getFilePointer(), l, 0L);
        boolean bl = false;
        boolean bl2 = false;
        QTAtommoof qTAtommoof = null;
        long l3 = -1L;
        boolean bl3 = false;
        for (long i = 0L; i < l && l - i >= 8L && (qTAtom = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l2) {
            block7: {
                block9: {
                    boolean bl4;
                    block13: {
                        block10: {
                            block12: {
                                block11: {
                                    block8: {
                                        block6: {
                                            if (!qTAtom.isType(FileChunk.regionMatches((int)(-19 - -49), (String)"spow"))) break block6;
                                            QTAtommoov qTAtommoov = QTUtils.parseAtommoov(iRandomAccessReader, qTAtom, qTParseContext);
                                            qTMediaContainer.setMoovAtom(qTAtommoov);
                                            bl = true;
                                            break block7;
                                        }
                                        if (!qTAtom.isType(FileChunk.regionMatches((int)(27 * 57), (String)"nkj`"))) break block8;
                                        qTAtommoof = QTUtils.parseAtommoof(iRandomAccessReader, qTAtom, qTParseContext, qTMediaContainer);
                                        if (bl2) break block9;
                                        if (l3 < 0L) break block10;
                                        break block11;
                                    }
                                    if (!qTAtom.isType(Base64.substring((String)"iags", (int)(723 / 151)))) break block12;
                                    l3 = iRandomAccessReader.getFilePointer();
                                    if (!bl3 && qTAtommoof != null) {
                                        qTAtommoof.setMdatFileOffset(l3, qTMediaContainer);
                                    }
                                    QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
                                    break block7;
                                }
                                bl4 = true;
                                break block13;
                            }
                            QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
                            break block7;
                        }
                        bl4 = false;
                    }
                    bl3 = bl4;
                }
                bl2 = true;
                if (bl3 && qTAtommoof != null) {
                    qTAtommoof.setMdatFileOffset(l3, qTMediaContainer);
                }
                qTMediaContainer.setFragmented(true);
            }
            if ((l2 = qTAtom.getSize()) > 0L) continue;
            throw new Exception(FileChunk.regionMatches((int)(29 * 37), (String)"@FF`|zd6i{ioxOK\r$&*%\u0006))<(#%)?to\u0011%=>t&?-=y3(|40)!-+'~e") + l2);
        }
        if (bl) {
            qTMediaContainer.flush();
            return qTMediaContainer;
        }
        throw new Exception(FileChunk.regionMatches((int)(1158 / 175), (String)"WS]}cg\u007f#~nbbwB@XssqxYtri\u007fvndp9$Cokm)cx,`g|cx|t42{xwo=;}iqrn"));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomudta parseAtomudta(IRandomAccessReader var0, QTAtom var1_1, QTParseContext var2_2) throws Exception {
        var3_3 = null;
        var3_3 = new QTAtomudta(var1_1);
        var4_5 = new byte[4];
        var5_6 = var0.getFilePointer();
        var7_7 = var1_1.getDataSize();
        var9_8 = 0L;
        block2: while (var9_8 < var7_7) {
            var0.read(var4_5, 0, 4);
            var9_8 += 4L;
            var11_12 = BufferUtils.byteArrayToInt((byte[])var4_5);
            if (var11_12 <= 4) break;
            var0.read(var4_5, 0, 4);
            var9_8 += 4L;
            var12_13 = new String(var4_5, FileChunk.regionMatches((int)(1176 / 190), (String)"SSN$2"));
            if (var12_13.equals(Base64.substring((String)"ad\u007fe", (int)(55 * 31)))) {
                var13_16 = 0;
            } else {
                if (!var12_13.equals(FileChunk.regionMatches((int)(109 + -37), (String)"  $-"))) {
                    if (var12_13.equals(FileChunk.regionMatches((int)(43 * 59), (String)"'+&)"))) {
                        var13_15 = new byte[var11_12 - 8];
                        var0.read(var13_15, 0, var11_12 - 8);
                        var9_8 += (long)(var11_12 - 8);
                        var14_11 = new String(var13_15, Base64.substring((String)"\u0014\u0016\u0005i}", (int)(13 - 44)));
                        var3_3.setName(var14_11);
                        continue;
                    }
                    QTUtils.skipBytesLong(var0, (long)(var11_12 - 8));
                    var9_8 += (long)(var11_12 - 8);
                    continue;
                }
                var13_14 = 0;
                while (true) {
                    if (var13_14 < var11_12 - 8) {
                        var0.read(var4_5, 0, 4);
                        var13_14 += 4;
                        var14_10 = BufferUtils.byteArrayToInt((byte[])var4_5);
                        var0.read(var4_5, 0, 4);
                        var13_14 += 4;
                        var15_17 = new String(var4_5, FileChunk.regionMatches((int)(-13 - -6), (String)"\f\u000e\u001dqe"));
                        if (var14_10 < 0) throw new Exception(Base64.substring((String)"WS]}cg\u007f#~nbbwR`z{b|m{!<F", (int)(1175 / 168)) + var15_17 + FileChunk.regionMatches((int)(2 + 76), (String)"\u0013up\u001337t&?-=cz") + var14_10 + ":" + var1_1.getDataSize());
                        if ((long)var14_10 > var1_1.getDataSize()) {
                            throw new Exception(Base64.substring((String)"WS]}cg\u007f#~nbbwR`z{b|m{!<F", (int)(1175 / 168)) + var15_17 + FileChunk.regionMatches((int)(2 + 76), (String)"\u0013up\u001337t&?-=cz") + var14_10 + ":" + var1_1.getDataSize());
                        }
                        if (var15_17.equals(Base64.substring((String)":*59", (int)(-52 - -30)))) {
                            var0.read(var4_5, 0, 4);
                            var13_14 += 4;
                            var16_19 = BufferUtils.byteArrayToInt((byte[])var4_5);
                            var0.read(var4_5, 0, 1);
                            ++var13_14;
                            var17_22 = new byte[var14_10 - 13];
                            var0.read(var17_22, 0, var14_10 - 13);
                            var13_14 += var14_10 - 13;
                            var18_24 = new String(var17_22, Base64.substring((String)"NH[3'", (int)(45 * 7)));
                            var3_3.setPaytType(var16_19);
                            var3_3.setPaytStr(var18_24);
                            continue;
                        }
                        if (var14_10 < 0) throw new Exception(FileChunk.regionMatches((int)(108 + -29), (String)"\u001e\u0004\u0004&:8&x'9+)>\u001d)125%6\"~e\u001d") + var15_17 + FileChunk.regionMatches((int)(647 / 119), (String)"X<'Jhn+\u007fdtj*1") + var14_10 + ":" + var1_1.getDataSize());
                        if ((long)var14_10 > var1_1.getDataSize()) {
                            throw new Exception(FileChunk.regionMatches((int)(108 + -29), (String)"\u001e\u0004\u0004&:8&x'9+)>\u001d)125%6\"~e\u001d") + var15_17 + FileChunk.regionMatches((int)(647 / 119), (String)"X<'Jhn+\u007fdtj*1") + var14_10 + ":" + var1_1.getDataSize());
                        }
                        var16_18 = new byte[var14_10 - 8];
                        var0.read(var16_18, 0, var14_10 - 8);
                        var13_14 += var14_10 - 8;
                        var3_3.addHinfData(var15_17, var16_18);
                        if (var15_17.equals(Base64.substring((String)"4;#.", (int)(11 * 43)))) {
                            var17_23 = BufferUtils.byteArrayToInt((byte[])var16_18);
                            var18_25 = BufferUtils.byteArrayToInt((byte[])var16_18, (int)4);
                            continue;
                        }
                        if (var14_10 - 8 == 4) {
                            var17_21 = BufferUtils.byteArrayToInt((byte[])var16_18);
                            continue;
                        }
                    } else {
                        var9_8 += (long)(var11_12 - 8);
                        continue block2;
                    }
                    if (var14_10 - 8 != 8) continue;
                    var17_20 = BufferUtils.byteArrayToLong((byte[])var16_18, (int)0, (int)8);
                }
                while (true) {
                    var9_8 += (long)(var11_12 - 8);
                    continue block2;
                    break;
                }
            }
            while (true) {
                if (var13_16 >= var11_12 - 8) ** continue;
                var0.read(var4_5, 0, 4);
                var13_16 += 4;
                var14_9 = BufferUtils.byteArrayToInt((byte[])var4_5);
                var0.read(var4_5, 0, 4);
                var13_16 += 4;
                var15_17 = new String(var4_5, Base64.substring((String)"LN]1%", (int)(63 + -38)));
                if (var14_9 < 0) throw new Exception(Base64.substring((String)"RPPrndz${m\u007f}jQe}~aqbv\"9AsriwB:!@b`%unrl0+", (int)(30 + -27)) + var14_9 + ":" + var1_1.getDataSize());
                if ((long)var14_9 > var1_1.getDataSize()) {
                    throw new Exception(Base64.substring((String)"RPPrndz${m\u007f}jQe}~aqbv\"9AsriwB:!@b`%unrl0+", (int)(30 + -27)) + var14_9 + ":" + var1_1.getDataSize());
                }
                QTUtils.skipBytesLong(var0, (long)(var14_9 - 8));
                var13_16 += var14_9 - 8;
            }
        }
        var0.seek(var5_6);
        QTUtils.skipBytesLong(var0, var1_1.getDataSize());
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtommoof parseAtommoof(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext, QTMediaContainer qTMediaContainer) throws Exception {
        QTAtommoof qTAtommoof = null;
        qTAtommoof = new QTAtommoof(qTAtom);
        qTAtommoof.setMoofFileOffset(iRandomAccessReader.getFilePointer());
        long l = qTAtom.getDataSize();
        long l2 = 0L;
        while (l2 < l) {
            long l3;
            QTAtom qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
            if (qTAtom2 == null) {
                return qTAtommoof;
            }
            if (qTAtom2.isType(FileChunk.regionMatches((int)(959 / 169), (String)"qtfn"))) {
                QTAtomtraf qTAtomtraf = QTUtils.parseAtomtraf(iRandomAccessReader, qTAtom2, qTParseContext, qTAtommoof, qTMediaContainer);
            } else if (qTAtom2.isType(FileChunk.regionMatches((int)(43 * 57), (String)"~r}r"))) {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            if ((l3 = qTAtom2.getSize()) <= 0L) {
                throw new Exception(Base64.substring((String)"^DDfzxf8gyki~]iqr-.-%~e\u00073'$j8%7+o9\"r::#7;1=`{", (int)(13 * 43)) + l3);
            }
            l2 += l3;
        }
        return qTAtommoof;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtommfhd parseAtommfhd(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtommfhd qTAtommfhd = null;
        qTAtommfhd = new QTAtommfhd(qTAtom);
        byte[] byArray = new byte[4];
        long l = qTAtom.getDataSize();
        long l2 = iRandomAccessReader.getFilePointer();
        iRandomAccessReader.seek(l2);
        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        return qTAtommfhd;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomtraf parseAtomtraf(IRandomAccessReader var0, QTAtom var1_1, QTParseContext var2_2, QTAtommoof var3_3, QTMediaContainer var4_4) throws Exception {
        var5_5 = null;
        var5_5 = new QTAtomtraf(var1_1);
        var6_7 = new byte[4];
        var7_8 = var1_1.getDataSize();
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        var12_12 = null;
        var13_13 = 0L;
        block2: while (var13_13 < var7_8) {
            block33: {
                block35: {
                    block37: {
                        block36: {
                            block29: {
                                block31: {
                                    block34: {
                                        block32: {
                                            block30: {
                                                block28: {
                                                    var15_14 = QTUtils.readAtomHeader(var0);
                                                    if (var15_14 == null) {
                                                        return var5_5;
                                                    }
                                                    var16_15 = var0.getFilePointer();
                                                    if (!var15_14.isType(FileChunk.regionMatches((int)(495 / 95), (String)"q`ol"))) break block28;
                                                    var0.read(var6_7, 0, 4);
                                                    var18_17 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)1, (int)3);
                                                    var0.read(var6_7, 0, 4);
                                                    var19_22 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                                    var9_9 = var3_3.getFragmentTrakData(var19_22);
                                                    var10_10 = var4_4.getFragmentTrakData(var19_22);
                                                    var9_9.startSampleOffset = var10_10.getCurrentSample();
                                                    var20_27 = var4_4.getMoovAtom();
                                                    if (var20_27 != null && (var11_11 = var20_27.getTrackById(var19_22)) != null) {
                                                        var12_12 = var11_11.getMdiaAtom().getMinfAtom().getStblAtom();
                                                    }
                                                    if ((var18_17 & 1) == 1) {
                                                        var20_27 = new byte[8];
                                                        var0.read((byte[])var20_27, 0, 8);
                                                        var9_9.base_data_offset = BufferUtils.byteArrayToLong((byte[])var20_27);
                                                    }
                                                    if ((var18_17 & 2) == 2) {
                                                        var0.read(var6_7, 0, 4);
                                                        var9_9.sample_description_index = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                                    }
                                                    if ((var18_17 & 8) == 8) {
                                                        var0.read(var6_7, 0, 4);
                                                        var9_9.default_sample_duration = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                                    }
                                                    break block29;
                                                }
                                                if (!var15_14.isType(FileChunk.regionMatches((int)(17 * 31), (String)"{bd|"))) break block30;
                                                var0.read(var6_7, 0, 4);
                                                var18_16 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)1, (int)3);
                                                var19_21 = 0;
                                                var20_26 = 0;
                                                var21_28 = 0;
                                                var0.read(var6_7, 0, 4);
                                                var19_21 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                                var10_10.incCurrentSample(var19_21);
                                                if ((var18_16 & 1) == 1) {
                                                    var0.read(var6_7, 0, 4);
                                                    var20_26 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                                }
                                                break block31;
                                            }
                                            if (!var15_14.isType(Base64.substring((String)"9/8=", (int)(-3 - 51)))) break block32;
                                            var0.read(var6_7, 0, 4);
                                            var18_18 = true;
                                            var19_23 = var4_4.getMoovAtom();
                                            if (var19_23 != null && (var20_27 = var19_23.getTrak(var9_9.trakId - 1)) != null) {
                                                var21_29 = var19_23.getVideoTrack(0);
                                                var18_18 = var20_27.equals(var21_29);
                                            }
                                            if (!var18_18) break block33;
                                            var19_24 = (int)var15_14.getDataSize() - 4;
                                            var20_27 = new byte[var19_24];
                                            var0.read((byte[])var20_27, 0, var19_24);
                                            var21_30 = 0;
                                            if (true) ** GOTO lbl205
                                        }
                                        if (!var15_14.isType(FileChunk.regionMatches((int)(96 + 89), (String)"lorx"))) break block34;
                                        var18_20 = new byte[16];
                                        var0.read(var18_20, 0, 16);
                                        var0.read(var6_7, 0, 1);
                                        var0.read(var6_7, 0, 3);
                                        var19_25 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)3);
                                        if (!Arrays.equals(QTUtils.UUID_FRAGBOX, var18_20)) break block35;
                                        var20_27 = new PlayReadySampleIndex();
                                        var20_27.setFlags(var19_25);
                                        if ((var19_25 & 1) == 1) break block36;
                                        if (var12_12 != null && (var21_32 = var12_12.getPlayReadyTrackInfo()) != null) {
                                            var20_27.setAlgorithmID(var21_32.getAlgorithmID());
                                            var20_27.setIvSize(var21_32.getIvSize());
                                            var20_27.setKeyID(var21_32.getKeyID());
                                        }
                                        break block37;
                                    }
                                    QTUtils.skipBytesLong(var0, var15_14.getDataSize());
                                    ** GOTO lbl198
                                }
                                if ((var18_16 & 4) == 4) {
                                    var0.read(var6_7, 0, 4);
                                    var21_28 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                                }
                                var22_34 = 0;
                                if (true) ** GOTO lbl167
                            }
                            if ((var18_17 & 16) == 16) {
                                var0.read(var6_7, 0, 4);
                                var9_9.default_sample_size = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                            }
                            if ((var18_17 & 32) == 32) {
                                var0.read(var6_7, 0, 4);
                                var9_9.default_sample_flags = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                            }
                            var0.seek(var16_15);
                            QTUtils.skipBytesLong(var0, var15_14.getDataSize());
                            ** GOTO lbl198
                        }
                        var0.read(var6_7, 0, 3);
                        var21_33 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)3);
                        var0.read(var6_7, 0, 1);
                        var22_36 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)1);
                        var23_39 = new byte[16];
                        var0.read(var23_39, 0, var23_39.length);
                        var20_27.setAlgorithmID(var21_33);
                        var20_27.setIvSize(var22_36);
                        var20_27.setKeyID(var23_39);
                        var20_27.setLocalKeyId(true);
                    }
                    var0.read(var6_7, 0, 4);
                    var21_31 = var0.getFilePointer();
                    var23_37 = (int)(var15_14.getDataSize() - (var21_31 - var16_15));
                    var20_27.setFilePos(var21_31);
                    var20_27.setSize(var23_37);
                    if (var11_11 != null) {
                        var11_11.addPlayReadyIndex(var9_9.startSampleOffset, (PlayReadySampleIndex)var20_27);
                        var2_2.incIndexRefCount();
                    }
                }
                var0.seek(var16_15);
                QTUtils.skipBytesLong(var0, var15_14.getDataSize());
                ** GOTO lbl198
                while (true) {
                    var10_10.addSampleSize(var24_40);
                    var25_41 = var9_9.default_sample_flags;
                    if (var22_34 == 0 && (var18_16 & 4) == 4) {
                        var25_41 = var21_28;
                    }
                    if ((var18_16 & 1024) == 1024) {
                        var0.read(var6_7, 0, 4);
                        var25_41 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                    }
                    if ((var25_41 >> 24 & 3) == 2) {
                        var10_10.addSyncSample(var9_9.startSampleOffset + (long)var9_9.trunSampleOffset + (long)var22_34);
                    }
                    var26_42 = 0;
                    if ((var18_16 & 2048) == 2048) {
                        var0.read(var6_7, 0, 4);
                        var26_42 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                    }
                    var10_10.addCTTS(var26_42);
                    ++var22_34;
lbl167:
                    // 2 sources

                    if (var22_34 < var19_21) {
                        var23_37 = var9_9.default_sample_duration;
                        if ((var18_16 & 256) == 256) {
                            var0.read(var6_7, 0, 4);
                            var23_37 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                        }
                    } else {
                        var9_9.trunSampleOffset += var19_21;
                        var10_10.addChunk(var19_21, var9_9.sample_description_index);
                        var22_35 = var9_9.base_data_offset;
                        if (var20_26 <= 0 || var22_35 > 0L) break;
                        var22_35 = var3_3.getMoofFileOffset() - 8L;
                        break;
                    }
                    var10_10.addTimeToSample(var23_37);
                    var24_40 = var9_9.default_sample_size;
                    if ((var18_16 & 512) != 512) continue;
                    var0.read(var6_7, 0, 4);
                    var24_40 = BufferUtils.byteArrayToInt((byte[])var6_7, (int)0, (int)4);
                }
                if (var22_35 + (long)var20_26 > 0L) {
                    var10_10.addChunkFileOffset(var22_35 + (long)var20_26);
                } else {
                    var9_9.doFileoffset = true;
                }
                var0.seek(var16_15);
                QTUtils.skipBytesLong(var0, var15_14.getDataSize());
                ** GOTO lbl198
            }
            while (true) {
                var0.seek(var16_15);
                QTUtils.skipBytesLong(var0, var15_14.getDataSize());
lbl198:
                // 5 sources

                if ((var18_19 = var15_14.getSize()) <= 0L) {
                    throw new Exception(Base64.substring((String)"\r\t\u000b+imq-tdttmH~day|n{+2R`z{7kp`~<tm?iotbhlb=(", (int)(21 - 25)) + var18_19);
                }
                var13_13 += var18_19;
                continue block2;
                break;
            }
        }
        return var5_5;
        while (true) {
            ++var21_30;
lbl205:
            // 2 sources

            if (var21_30 >= var19_24) ** continue;
            if ((var20_27[var21_30] >> 4 & 3) != 2) continue;
            var10_10.addSyncSample(var9_9.startSampleOffset + (long)var21_30);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtommoov parseAtommoov(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtommoov qTAtommoov = null;
        qTAtommoov = new QTAtommoov(qTAtom);
        long l = qTAtom.getDataSize();
        long l2 = 0L;
        while (l2 < l) {
            long l3;
            QTAtom qTAtom2;
            block12: {
                long l4;
                block18: {
                    byte[] byArray;
                    block19: {
                        block17: {
                            block16: {
                                QTAtomtrak qTAtomtrak;
                                block15: {
                                    block14: {
                                        block13: {
                                            qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
                                            if (qTAtom2 == null) {
                                                return qTAtommoov;
                                            }
                                            l4 = iRandomAccessReader.getFilePointer();
                                            if (!qTAtom2.isType(FileChunk.regionMatches((int)(11 * 49), (String)"on|u"))) break block13;
                                            qTAtomtrak = QTUtils.parseAtomtrak(iRandomAccessReader, qTAtommoov, qTAtom2, qTParseContext);
                                            if (!qTAtomtrak.isAudio()) break block14;
                                            break block15;
                                        }
                                        if (!qTAtom2.isType(FileChunk.regionMatches((int)(26 - -54), (String)"%5&2"))) break block16;
                                        QTAtomudta qTAtomudta = QTUtils.parseAtomudta(iRandomAccessReader, qTAtom2, qTParseContext);
                                        qTAtommoov.setUdtaAtom(qTAtomudta);
                                        break block12;
                                    }
                                    if (qTAtomtrak.isVideo()) {
                                        if (!qTParseContext.isParseVideoTrack()) {
                                            qTAtommoov.addTrak(null);
                                            break block12;
                                        } else {
                                            qTAtommoov.addTrak(qTAtomtrak);
                                        }
                                        break block12;
                                    } else {
                                        qTAtommoov.addTrak(qTAtomtrak);
                                    }
                                    break block12;
                                }
                                if (!qTParseContext.isParseAudioTrack()) {
                                    qTAtommoov.addTrak(null);
                                    break block12;
                                } else {
                                    qTAtommoov.addTrak(qTAtomtrak);
                                }
                                break block12;
                            }
                            if (!qTAtom2.isType(FileChunk.regionMatches((int)(51 * 37), (String)"*5(&"))) break block17;
                            byte[] byArray2 = new byte[16];
                            iRandomAccessReader.read(byArray2, 0, byArray2.length);
                            byArray = new byte[4];
                            iRandomAccessReader.read(byArray, 0, 4);
                            if (!Arrays.equals(byArray2, UUID_PROTECTIONBOX)) break block18;
                            break block19;
                        }
                        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
                        break block12;
                    }
                    byte[] byArray3 = new byte[16];
                    iRandomAccessReader.read(byArray3, 0, byArray3.length);
                    iRandomAccessReader.read(byArray, 0, 4);
                    int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    byte[] byArray4 = null;
                    if (n > 0) {
                        byArray4 = new byte[n];
                        iRandomAccessReader.read(byArray4, 0, n);
                    }
                    PlayReadyMediaInfo playReadyMediaInfo = new PlayReadyMediaInfo();
                    playReadyMediaInfo.setSystemId(byArray3);
                    playReadyMediaInfo.setExtraData(byArray4);
                    qTAtommoov.setPlayReadyInfo(playReadyMediaInfo);
                }
                iRandomAccessReader.seek(l4);
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            if ((l3 = qTAtom2.getSize()) <= 0L) {
                throw new Exception(FileChunk.regionMatches((int)(49 * 49), (String)"\u0010\u0016\u00160,*4f9+9?(\u000f;?<?<;#lw\u0019-56|.7%e!kp$lhqieco6-") + l3);
            }
            l2 += l3;
        }
        return qTAtommoov;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomtrak parseAtomtrak(IRandomAccessReader iRandomAccessReader, QTAtommoov qTAtommoov, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtomtrak qTAtomtrak = null;
        qTAtomtrak = new QTAtomtrak(qTAtom);
        byte[] byArray = new byte[4];
        long l = qTAtom.getDataSize();
        long l2 = 0L;
        while (l2 < l) {
            long l3;
            QTAtom qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
            if (qTAtom2 == null) {
                return qTAtomtrak;
            }
            if (qTAtom2.isType(FileChunk.regionMatches((int)(972 / 175), (String)"hbni"))) {
                QTAtommdia qTAtommdia = QTUtils.parseAtommdia(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setMdiaAtom(qTAtommdia);
            } else if (qTAtom2.isType(Base64.substring((String)"{kdp", (int)(-59 - 23)))) {
                QTAtomudta qTAtomudta = QTUtils.parseAtomudta(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setUdtaAtom(qTAtomudta);
            } else if (qTAtom2.isType(FileChunk.regionMatches((int)(300 / 68), (String)"pnnc"))) {
                QTAtomtkhd qTAtomtkhd = QTUtils.parseAtomtkhd(iRandomAccessReader, qTAtom2, qTParseContext);
                qTAtomtrak.setTkhdAtom(qTAtomtkhd);
                int n = (int)qTAtomtkhd.getTrackId();
                qTAtomtrak.setTrackId(n);
                qTAtommoov.putTrack(n, qTAtomtrak);
            } else if (qTAtom2.isType(Base64.substring((String)"60!%", (int)(37 + 78)))) {
                QTAtomedts qTAtomedts = QTUtils.parseAtomedts(iRandomAccessReader, qTAtom2, qTAtomtrak, qTParseContext);
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            if ((l3 = qTAtom2.getSize()) <= 0L) {
                throw new Exception(FileChunk.regionMatches((int)(27 * 11), (String)"X^^xdb|>asagpWcwtni}v$?\u00015-.d6/=-i#8l$ 91=;7nu") + l3);
            }
            l2 += l3;
        }
        return qTAtomtrak;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomedts parseAtomedts(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTAtomtrak qTAtomtrak, QTParseContext qTParseContext) throws Exception {
        QTAtom qTAtom2;
        long l;
        long l2;
        byte[] byArray;
        long l3;
        QTAtomedts qTAtomedts;
        block8: {
            qTAtomedts = null;
            l3 = iRandomAccessReader.getFilePointer();
            try {
                qTAtomedts = new QTAtomedts(qTAtom);
                byArray = new byte[4];
                l2 = qTAtom.getDataSize();
                break block8;
            }
            catch (Throwable throwable) {}
            {
                catch (Exception exception) {
                    throw exception;
                }
            }
            iRandomAccessReader.seek(l3);
            QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
            throw throwable;
        }
        for (long i = 0L; i < l2 && (qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader)) != null; i += l) {
            if (!qTAtom2.isType(Base64.substring((String)";335", (int)(-8 - 26)))) {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            } else {
                iRandomAccessReader.read(byArray, 0, 1);
                int n = byArray[0] & 0xFF;
                iRandomAccessReader.read(byArray, 0, 3);
                int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                iRandomAccessReader.read(byArray, 0, 4);
                int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                for (int j = 0; j < n3; ++j) {
                    double d;
                    QTEditListEntry qTEditListEntry = new QTEditListEntry();
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTEditListEntry.trackDuration = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    iRandomAccessReader.read(byArray, 0, 4);
                    qTEditListEntry.mediaTime = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    iRandomAccessReader.read(byArray, 0, 4);
                    int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4);
                    qTEditListEntry.mediaRate = d = (double)n4 / 65536.0;
                    qTAtomtrak.addEditListEntry(qTEditListEntry);
                }
            }
            if ((l = qTAtom2.getSize()) > 0L) continue;
            throw new Exception(Base64.substring((String)"\u0018\u001e\u001e8$\"<~!3!'0\u0017#74.)=6d\u007f\u00015-.d6/=-i#8l$ 91=;7nu", (int)(7 + 66)) + l);
        }
        iRandomAccessReader.seek(l3);
        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        return qTAtomedts;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomtkhd parseAtomtkhd(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        long l;
        QTAtomtkhd qTAtomtkhd;
        block4: {
            byte[] byArray;
            block7: {
                long l2;
                long l3;
                byte[] byArray2;
                block6: {
                    block5: {
                        qTAtomtkhd = null;
                        l = iRandomAccessReader.getFilePointer();
                        try {
                            qTAtomtkhd = new QTAtomtkhd(qTAtom);
                            byArray = new byte[4];
                            byArray2 = new byte[8];
                            long l4 = 0L;
                            long l5 = qTAtom.getDataSize();
                            if (l4 >= l5) break block4;
                            iRandomAccessReader.read(byArray, 0, 1);
                            int n = byArray[0] & 0xFF;
                            iRandomAccessReader.read(byArray, 0, 3);
                            int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                            qTAtomtkhd.setFlags(n2);
                            if (n <= 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {}
                        {
                            catch (Exception exception) {
                                throw exception;
                            }
                        }
                        iRandomAccessReader.seek(l);
                        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
                        throw throwable;
                    }
                    iRandomAccessReader.read(byArray, 0, 4);
                    l3 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setCreationTime(l3);
                    iRandomAccessReader.read(byArray, 0, 4);
                    l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setModificationTime(l2);
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l6 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setTrackId(l6);
                    IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
                    iRandomAccessReader2.seek(iRandomAccessReader2.getFilePointer() + 4L);
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l7 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    qTAtomtkhd.setDuration(l7);
                    break block7;
                }
                iRandomAccessReader.read(byArray2, 0, 8);
                l3 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                qTAtomtkhd.setCreationTime(l3);
                iRandomAccessReader.read(byArray2, 0, 8);
                l2 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                qTAtomtkhd.setModificationTime(l2);
                iRandomAccessReader.read(byArray, 0, 4);
                long l8 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                qTAtomtkhd.setTrackId(l8);
                IRandomAccessReader iRandomAccessReader3 = iRandomAccessReader;
                iRandomAccessReader3.seek(iRandomAccessReader3.getFilePointer() + 4L);
                iRandomAccessReader.read(byArray2, 0, 8);
                long l9 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                qTAtomtkhd.setDuration(l9);
            }
            IRandomAccessReader iRandomAccessReader4 = iRandomAccessReader;
            iRandomAccessReader4.seek(iRandomAccessReader4.getFilePointer() + 8L);
            iRandomAccessReader.read(byArray, 0, 2);
            int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
            qTAtomtkhd.setLayer(n);
            iRandomAccessReader.read(byArray, 0, 2);
            int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
            qTAtomtkhd.setAlternateGroup(n3);
            iRandomAccessReader.read(byArray, 0, 2);
            int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
            qTAtomtkhd.setVolume(n4);
            IRandomAccessReader iRandomAccessReader5 = iRandomAccessReader;
            iRandomAccessReader5.seek(iRandomAccessReader5.getFilePointer() + 2L);
            IRandomAccessReader iRandomAccessReader6 = iRandomAccessReader;
            iRandomAccessReader6.seek(iRandomAccessReader6.getFilePointer() + 36L);
            iRandomAccessReader.read(byArray, 0, 4);
            long l10 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
            qTAtomtkhd.setTrackWidth(l10 >>= 16);
            iRandomAccessReader.read(byArray, 0, 4);
            long l11 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
            qTAtomtkhd.setTrackHeight(l11 >>= 16);
        }
        iRandomAccessReader.seek(l);
        QTUtils.skipBytesLong(iRandomAccessReader, qTAtom.getDataSize());
        return qTAtomtkhd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtommdia parseAtommdia(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        QTAtommdia qTAtommdia;
        block10: {
            qTAtommdia = null;
            qTAtommdia = new QTAtommdia(qTAtom);
            byte[] byArray = new byte[4];
            long l = qTAtom.getDataSize();
            long l2 = 0L;
            while (l2 < l) {
                long l3;
                QTAtom qTAtom2;
                block11: {
                    int n;
                    block14: {
                        block13: {
                            block12: {
                                qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
                                if (qTAtom2 == null) break block10;
                                if (!qTAtom2.isType(FileChunk.regionMatches((int)(11 - -43), (String)"{sp}"))) break block12;
                                l3 = iRandomAccessReader.getFilePointer();
                                iRandomAccessReader.read(byArray, 0, 1);
                                n = byArray[0] & 0xFF;
                                IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
                                iRandomAccessReader2.seek(iRandomAccessReader2.getFilePointer() + 3L);
                                if (n == 1) break block13;
                                IRandomAccessReader iRandomAccessReader3 = iRandomAccessReader;
                                iRandomAccessReader3.seek(iRandomAccessReader3.getFilePointer() + 8L);
                                break block14;
                            }
                            if (qTAtom2.isType(FileChunk.regionMatches((int)(200 / 37), (String)"mbkz"))) {
                                l3 = iRandomAccessReader.getFilePointer();
                                IRandomAccessReader iRandomAccessReader4 = iRandomAccessReader;
                                iRandomAccessReader4.seek(iRandomAccessReader4.getFilePointer() + 8L);
                                iRandomAccessReader.read(byArray, 0, 4);
                                String string = new String(byArray, FileChunk.regionMatches((int)(-49 - -13), (String)"\t\t\u0018rx"));
                                qTAtommdia.setSubType(string);
                                iRandomAccessReader.seek(l3);
                                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
                                break block11;
                            } else if (qTAtom2.isType(FileChunk.regionMatches((int)(1189 / 235), (String)"hoin"))) {
                                QTAtomminf qTAtomminf = QTUtils.parseAtomminf(iRandomAccessReader, qTAtom2, qTParseContext);
                                qTAtommdia.setMinfAtom(qTAtomminf);
                                break block11;
                            } else {
                                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
                            }
                            break block11;
                        }
                        IRandomAccessReader iRandomAccessReader5 = iRandomAccessReader;
                        iRandomAccessReader5.seek(iRandomAccessReader5.getFilePointer() + 16L);
                    }
                    iRandomAccessReader.read(byArray, 0, 4);
                    long l4 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    long l5 = 0L;
                    if (n == 1) {
                        byte[] byArray2 = new byte[8];
                        iRandomAccessReader.read(byArray2, 0, 8);
                        l5 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)8);
                    } else {
                        iRandomAccessReader.read(byArray, 0, 4);
                        l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                    }
                    qTAtommdia.setTimescale(l4);
                    qTAtommdia.setDuration(l5);
                    iRandomAccessReader.read(byArray, 0, 2);
                    int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
                    qTAtommdia.setLanguage(n2);
                    iRandomAccessReader.seek(l3);
                    QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
                }
                if ((l3 = qTAtom2.getSize()) <= 0L) {
                    throw new Exception(FileChunk.regionMatches((int)(91 + 43), (String)"WS]}cg\u007f#~nbbwR`z{z|p{!<\\jpm!qj~`&n{)cezlbft+2") + l3);
                }
                l2 += l3;
            }
            return qTAtommdia;
        }
        return qTAtommdia;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static QTAtomminf parseAtomminf(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, QTParseContext qTParseContext) throws Exception {
        long l;
        QTAtom qTAtom2;
        QTAtomminf qTAtomminf = null;
        qTAtomminf = new QTAtomminf(qTAtom);
        long l2 = iRandomAccessReader.getFilePointer();
        long l3 = qTAtom.getDataSize();
        long l4 = 0L;
        while (true) {
            block15: {
                block14: {
                    block13: {
                        if (l4 >= l3) break;
                        qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
                        if (qTAtom2.isType(FileChunk.regionMatches((int)(31 * 35), (String)"ksw$"))) break block13;
                        if (!qTAtom2.isType(Base64.substring((String)"? &+", (int)(112 + 92)))) break block14;
                        qTAtomminf.setMinfType(FileChunk.regionMatches((int)(40 + -29), (String)"xaej"));
                        break block15;
                    }
                    qTAtomminf.setMinfType(FileChunk.regionMatches((int)(29 * 45), (String)"owsx"));
                    break block15;
                }
                if (qTAtom2.isType(FileChunk.regionMatches((int)(-27 - -26), (String)"8mif"))) {
                    qTAtomminf.setMinfType(Base64.substring((String)"enla", (int)(41 - 39)));
                } else if (qTAtom2.isType(Base64.substring((String)"squz", (int)(5 * 63)))) {
                    qTAtomminf.setMinfType(FileChunk.regionMatches((int)(48 - -3), (String)"{y}r"));
                } else if (qTAtom2.isType(FileChunk.regionMatches((int)(1456 / 238), (String)"hj`m"))) {
                    qTAtomminf.setMinfType(FileChunk.regionMatches((int)(586 / 122), (String)"jhnc"));
                }
            }
            QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            l = qTAtom2.getSize();
            if (l <= 0L) {
                throw new Exception(Base64.substring((String)"]Y[{y}a=dtdd}Xntqpwqf;\"Bpjk'{`pn,d}/y\u007fdrx|r-8", (int)(26 - 14)) + l);
            }
            l4 += l;
        }
        iRandomAccessReader.seek(l2);
        l4 = 0L;
        while (l4 < l3) {
            qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
            if (qTAtom2 == null) return qTAtomminf;
            if (qTAtom2.isType(Base64.substring((String)".*=,", (int)(83 + 10)))) {
                QTAtomstbl qTAtomstbl = QTUtils.parseAtomstbl(iRandomAccessReader, qTAtom2, qTAtomminf.getMinfType(), qTParseContext);
                qTAtomminf.setStblAtom(qTAtomstbl);
            } else {
                QTUtils.skipBytesLong(iRandomAccessReader, qTAtom2.getDataSize());
            }
            if ((l = qTAtom2.getSize()) <= 0L) {
                throw new Exception(Base64.substring((String)"DBBlpvh2m\u007fmsdCwkhknfo0+Myab0b{iq5\u007fd8ptm}qw{za", (int)(23 + 126)) + l);
            }
            l4 += l;
        }
        return qTAtomminf;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomstbl parseAtomstbl(IRandomAccessReader var0, QTAtom var1_1, String var2_2, QTParseContext var3_3) throws Exception {
        block49: {
            var4_4 = null;
            var4_4 = new QTAtomstbl(var1_1);
            var5_6 = new byte[4];
            var6_7 = new byte[8];
            var7_8 = var1_1.getDataSize();
            var9_9 = 0L;
lbl11:
            // 2 sources

            while (true) {
                block59: {
                    block60: {
                        block57: {
                            block58: {
                                block67: {
                                    block51: {
                                        block52: {
                                            block65: {
                                                block63: {
                                                    block66: {
                                                        block64: {
                                                            block62: {
                                                                block61: {
                                                                    block56: {
                                                                        block54: {
                                                                            block55: {
                                                                                block53: {
                                                                                    block50: {
                                                                                        if (var9_9 >= var7_8) return var4_4;
                                                                                        var11_10 = QTUtils.readAtomHeader(var0);
                                                                                        if (var11_10 == null) {
                                                                                            return var4_4;
                                                                                        }
                                                                                        if (!var11_10.isType(Base64.substring((String)"  !%", (int)(55 * 37)))) break block50;
                                                                                        var12_11 = var0.getFilePointer();
                                                                                        v0 = var0;
                                                                                        v0.seek(v0.getFilePointer() + 4L);
                                                                                        var0.read(var5_6, 0, 4);
                                                                                        var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                                                        if (var14_12 <= 0) break block51;
                                                                                        var15_15 = 8;
                                                                                        var16_22 = var14_12 * var15_15;
                                                                                        if (var16_22 < 0) throw new Exception(FileChunk.regionMatches((int)(79 + -12), (String)"\u0012\u0010\u00102.$:d;-?=*\u0011%=>'!4;by\u0001") + var11_10 + Base64.substring((String)"\u0000d\u007f\u0002 &c7,<\"ri", (int)(13 * 17)) + var16_22 + ":" + var1_1.getDataSize());
                                                                                        if ((long)var16_22 > var1_1.getDataSize()) {
                                                                                            throw new Exception(FileChunk.regionMatches((int)(79 + -12), (String)"\u0012\u0010\u00102.$:d;-?=*\u0011%=>'!4;by\u0001") + var11_10 + Base64.substring((String)"\u0000d\u007f\u0002 &c7,<\"ri", (int)(13 * 17)) + var16_22 + ":" + var1_1.getDataSize());
                                                                                        }
                                                                                        break block52;
                                                                                    }
                                                                                    if (!var11_10.isType(Base64.substring((String)"oiml", (int)(96 + 92)))) break block53;
                                                                                    var12_11 = var0.getFilePointer();
                                                                                    v1 = var0;
                                                                                    v1.seek(v1.getFilePointer() + 4L);
                                                                                    var0.read(var5_6, 0, 4);
                                                                                    var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                                                    if (var14_12 != 0) break block54;
                                                                                    break block55;
                                                                                }
                                                                                if (!var11_10.isType(Base64.substring((String)"%#+:", (int)(48 + 70)))) break block56;
                                                                                var12_11 = var0.getFilePointer();
                                                                                v2 = var0;
                                                                                v2.seek(v2.getFilePointer() + 4L);
                                                                                var0.read(var5_6, 0, 4);
                                                                                var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                                                if (var14_12 <= 0) break block57;
                                                                                break block58;
                                                                            }
                                                                            var14_12 = (int)((var11_10.getDataSize() - 8L) / 4L);
                                                                        }
                                                                        if (var14_12 <= 0) break block59;
                                                                        var15_17 = 4;
                                                                        var16_25 = var14_12 * var15_17;
                                                                        var17_31 = var3_3.getIndexFilePtr();
                                                                        var18_36 = var3_3.getIndexBufferSize();
                                                                        if (var16_25 < 0) throw new Exception(Base64.substring((String)"UQSsaey%|l||uPf|yfbut#:@", (int)(340 / 69)) + var11_10 + FileChunk.regionMatches((int)(262 / 43), (String)"[=(Kko,~guu+2") + var16_25 + ":" + var1_1.getDataSize());
                                                                        if ((long)var16_25 > var1_1.getDataSize()) {
                                                                            throw new Exception(Base64.substring((String)"UQSsaey%|l||uPf|yfbut#:@", (int)(340 / 69)) + var11_10 + FileChunk.regionMatches((int)(262 / 43), (String)"[=(Kko,~guu+2") + var16_25 + ":" + var1_1.getDataSize());
                                                                        }
                                                                        break block60;
                                                                    }
                                                                    if (!var11_10.isType(FileChunk.regionMatches((int)(23 * 7), (String)"rvp~"))) break block61;
                                                                    var12_11 = var0.getFilePointer();
                                                                    v3 = var0;
                                                                    v3.seek(v3.getFilePointer() + 4L);
                                                                    var0.read(var5_6, 0, 4);
                                                                    var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                                    if (var14_12 == 0) break block62;
                                                                    break block63;
                                                                }
                                                                if (var11_10.isType(FileChunk.regionMatches((int)(102 + 76), (String)"agwz")) || var11_10.isType(Base64.substring((String)"fi1<", (int)(1124 / 221)))) {
                                                                    var12_11 = var0.getFilePointer();
                                                                    v4 = var0;
                                                                    v4.seek(v4.getFilePointer() + 4L);
                                                                    var0.read(var5_6, 0, 4);
                                                                    var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                                    v5 = var15_14 = var11_10.isType(Base64.substring((String)"- fe", (int)(32 + 46))) != false ? 8 : 4;
                                                                }
                                                                break block64;
                                                            }
                                                            var0.read(var5_6, 0, 4);
                                                            var15_16 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                            var16_24 = 4;
                                                            var17_30 = var15_16 * var16_24;
                                                            if (var17_30 < 0) throw new Exception(Base64.substring((String)"WS]}cg\u007f#~nbbwR`z{dl{v!<F", (int)(97 + -91)) + var11_10 + Base64.substring((String)"_9$Ggc(zcqi7.", (int)(6 - 4)) + var17_30 + ":" + var1_1.getDataSize());
                                                            if ((long)var17_30 > var1_1.getDataSize()) {
                                                                throw new Exception(Base64.substring((String)"WS]}cg\u007f#~nbbwR`z{dl{v!<F", (int)(97 + -91)) + var11_10 + Base64.substring((String)"_9$Ggc(zcqi7.", (int)(6 - 4)) + var17_30 + ":" + var1_1.getDataSize());
                                                            }
                                                            break block65;
                                                        }
                                                        if (!var11_10.isType(Base64.substring((String)"us{m", (int)(555 / 92)))) break block66;
                                                        var12_11 = var0.getFilePointer();
                                                        v6 = var0;
                                                        v6.seek(v6.getFilePointer() + 4L);
                                                        var0.read(var5_6, 0, 4);
                                                        var14_12 = BufferUtils.byteArrayToInt((byte[])var5_6);
                                                        var15_13 = 0;
                                                        ** GOTO lbl387
                                                    }
                                                    if (!var11_10.isType(Base64.substring((String)"gqrt", (int)(1028 / 252)))) {
                                                        QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                                                    } else {
                                                        var12_11 = var0.getFilePointer();
                                                        var14_12 = (int)var11_10.getDataSize() - 8;
                                                        if (var14_12 < 0) throw new Exception(Base64.substring((String)"\u000f\u000b\u00155+/7k6&::/\n8\"#<$3>it\u000e", (int)(32 - -62)) + var11_10 + Base64.substring((String)"\u0018|g\n(.k?$4*jq", (int)(-52 - 7)) + var14_12 + ":" + var1_1.getDataSize());
                                                        if ((long)var14_12 > var1_1.getDataSize()) {
                                                            throw new Exception(Base64.substring((String)"\u000f\u000b\u00155+/7k6&::/\n8\"#<$3>it\u000e", (int)(32 - -62)) + var11_10 + Base64.substring((String)"\u0018|g\n(.k?$4*jq", (int)(-52 - 7)) + var14_12 + ":" + var1_1.getDataSize());
                                                        }
                                                        var15_18 = new byte[var14_12];
                                                        var0.read(var15_18, 0, var15_18.length);
                                                        var16_26 = new FastIntDirect();
                                                        var16_26.setData(var15_18);
                                                        var16_26.setEntrySize(8);
                                                        var16_26.setDataSize(4);
                                                        var4_4.setCttsValues((IFastIntBuffer)var16_26);
                                                        var0.seek(var12_11);
                                                        QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                                                    }
                                                    ** GOTO lbl405
                                                }
                                                var4_4.setSampleSize(var14_12);
                                                break block67;
                                            }
                                            if (var15_16 <= 0) break block67;
                                            var18_37 = var3_3.getIndexFilePtr();
                                            var19_43 = var3_3.getIndexBufferSize();
                                            var20_46 /* !! */  = null;
                                            if (var18_37 != null && var17_30 > var19_43) {
                                                var20_46 /* !! */  = (byte[])new FastIntBuffer();
                                                var20_46 /* !! */ .setEntrySize(var16_24);
                                                var20_46 /* !! */ .setDataSize(var16_24);
                                                var20_46 /* !! */ .setBufferSize(var19_43);
                                                var20_46 /* !! */ .setRandomAccessReader(var18_37);
                                                var20_46 /* !! */ .setRandomAccessReaderStartPos(var0.getFilePointer());
                                                var20_46 /* !! */ .setTotalSize(var17_30);
                                                var20_46 /* !! */ .allocateBuffer();
                                                var3_3.incIndexRefCount();
                                            } else {
                                                var20_46 /* !! */  = (byte[])new FastIntDirect();
                                                var20_46 /* !! */ .setEntrySize(var16_24);
                                                var20_46 /* !! */ .setDataSize(var16_24);
                                                var21_47 = new byte[var17_30];
                                                var0.read((byte[])var21_47, 0, ((byte[])var21_47).length);
                                                var20_46 /* !! */ .setData((byte[])var21_47);
                                            }
                                            var4_4.setSampleSizes((IFastIntBuffer)var20_46 /* !! */ );
                                            break block67;
                                        }
                                        var17_29 = var3_3.getIndexFilePtr();
                                        var18_35 = var3_3.getIndexBufferSize();
                                        var19_41 = null;
                                        if (var17_29 == null || var16_22 <= var18_35) {
                                            var19_41 = new FastIntDirect();
                                            var19_41.setEntrySize(var15_15);
                                            var19_41.setDataSize(var15_15 / 2);
                                            var20_46 /* !! */  = new byte[var16_22];
                                            var0.read(var20_46 /* !! */ , 0, var20_46 /* !! */ .length);
                                            var19_41.setData(var20_46 /* !! */ );
                                        } else {
                                            var19_41 = new FastIntBuffer();
                                            var19_41.setEntrySize(var15_15);
                                            var19_41.setDataSize(var15_15 / 2);
                                            var19_41.setBufferSize(var18_35);
                                            var19_41.setRandomAccessReader(var17_29);
                                            var19_41.setRandomAccessReaderStartPos(var0.getFilePointer());
                                            var19_41.setTotalSize(var16_22);
                                            var19_41.allocateBuffer();
                                            var3_3.incIndexRefCount();
                                        }
                                        var4_4.setTimeToSample((IFastIntBuffer)var19_41);
                                    }
                                    var0.seek(var12_11);
                                    QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                                    ** GOTO lbl405
                                }
                                var0.seek(var12_11);
                                QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                                ** GOTO lbl405
                            }
                            var15_19 = 12;
                            var16_23 = var14_12 * var15_19;
                            var17_32 = var3_3.getIndexFilePtr();
                            var18_38 = var3_3.getIndexBufferSize();
                            if (var16_23 < 0) throw new Exception(FileChunk.regionMatches((int)(57 * 51), (String)"\n\b\b*6,2l3%75\"\t=%&?9,#jq\t") + var11_10 + FileChunk.regionMatches((int)(307 / 100), (String)"^>%Dfl)ybvh4/") + var16_23 + ":" + var1_1.getDataSize());
                            if ((long)var16_23 > var1_1.getDataSize()) {
                                throw new Exception(FileChunk.regionMatches((int)(57 * 51), (String)"\n\b\b*6,2l3%75\"\t=%&?9,#jq\t") + var11_10 + FileChunk.regionMatches((int)(307 / 100), (String)"^>%Dfl)ybvh4/") + var16_23 + ":" + var1_1.getDataSize());
                            }
                            var19_44 = null;
                            if (var17_32 != null && var16_23 > var18_38) {
                                var19_44 = new FastIntBuffer();
                                var19_44.setEntrySize(var15_19);
                                var19_44.setDataSize(var15_19 / 3);
                                var19_44.setBufferSize(var18_38);
                                var19_44.setRandomAccessReader(var17_32);
                                var19_44.setRandomAccessReaderStartPos(var0.getFilePointer());
                                var19_44.setTotalSize(var16_23);
                                var19_44.allocateBuffer();
                                var3_3.incIndexRefCount();
                            } else {
                                var19_44 = new FastIntDirect();
                                var19_44.setEntrySize(var15_19);
                                var19_44.setDataSize(var15_19 / 3);
                                var20_46 /* !! */  = new byte[var16_23];
                                var0.read(var20_46 /* !! */ , 0, var20_46 /* !! */ .length);
                                var19_44.setData(var20_46 /* !! */ );
                            }
                            var4_4.setSampleToChunk((IFastIntBuffer)var19_44);
                        }
                        var0.seek(var12_11);
                        QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                        ** GOTO lbl405
                        if (var14_12 > 0) {
                            var16_21 = var14_12 * var15_14;
                            var17_28 = var3_3.getIndexFilePtr();
                            var18_34 = var3_3.getIndexBufferSize();
                            if (var16_21 < 0) throw new Exception(Base64.substring((String)"FLLnrpn0o!31&\u00051)*;=('vm\u0015", (int)(37 * 43)) + var11_10 + Base64.substring((String)"[=(Kko,~guu+2", (int)(454 / 69)) + var16_21 + ":" + var1_1.getDataSize());
                            if ((long)var16_21 > var1_1.getDataSize()) {
                                throw new Exception(Base64.substring((String)"FLLnrpn0o!31&\u00051)*;=('vm\u0015", (int)(37 * 43)) + var11_10 + Base64.substring((String)"[=(Kko,~guu+2", (int)(454 / 69)) + var16_21 + ":" + var1_1.getDataSize());
                            }
                            var19_42 = null;
                            if (var17_28 != null && var16_21 > var18_34) {
                                var19_42 = new FastLongBuffer();
                                var19_42.setEntrySize(var15_14);
                                var19_42.setDataSize(var15_14);
                                var19_42.setBufferSize(var18_34);
                                var19_42.setRandomAccessReader(var17_28);
                                var19_42.setRandomAccessReaderStartPos(var0.getFilePointer());
                                var19_42.setTotalSize(var16_21);
                                var19_42.allocateBuffer();
                                var3_3.incIndexRefCount();
                            } else {
                                var19_42 = new FastLongDirect();
                                var19_42.setEntrySize(var15_14);
                                var19_42.setDataSize(var15_14);
                                var20_46 /* !! */  = new byte[var16_21];
                                var0.read(var20_46 /* !! */ , 0, var20_46 /* !! */ .length);
                                var19_42.setData(var20_46 /* !! */ );
                            }
                            var4_4.setChunkOffsets((IFastLongBuffer)var19_42);
                        }
                        var0.seek(var12_11);
                        QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                        ** GOTO lbl405
                    }
                    var19_45 = null;
                    if (var17_31 != null && var16_25 > var18_36) {
                        var19_45 = new FastLongBuffer();
                        var19_45.setEntrySize(var15_17);
                        var19_45.setDataSize(var15_17);
                        var19_45.setBufferSize(var18_36);
                        var19_45.setRandomAccessReader(var17_31);
                        var19_45.setRandomAccessReaderStartPos(var0.getFilePointer());
                        var19_45.setTotalSize(var16_25);
                        var19_45.allocateBuffer();
                        var19_45.generateIndex();
                        var3_3.incIndexRefCount();
                    } else {
                        var19_45 = new FastLongDirect();
                        var19_45.setEntrySize(var15_17);
                        var19_45.setDataSize(var15_17);
                        var20_46 /* !! */  = new byte[var16_25];
                        var0.read(var20_46 /* !! */ , 0, var20_46 /* !! */ .length);
                        var19_45.setData(var20_46 /* !! */ );
                    }
                    var4_4.setSyncSamples((IFastLongBuffer)var19_45);
                }
                var0.seek(var12_11);
                QTUtils.skipBytesLong(var0, var11_10.getDataSize());
                ** GOTO lbl405
                break;
            }
            while (true) {
                WMSLoggerFactory.getLogger(QTUtils.class).warn(Base64.substring((String)"UQSsaey%|l||uPf|yfbutB", (int)(667 / 145)) + var0.getPath() + Base64.substring((String)"^>%usz|i\u007fOb{ad1f|{5~~\u007fqA", (int)(858 / 237)) + var31_58 + ":" + var29_55 + Base64.substring((String)"W1,", (int)(-37 - 49)) + var2_2);
                ** GOTO lbl471
                break;
            }
lbl277:
            // 1 sources

            while (true) {
                continue;
                while (true) {
                    var9_9 += var12_11;
                    ** continue;
                    break;
                }
lbl282:
                // 2 sources

                while (true) {
                    var4_4.setAudioChannels(var24_50);
                    var29_55 = 0;
                    ** GOTO lbl459
                    break;
                }
                while (true) {
                    block68: {
                        if (!var2_2.equals(FileChunk.regionMatches((int)(15 + 104), (String)"$51>"))) break block49;
                        v7 = var0;
                        v7.seek(v7.getFilePointer() + 8L);
                        var16_20 += 8;
                        var0.read(var5_6, 0, 2);
                        var16_20 += 2;
                        var23_49 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
                        v8 = var0;
                        v8.seek(v8.getFilePointer() + 6L);
                        var16_20 += 6;
                        var0.read(var5_6, 0, 2);
                        var16_20 += 2;
                        var24_50 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
                        var0.read(var5_6, 0, 2);
                        var16_20 += 2;
                        var25_51 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
                        var0.read(var5_6, 0, 2);
                        var16_20 += 2;
                        var26_52 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
                        var0.read(var5_6, 0, 2);
                        var16_20 += 2;
                        var27_53 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
                        var0.read(var5_6, 0, 4);
                        var16_20 += 4;
                        var28_54 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)4);
                        if (var23_49 == 1) break block68;
                        if (var23_49 == 2) {
                            var29_55 = 0;
                            var30_56 = 36;
                            v9 = var0;
                            v9.seek(v9.getFilePointer() + 4L);
                            var29_55 += 4;
                            var16_20 += 4;
                            var0.read(var6_7, 0, 8);
                            var29_55 += 8;
                            var16_20 += 8;
                            var31_60 = BufferUtils.byteArrayToLong((byte[])var6_7, (int)0, (int)8);
                            var33_64 = Double.longBitsToDouble(var31_60);
                            var0.read(var5_6, 0, 4);
                            var16_20 += 4;
                            var24_50 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)4);
                            v10 = var0;
                            v10.seek(v10.getFilePointer() + (long)var30_56 - (long)(var29_55 += 4));
                            var16_20 += var30_56 - var29_55;
                        }
                        ** GOTO lbl282
                    }
                    v11 = var0;
                    v11.seek(v11.getFilePointer() + 16L);
                    var16_20 += 16;
                    ** continue;
                    break;
                }
                break;
            }
            while (true) {
                var35_70 = new byte[var29_55 - 8];
                var0.read(var35_70, 0, var29_55 - 8);
                var0.seek(var33_63 + 1L);
                var0.read(var5_6, 0, 1);
                var36_73 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)1);
                var0.read(var5_6, 0, 1);
                var37_75 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)1);
                var0.read(var5_6, 0, 1);
                var38_76 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)1);
                var21_47 = new AVCCData();
                var21_47.setAvccBytes(var35_70);
                var21_47.setAvcLevel(var38_76);
                var21_47.setAvcProfile(var36_73);
                var21_47.setAvcProfileCompat(var37_75);
                try {
                    if (var35_70 != null && (var39_77 = H264Utils.decodeAVCC((byte[])var35_70, (int)0)) != null) {
                        if (var39_77.frameRate > 0.0) {
                            var4_4.setFrameRate(var39_77.frameRate);
                        }
                        if (var39_77.displayWidth > 0 && var39_77.displayHeight > 0) {
                            var4_4.setDisplayWidth(var39_77.displayWidth);
                            var4_4.setDisplayHeight(var39_77.displayHeight);
                        }
                    }
                    ** GOTO lbl505
                }
                catch (Exception var39_78) {}
                ** GOTO lbl505
                break;
            }
        }
lbl376:
        // 5 sources

        while (true) {
            block69: {
                if (var2_2.equals(FileChunk.regionMatches((int)(-1 - 12), (String)"%9=2"))) {
                    var4_4.addAVCCData((AVCCData)var21_47);
                }
                if (var2_2.equals(FileChunk.regionMatches((int)(218 / 59), (String)"pimb"))) {
                    var4_4.addESDSData(var22_48);
                }
                var0.seek(var19_39 + (long)var17_27 - 8L);
                if (var17_27 - 8 > 0) break block69;
                WMSLoggerFactory.getLogger(QTUtils.class).warn(FileChunk.regionMatches((int)(1383 / 228), (String)"WS]}cg\u007f#~nbbwR`z{dl{v@") + var0.getPath() + Base64.substring((String)"X<'M{xd~-|jqu{}s51dlj~<<n{|thmm*%Ci|{s+e~.uuc}3g|lr6", (int)(807 / 142)));
                ** GOTO lbl-1000
            }
            ++var15_13;
lbl387:
            // 2 sources

            if (var15_13 < var14_12) {
                var16_20 = 0;
                var0.read(var5_6, 0, 4);
                var16_20 += 4;
                var17_27 = BufferUtils.byteArrayToInt((byte[])var5_6);
                var0.read(var5_6, 0, 4);
                var16_20 += 4;
                var18_33 = new String(var5_6, FileChunk.regionMatches((int)(82 + -26), (String)"MM\\6$"));
                var4_4.addDataType(var18_33);
                var19_39 = var0.getFilePointer();
                var21_47 = null;
                var22_48 = null;
                if (!var2_2.equals(FileChunk.regionMatches((int)(49 * 11), (String)"mquz"))) ** continue;
            } else lbl-1000:
            // 2 sources

            {
                var0.seek(var12_11);
                QTUtils.skipBytesLong(var0, var11_10.getDataSize());
lbl405:
                // 8 sources

                if ((var12_11 = var11_10.getSize()) > 0L) ** continue;
                throw new Exception(FileChunk.regionMatches((int)(301 / 75), (String)"UQSsaey%|l||uPf|yfbut#:Zhrs?shxf$lu'ag|j`dj50") + var12_11);
            }
            v12 = var0;
            v12.seek(v12.getFilePointer() + 24L);
            var16_20 += 24;
            var0.read(var5_6, 0, 2);
            var16_20 += 2;
            var23_49 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
            var0.read(var5_6, 0, 2);
            var16_20 += 2;
            var24_50 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
            var0.read(var5_6, 0, 4);
            var16_20 += 4;
            var25_51 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)4) >> 16;
            var0.read(var5_6, 0, 4);
            var16_20 += 4;
            var26_52 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)4) >> 16;
            v13 = var0;
            v13.seek(v13.getFilePointer() + 4L);
            var16_20 += 4;
            var0.read(var5_6, 0, 2);
            var16_20 += 2;
            var27_53 = BufferUtils.byteArrayToInt((byte[])var5_6, (int)0, (int)2);
            var4_4.setFrameWidth(var23_49);
            var4_4.setFrameHeight(var24_50);
            var4_4.setDisplayWidth(var23_49);
            var4_4.setDisplayHeight(var24_50);
            var4_4.setHorizontalResolution(var25_51);
            var4_4.setVerticalResolution(var26_52);
            var4_4.setFramesPerSample(var27_53);
            v14 = var0;
            v14.seek(v14.getFilePointer() + 32L);
            var16_20 += 32;
            v15 = var0;
            v15.seek(v15.getFilePointer() + 4L);
            var16_20 += 4;
            var28_54 = 0;
            if (true) ** GOTO lbl510
            break;
        }
        var22_48 = MP4Utils.a(var0);
        do {
            var0.seek(var37_74 + (long)var35_69 - 8L);
            var34_66 += var35_69 - 8;
            if (var35_69 - 8 > 0) ** GOTO lbl482
            while (true) {
                block70: {
                    var0.seek(var32_61 + (long)var30_56 - 8L);
                    var16_20 += var30_56 - 8;
                    if (var30_56 - 8 > 0) break block70;
                    WMSLoggerFactory.getLogger(QTUtils.class).warn(FileChunk.regionMatches((int)(41 * 3), (String)"\n\b\b*6lr,sewubI}ef\u007fylcK") + var0.getPath() + FileChunk.regionMatches((int)(284 / 84), (String)"^>%Cuzfx+~hoky\u007fu33fbd|>:hy~jvoo,#Wqtrk}\u007fyi-g|0kwa{5e~b| ;") + var2_2 + ":" + var31_58);
                    ** GOTO lbl376
                }
                if (var17_27 - var16_20 < 8) ** GOTO lbl376
                var0.read(var5_6, 0, 4);
                var16_20 += 4;
                var30_56 = BufferUtils.byteArrayToInt((byte[])var5_6);
                var0.read(var5_6, 0, 4);
                var16_20 += 4;
                var31_58 = new String(var5_6, FileChunk.regionMatches((int)(61 * 17), (String)"XZI=)"));
                var32_61 = var0.getFilePointer();
                if (++var29_55 == 100) ** continue;
lbl471:
                // 2 sources

                if (var31_58.equals(Base64.substring((String)"`uc{", (int)(765 / 149)))) {
                    var22_48 = MP4Utils.a(var0);
                    continue;
                }
                if (var31_58.equals(Base64.substring((String)"'0$6", (int)(-6 - 10)))) {
                    var34_66 = 0;
                } else {
                    if (!var31_58.equals(Base64.substring((String)"#8<5", (int)(8 - 56)))) continue;
                    var34_68 = new QTAtom(var31_58, var0.getFilePointer() - 8L, var30_56, 8L);
                    var35_71 = QTUtils.parseAtomsinf(var0, var34_68, var2_2, var3_3);
                    var4_4.setSinfAtom(var35_71);
                    continue;
                }
lbl482:
                // 2 sources

                if (var30_56 - var34_66 >= 8) break;
            }
            var0.read(var5_6, 0, 4);
            var34_66 += 4;
            var35_69 = BufferUtils.byteArrayToInt((byte[])var5_6);
            var0.read(var5_6, 0, 4);
            var34_66 += 4;
            var36_72 = new String(var5_6, Base64.substring((String)"PRA%1", (int)(52 - 47)));
            var37_74 = var0.getFilePointer();
        } while (!var36_72.equals(FileChunk.regionMatches((int)(79 + -55), (String)"}j~h")));
        ** while (true)
        while (true) {
            block71: {
                if (var30_57.equals(FileChunk.regionMatches((int)(35 * 9), (String)"zj~]"))) {
                    var33_63 = var0.getFilePointer();
                    if (var29_55 < 0) throw new Exception(Base64.substring((String)"\u001f\u001b\u0005%;?'{&6**?\u001a(23,4#.yd\u001e", (int)(3 - 53)) + var30_57 + Base64.substring((String)"[=(Kko,~guu+2", (int)(86 + 80)) + var29_55 + ":" + var1_1.getDataSize());
                    if ((long)var29_55 <= var1_1.getDataSize()) ** continue;
                    throw new Exception(Base64.substring((String)"\u001f\u001b\u0005%;?'{&6**?\u001a(23,4#.yd\u001e", (int)(3 - 53)) + var30_57 + Base64.substring((String)"[=(Kko,~guu+2", (int)(86 + 80)) + var29_55 + ":" + var1_1.getDataSize());
                }
                if (var30_57.equals(FileChunk.regionMatches((int)(306 / 69), (String)"wlha"))) {
                    var33_62 = new QTAtom(var30_57, var0.getFilePointer() - 8L, var29_55, 8L);
                    var34_67 = QTUtils.parseAtomsinf(var0, var33_62, var2_2, var3_3);
                    var4_4.setSinfAtom(var34_67);
                }
lbl505:
                // 6 sources

                var0.seek(var31_59 + (long)var29_55 - 8L);
                var16_20 += var29_55 - 8;
                if (var29_55 - 8 > 0) break block71;
                WMSLoggerFactory.getLogger(QTUtils.class).warn(Base64.substring((String)"TRR|`fx\"}o}ctSg{xeczuA", (int)(415 / 73)) + var0.getPath() + FileChunk.regionMatches((int)(36 - -32), (String)"\u0019\u007ff\u0002:;%9l?+.48<4tr%#+=}{/8=+).,md\u001625=*>>>(n&#q(6&:v$1#?a|") + var2_2 + ":" + var30_57);
                ** GOTO lbl376
            }
            if (var17_27 - var16_20 >= 8) ** break;
            ** continue;
            var0.read(var5_6, 0, 4);
            var16_20 += 4;
            var29_55 = BufferUtils.byteArrayToInt((byte[])var5_6);
            var0.read(var5_6, 0, 4);
            var16_20 += 4;
            var30_57 = new String(var5_6, Base64.substring((String)"\u0015\u0015\u0004n|", (int)(111 + 113)));
            var31_59 = var0.getFilePointer();
            if (++var28_54 != 100) continue;
            WMSLoggerFactory.getLogger(QTUtils.class).warn(Base64.substring((String)"\u0010\u0016\u00160,*4f9+9?(\u000f;?<!'69\r", (int)(5 * 13)) + var0.getPath() + FileChunk.regionMatches((int)(6 - -49), (String)"J\"9ionh}k\u0003.7-0e2('i\"\"+%\u0015") + var30_57 + ":" + var28_54 + Base64.substring((String)"[=(", (int)(1614 / 254)) + var2_2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QTAtomsinf parseAtomsinf(IRandomAccessReader iRandomAccessReader, QTAtom qTAtom, String string, QTParseContext qTParseContext) throws Exception {
        long l;
        QTAtomsinf qTAtomsinf = null;
        qTAtomsinf = new QTAtomsinf(qTAtom);
        long l2 = iRandomAccessReader.getFilePointer();
        long l3 = qTAtom.getDataSize();
        byte[] byArray = new byte[4];
        PlayReadyTrackInfo playReadyTrackInfo = null;
        for (long i = 0L; i < l3; i += l) {
            long l4;
            block13: {
                Object object;
                block15: {
                    QTAtom qTAtom2;
                    block14: {
                        block12: {
                            l4 = iRandomAccessReader.getFilePointer();
                            qTAtom2 = QTUtils.readAtomHeader(iRandomAccessReader);
                            if (qTAtom2 == null) break;
                            l = qTAtom2.getSize();
                            if (l <= 0L) {
                                throw new Exception(Base64.substring((String)"5'5;,\u000b?# =&>7hs\u0015!9:x*3!9}7, hlueioc2)", (int)(57 * 13)) + l);
                            }
                            if (!qTAtom2.isType(Base64.substring((String)"ctji", (int)(1274 / 249)))) break block12;
                            if (qTAtom2.getDataSize() > 4L) break block13;
                            break block14;
                        }
                        if (qTAtom2.isType(FileChunk.regionMatches((int)(17 * 51), (String)"0'-+")) || !qTAtom2.isType(Base64.substring((String)"ap||", (int)(120 + -70)))) break block13;
                        object = QTUtils.readAtomHeader(iRandomAccessReader);
                        if (object == null) {
                            break;
                        }
                        break block15;
                    }
                    iRandomAccessReader.read(byArray, 0, (int)qTAtom2.getDataSize());
                    object = null;
                    try {
                        object = new String(byArray, 0, (int)qTAtom2.getDataSize());
                    }
                    catch (Exception exception) {}
                    if (object != null) {
                        if (playReadyTrackInfo == null) {
                            playReadyTrackInfo = new PlayReadyTrackInfo();
                        }
                        playReadyTrackInfo.setDataType((String)object);
                    }
                    break block13;
                }
                if (((QTAtom)object).isType(FileChunk.regionMatches((int)(1396 / 228), (String)"sram"))) {
                    byte[] byArray2 = new byte[16];
                    iRandomAccessReader.read(byArray2, 0, 16);
                    iRandomAccessReader.read(byArray, 0, 4);
                    if (Arrays.equals(UUID_TRACKBOX, byArray2)) {
                        iRandomAccessReader.read(byArray, 0, 3);
                        int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)3);
                        iRandomAccessReader.read(byArray, 0, 1);
                        int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)1);
                        byte[] byArray3 = new byte[16];
                        iRandomAccessReader.read(byArray3, 0, byArray3.length);
                        if (playReadyTrackInfo == null) {
                            playReadyTrackInfo = new PlayReadyTrackInfo();
                        }
                        playReadyTrackInfo.setAlgorithmID(n);
                        playReadyTrackInfo.setIvSize(n2);
                        playReadyTrackInfo.setKeyID(byArray3);
                    }
                }
            }
            iRandomAccessReader.seek(l4);
            QTUtils.skipBytesLong(iRandomAccessReader, l);
        }
        if (playReadyTrackInfo == null) return qTAtomsinf;
        qTAtomsinf.setPlayReadyTrackInfo(playReadyTrackInfo);
        return qTAtomsinf;
    }
}

