/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.drm.playready.PlayReadySampleData;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.util.Iterator;
import java.util.List;

public class SmoothStreamingFragmentWriter {
    public static final byte[] PLAYREADY_GUID_BYTES = BufferUtils.decodeHexString((String)FileChunk.regionMatches((int)(-27 - 6), (String)"\u001err{w\u0002ptr\tp\b\u007f*|z\u000ebefe\u0017ad`\u001bonc\u0018\u001bj"));
    public static final String DURATION_GUID = "6d1d9b0542d544e680e2141daff757b2";
    public static final byte[] DURATION_GUID_BYTES = BufferUtils.decodeHexString((String)FileChunk.regionMatches((int)(23 - -2), (String)"/~*x$|/550g112b>1:n><:>tptu# !u*"));
    public static final String READ_AHEAD_GUID = "d4807ef2ca3946958e5426cb9e46a79f";
    public static final byte[] READ_AHEAD_GUID_BYTES = BufferUtils.decodeHexString((String)FileChunk.regionMatches((int)(-54 - -32), (String)".\u007ft}y*6c12glbaalb>iilicc;f03g01o"));
    public static final int ATOMHEADERSIZE = 8;
    public static final int VERSIONFLAGSSIZE = 4;
    public static final int GUIDESIZE = 16;
    public static final int MP4_TRUN_DATA_OFFSET = 1;
    public static final int MP4_TRUN_FIRST_FLAGS = 4;
    public static final int MP4_TRUN_SAMPLE_DURATION = 256;
    public static final int MP4_TRUN_SAMPLE_SIZE = 512;
    public static final int MP4_TRUN_SAMPLE_FLAGS = 1024;
    public static final int MP4_TRUN_SAMPLE_TIME_OFFSET = 2048;

    public static int getMediaSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 0;
        Iterator<SmoothStreamingMediaPacket> iterator = smoothStreamingFragmentWriterMedia.packets.iterator();
        while (iterator.hasNext()) {
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = iterator.next();
            n += smoothStreamingMediaPacket.getSize();
        }
        return n;
    }

    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, true, false);
    }

    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl) {
        return SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFragmentSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = smoothStreamingFragmentWriterMedia.packets.size();
        int n3 = 0;
        if (bl) {
            for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingFragmentWriterMedia.packets) {
                n3 += smoothStreamingMediaPacket.getSize();
            }
        }
        if (bl2) {
            n += SmoothStreamingFragmentWriter.getSTYPSize(smoothStreamingFragmentWriterMedia);
            n += SmoothStreamingFragmentWriter.getSIDXSize(smoothStreamingFragmentWriterMedia);
        }
        n += 8;
        n += 16;
        n += 8;
        n += 16;
        n += 16 + 12 * n2;
        n += 12 + n2;
        if (smoothStreamingFragmentWriterMedia.writeUUID) {
            n += 44;
            n += 29 + (smoothStreamingFragmentWriterMedia.readAheadDurations.length << 4);
        }
        n += SmoothStreamingFragmentWriter.getPlayReadySize(smoothStreamingFragmentWriterMedia.playReadySampleData);
        return n += 8 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFragmentSizeDASH(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = smoothStreamingFragmentWriterMedia.packets.size();
        int n3 = 0;
        if (bl) {
            for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingFragmentWriterMedia.packets) {
                n3 += smoothStreamingMediaPacket.getSize();
            }
        }
        if (bl2) {
            n += SmoothStreamingFragmentWriter.getSTYPSize(smoothStreamingFragmentWriterMedia);
            n += SmoothStreamingFragmentWriter.getSIDXSize(smoothStreamingFragmentWriterMedia);
        }
        n += 8;
        n += 16;
        n += 8;
        n += 16;
        n += SmoothStreamingFragmentWriter.getTRUNSize(smoothStreamingFragmentWriterMedia);
        n += 12 + n2;
        if (smoothStreamingFragmentWriterMedia.writeUUID) {
            n += 44;
            n += 29 + (smoothStreamingFragmentWriterMedia.readAheadDurations.length << 4);
        }
        n += SmoothStreamingFragmentWriter.getPlayReadySize(smoothStreamingFragmentWriterMedia.playReadySampleData);
        return n += 8 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getPlayReadySize(PlayReadySampleData playReadySampleData) {
        int n = 0;
        if (playReadySampleData == null) return n;
        int n2 = 0;
        if (playReadySampleData.getKeyId() != null) {
            n2 = 20;
        }
        return n += 28 + n2 + 4 + playReadySampleData.getSize();
    }

    public static int startAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        return n + 8;
    }

    public static void stopAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, String string, int n2) {
        int n3 = n - n2;
        int n4 = n - n3 - 8;
        BufferUtils.intToByteArray((int)(n3 + 8), (byte[])byArray, (int)n4, (int)4);
        System.arraycopy(string.getBytes(), 0, byArray, n4 + 4, 4);
    }

    public static void stopAtom(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, String string, int n2, int n3) {
        int n4 = n3;
        int n5 = n - 8;
        BufferUtils.intToByteArray((int)(n4 + 8), (byte[])byArray, (int)n5, (int)4);
        System.arraycopy(string.getBytes(), 0, byArray, n5 + 4, 4);
    }

    public static int writeStartMOOF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMOOF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)":76<", (int)(7 * 17)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMOOV(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMOOV(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"khg\u007f", (int)(454 / 69)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartTRAK(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopTRAK(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"vqen", (int)(10 + 24)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMDIA(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(1177 / 244), (String)"iaof"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMDIA(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMVEX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"nr`~", (int)(485 / 141)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMVEX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"nmk`", (int)(351 / 115)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartMINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopDINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"?538", (int)(-25 - 12)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartSTBL(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopSTBL(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"wqdk", (int)(406 / 84)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStartDINF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(84 + 41), (String)"0:>t"), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int writeStopMDAT(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"n`dr", (int)(8 + 123)), smoothStreamingFragmentWriterContext.popStartLoc(), n2);
        return n;
    }

    public static int writeStartTRAF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
        smoothStreamingFragmentWriterContext.pushStartLoc(n);
        return n;
    }

    public static int writeStopTRAF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext) {
        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"qtfn", (int)(-7 - -12)), smoothStreamingFragmentWriterContext.popStartLoc());
        return n;
    }

    public static int getSTYPSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
        n += byArray.length;
        int n2 = 0;
        while (n2 < smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.compatibleBrands[n2].getBytes();
            n += byArray2.length;
            ++n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTYP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.majorBrandVersion, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            n += 4;
            int n3 = 0;
            while (true) {
                if (n3 >= smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"884>", (int)(51 - -24)), n2);
                    return n;
                }
                byte[] byArray3 = smoothStreamingFragmentWriterMedia.compatibleBrands[n3].getBytes();
                System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
                n += byArray3.length;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"B@Bd~l|hNhtrl.vpjp`GsgdY_U]4/", (int)(43 * 57)) + exception.toString());
            return n;
        }
    }

    public static int getFTYPSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
        n += byArray.length;
        int n2 = 0;
        while (n2 < smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.compatibleBrands[n2].getBytes();
            n += byArray2.length;
            ++n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomFTYP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = smoothStreamingFragmentWriterMedia.majorBrand.getBytes();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.majorBrandVersion, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            n += 4;
            int n3 = 0;
            while (true) {
                if (n3 >= smoothStreamingFragmentWriterMedia.compatibleBrands.length) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(737 / 158), (String)"bq\u007fw"), n2);
                    return n;
                }
                byte[] byArray3 = smoothStreamingFragmentWriterMedia.compatibleBrands[n3].getBytes();
                System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
                n += byArray3.length;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"RPRtn|lx^xdb|>f`z`pWcwt\\OEM$?", (int)(61 * 63)) + exception.toString());
            return n;
        }
    }

    public static int getSIDXSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 44;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSIDX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n3 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n4 = 0;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.a, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.timescale, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.startTimecode, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.b, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
            int n5 = 1;
            BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)Integer.MIN_VALUE, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.substring((String)"vocp", (int)(228 / 41)), n3);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(63 * 29), (String)"RPRtn|lx^xdb|>f`z`pWcwtIRXE$?") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomMFHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.sequenceNumber, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(465 / 68), (String)"ka`m"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\f\n\brhvfvPrndz$|~dzjQe}~YS^S\"9", (int)(41 * 53)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomTFHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.substring((String)"4'*'", (int)(23 + 41)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(47 * 53), (String)"JHJlv4$0\u00160,*4f>8\"8(\u000f;?<\u0006\u0015\u001c\u0011lw") + exception.toString());
            return n;
        }
    }

    public static int getSTTSEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTTSEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(-46 - -52), (String)"us|z"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(103 + -11), (String)"\r\t\t-)5'1\u00111/+;g=9%9+\u000e$>?\u0000\u0000\u0001\u0005\u00125).\"f}") + exception.toString());
            return n;
        }
    }

    public static int getSTSCEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTSCEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.substring((String)"ppve", (int)(254 / 78)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u001a\u0018\u001a<&$4 \u0006 <:$v.(2(8\u001f+/,\u0011\u0017\u0017\u0006\u0003*8=3ql", (int)(57 * 35)) + exception.toString());
            return n;
        }
    }

    public static int getSTSZEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 20;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTSZEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, Base64.substring((String)"*.(&", (int)(51 + 70)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(15 * 49), (String)"\u000e\u0014\u00160*0 4\u0012< &8b:<&$4\u0013';8\u0005\u0003\u000b\u0003\u001f6,)'e ") + exception.toString());
            return n;
        }
    }

    public static int getSTCOEmpty(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSTCOEmpty(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(31 - -42), (String)":>(#"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"FLNhrhxlJthnp*rtn|lK\u007fc`][S^W~dao-8", (int)(70 + -47)) + exception.toString());
            return n;
        }
    }

    public static int getIODSSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 19;
        return n += SmoothStreamingFragmentWriter.a(16, 7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomIODS(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            n = SmoothStreamingFragmentWriter.a(byArray, n, 16, 7);
            BufferUtils.intToByteArray((int)79, (byte[])byArray, (int)n, (int)2);
            byArray[n += 2] = -1;
            byArray[++n] = -1;
            byArray[++n] = (byte)(smoothStreamingFragmentWriterMedia.trackType == 8 ? 254 : 255);
            byArray[++n] = (byte)(smoothStreamingFragmentWriterMedia.trackType == 9 ? 254 : 255);
            byArray[++n] = -1;
            SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, Base64.substring((String)"mjbt", (int)(648 / 138)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"RPRtn|lx^xdb|>f`z`pWcwtSTXN$?", (int)(-52 - -55)) + exception.toString());
            return n;
        }
    }

    public static int getTREXSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 32;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTREX(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 3), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)4);
            int n4 = smoothStreamingFragmentWriterMedia.trackType == 9 ? 0x2000000 : 0x1010000;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(8 + 38), (String)"z}ui"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(45 * 3), (String)"V\\^xbxh|Zdx~`:bd~l|[ospJMEY8#") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTRUNSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        int n2 = smoothStreamingFragmentWriterMedia.trunFlags;
        if ((n2 & 1) == 1) {
            n += 4;
        }
        if ((n2 & 4) == 4) {
            n += 4;
        }
        int n3 = smoothStreamingFragmentWriterMedia.packets.size();
        if ((n2 & 0x100) == 256) {
            n += 4 * n3;
        }
        if ((n2 & 0x200) == 512) {
            n += 4 * n3;
        }
        if ((n2 & 0x400) == 1024) {
            n += 4 * n3;
        }
        if ((n2 & 0x800) != 2048) return n;
        return n += 4 * n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMVHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 4 + 2 + 2 + 4 + 4 + 36 + 24 + 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomMVHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.mvhdVersion;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.mvhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.timescale, (byte[])byArray, (int)n, (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.mvhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)256L, (byte[])byArray, (int)(n += 4), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0x40000000L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)(n += 4), (int)4);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 4, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(37 * 39), (String)"nrmb"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"TRPz`~n~Xzf|b<df|brYmuvQKV[:!", (int)(1139 / 195)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTKHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 4 + 4 + 4 + 2 + 2 + 36 + 4 + 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTKHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.tkhdVersion;
            ++n;
            int n3 = 1;
            if (smoothStreamingFragmentWriterMedia.trackType == 9 || smoothStreamingFragmentWriterMedia.trackType == 8) {
                n3 |= 6;
            }
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)n, (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.tkhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackId, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.tkhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)n, (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)256L, (byte[])byArray, (int)(n += 4), (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 2), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)65536L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.longToByteArray((long)0x40000000L, (byte[])byArray, (int)(n += 4), (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.trackType == 9) {
                BufferUtils.longToByteArray((long)(smoothStreamingFragmentWriterMedia.trackWidth << 16), (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)(smoothStreamingFragmentWriterMedia.trackHeight << 16), (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            } else {
                BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, Base64.substring((String)"womb", (int)(669 / 168)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u000f\u000bWskwawSsaey%{\u007fg{uPf|yA]_\\#:", (int)(-57 - -55)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMDHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        return 12 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 16 : 8) + 4 + (smoothStreamingFragmentWriterMedia.mvhdVersion > 0 ? 8 : 4) + 2 + 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomMDHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = (byte)smoothStreamingFragmentWriterMedia.mdhdVersion;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (smoothStreamingFragmentWriterMedia.mdhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)n, (int)4);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.createTime, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackTimescale, (byte[])byArray, (int)n, (int)4);
            n += 4;
            if (smoothStreamingFragmentWriterMedia.mdhdVersion > 0) {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)8);
                n += 8;
            } else {
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackDuration, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            BufferUtils.longToByteArray((long)5575L, (byte[])byArray, (int)n, (int)2);
            BufferUtils.longToByteArray((long)0L, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, Base64.substring((String)"btyv", (int)(-60 - 53)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u0016\u001c\u001e8\"8(<\u001a$8> z\"$>,<\u001b/30\u0013\u001b\b\u0005xc", (int)(123 + -52)) + exception.toString());
            return n;
        }
    }

    public static int getHDLRSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 32;
        byte[] byArray = smoothStreamingFragmentWriterMedia.componentName.getBytes();
        return n += byArray.length + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomHDLR(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            byte[] byArray2 = null;
            switch (smoothStreamingFragmentWriterMedia.trackType) {
                default: {
                    byArray2 = FileChunk.regionMatches((int)(9 * 23), (String)"\"5%3").getBytes();
                    break;
                }
                case 9: {
                    byArray2 = FileChunk.regionMatches((int)(31 * 37), (String)"-59;").getBytes();
                    break;
                }
                case 8: {
                    byArray2 = Base64.substring((String)"wjsi", (int)(572 / 117)).getBytes();
                }
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += byArray2.length), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
            byte[] byArray3 = smoothStreamingFragmentWriterMedia.componentName.getBytes();
            System.arraycopy(byArray3, 0, byArray, n += 4, byArray3.length);
            byArray[n += byArray3.length] = 0;
            SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(340 / 75), (String)"laju"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(62 - 25), (String)"TRPz`~n~Xzf|b<df|brYmuvTYRMza") + exception.toString());
            return n;
        }
    }

    public static int getVMHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 20;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomVMHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 1;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(693 / 121), (String)"skol"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\n\b\n,64$0\u00160,*4f>8\"8(\u000f;?<\u0004\u001e\u001c\u0011lw", (int)(47 * 21)) + exception.toString());
            return n;
        }
    }

    public static int getSMHDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomSMHD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 3), (int)2);
            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, Base64.substring((String)"1.,!", (int)(5 + 61)), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(33 + 36), (String)"\u0014\u0012\u0010: >.>\u0018:&<\"|$&<\"2\u0019-56\u000f\u0010\u0016\u001bza") + exception.toString());
            return n;
        }
    }

    public static int getDREFSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 28;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomDREF(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl = false;
            byArray[n] = (byte)(bl ? 1 : 0);
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = 1;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            int n5 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            boolean bl2 = false;
            byArray[n] = (byte)(bl2 ? 1 : 0);
            int n6 = 1;
            BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)(++n), (int)3);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 3, smoothStreamingFragmentWriterContext, Base64.substring((String)"ptk(", (int)(49 * 53)), n5);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(55 * 27), (String)")<*6"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\n\b\n,6tdpVpljt&~xbxhO{\u007f|VAQS,7", (int)(-27 - -22)) + exception.toString());
            return n;
        }
    }

    static int a(int n) {
        int n2 = 1;
        while (n >> 7 * n2 > 0) {
            ++n2;
        }
        return n + 1 + n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int a(int n, int n2) {
        int n3 = 2;
        try {
            int n4 = SmoothStreamingFragmentWriter.a(n2) - n2 - 2;
            while (n4 > 0) {
                ++n3;
                --n4;
            }
            return n3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(FileChunk.regionMatches((int)(71 + 38), (String)"\u001c\u001a\u0018\"8&6&\u0000\">4*t+))\u001a:sbpOak<'") + exception.toString());
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int a(byte[] byArray, int n, int n2, int n3) {
        try {
            int n4 = SmoothStreamingFragmentWriter.a(n3) - n3 - 2;
            byArray[n] = (byte)n2;
            ++n;
            while (true) {
                if (n4 <= 0) {
                    byArray[n] = (byte)(n3 & 0x7F);
                    ++n;
                    return n;
                }
                byArray[n] = (byte)(n3 >> 7 * n4 | 0x80);
                ++n;
                --n4;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(FileChunk.regionMatches((int)(55 - 26), (String)"LJHrhvfvPrndz${yyJjcr`)4") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getSTSDSize(SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        int n = 16;
        if (smoothStreamingFragmentWriterMedia.trackType == 9 && smoothStreamingFragmentWriterMedia.trackCodec == 7) {
            n += 86;
            if (smoothStreamingFragmentWriterMedia.trackAVCCBytes == null) return n;
            return n += 8 + smoothStreamingFragmentWriterMedia.trackAVCCBytes.length;
        }
        if (smoothStreamingFragmentWriterMedia.trackType != 8 || smoothStreamingFragmentWriterMedia.trackCodec != 10) {
            if (smoothStreamingFragmentWriterMedia.trackType != 8) return n;
            if (smoothStreamingFragmentWriterMedia.trackCodec != 2) return n;
            return n += 36;
        }
        n += 36;
        n += 12;
        byte[] byArray = smoothStreamingFragmentWriterMedia.trackAACConfigBytes;
        int n2 = byArray == null ? 0 : SmoothStreamingFragmentWriter.a(byArray.length);
        n += SmoothStreamingFragmentWriter.a(3, 3 + SmoothStreamingFragmentWriter.a(13 + n2) + SmoothStreamingFragmentWriter.a(1));
        n += 2;
        ++n;
        n += SmoothStreamingFragmentWriter.a(4, 13 + n2);
        ++n;
        ++n;
        n += 3;
        n += 4;
        n += 4;
        if (byArray != null) {
            n += SmoothStreamingFragmentWriter.a(5, byArray.length);
            n += byArray.length;
        }
        n += SmoothStreamingFragmentWriter.a(6, 1);
        return ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomSTSD(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2;
            block7: {
                block6: {
                    block4: {
                        block5: {
                            n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                            boolean bl = false;
                            byArray[n] = (byte)(bl ? 1 : 0);
                            int n3 = 0;
                            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
                            n += 3;
                            if (smoothStreamingFragmentWriterMedia.trackType == 9 && smoothStreamingFragmentWriterMedia.trackCodec == 7) break block4;
                            if (smoothStreamingFragmentWriterMedia.trackType == 8 && smoothStreamingFragmentWriterMedia.trackCodec == 10) break block5;
                            if (smoothStreamingFragmentWriterMedia.trackType != 8 || smoothStreamingFragmentWriterMedia.trackCodec != 2) break block6;
                            int n4 = 1;
                            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)n, (int)4);
                            n += 4;
                            String string = FileChunk.regionMatches((int)(1492 / 235), (String)"(jx:");
                            int n5 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                            BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioChannelCount, (byte[])byArray, (int)(n += 4), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioSampleRate, (byte[])byArray, (int)(n += 2), (int)2);
                            BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 2, smoothStreamingFragmentWriterContext, string, n5);
                            break block7;
                        }
                        int n6 = 1;
                        BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)n, (int)4);
                        n += 4;
                        String string = Base64.substring((String)".4q'", (int)(47 * 45));
                        int n7 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                        BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                        BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioChannelCount, (byte[])byArray, (int)(n += 4), (int)2);
                        BufferUtils.intToByteArray((int)16, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackAudioSampleRate, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.trackTimescale, (byte[])byArray, (int)(n += 2), (int)2);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                        n += 2;
                        int n8 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                        n += 4;
                        byte[] byArray2 = smoothStreamingFragmentWriterMedia.trackAACConfigBytes;
                        int n9 = byArray2 == null ? 0 : SmoothStreamingFragmentWriter.a(byArray2.length);
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 3, 3 + SmoothStreamingFragmentWriter.a(13 + n9) + SmoothStreamingFragmentWriter.a(1));
                        BufferUtils.intToByteArray((int)(smoothStreamingFragmentWriterMedia.trackId + 1), (byte[])byArray, (int)n, (int)2);
                        byArray[n += 2] = 0;
                        ++n;
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 4, 13 + n9);
                        byArray[n] = 64;
                        byArray[++n] = 21;
                        int n10 = 0;
                        int n11 = 0;
                        int n12 = 0;
                        BufferUtils.intToByteArray((int)n10, (byte[])byArray, (int)(++n), (int)3);
                        BufferUtils.intToByteArray((int)n11, (byte[])byArray, (int)(n += 3), (int)4);
                        BufferUtils.intToByteArray((int)n12, (byte[])byArray, (int)(n += 4), (int)4);
                        n += 4;
                        if (byArray2 != null) {
                            n = SmoothStreamingFragmentWriter.a(byArray, n, 5, byArray2.length);
                            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                            n += byArray2.length;
                        }
                        n = SmoothStreamingFragmentWriter.a(byArray, n, 6, 1);
                        byArray[n] = 2;
                        SmoothStreamingFragmentWriter.stopAtom(byArray, ++n, smoothStreamingFragmentWriterContext, Base64.substring((String)"avbt", (int)(110 + 54)), n8);
                        SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, string, n7);
                        break block7;
                    }
                    int n13 = 1;
                    BufferUtils.intToByteArray((int)n13, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                    String string = FileChunk.regionMatches((int)(67 + 83), (String)"wa{(");
                    int n14 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)n, (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)2);
                    BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 2), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackWidth, (byte[])byArray, (int)(n += 4), (int)2);
                    BufferUtils.intToByteArray((int)smoothStreamingFragmentWriterMedia.trackHeight, (byte[])byArray, (int)(n += 2), (int)2);
                    BufferUtils.intToByteArray((int)0x480000, (byte[])byArray, (int)(n += 2), (int)4);
                    BufferUtils.intToByteArray((int)0x480000, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)0, (byte[])byArray, (int)(n += 4), (int)4);
                    BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)(n += 4), (int)2);
                    String string2 = smoothStreamingFragmentWriterMedia.componentName;
                    byte[] byArray3 = string2.getBytes();
                    byArray[n += 2] = (byte)(byArray3.length & 0xFF);
                    System.arraycopy(byArray3, 0, byArray, ++n, byArray3.length);
                    BufferUtils.intToByteArray((int)24, (byte[])byArray, (int)(n += 31), (int)2);
                    BufferUtils.intToByteArray((int)65535, (byte[])byArray, (int)(n += 2), (int)2);
                    n += 2;
                    if (smoothStreamingFragmentWriterMedia.trackAVCCBytes != null) {
                        int n15 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
                        System.arraycopy(smoothStreamingFragmentWriterMedia.trackAVCCBytes, 0, byArray, n, smoothStreamingFragmentWriterMedia.trackAVCCBytes.length);
                        SmoothStreamingFragmentWriter.stopAtom(byArray, n += smoothStreamingFragmentWriterMedia.trackAVCCBytes.length, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(114 + 105), (String)":*>\u001d"), n15);
                    }
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, string, n14);
                    break block7;
                }
                int n16 = 0;
                BufferUtils.intToByteArray((int)n16, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(123 + 59), (String)"eck}"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\b\u000e\f.4*:2\u00146*(6h0: >.\r9!\"\u0003\u0005\u0001\u0017nu", (int)(15 * 23)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTRUNDASH(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, int n2, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n3;
            int n4 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n5 = smoothStreamingFragmentWriterMedia.trunFlags;
            BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(++n), (int)3);
            int n6 = smoothStreamingFragmentWriterMedia.packets.size();
            BufferUtils.intToByteArray((int)n6, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            if ((n5 & 1) == 1) {
                BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            if ((n5 & 4) == 4) {
                n3 = 0;
                BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)n, (int)4);
                n += 4;
            }
            n3 = 0;
            int n7 = 0;
            while (true) {
                if (n7 >= n6) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(11 * 45), (String)";\"$<"), n4);
                    return n;
                }
                long l = n7 != n6 - 1 ? smoothStreamingFragmentWriterMedia.packets.get(n7 + 1).getTimecode() - smoothStreamingFragmentWriterMedia.packets.get(n7).getTimecode() : smoothStreamingFragmentWriterMedia.lastTimecode - smoothStreamingFragmentWriterMedia.packets.get(n7).getTimecode();
                int n8 = smoothStreamingFragmentWriterMedia.packets.get(n7).getSize();
                long l2 = smoothStreamingFragmentWriterMedia.packets.get(n7).getCTTS();
                int n9 = 0;
                n3 = (int)((long)n3 + l);
                if ((n5 & 0x100) == 256) {
                    BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x200) == 512) {
                    BufferUtils.intToByteArray((int)n8, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x400) == 1024) {
                    BufferUtils.intToByteArray((int)n9, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                if ((n5 & 0x800) == 2048) {
                    BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)n, (int)4);
                    n += 4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u0014\u0012\u0010: >.>\u0018:&<\"|$&<\"2\u0019-56\b\u000f\u000b\u0011\u0004\u0000\u0011\u000b~e", (int)(51 + 18)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomTRUN(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 2816;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = smoothStreamingFragmentWriterMedia.packets.size();
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)4);
            n += 4;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                if (n6 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(13 * 29), (String)"-(.2"), n2);
                    return n;
                }
                long l = (n6 != n4 - 1 ? smoothStreamingFragmentWriterMedia.packets.get(n6 + 1).getTimecode() - smoothStreamingFragmentWriterMedia.packets.get(n6).getTimecode() : smoothStreamingFragmentWriterMedia.lastTimecode - smoothStreamingFragmentWriterMedia.packets.get(n6).getTimecode()) * smoothStreamingFragmentWriterMedia.timescaleAdjust;
                int n7 = smoothStreamingFragmentWriterMedia.packets.get(n6).getSize();
                long l2 = (long)smoothStreamingFragmentWriterMedia.packets.get(n6).getCTTS() * smoothStreamingFragmentWriterMedia.timescaleAdjust;
                n5 = (int)((long)n5 + l);
                BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)n, (int)4);
                BufferUtils.intToByteArray((int)n7, (byte[])byArray, (int)(n += 4), (int)4);
                BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)(n += 4), (int)4);
                n += 4;
                ++n6;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u0004\u0002\u0000*0.>.\b*6,2l46,2\"\t=%&\u0018\u001f\u001b\u0001jq", (int)(-15 - 28)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomSDTP(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byArray[n] = 0;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            int n4 = smoothStreamingFragmentWriterMedia.packets.size();
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(13 * 47), (String)"0 16"), n2);
                    return n;
                }
                int n6 = smoothStreamingFragmentWriterMedia.packets.get(n5).getFrameType() != 1 ? 20 : 36;
                BufferUtils.longToByteArray((long)n6, (byte[])byArray, (int)n, (int)1);
                ++n;
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"TRPz`~n~Xzf|b<df|brYmuvOYJO:!", (int)(344 / 62)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeAtomPlayReadyTrackUUID(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2;
            int n3 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = PLAYREADY_GUID_BYTES;
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            byArray[n += byArray2.length] = 0;
            byte[] byArray3 = smoothStreamingFragmentWriterMedia.playReadySampleData.getKeyId();
            int n4 = (byArray3 == null ? 0 : 1) + (smoothStreamingFragmentWriterMedia.playReadySampleData.isSubSamples() ? 2 : 0);
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(++n), (int)3);
            n += 3;
            if (byArray3 != null) {
                n2 = smoothStreamingFragmentWriterMedia.playReadySampleData.getAlgorithmId();
                int n5 = smoothStreamingFragmentWriterMedia.playReadySampleData.getIvLen();
                BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)3);
                BufferUtils.intToByteArray((int)n5, (byte[])byArray, (int)(n += 3), (int)1);
                System.arraycopy(byArray3, 0, byArray, ++n, byArray3.length);
                n += byArray3.length;
            }
            n2 = smoothStreamingFragmentWriterMedia.playReadySampleData.getCount();
            BufferUtils.intToByteArray((int)n2, (byte[])byArray, (int)n, (int)4);
            n += 4;
            List list = smoothStreamingFragmentWriterMedia.playReadySampleData.getFragments();
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(781 / 194), (String)"qpoc"), n3);
                    return n;
                }
                RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)iterator.next();
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n, rTPPacketFragment.getLen());
                n += rTPPacketFragment.getLen();
            }
        }
        catch (Exception exception) {
            System.out.println(FileChunk.regionMatches((int)(982 / 186), (String)"TRPz`~n~Xzf|b<df|brYmuvLq\u007ffRdcg}Qtfkb_^EI4/") + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUID(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            n = SmoothStreamingFragmentWriter.writeAtomUUIDDuration(byArray, n, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
            return SmoothStreamingFragmentWriter.writeAtomUUIDReadAhead(byArray, n, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\f\n\brhvfvPrndz$|~dzjQe}~A@_S\"9", (int)(65 + 60)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUIDDuration(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            byte[] byArray2 = BufferUtils.decodeHexString((String)Base64.substring((String)">m;o5o>:$#v& !s! )\u007f)-)/{agd412d5", (int)(3 - -5)));
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            byArray[n += byArray2.length] = 1;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.startTimecode, (byte[])byArray, (int)(n += 3), (int)8);
            BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.duration, (byte[])byArray, (int)(n += 8), (int)8);
            SmoothStreamingFragmentWriter.stopAtom(byArray, n += 8, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(199 / 37), (String)"psnl"), n2);
            return n;
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"\u0006\f\u000e(2(8,\n4(.0j24.<,\u000b?# \u001b\u001a\u0019\u0015\u0016&&4\">77`{", (int)(113 + 102)) + exception.toString());
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeAtomUUIDReadAhead(byte[] byArray, int n, SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext, SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia) {
        try {
            int n2 = n = SmoothStreamingFragmentWriter.startAtom(byArray, n, smoothStreamingFragmentWriterContext);
            System.arraycopy(READ_AHEAD_GUID_BYTES, 0, byArray, n, READ_AHEAD_GUID_BYTES.length);
            byArray[n += SmoothStreamingFragmentWriter.READ_AHEAD_GUID_BYTES.length] = 1;
            int n3 = 0;
            BufferUtils.intToByteArray((int)n3, (byte[])byArray, (int)(++n), (int)3);
            int n4 = smoothStreamingFragmentWriterMedia.readAheadDurations.length;
            BufferUtils.intToByteArray((int)n4, (byte[])byArray, (int)(n += 3), (int)1);
            ++n;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    SmoothStreamingFragmentWriter.stopAtom(byArray, n, smoothStreamingFragmentWriterContext, FileChunk.regionMatches((int)(15 + 76), (String)".)4:"), n2);
                    return n;
                }
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.readAheadStartTimes[n5], (byte[])byArray, (int)n, (int)8);
                BufferUtils.longToByteArray((long)smoothStreamingFragmentWriterMedia.readAheadDurations[n5], (byte[])byArray, (int)(n += 8), (int)8);
                n += 8;
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(Base64.substring((String)"PVTvlrbz\\~b`~ xbxfvUayzMLS_Nx\u007f{Aigb`?&", (int)(27 * 19)) + exception.toString());
            return n;
        }
    }
}

