/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyTIPL;

public class TagOptionSingleton {
    private static final Map tagOptionTable = new HashMap();
    private static final String DEFAULT = "default";
    private static Object defaultOptions = "default";
    private Map keywordMap = new HashMap();
    private Map lyrics3SaveFieldMap = new HashMap();
    private Map parenthesisMap = new HashMap();
    private Map replaceWordMap = new HashMap();
    private List endWordDelimiterList = new LinkedList();
    private List filenameDelimiterList = new LinkedList();
    private List startWordDelimiterList = new LinkedList();
    private List upperLowerCaseWordList = new LinkedList();
    private String language = "eng";
    private boolean compositeMatchOverwrite = false;
    private boolean filenameTagSave = false;
    private boolean id3v1Save = true;
    private boolean id3v1SaveAlbum = true;
    private boolean id3v1SaveArtist = true;
    private boolean id3v1SaveComment = true;
    private boolean id3v1SaveGenre = true;
    private boolean id3v1SaveTitle = true;
    private boolean id3v1SaveTrack = true;
    private boolean id3v1SaveYear = true;
    private boolean id3v2KeepEmptyFrameIfRead = false;
    private boolean id3v2PaddingCopyTag = true;
    private boolean id3v2PaddingWillShorten = false;
    private boolean id3v2Save = true;
    private boolean id3v2SaveEmptyFrame = false;
    private boolean id3v2SaveExtendedHeader = false;
    private boolean lyrics3KeepEmptyFieldIfRead = false;
    private boolean lyrics3Save = true;
    private boolean lyrics3SaveEmptyField = false;
    private boolean originalSavedAfterAdjustingID3v2Padding = true;
    private byte playCounterSize = (byte)4;
    private byte textEncoding = 0;
    private byte timeStampFormat = (byte)2;
    private float id3v2PaddingMultiplier = 2.0f;
    private int defaultSaveMode = 1;
    private int id3v2PaddingSize = 2048;
    private int numberMP3SyncFrame = 5;

    private TagOptionSingleton() {
        this.setToDefault();
    }

    public static TagOptionSingleton getInstance() {
        return TagOptionSingleton.getInstance(defaultOptions);
    }

    public static TagOptionSingleton getInstance(Object object) {
        TagOptionSingleton tagOptionSingleton = (TagOptionSingleton)tagOptionTable.get(object);
        if (tagOptionSingleton == null) {
            tagOptionSingleton = new TagOptionSingleton();
            tagOptionTable.put(object, tagOptionSingleton);
        }
        return tagOptionSingleton;
    }

    public String getCloseParenthesis(String string) {
        return (String)this.parenthesisMap.get(string);
    }

    public boolean isCloseParenthesis(String string) {
        return this.parenthesisMap.containsValue(string);
    }

    public void setCompositeMatchOverwrite(boolean bl) {
        this.compositeMatchOverwrite = bl;
    }

    public boolean isCompositeMatchOverwrite() {
        return this.compositeMatchOverwrite;
    }

    public void setDefaultSaveMode(int n) {
        this.defaultSaveMode = n;
    }

    public int getDefaultSaveMode() {
        return this.defaultSaveMode;
    }

    public void setFilenameTagSave(boolean bl) {
        this.filenameTagSave = bl;
    }

    public boolean isFilenameTagSave() {
        return this.filenameTagSave;
    }

    public boolean isId3v2SaveExtendedHeader() {
        return this.id3v2SaveExtendedHeader;
    }

    public void setInstanceKey(Object object) {
        defaultOptions = object;
    }

    public static Object getInstanceKey() {
        return defaultOptions;
    }

    public Iterator getEndWordDelimiterIterator() {
        return this.endWordDelimiterList.iterator();
    }

    public Iterator getFilenameDelimiterIterator() {
        return this.filenameDelimiterList.iterator();
    }

    public void setId3v1Save(boolean bl) {
        this.id3v1Save = bl;
    }

    public boolean isId3v1Save() {
        return this.id3v1Save;
    }

    public void setId3v1SaveAlbum(boolean bl) {
        this.id3v1SaveAlbum = bl;
    }

    public boolean isId3v1SaveAlbum() {
        return this.id3v1SaveAlbum;
    }

    public void setId3v1SaveArtist(boolean bl) {
        this.id3v1SaveArtist = bl;
    }

    public boolean isId3v1SaveArtist() {
        return this.id3v1SaveArtist;
    }

    public void setId3v1SaveComment(boolean bl) {
        this.id3v1SaveComment = bl;
    }

    public boolean isId3v1SaveComment() {
        return this.id3v1SaveComment;
    }

    public void setId3v1SaveGenre(boolean bl) {
        this.id3v1SaveGenre = bl;
    }

    public boolean isId3v1SaveGenre() {
        return this.id3v1SaveGenre;
    }

    public void setId3v1SaveTitle(boolean bl) {
        this.id3v1SaveTitle = bl;
    }

    public boolean isId3v1SaveTitle() {
        return this.id3v1SaveTitle;
    }

    public void setId3v1SaveTrack(boolean bl) {
        this.id3v1SaveTrack = bl;
    }

    public boolean isId3v1SaveTrack() {
        return this.id3v1SaveTrack;
    }

    public void setId3v1SaveYear(boolean bl) {
        this.id3v1SaveYear = bl;
    }

    public boolean isId3v1SaveYear() {
        return this.id3v1SaveYear;
    }

    public void setId3v2KeepEmptyFrameIfRead(boolean bl) {
        this.id3v2KeepEmptyFrameIfRead = bl;
    }

    public boolean isId3v2KeepEmptyFrameIfRead() {
        return this.id3v2KeepEmptyFrameIfRead;
    }

    public void setId3v2PaddingCopyTag(boolean bl) {
        this.id3v2PaddingCopyTag = bl;
    }

    public boolean isId3v2PaddingCopyTag() {
        return this.id3v2PaddingCopyTag;
    }

    public void setId3v2PaddingMultiplier(float f) {
        if (f > 1.0f) {
            this.id3v2PaddingMultiplier = f;
        }
    }

    public float getId3v2PaddingMultiplier() {
        return this.id3v2PaddingMultiplier;
    }

    public void setId3v2PaddingSize(int n) {
        if (n >= 0) {
            this.id3v2PaddingSize = n;
        }
    }

    public int getId3v2PaddingSize() {
        return this.id3v2PaddingSize;
    }

    public void setId3v2PaddingWillShorten(boolean bl) {
        this.id3v2PaddingWillShorten = bl;
    }

    public boolean isId3v2PaddingWillShorten() {
        return this.id3v2PaddingWillShorten;
    }

    public void setId3v2Save(boolean bl) {
        this.id3v2Save = bl;
    }

    public boolean isId3v2Save() {
        return this.id3v2Save;
    }

    public void setId3v2SaveEmptyFrame(boolean bl) {
        this.id3v2SaveEmptyFrame = bl;
    }

    public boolean isId3v2SaveEmptyFrame() {
        return this.id3v2SaveEmptyFrame;
    }

    public void setId3v2SaveExtendedHeader(boolean bl) {
        this.id3v2SaveExtendedHeader = bl;
    }

    public Iterator getKeywordIterator() {
        return this.keywordMap.keySet().iterator();
    }

    public Iterator getKeywordListIterator(Class clazz) {
        return ((LinkedList)this.keywordMap.get(clazz)).iterator();
    }

    public void setLanguage(String string) {
        if (TagConstant.languageIdToString.containsKey(string)) {
            this.language = string;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLyrics3KeepEmptyFieldIfRead(boolean bl) {
        this.lyrics3KeepEmptyFieldIfRead = bl;
    }

    public boolean isLyrics3KeepEmptyFieldIfRead() {
        return this.lyrics3KeepEmptyFieldIfRead;
    }

    public void setLyrics3Save(boolean bl) {
        this.lyrics3Save = bl;
    }

    public boolean isLyrics3Save() {
        return this.lyrics3Save;
    }

    public void setLyrics3SaveEmptyField(boolean bl) {
        this.lyrics3SaveEmptyField = bl;
    }

    public boolean isLyrics3SaveEmptyField() {
        return this.lyrics3SaveEmptyField;
    }

    public void setLyrics3SaveField(String string, boolean bl) {
        this.lyrics3SaveFieldMap.put(string, new Boolean(bl));
    }

    public boolean getLyrics3SaveField(String string) {
        return (Boolean)this.lyrics3SaveFieldMap.get(string);
    }

    public Map getLyrics3SaveFieldMap() {
        return this.lyrics3SaveFieldMap;
    }

    public String getNewReplaceWord(String string) {
        return (String)this.replaceWordMap.get(string);
    }

    public void setNumberMP3SyncFrame(int n) {
        this.numberMP3SyncFrame = n;
    }

    public int getNumberMP3SyncFrame() {
        return this.numberMP3SyncFrame;
    }

    public Iterator getOldReplaceWordIterator() {
        return this.replaceWordMap.keySet().iterator();
    }

    public boolean isOpenParenthesis(String string) {
        return this.parenthesisMap.containsKey(string);
    }

    public Iterator getOpenParenthesisIterator() {
        return this.parenthesisMap.keySet().iterator();
    }

    public void setOriginalSavedAfterAdjustingID3v2Padding(boolean bl) {
        this.originalSavedAfterAdjustingID3v2Padding = bl;
    }

    public boolean isOriginalSavedAfterAdjustingID3v2Padding() {
        return this.originalSavedAfterAdjustingID3v2Padding;
    }

    public void setPlayCounterSize(byte by) {
        if (by > 0) {
            this.playCounterSize = by;
        }
    }

    public byte getPlayCounterSize() {
        return this.playCounterSize;
    }

    public Iterator getStartWordDelimiterIterator() {
        return this.startWordDelimiterList.iterator();
    }

    public void setTextEncoding(byte by) {
        if (by >= 0 && by <= 3) {
            this.textEncoding = by;
        }
    }

    public byte getTextEncoding() {
        return this.textEncoding;
    }

    public void setTimeStampFormat(byte by) {
        if (by == 1 || by == 2) {
            this.timeStampFormat = by;
        }
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setToDefault() {
        Iterator iterator;
        this.keywordMap = new HashMap();
        this.compositeMatchOverwrite = false;
        this.defaultSaveMode = 1;
        this.endWordDelimiterList = new LinkedList();
        this.filenameDelimiterList = new LinkedList();
        this.filenameTagSave = false;
        this.id3v1Save = true;
        this.id3v1SaveAlbum = true;
        this.id3v1SaveArtist = true;
        this.id3v1SaveComment = true;
        this.id3v1SaveGenre = true;
        this.id3v1SaveTitle = true;
        this.id3v1SaveTrack = true;
        this.id3v1SaveYear = true;
        this.id3v2KeepEmptyFrameIfRead = false;
        this.id3v2PaddingCopyTag = true;
        this.id3v2PaddingWillShorten = false;
        this.id3v2Save = true;
        this.id3v2SaveEmptyFrame = false;
        this.id3v2SaveExtendedHeader = false;
        this.id3v2PaddingMultiplier = 2.0f;
        this.id3v2PaddingSize = 2048;
        this.language = "eng";
        this.lyrics3KeepEmptyFieldIfRead = false;
        this.lyrics3Save = true;
        this.lyrics3SaveEmptyField = false;
        this.lyrics3SaveFieldMap = new HashMap();
        this.numberMP3SyncFrame = 5;
        this.parenthesisMap = new HashMap();
        this.playCounterSize = (byte)4;
        this.replaceWordMap = new HashMap();
        this.startWordDelimiterList = new LinkedList();
        this.textEncoding = 0;
        this.timeStampFormat = (byte)2;
        this.upperLowerCaseWordList = new LinkedList();
        for (String string : TagConstant.lyrics3v2FieldIdToString.keySet()) {
            this.lyrics3SaveFieldMap.put(string, new Boolean(true));
        }
        try {
            this.addKeyword(FrameBodyCOMM.class, "ultimix");
            this.addKeyword(FrameBodyCOMM.class, "dance");
            this.addKeyword(FrameBodyCOMM.class, "mix");
            this.addKeyword(FrameBodyCOMM.class, "remix");
            this.addKeyword(FrameBodyCOMM.class, "rmx");
            this.addKeyword(FrameBodyCOMM.class, "live");
            this.addKeyword(FrameBodyCOMM.class, "cover");
            this.addKeyword(FrameBodyCOMM.class, "soundtrack");
            this.addKeyword(FrameBodyCOMM.class, "version");
            this.addKeyword(FrameBodyCOMM.class, "acoustic");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "cd");
            this.addKeyword(FrameBodyCOMM.class, "extended");
            this.addKeyword(FrameBodyCOMM.class, "vocal");
            this.addKeyword(FrameBodyCOMM.class, "unplugged");
            this.addKeyword(FrameBodyCOMM.class, "acapella");
            this.addKeyword(FrameBodyCOMM.class, "edit");
            this.addKeyword(FrameBodyCOMM.class, "radio");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "album");
            this.addKeyword(FrameBodyCOMM.class, "studio");
            this.addKeyword(FrameBodyCOMM.class, "instrumental");
            this.addKeyword(FrameBodyCOMM.class, "unedited");
            this.addKeyword(FrameBodyCOMM.class, "karoke");
            this.addKeyword(FrameBodyCOMM.class, "quality");
            this.addKeyword(FrameBodyCOMM.class, "uncensored");
            this.addKeyword(FrameBodyCOMM.class, "clean");
            this.addKeyword(FrameBodyCOMM.class, "dirty");
            this.addKeyword(FrameBodyTIPL.class, "f.");
            this.addKeyword(FrameBodyTIPL.class, "feat");
            this.addKeyword(FrameBodyTIPL.class, "feat.");
            this.addKeyword(FrameBodyTIPL.class, "featuring");
            this.addKeyword(FrameBodyTIPL.class, "ftng");
            this.addKeyword(FrameBodyTIPL.class, "ftng.");
            this.addKeyword(FrameBodyTIPL.class, "ft.");
            this.addKeyword(FrameBodyTIPL.class, "ft");
            iterator = TagConstant.genreStringToId.keySet().iterator();
            while (iterator.hasNext()) {
                this.addKeyword(FrameBodyCOMM.class, (String)iterator.next());
            }
        }
        catch (TagException tagException) {
            tagException.printStackTrace();
        }
        this.addUpperLowerCaseWord("a");
        this.addUpperLowerCaseWord("in");
        this.addUpperLowerCaseWord("of");
        this.addUpperLowerCaseWord("the");
        this.addUpperLowerCaseWord("on");
        this.addUpperLowerCaseWord("is");
        this.addUpperLowerCaseWord("it");
        this.addUpperLowerCaseWord("to");
        this.addUpperLowerCaseWord("at");
        this.addUpperLowerCaseWord("an");
        this.addUpperLowerCaseWord("and");
        this.addUpperLowerCaseWord("but");
        this.addUpperLowerCaseWord("or");
        this.addUpperLowerCaseWord("for");
        this.addUpperLowerCaseWord("nor");
        this.addUpperLowerCaseWord("not");
        this.addUpperLowerCaseWord("so");
        this.addUpperLowerCaseWord("yet");
        this.addUpperLowerCaseWord("with");
        this.addUpperLowerCaseWord("into");
        this.addUpperLowerCaseWord("by");
        this.addUpperLowerCaseWord("up");
        this.addUpperLowerCaseWord("as");
        this.addUpperLowerCaseWord("if");
        this.addUpperLowerCaseWord("feat.");
        this.addUpperLowerCaseWord("vs.");
        this.addUpperLowerCaseWord("I'm");
        this.addUpperLowerCaseWord("I");
        this.addUpperLowerCaseWord("I've");
        this.addUpperLowerCaseWord("I'll");
        this.addReplaceWord("v.", "vs.");
        this.addReplaceWord("vs.", "vs.");
        this.addReplaceWord("versus", "vs.");
        this.addReplaceWord("f.", "feat.");
        this.addReplaceWord("feat", "feat.");
        this.addReplaceWord("featuring", "feat.");
        this.addReplaceWord("ftng.", "feat.");
        this.addReplaceWord("ftng", "feat.");
        this.addReplaceWord("ft.", "feat.");
        this.addReplaceWord("ft", "feat.");
        this.addFilenameDelimiter("/");
        this.addFilenameDelimiter("\\");
        this.addFilenameDelimiter(" -");
        this.addFilenameDelimiter(";");
        this.addFilenameDelimiter("|");
        this.addFilenameDelimiter(":");
        iterator = this.getKeywordListIterator(FrameBodyTIPL.class);
        while (iterator.hasNext()) {
            this.addStartWordDelimiter((String)iterator.next());
        }
        this.addParenthesis("(", ")");
        this.addParenthesis("[", "]");
        this.addParenthesis("{", "}");
        this.addParenthesis("<", ">");
    }

    public Iterator getUpperLowerCaseWordListIterator() {
        return this.upperLowerCaseWordList.iterator();
    }

    public void addEndWordDelimiter(String string) {
        this.endWordDelimiterList.add(string);
    }

    public void addFilenameDelimiter(String string) {
        this.filenameDelimiterList.add(string);
    }

    public void addKeyword(Class clazz, String string) throws TagException {
        if (!AbstractID3v2FrameBody.class.isAssignableFrom(clazz)) {
            throw new TagException("Invalid class type. Must be AbstractId3v2FrameBody " + clazz);
        }
        if (string != null && string.length() > 0) {
            LinkedList linkedList;
            if (!this.keywordMap.containsKey(clazz)) {
                linkedList = new LinkedList();
                this.keywordMap.put(clazz, linkedList);
            } else {
                linkedList = (LinkedList)this.keywordMap.get(clazz);
            }
            linkedList.add(string);
        }
    }

    public void addParenthesis(String string, String string2) {
        this.parenthesisMap.put(string, string2);
    }

    public void addReplaceWord(String string, String string2) {
        this.replaceWordMap.put(string, string2);
    }

    public void addStartWordDelimiter(String string) {
        this.startWordDelimiterList.add(string);
    }

    public void addUpperLowerCaseWord(String string) {
        this.upperLowerCaseWordList.add(string);
    }
}

