/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.MP3File;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameTag
extends AbstractMP3Tag {
    private AbstractFilenameComposite composite = null;
    private ID3v2_4 id3tag = null;
    private MP3File mp3file = null;
    private String extension = null;

    public FilenameTag(FilenameTag filenameTag) {
        super(filenameTag);
        this.composite = (AbstractFilenameComposite)TagUtility.copyObject(filenameTag.composite);
        this.id3tag = new ID3v2_4(filenameTag.id3tag);
        this.mp3file = new MP3File(filenameTag.mp3file);
        this.extension = filenameTag.extension;
    }

    protected FilenameTag() {
    }

    public void setComposite(AbstractFilenameComposite abstractFilenameComposite) {
        this.composite = abstractFilenameComposite;
    }

    public AbstractFilenameComposite getComposite() {
        return this.composite;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame != null) {
            if (this.id3tag == null) {
                this.id3tag = new ID3v2_4();
            }
            this.id3tag.setFrame(abstractID3v2Frame);
            if (this.composite != null) {
                this.composite.setFrame(abstractID3v2Frame);
            }
        }
    }

    public AbstractID3v2Frame getFrame(String string) {
        AbstractID3v2Frame abstractID3v2Frame = null;
        if (this.id3tag != null) {
            abstractID3v2Frame = this.id3tag.getFrame(string);
        }
        return abstractID3v2Frame;
    }

    public Iterator getFrameOfType(String string) {
        return this.id3tag.getFrameOfType(string);
    }

    public void setId3tag(ID3v2_4 iD3v2_4) {
        this.id3tag = iD3v2_4;
        if (iD3v2_4 != null) {
            Iterator iterator = iD3v2_4.iterator();
            while (iterator.hasNext()) {
                this.composite.setFrame((AbstractID3v2Frame)iterator.next());
            }
            if (this.composite != null) {
                this.composite.matchAgainstTag(iD3v2_4);
            }
        }
    }

    public ID3v2_4 getId3tag() {
        return this.id3tag;
    }

    public String getIdentifier() {
        return "FilenameTagv1.00";
    }

    public void setMp3file(MP3File mP3File) {
        this.mp3file = mP3File;
    }

    public MP3File getMp3file() {
        return this.mp3file;
    }

    public int getSize() {
        return this.composeFilename().length();
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public void append(RandomAccessFile randomAccessFile) {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public String composeFilename() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.composite != null) {
            stringBuffer.append(this.composite.composeFilename().trim());
            stringBuffer.append('.');
            stringBuffer.append(this.extension);
        }
        return stringBuffer.toString();
    }

    public void delete(RandomAccessFile randomAccessFile) {
        throw new UnsupportedOperationException("Method delete() not yet implemented.");
    }

    public boolean hasFrame(String string) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrame(string);
        }
        return false;
    }

    public boolean hasFrameOfType(String string) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrameOfType(string);
        }
        return false;
    }

    public Iterator iterator() {
        Iterator iterator = null;
        if (this.composite != null) {
            iterator = this.composite.iterator();
        }
        return iterator;
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method overwrite() not yet implemented.");
    }

    public void overwrite(RandomAccessFile randomAccessFile) throws TagException, IOException {
        this.write(randomAccessFile);
    }

    public void read(RandomAccessFile randomAccessFile) {
        throw new UnsupportedOperationException("Method read() not yet implemented.");
    }

    public boolean seek(RandomAccessFile randomAccessFile) {
        throw new UnsupportedOperationException("Method seek() not yet implemented.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        return stringBuffer.toString();
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method write() not yet implemented.");
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException, TagException {
        File file = this.getMp3file().getMp3file();
        File file2 = new File(file.getParentFile(), this.composeFilename());
        if (!file2.getName().equals(file.getName())) {
            randomAccessFile.getFD().sync();
            randomAccessFile.getChannel().close();
            randomAccessFile.close();
            TagUtility.copyFile(file, file2);
            if (!file.delete()) {
                throw new TagException("Unable to delete original file: " + file.getName());
            }
        }
    }

    public String getSongTitle() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TIT2");
        if (abstractID3v2Frame != null) {
            FrameBodyTIT2 frameBodyTIT2 = (FrameBodyTIT2)abstractID3v2Frame.getBody();
            string = frameBodyTIT2.getText();
        }
        return string.trim();
    }

    public String getLeadArtist() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TPE1");
        if (abstractID3v2Frame != null) {
            FrameBodyTPE1 frameBodyTPE1 = (FrameBodyTPE1)abstractID3v2Frame.getBody();
            string = frameBodyTPE1.getText();
        }
        return string.trim();
    }

    public String getAlbumTitle() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TALB");
        if (abstractID3v2Frame != null) {
            FrameBodyTALB frameBodyTALB = (FrameBodyTALB)abstractID3v2Frame.getBody();
            string = frameBodyTALB.getText();
        }
        return string.trim();
    }

    public String getYearReleased() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TDRC");
        if (abstractID3v2Frame != null) {
            FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractID3v2Frame.getBody();
            string = frameBodyTDRC.getText();
        }
        return string.trim();
    }

    public String getSongComment() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("COMM");
        if (abstractID3v2Frame != null) {
            FrameBodyCOMM frameBodyCOMM = (FrameBodyCOMM)abstractID3v2Frame.getBody();
            string = frameBodyCOMM.getText();
        }
        return string.trim();
    }

    public String getSongGenre() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCON");
        if (abstractID3v2Frame != null) {
            FrameBodyTCON frameBodyTCON = (FrameBodyTCON)abstractID3v2Frame.getBody();
            string = frameBodyTCON.getText();
        }
        return string.trim();
    }

    public String getTrackNumberOnAlbum() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TRCK");
        if (abstractID3v2Frame != null) {
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            string = frameBodyTRCK.getText();
        }
        return string.trim();
    }

    public String getSongLyric() {
        AbstractID3v2FrameBody abstractID3v2FrameBody;
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("SYLT");
        if (abstractID3v2Frame != null) {
            abstractID3v2FrameBody = (FrameBodySYLT)abstractID3v2Frame.getBody();
            string = ((FrameBodySYLT)abstractID3v2FrameBody).getLyric();
        }
        if (string == null && (abstractID3v2Frame = this.getFrame("USLT")) != null) {
            abstractID3v2FrameBody = (FrameBodyUSLT)abstractID3v2Frame.getBody();
            string = ((FrameBodyUSLT)abstractID3v2FrameBody).getLyric();
        }
        return string.trim();
    }

    public String getAuthorComposer() {
        String string = null;
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCOM");
        if (abstractID3v2Frame != null) {
            FrameBodyTCOM frameBodyTCOM = (FrameBodyTCOM)abstractID3v2Frame.getBody();
            string = frameBodyTCOM.getText();
        }
        return string.trim();
    }

    public void setSongTitle(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TIT2");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTIT2(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTIT2)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setLeadArtist(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TPE1");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTPE1(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTPE1)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setAlbumTitle(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TALB");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTALB(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTALB)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setYearReleased(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TDRC");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTDRC(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTDRC)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongComment(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("COMM");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyCOMM(0, "ENG", "", string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyCOMM)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongGenre(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCON");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTCON(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTCON)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setTrackNumberOnAlbum(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TRCK");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTRCK(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTRCK)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongLyric(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("SYLT");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyUSLT(0, "ENG", "", string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyUSLT)abstractID3v2Frame.getBody()).setLyric(string.trim());
        }
    }

    public void setAuthorComposer(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCOM");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTCOM(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTCOM)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }
}

