/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class LineDelimiter {
    public static final LineDelimiter DEFAULT;
    public static final LineDelimiter AUTO;
    public static final LineDelimiter UNIX;
    public static final LineDelimiter WINDOWS;
    public static final LineDelimiter MAC;
    private final String value;

    public LineDelimiter(String string) {
        if (string == null) {
            throw new NullPointerException("delimiter");
        }
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineDelimiter)) {
            return false;
        }
        LineDelimiter lineDelimiter = (LineDelimiter)object;
        return this.value.equals(lineDelimiter.value);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delimiter:");
        if (this.value.length() == 0) {
            stringBuffer.append(" auto");
        } else {
            for (int i = 0; i < this.value.length(); ++i) {
                stringBuffer.append(" 0x");
                stringBuffer.append(Integer.toHexString(this.value.charAt(i)));
            }
        }
        return stringBuffer.toString();
    }

    static {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println();
        DEFAULT = new LineDelimiter(new String(byteArrayOutputStream.toByteArray()));
        AUTO = new LineDelimiter("");
        UNIX = new LineDelimiter("\n");
        WINDOWS = new LineDelimiter("\r\n");
        MAC = new LineDelimiter("\r");
    }
}

