/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;

public class VmPipeAcceptor
extends BaseIoAcceptor {
    static final Map boundHandlers = new HashMap();
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoAcceptorConfig(){

        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) throws IOException {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        Map map = boundHandlers;
        synchronized (map) {
            if (boundHandlers.containsKey(socketAddress)) {
                throw new IOException("Address already bound: " + socketAddress);
            }
            boundHandlers.put(socketAddress, new VmPipe(this, (VmPipeAddress)socketAddress, ioHandler, ioServiceConfig, this.getListeners()));
        }
        this.getListeners().fireServiceActivated(this, socketAddress, ioHandler, ioServiceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        VmPipe vmPipe = null;
        Map map = boundHandlers;
        synchronized (map) {
            if (!boundHandlers.containsKey(socketAddress)) {
                throw new IllegalArgumentException("Address not bound: " + socketAddress);
            }
            vmPipe = (VmPipe)boundHandlers.remove(socketAddress);
        }
        this.getListeners().fireServiceDeactivated(this, vmPipe.getAddress(), vmPipe.getHandler(), vmPipe.getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        Map map = boundHandlers;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(boundHandlers.keySet());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.unbind((SocketAddress)iterator.next());
            }
        }
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

