/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorFilter;

public class ExecutorThreadModel
implements ThreadModel {
    private static final Map service2model = new HashMap();
    private final String threadNamePrefix;
    private final ExecutorFilter defaultFilter;
    private ExecutorFilter filter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorThreadModel getInstance(String string) {
        ExecutorThreadModel executorThreadModel;
        if (string == null) {
            throw new NullPointerException("serviceName");
        }
        Map map = service2model;
        synchronized (map) {
            executorThreadModel = (ExecutorThreadModel)service2model.get(string);
            if (executorThreadModel == null) {
                executorThreadModel = new ExecutorThreadModel(string);
                service2model.put(string, executorThreadModel);
            }
        }
        return executorThreadModel;
    }

    private ExecutorThreadModel(String string) {
        this.threadNamePrefix = string;
        this.defaultFilter = new ExecutorFilter();
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.defaultFilter.getExecutor();
        final ThreadFactory threadFactory = threadPoolExecutor.getThreadFactory();
        ThreadFactory threadFactory2 = new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger(0);

            public Thread newThread(Runnable runnable) {
                Thread thread = threadFactory.newThread(runnable);
                thread.setName(ExecutorThreadModel.this.threadNamePrefix + '-' + this.threadId.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        threadPoolExecutor.setThreadFactory(threadFactory2);
        this.setExecutor(null);
    }

    public Executor getExecutor() {
        return this.filter.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.filter = executor == null ? this.defaultFilter : new ExecutorFilter(executor);
    }

    public void buildFilterChain(IoFilterChain ioFilterChain) throws Exception {
        ioFilterChain.addFirst(ExecutorThreadModel.class.getName(), this.filter);
    }
}

