/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;

public class DefaultIoFuture
implements IoFuture {
    private final IoSession session;
    private final Object lock;
    private IoFutureListener firstListener;
    private List<IoFutureListener> otherListeners;
    private Object result;
    private boolean ready;
    private int waiters;

    public DefaultIoFuture(IoSession ioSession) {
        this.session = ioSession;
        this.lock = this;
    }

    public DefaultIoFuture(IoSession ioSession, Object object) {
        this.session = ioSession;
        this.lock = object;
    }

    public IoSession getSession() {
        return this.session;
    }

    public Object getLock() {
        return this.lock;
    }

    public void join() {
        this.awaitUninterruptibly();
    }

    public boolean join(long l) {
        return this.awaitUninterruptibly(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoFuture awaitUninterruptibly() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                ++this.waiters;
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    --this.waiters;
                }
            }
        }
        return this;
    }

    private boolean awaitUninterruptibly(long l) {
        try {
            return this.await0(l, false);
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long l, boolean bl) throws InterruptedException {
        long l2 = l <= 0L ? 0L : System.currentTimeMillis();
        long l3 = l;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (l3 <= 0L) {
                return this.ready;
            }
            ++this.waiters;
            try {
                do {
                    block11: {
                        try {
                            this.lock.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!bl) break block11;
                            throw interruptedException;
                        }
                    }
                    if (!this.ready) continue;
                    boolean bl2 = true;
                    return bl2;
                } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
                boolean bl3 = this.ready;
                return bl3;
            }
            finally {
                --this.waiters;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ready) {
                return;
            }
            this.result = object;
            this.ready = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IoFutureListener ioFutureListener) {
        if (ioFutureListener == null) {
            throw new NullPointerException("listener");
        }
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                bl = true;
            } else if (this.firstListener == null) {
                this.firstListener = ioFutureListener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<IoFutureListener>(1);
                }
                this.otherListeners.add(ioFutureListener);
            }
        }
        if (bl) {
            this.notifyListener(ioFutureListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IoFutureListener ioFutureListener) {
        if (ioFutureListener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                if (ioFutureListener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(ioFutureListener);
                }
            }
        }
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (IoFutureListener ioFutureListener : this.otherListeners) {
                    this.notifyListener(ioFutureListener);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(IoFutureListener ioFutureListener) {
        try {
            ioFutureListener.operationComplete(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

