/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String EXTXVERSIONPLACEHOLDER = "{ext-x-version}";
    public static final String EXTXVERSIONSTR = "#EXT-X-VERSION:{ext-x-version}";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYSTR_NODVR_PLACHOLDER = "{query_no_dvr}";
    public static final String RESOLUTIONPLACEHOLDER = "{resolution}";
    public static final String RESOLUTIONWIDTHPLACEHOLDER = "{resolution-width}";
    public static final String RESOLUTIONHEIGHTPLACEHOLDER = "{resolution-height}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String PLAYSTARTNAME = "{playStartName}";
    public static final String PLAYSTARTVALUE = "{playStartValue}";
    public static final String PLAYSTARTPLACHOLDER = "{playStartName}={playStartValue}";
    public static final String PLAYDURATIONNAME = "{playDurationName}";
    public static final String PLAYDURATIONVALUE = "{playDurationValue}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDurationName}={playDurationValue}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCIVPLACEHOLDER = "{encIV}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String ENCKEYSTRWITHIV = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\",IV=\"{encIV}\"";
    public static final String DISCONTINUITYSTR = "#EXT-X-DISCONTINUITY";
    public static final String RESOLUTIONSTR = ",RESOLUTION={resolution-width}x{resolution-height}";
    public static final String MEDIANAMEPLACEHOLDER = "{mediaName}";
    public static final String BITRATEPLACEHOLDER = "{bitrate}";
    public static final String FILENAMEPATTERN = "{mediaName}{bitrate}_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";
    public static final String DEFAULT_MEDIANAME = "media";
    public static final String DEFAULT_CHUNKLISTNAME = "chunklist";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.getChars((int)(22 - 46), (String)"f=9");
        switch (n) {
            case 2: {
                string = FileChunk.getChars((int)(35 - 23), (String)"\"`~<");
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.getChars((int)(-16 - -5), (String)"{76;");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingCupertinoBlock> arrayList;
        List<LiveStreamingCupertinoBlock> list;
        Cipher cipher;
        if (cupertinoEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info(Base64.insert((String)"\u0006\":(\u001d;\"43>\u000445<=-3!9/\u001d*pdpwmki)ne\u007fxd]ol{tf`.5ws|[unr~g\\arvoaVcd}{c\u007fu]|`fxvvf/6", (int)(110 + 124)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), FileChunk.getChars((int)(513 / 83), (String)"GB["));
            long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(Base64.insert((String)"\u000e\u0015\u0002}\u0010\u0016\u0016y\u0007\u0013\u001a\tl\f<:;ioe", (int)(54 + 57)), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerCupertinoChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(FileChunk.getChars((int)(33 - -14), (String)"Cygw@`gsvuI{xwxjv:$0\u000015#5< $$\u00199'##\u007f7=7'/',\u001a2.26d\u007f\u0001\u0004\u0011nuw~g-')95=:&??hs") + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(n);
            n4 += liveStreamingCupertinoBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingCupertinoBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.insert((String)"(lmp", (int)(440 / 71)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(FileChunk.getChars((int)(-29 - -43), (String)"{}|"));
            if (string3 != null || (string3 = (String)object.get(FileChunk.getChars((int)(19 * 17), (String)"66,"))) != null || (string3 = (String)object.get(Base64.insert((String)"fswm{~bbb}{bts~}{q:y|i*.%3jrm", (int)(1135 / 212)))) != null || (string3 = (String)object.get(FileChunk.getChars((int)(489 / 100), (String)"gpvbz}cec~z}up\u007fzzr;v}j+)$0kmi"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(FileChunk.getChars((int)(19 * 45), (String)"<= "))) != null || (string2 = (String)object.get(FileChunk.getChars((int)(887 / 201), (String)"gpvbz}cec~z}up\u007fzzr;v}j+)$0uzy"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(FileChunk.getChars((int)(49 - -54), (String)"\u000b!?/\u00188?+.=\u000130?0\">\"<(\u0018)-;-thll*lhn|3*@it.cu\u007fug|5\u007fy{vhiy~j1 Lwpp%db(8<+ntzjc1: &5u\u007fyk{xhxllia.,*\"f\u001c") + file + Base64.insert((String)"N.5", (int)(33 * 51)) + string2.length());
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new CupertinoEncInfo(string2, byArray, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n > 0) return n;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 2: {
                string = FileChunk.getChars((int)(60 - -47), (String)"&<y/ada|") + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 10: 
        }
        if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
        return FileChunk.getChars((int)(264 / 73), (String)"nt1g)<9$") + mediaCodecInfoAudio.getAudioObjectType();
    }

    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return LiveStreamPacketizerCupertinoUtils.codecInfoVideoToCodecsStr(mediaCodecInfoVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo, boolean bl) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            case 7: {
                if (!bl) break;
                return FileChunk.getChars((int)(-30 - -34), (String)"ese6&?<%?=");
            }
            default: {
                return string;
            }
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return FileChunk.getChars((int)(2 - -62), (String)"!7!rj") + n2 + "." + n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToStreamMode(String var0) {
        var1_1 = 1;
        var2_2 = var0.lastIndexOf(".");
        if (var2_2 >= 0) ** GOTO lbl-1000
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = var0.substring(var2_2);
            if (StringUtils.isEmpty((String)var3_3)) {
                return var1_1;
            }
            if (var3_3.startsWith(FileChunk.getChars((int)(126 + 23), (String)";wv{"))) {
                var1_1 = 3;
            }
            if (var3_3.startsWith(FileChunk.getChars((int)(1201 / 245), (String)"*hv4")) == false) return var1_1;
            return 2;
        }
    }

    public static String getRandomMediaName(int n) {
        String string = FileChunk.getChars((int)(37 * 3), (String)"\"55;2");
        Random random = new Random(System.currentTimeMillis());
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        int n2 = 0;
        while (n2 < n) {
            string = string + BufferUtils.alphas[(byArray[n2] & 0x7F) % BufferUtils.alphas.length];
            ++n2;
        }
        return string;
    }
}

