/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;
    private static final int MODIFY_TRUNCATE = 0;
    private static final int MODIFY_ROUND = 1;
    private static final int MODIFY_CEILING = 2;
    public static final int MILLIS_IN_SECOND = 1000;
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final int MILLIS_IN_HOUR = 3600000;
    public static final int MILLIS_IN_DAY = 86400000;

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(10) == calendar2.get(10) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date parseDate(String string, String[] stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, stringArray, true);
    }

    public static Date parseDateStrictly(String string, String[] stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, stringArray, false);
    }

    private static Date parseDateWithLeniency(String string, String[] stringArray, boolean bl) throws ParseException {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setLenient(bl);
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i = 0; i < stringArray.length; ++i) {
            Date date;
            String string2 = stringArray[i];
            if (stringArray[i].endsWith("ZZ")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            simpleDateFormat.applyPattern(string2);
            parsePosition.setIndex(0);
            String string3 = string;
            if (stringArray[i].endsWith("ZZ")) {
                int n = DateUtils.indexOfSignChars(string3, 0);
                while (n >= 0) {
                    string3 = DateUtils.reformatTimezone(string3, n);
                    ++n;
                    n = DateUtils.indexOfSignChars(string3, n);
                }
            }
            if ((date = simpleDateFormat.parse(string3, parsePosition)) == null || parsePosition.getIndex() != string3.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    private static int indexOfSignChars(String string, int n) {
        int n2 = StringUtils.indexOf(string, '+', n);
        if (n2 < 0) {
            n2 = StringUtils.indexOf(string, '-', n);
        }
        return n2;
    }

    private static String reformatTimezone(String string, int n) {
        String string2 = string;
        if (n >= 0 && n + 5 < string.length() && Character.isDigit(string.charAt(n + 1)) && Character.isDigit(string.charAt(n + 2)) && string.charAt(n + 3) == ':' && Character.isDigit(string.charAt(n + 4)) && Character.isDigit(string.charAt(n + 5))) {
            string2 = string.substring(0, n + 3) + string.substring(n + 4);
        }
        return string2;
    }

    public static Date addYears(Date date, int n) {
        return DateUtils.add(date, 1, n);
    }

    public static Date addMonths(Date date, int n) {
        return DateUtils.add(date, 2, n);
    }

    public static Date addWeeks(Date date, int n) {
        return DateUtils.add(date, 3, n);
    }

    public static Date addDays(Date date, int n) {
        return DateUtils.add(date, 5, n);
    }

    public static Date addHours(Date date, int n) {
        return DateUtils.add(date, 11, n);
    }

    public static Date addMinutes(Date date, int n) {
        return DateUtils.add(date, 12, n);
    }

    public static Date addSeconds(Date date, int n) {
        return DateUtils.add(date, 13, n);
    }

    public static Date addMilliseconds(Date date, int n) {
        return DateUtils.add(date, 14, n);
    }

    public static Date add(Date date, int n, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int n) {
        return DateUtils.set(date, 1, n);
    }

    public static Date setMonths(Date date, int n) {
        return DateUtils.set(date, 2, n);
    }

    public static Date setDays(Date date, int n) {
        return DateUtils.set(date, 5, n);
    }

    public static Date setHours(Date date, int n) {
        return DateUtils.set(date, 11, n);
    }

    public static Date setMinutes(Date date, int n) {
        return DateUtils.set(date, 12, n);
    }

    public static Date setSeconds(Date date, int n) {
        return DateUtils.set(date, 13, n);
    }

    public static Date setMilliseconds(Date date, int n) {
        return DateUtils.set(date, 14, n);
    }

    private static Date set(Date date, int n, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n, n2);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date round(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, 1);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, 1);
        return calendar2;
    }

    public static Date round(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date truncate(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, 0);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, 0);
        return calendar2;
    }

    public static Date truncate(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    public static Date ceiling(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, 2);
        return calendar.getTime();
    }

    public static Calendar ceiling(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, 2);
        return calendar2;
    }

    public static Date ceiling(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.ceiling((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.ceiling((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    private static void modify(Calendar calendar, int n, int n2) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n == 14) {
            return;
        }
        Date date = calendar.getTime();
        long l = date.getTime();
        boolean bl = false;
        int n3 = calendar.get(14);
        if (0 == n2 || n3 < 500) {
            l -= (long)n3;
        }
        if (n == 13) {
            bl = true;
        }
        int n4 = calendar.get(13);
        if (!(bl || 0 != n2 && n4 >= 30)) {
            l -= (long)n4 * 1000L;
        }
        if (n == 12) {
            bl = true;
        }
        int n5 = calendar.get(12);
        if (!(bl || 0 != n2 && n5 >= 30)) {
            l -= (long)n5 * 60000L;
        }
        if (date.getTime() != l) {
            date.setTime(l);
            calendar.setTime(date);
        }
        boolean bl2 = false;
        for (int i = 0; i < fields.length; ++i) {
            int n6;
            for (n6 = 0; n6 < fields[i].length; ++n6) {
                if (fields[i][n6] != n) continue;
                if (n2 == 2 || n2 == 1 && bl2) {
                    if (n == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                        } else {
                            calendar.add(5, -15);
                            calendar.add(2, 1);
                        }
                    } else if (n == 9) {
                        if (calendar.get(11) == 0) {
                            calendar.add(11, 12);
                        } else {
                            calendar.add(11, -12);
                            calendar.add(5, 1);
                        }
                    } else {
                        calendar.add(fields[i][0], 1);
                    }
                }
                return;
            }
            n6 = 0;
            boolean bl3 = false;
            switch (n) {
                case 1001: {
                    if (fields[i][0] != 5) break;
                    n6 = calendar.get(5) - 1;
                    if (n6 >= 15) {
                        n6 -= 15;
                    }
                    bl2 = n6 > 7;
                    bl3 = true;
                    break;
                }
                case 9: {
                    if (fields[i][0] != 11) break;
                    n6 = calendar.get(11);
                    if (n6 >= 12) {
                        n6 -= 12;
                    }
                    bl2 = n6 >= 6;
                    bl3 = true;
                }
            }
            if (!bl3) {
                int n7 = calendar.getActualMinimum(fields[i][0]);
                int n8 = calendar.getActualMaximum(fields[i][0]);
                n6 = calendar.get(fields[i][0]) - n7;
                boolean bl4 = bl2 = n6 > (n8 - n7) / 2;
            }
            if (n6 == 0) continue;
            calendar.set(fields[i][0], calendar.get(fields[i][0]) - n6);
        }
        throw new IllegalArgumentException("The field " + n + " is not supported");
    }

    public static Iterator iterator(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n);
    }

    public static Iterator iterator(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = null;
        Calendar calendar3 = null;
        int n2 = 1;
        int n3 = 7;
        switch (n) {
            case 5: 
            case 6: {
                calendar2 = DateUtils.truncate(calendar, 2);
                calendar3 = (Calendar)calendar2.clone();
                calendar3.add(2, 1);
                calendar3.add(5, -1);
                if (n != 6) break;
                n2 = 2;
                n3 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar2 = DateUtils.truncate(calendar, 5);
                calendar3 = DateUtils.truncate(calendar, 5);
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        n2 = calendar.get(7);
                        n3 = n2 - 1;
                        break;
                    }
                    case 4: {
                        n2 = calendar.get(7) - 3;
                        n3 = calendar.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n + " is not valid.");
            }
        }
        if (n2 < 1) {
            n2 += 7;
        }
        if (n2 > 7) {
            n2 -= 7;
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        while (calendar2.get(7) != n2) {
            calendar2.add(5, -1);
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, 1);
        }
        return new DateIterator(calendar2, calendar3);
    }

    public static Iterator iterator(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    public static long getFragmentInMilliseconds(Date date, int n) {
        return DateUtils.getFragment(date, n, 14);
    }

    public static long getFragmentInSeconds(Date date, int n) {
        return DateUtils.getFragment(date, n, 13);
    }

    public static long getFragmentInMinutes(Date date, int n) {
        return DateUtils.getFragment(date, n, 12);
    }

    public static long getFragmentInHours(Date date, int n) {
        return DateUtils.getFragment(date, n, 11);
    }

    public static long getFragmentInDays(Date date, int n) {
        return DateUtils.getFragment(date, n, 6);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int n) {
        return DateUtils.getFragment(calendar, n, 14);
    }

    public static long getFragmentInSeconds(Calendar calendar, int n) {
        return DateUtils.getFragment(calendar, n, 13);
    }

    public static long getFragmentInMinutes(Calendar calendar, int n) {
        return DateUtils.getFragment(calendar, n, 12);
    }

    public static long getFragmentInHours(Calendar calendar, int n) {
        return DateUtils.getFragment(calendar, n, 11);
    }

    public static long getFragmentInDays(Calendar calendar, int n) {
        return DateUtils.getFragment(calendar, n, 6);
    }

    private static long getFragment(Date date, int n, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFragment(calendar, n, n2);
    }

    private static long getFragment(Calendar calendar, int n, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long l = DateUtils.getMillisPerUnit(n2);
        long l2 = 0L;
        switch (n) {
            case 1: {
                l2 += (long)calendar.get(6) * 86400000L / l;
                break;
            }
            case 2: {
                l2 += (long)calendar.get(5) * 86400000L / l;
            }
        }
        switch (n) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l2 += (long)calendar.get(11) * 3600000L / l;
            }
            case 11: {
                l2 += (long)calendar.get(12) * 60000L / l;
            }
            case 12: {
                l2 += (long)calendar.get(13) * 1000L / l;
            }
            case 13: {
                l2 += (long)(calendar.get(14) * 1) / l;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + n + " is not supported");
            }
        }
        return l2;
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n) {
        return DateUtils.truncatedCompareTo(date, date2, n) == 0;
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n) {
        Calendar calendar3 = DateUtils.truncate(calendar, n);
        Calendar calendar4 = DateUtils.truncate(calendar2, n);
        return calendar3.getTime().compareTo(calendar4.getTime());
    }

    public static int truncatedCompareTo(Date date, Date date2, int n) {
        Date date3 = DateUtils.truncate(date, n);
        Date date4 = DateUtils.truncate(date2, n);
        return date3.compareTo(date4);
    }

    private static long getMillisPerUnit(int n) {
        long l = Long.MAX_VALUE;
        switch (n) {
            case 5: 
            case 6: {
                l = 86400000L;
                break;
            }
            case 11: {
                l = 3600000L;
                break;
            }
            case 12: {
                l = 60000L;
                break;
            }
            case 13: {
                l = 1000L;
                break;
            }
            case 14: {
                l = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("The unit " + n + " cannot be represented is milleseconds");
            }
        }
        return l;
    }

    static class DateIterator
    implements Iterator {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        public Object next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return this.spot.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

