/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.OnMetadataBasic;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;

public class TranscoderSessionBitrateCalculator {
    protected boolean calculating = true;
    protected long startTimecode = -1L;
    protected int bitrateCalculatorDuration = 3000;
    protected int bitrateCalculatorDefaultAudioDuration = 30;
    protected int bitrateCalculatorDefaultVideoDuration = 30;
    protected int bitrateCalculatorMaxAudioDuration = 1000;
    protected int bitrateCalculatorMaxVideoDuration = 1000;
    protected CalculatorValues audioValues = new CalculatorValues();
    protected CalculatorValues videoValues = new CalculatorValues();
    protected boolean haveAudioDataRate = false;
    protected int audioDataRate = -1;
    protected boolean haveVideoDataRate = false;
    protected int videoDataRate = -1;

    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        WMSProperties wMSProperties = liveStreamTranscoder.getProperties();
        this.bitrateCalculatorDuration = wMSProperties.getPropertyInt(Base64.insert((String)"flrui}oHmamz|pf|fQceymstr", (int)(1058 / 220)), this.bitrateCalculatorDuration);
        this.bitrateCalculatorDefaultAudioDuration = wMSProperties.getPropertyInt(FileChunk.getChars((int)(-11 - 55), (String)"|v43#7!\u0006'++<&*8\"<\u000b573&8!\u0017\"<05\u001f)/?+).,"), this.bitrateCalculatorDefaultAudioDuration);
        this.bitrateCalculatorDefaultVideoDuration = wMSProperties.getPropertyInt(Base64.insert((String)"flrui}oHmamz|pf|fQsqylvoJtzzoEwqeqohf", (int)(50 - 46)), this.bitrateCalculatorDefaultVideoDuration);
        this.bitrateCalculatorMaxAudioDuration = wMSProperties.getPropertyInt(FileChunk.getChars((int)(104 + -17), (String)"51-(:(8\u001d>,\"7/%1)5\u0005(2\n9)' \u0014$ 2 <99"), this.bitrateCalculatorMaxAudioDuration);
        this.bitrateCalculatorMaxVideoDuration = wMSProperties.getPropertyInt(FileChunk.getChars((int)(1049 / 211), (String)"flrui}oHmamz|pf|fXwoNp~~sYkmauklj"), this.bitrateCalculatorMaxVideoDuration);
        String string = liveStreamTranscoder.getAppInstance().getContextStr() + ":" + liveStreamTranscoder.getStreamName();
        this.audioValues.f = this.bitrateCalculatorDefaultAudioDuration;
        this.audioValues.g = this.bitrateCalculatorMaxAudioDuration;
        this.audioValues.h = string + Base64.insert((String)"7oztx}", (int)(63 + -50));
        this.videoValues.f = this.bitrateCalculatorDefaultVideoDuration;
        this.videoValues.g = this.bitrateCalculatorMaxVideoDuration;
        this.videoValues.h = string + FileChunk.getChars((int)(-39 - 54), (String)"9rlbbg");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void inspectOnMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        OnMetadataBasic onMetadataBasic = FLVUtils.getOnMetadataData((AMFPacket)aMFPacket);
        if (onMetadataBasic == null) {
            return;
        }
        if (onMetadataBasic.audiodatarate > 0.0) {
            this.haveAudioDataRate = true;
            this.audioDataRate = (int)(onMetadataBasic.audiodatarate * 1024.0);
        }
        if (!(onMetadataBasic.videodatarate > 0.0)) return;
        this.haveVideoDataRate = true;
        this.videoDataRate = (int)(onMetadataBasic.videodatarate * 1024.0);
    }

    /*
     * Unable to fully structure code
     */
    public void handlePacket(IMediaStream var1_1, AMFPacket var2_2) {
        block12: {
            var3_3 = System.currentTimeMillis();
            if (this.startTimecode < 0L) break block12;
lbl3:
            // 2 sources

            while (true) {
                continue;
lbl5:
                // 2 sources

                while (true) {
                    if (var3_3 - this.startTimecode <= (long)this.bitrateCalculatorDuration) lbl-1000:
                    // 2 sources

                    {
                        return;
                    }
                    ** GOTO lbl15
                    break;
                }
                var5_4 = var2_2.getType();
                switch (var5_4) {
                    case 9: {
                        if (FLVUtils.isVideoCodecConfig((AMFPacket)var2_2)) ** break;
                        break;
                    }
lbl15:
                    // 2 sources

                    while (true) {
                        this.calculating = false;
                        ** continue;
                        break;
                    }
lbl18:
                    // 1 sources

                    while (true) {
                        this.audioValues.handlePacket(var1_1, var2_2);
                        ** break;
                        break;
                    }
                    case 8: {
                        if (FLVUtils.isAudioCodecConfig((AMFPacket)var2_2)) ** break;
                        ** continue;
                    }
                    case 18: {
                        this.inspectOnMetaData(var1_1, var2_2);
                        ** break;
                    }
                }
                this.videoValues.handlePacket(var1_1, var2_2);
                ** break;
lbl29:
                // 1 sources

                while (true) {
                    if (this.haveVideoDataRate) ** continue;
                    ** GOTO lbl5
                    break;
                }
lbl32:
                // 6 sources

                if (this.haveAudioDataRate) ** break;
                ** continue;
                ** continue;
                break;
            }
        }
        this.startTimecode = var3_3;
        ** while (true)
    }

    public boolean isCalculating() {
        return this.calculating;
    }

    public void setCalculating(boolean bl) {
        this.calculating = bl;
    }

    public long getVideoBitrate() {
        if (!this.haveVideoDataRate) {
            return this.videoValues.getBitrate();
        }
        return this.videoDataRate;
    }

    public long getAudioBitrate() {
        if (!this.haveAudioDataRate) {
            return this.audioValues.getBitrate();
        }
        return this.audioDataRate;
    }

    class CalculatorValues {
        long a = -1L;
        long b = -1L;
        int c = -1;
        long d = -1L;
        long e = -1L;
        int f = 30;
        int g = 1000;
        String h = "";

        CalculatorValues() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getSize();
            if (this.a < 0L) {
                this.a = l;
            } else {
                long l2 = l - this.b;
                if (l2 < 0L) {
                    l2 = this.f;
                } else if (l2 > (long)this.g) {
                    l2 = this.f;
                }
                this.e += l2;
                this.d += (long)this.c;
            }
            this.b = l;
            this.c = n;
        }

        public long getBitrate() {
            if (this.e <= 0L) {
                return 0L;
            }
            return this.d * 8L * 1000L / this.e;
        }
    }
}

