/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableColumnFormatException;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationManager {
    private static final String CONFIG_FILE_NAME = "lf5_configuration.xml";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String SELECTED = "selected";
    private static final String EXPANDED = "expanded";
    private static final String CATEGORY = "category";
    private static final String FIRST_CATEGORY_NAME = "Categories";
    private static final String LEVEL = "level";
    private static final String COLORLEVEL = "colorlevel";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String COLUMN = "column";
    private static final String NDCTEXTFILTER = "searchtext";
    private LogBrokerMonitor _monitor = null;
    private LogTable _table = null;

    public ConfigurationManager(LogBrokerMonitor logBrokerMonitor, LogTable logTable) {
        this._monitor = logBrokerMonitor;
        this._table = logTable;
        this.load();
    }

    public void save() {
        CategoryExplorerModel categoryExplorerModel = this._monitor.getCategoryExplorerTree().getExplorerModel();
        CategoryNode categoryNode = categoryExplorerModel.getRootCategoryNode();
        StringBuffer stringBuffer = new StringBuffer(2048);
        this.openXMLDocument(stringBuffer);
        this.openConfigurationXML(stringBuffer);
        this.processLogRecordFilter(this._monitor.getNDCTextFilter(), stringBuffer);
        this.processLogLevels(this._monitor.getLogLevelMenuItems(), stringBuffer);
        this.processLogLevelColors(this._monitor.getLogLevelMenuItems(), LogLevel.getLogLevelColorMap(), stringBuffer);
        this.processLogTableColumns(LogTableColumn.getLogTableColumns(), stringBuffer);
        this.processConfigurationNode(categoryNode, stringBuffer);
        this.closeConfigurationXML(stringBuffer);
        this.store(stringBuffer.toString());
    }

    public void reset() {
        this.deleteConfigurationFile();
        this.collapseTree();
        this.selectAllNodes();
    }

    public static String treePathToString(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        CategoryNode categoryNode = null;
        Object[] objectArray = treePath.getPath();
        for (int i = 1; i < objectArray.length; ++i) {
            categoryNode = (CategoryNode)objectArray[i];
            if (i > 1) {
                stringBuffer.append(".");
            }
            stringBuffer.append(categoryNode.getTitle());
        }
        return stringBuffer.toString();
    }

    protected void load() {
        File file = new File(this.getFilename());
        if (file.exists()) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                this.processRecordFilter(document);
                this.processCategories(document);
                this.processLogLevels(document);
                this.processLogLevelColors(document);
                this.processLogTableColumns(document);
            }
            catch (Exception exception) {
                System.err.println("Unable process configuration file at " + this.getFilename() + ". Error Message=" + exception.getMessage());
            }
        }
    }

    protected void processRecordFilter(Document document) {
        NodeList nodeList = document.getElementsByTagName(NDCTEXTFILTER);
        Node node = nodeList.item(0);
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getValue(namedNodeMap, NAME);
        if (string == null || string.equals("")) {
            return;
        }
        this._monitor.setNDCLogRecordFilter(string);
    }

    protected void processCategories(Document document) {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        CategoryExplorerModel categoryExplorerModel = categoryExplorerTree.getExplorerModel();
        NodeList nodeList = document.getElementsByTagName(CATEGORY);
        NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
        int n = this.getValue(namedNodeMap, NAME).equalsIgnoreCase(FIRST_CATEGORY_NAME) ? 1 : 0;
        for (int i = nodeList.getLength() - 1; i >= n; --i) {
            Node node = nodeList.item(i);
            namedNodeMap = node.getAttributes();
            CategoryNode categoryNode = categoryExplorerModel.addCategory(new CategoryPath(this.getValue(namedNodeMap, PATH)));
            categoryNode.setSelected(this.getValue(namedNodeMap, SELECTED).equalsIgnoreCase("true"));
            if (this.getValue(namedNodeMap, EXPANDED).equalsIgnoreCase("true")) {
                // empty if block
            }
            categoryExplorerTree.expandPath(categoryExplorerModel.getTreePathToRoot(categoryNode));
        }
    }

    protected void processLogLevels(Document document) {
        NodeList nodeList = document.getElementsByTagName(LEVEL);
        Map map = this._monitor.getLogLevelMenuItems();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = this.getValue(namedNodeMap, NAME);
            try {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)map.get(LogLevel.valueOf(string));
                jCheckBoxMenuItem.setSelected(this.getValue(namedNodeMap, SELECTED).equalsIgnoreCase("true"));
                continue;
            }
            catch (LogLevelFormatException logLevelFormatException) {
                // empty catch block
            }
        }
    }

    protected void processLogLevelColors(Document document) {
        NodeList nodeList = document.getElementsByTagName(COLORLEVEL);
        LogLevel.getLogLevelColorMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) {
                return;
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = this.getValue(namedNodeMap, NAME);
            try {
                LogLevel logLevel = LogLevel.valueOf(string);
                int n = Integer.parseInt(this.getValue(namedNodeMap, RED));
                int n2 = Integer.parseInt(this.getValue(namedNodeMap, GREEN));
                int n3 = Integer.parseInt(this.getValue(namedNodeMap, BLUE));
                Color color = new Color(n, n2, n3);
                if (logLevel == null) continue;
                logLevel.setLogLevelColorMap(logLevel, color);
                continue;
            }
            catch (LogLevelFormatException logLevelFormatException) {
                // empty catch block
            }
        }
    }

    protected void processLogTableColumns(Document document) {
        NodeList nodeList = document.getElementsByTagName(COLUMN);
        Map map = this._monitor.getLogTableColumnMenuItems();
        ArrayList<LogTableColumn> arrayList = new ArrayList<LogTableColumn>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) {
                return;
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = this.getValue(namedNodeMap, NAME);
            try {
                LogTableColumn logTableColumn = LogTableColumn.valueOf(string);
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)map.get(logTableColumn);
                jCheckBoxMenuItem.setSelected(this.getValue(namedNodeMap, SELECTED).equalsIgnoreCase("true"));
                if (jCheckBoxMenuItem.isSelected()) {
                    arrayList.add(logTableColumn);
                }
            }
            catch (LogTableColumnFormatException logTableColumnFormatException) {
                // empty catch block
            }
            if (arrayList.isEmpty()) {
                this._table.setDetailedView();
                continue;
            }
            this._table.setView(arrayList);
        }
    }

    protected String getValue(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        return node.getNodeValue();
    }

    protected void collapseTree() {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        for (int i = categoryExplorerTree.getRowCount() - 1; i > 0; --i) {
            categoryExplorerTree.collapseRow(i);
        }
    }

    protected void selectAllNodes() {
        CategoryExplorerModel categoryExplorerModel = this._monitor.getCategoryExplorerTree().getExplorerModel();
        CategoryNode categoryNode = categoryExplorerModel.getRootCategoryNode();
        Enumeration<TreeNode> enumeration = categoryNode.breadthFirstEnumeration();
        CategoryNode categoryNode2 = null;
        while (enumeration.hasMoreElements()) {
            categoryNode2 = (CategoryNode)enumeration.nextElement();
            categoryNode2.setSelected(true);
        }
    }

    protected void store(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFilename()));
            printWriter.print(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void deleteConfigurationFile() {
        try {
            File file = new File(this.getFilename());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Cannot delete " + this.getFilename() + " because a security violation occured.");
        }
    }

    protected String getFilename() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        return string + string2 + "lf5" + string2 + CONFIG_FILE_NAME;
    }

    private void processConfigurationNode(CategoryNode categoryNode, StringBuffer stringBuffer) {
        CategoryExplorerModel categoryExplorerModel = this._monitor.getCategoryExplorerTree().getExplorerModel();
        Enumeration<TreeNode> enumeration = categoryNode.breadthFirstEnumeration();
        CategoryNode categoryNode2 = null;
        while (enumeration.hasMoreElements()) {
            categoryNode2 = (CategoryNode)enumeration.nextElement();
            this.exportXMLElement(categoryNode2, categoryExplorerModel.getTreePathToRoot(categoryNode2), stringBuffer);
        }
    }

    private void processLogLevels(Map map, StringBuffer stringBuffer) {
        stringBuffer.append("\t<loglevels>\r\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            LogLevel logLevel = (LogLevel)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)map.get(logLevel);
            this.exportLogLevelXMLElement(logLevel.getLabel(), jCheckBoxMenuItem.isSelected(), stringBuffer);
        }
        stringBuffer.append("\t</loglevels>\r\n");
    }

    private void processLogLevelColors(Map map, Map map2, StringBuffer stringBuffer) {
        stringBuffer.append("\t<loglevelcolors>\r\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            LogLevel logLevel = (LogLevel)iterator.next();
            Color color = (Color)map2.get(logLevel);
            this.exportLogLevelColorXMLElement(logLevel.getLabel(), color, stringBuffer);
        }
        stringBuffer.append("\t</loglevelcolors>\r\n");
    }

    private void processLogTableColumns(List list, StringBuffer stringBuffer) {
        stringBuffer.append("\t<logtablecolumns>\r\n");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LogTableColumn logTableColumn = (LogTableColumn)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = this._monitor.getTableColumnMenuItem(logTableColumn);
            this.exportLogTableColumnXMLElement(logTableColumn.getLabel(), jCheckBoxMenuItem.isSelected(), stringBuffer);
        }
        stringBuffer.append("\t</logtablecolumns>\r\n");
    }

    private void processLogRecordFilter(String string, StringBuffer stringBuffer) {
        stringBuffer.append("\t<").append(NDCTEXTFILTER).append(" ");
        stringBuffer.append(NAME).append("=\"").append(string).append("\"");
        stringBuffer.append("/>\r\n");
    }

    private void openXMLDocument(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
    }

    private void openConfigurationXML(StringBuffer stringBuffer) {
        stringBuffer.append("<configuration>\r\n");
    }

    private void closeConfigurationXML(StringBuffer stringBuffer) {
        stringBuffer.append("</configuration>\r\n");
    }

    private void exportXMLElement(CategoryNode categoryNode, TreePath treePath, StringBuffer stringBuffer) {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        stringBuffer.append("\t<").append(CATEGORY).append(" ");
        stringBuffer.append(NAME).append("=\"").append(categoryNode.getTitle()).append("\" ");
        stringBuffer.append(PATH).append("=\"").append(ConfigurationManager.treePathToString(treePath)).append("\" ");
        stringBuffer.append(EXPANDED).append("=\"").append(categoryExplorerTree.isExpanded(treePath)).append("\" ");
        stringBuffer.append(SELECTED).append("=\"").append(categoryNode.isSelected()).append("\"/>\r\n");
    }

    private void exportLogLevelXMLElement(String string, boolean bl, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<").append(LEVEL).append(" ").append(NAME);
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append(SELECTED).append("=\"").append(bl);
        stringBuffer.append("\"/>\r\n");
    }

    private void exportLogLevelColorXMLElement(String string, Color color, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<").append(COLORLEVEL).append(" ").append(NAME);
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append(RED).append("=\"").append(color.getRed()).append("\" ");
        stringBuffer.append(GREEN).append("=\"").append(color.getGreen()).append("\" ");
        stringBuffer.append(BLUE).append("=\"").append(color.getBlue());
        stringBuffer.append("\"/>\r\n");
    }

    private void exportLogTableColumnXMLElement(String string, boolean bl, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<").append(COLUMN).append(" ").append(NAME);
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append(SELECTED).append("=\"").append(bl);
        stringBuffer.append("\"/>\r\n");
    }
}

