/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.PacketFragment;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.media.ts.TransportStreamUtils;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CupertinoTSPacketizer {
    public static final int TS_PACKETLEN = 188;
    public static final int TS_MAXLEN = 32725;
    public static final int TS_MAXLEN_PACKETS = 178;
    public static final int TS_VIDEO_LEN_1ST = 157;
    public static final int TS_VIDEO_LEN = 184;
    public static final int TS_AUDIO_LEN_1ST = 170;
    public static final int TS_AUDIO_LEN = 184;
    public static final int TS_DATA_LEN_1ST = 170;
    public static final int TS_DATA_LEN = 184;
    private int a = 256;
    private int b = 257;
    private int c = 258;
    private byte d = (byte)-32;
    private byte e = (byte)-64;
    private long f = -1L;
    private long g = -1L;
    private long h = -1L;
    private long i = 0L;
    private H264CodecConfigParts j = null;
    private H264CodecConfigInfo k = null;
    private boolean l = false;
    private int m = -1;
    private AACFrame n = null;
    private boolean o = true;

    public void resetCounters() {
        this.f = -1L;
        this.g = -1L;
        this.h = -1L;
        this.i = 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final LiveStreamingCupertinoBlock a(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length > 1) {
            byArray2[1] = 66;
        }
        if (byArray2.length <= 3) return new LiveStreamingCupertinoBlock(byArray2, 0, n2);
        byte by = byArray2[3];
        if (by <= 30) return new LiveStreamingCupertinoBlock(byArray2, 0, n2);
        byArray2[3] = 30;
        return new LiveStreamingCupertinoBlock(byArray2, 0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int a(int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 <= 0) return n2;
        ++n2;
        if ((n3 -= 170) <= 0) return n2;
        return n2 += n3 / 184 + (n3 % 184 <= 0 ? 0 : 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int b(int n) {
        int n2 = n / 32725 * 178;
        int n3 = n % 32725;
        if (n3 <= 0) return n2;
        ++n2;
        if ((n3 -= 157) <= 0) return n2;
        return n2 += n3 / 184 + (n3 % 184 <= 0 ? 0 : 1);
    }

    public byte[] getAudioID3TagHeader(long l) {
        byte[] byArray = BufferUtils.decodeHexString((String)Base64.getChars((String)"7=124;9>;<=>? !\"#$&P\"(,(/%((/0123463789:=?;H9T#W%%\"& (/Y-)/[(svvtvssqy\u007f\u000e}u{\u000bygc\u0017d`bdaio\u001flojni\u0006vptppup|~x}y{\u007fy\u0014dfemc\u0012amnilhkoiD623456789:;<=?7 ( R$", (int)(693 / 202)));
        long l2 = 0x1FFFFFFFFL;
        BufferUtils.longToByteArray((long)(l & l2), (byte[])byArray, (int)(byArray.length - 8), (int)8);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getTSHeader(int n, int n2) {
        int n3;
        int n4;
        int n5;
        byte[] byArray = null;
        try {
            int n6 = 0;
            byArray = new byte[376];
            TransportStreamUtils.fillPAT((byte[])byArray, (int)n6, (long)this.i);
            n5 = TransportStreamUtils.videoCodecToStreamType((int)n);
            n4 = TransportStreamUtils.audioCodecToStreamType((int)n2);
            n3 = this.o ? this.c : -1;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"QfdpdcqwuOOM\u007f|+$6*> 4i/,>\u001b>\")=1<\u00062693mx", (int)(-24 + 74)) + exception.toString());
            return byArray;
        }
        TransportStreamUtils.fillPMT((byte[])byArray, (int)(n6 += 188), (long)this.i, (int)this.a, (int)this.b, (int)n3, (int)n5, (int)n4);
        ++this.i;
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] dataPacketsToMP3(ID3Frames iD3Frames) {
        byte[] byArray = null;
        try {
            if (iD3Frames == null) {
                return byArray;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(FileChunk.toString((int)(838 / 136), (String)"Erxlx\u007feca[CAsp\u007fpb~b|h5x|j~P`ahaquSgDZ86-") + exception.toString());
            return byArray;
        }
        if (iD3Frames.getSize() > 0) return iD3Frames.serialize(true, false, 0);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] audioPacketsToMP3(List<CupertinoPacketHolder> list) {
        byte[] byArray = null;
        try {
            Object object;
            int n = 0;
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                object = cupertinoPacketHolder.getPacket();
                n += object.getSize() - 1;
            }
            if (n <= 0) {
                return byArray;
            }
            byArray = new byte[n];
            int n2 = 0;
            Iterator<CupertinoPacketHolder> iterator = list.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                AMFPacket aMFPacket = ((CupertinoPacketHolder)object).getPacket();
                int n3 = aMFPacket.getSize();
                byte[] byArray2 = aMFPacket.getData();
                System.arraycopy(byArray2, 1, byArray, n2, n3 - 1);
                n2 += n3 - 1;
            }
            return byArray;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(FileChunk.toString((int)(841 / 140), (String)"Erxlx\u007feca[CAsp\u007fpb~b|h5}hzvoQc`o`rt\\fG[?7.") + exception.toString());
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] dataPacketsToAAC(ID3Frames iD3Frames) {
        byte[] byArray = null;
        try {
            if (iD3Frames == null) {
                return byArray;
            }
            if (iD3Frames.getSize() > 0) return iD3Frames.serialize(true, false, 0);
            return byArray;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"Gpvbz}cecY]_qryv`|lrj7~zh|N~cjgwwQiFIJ0+", (int)(286 / 67)) + exception.toString());
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] audioPacketsToAAC(List<CupertinoPacketHolder> list) {
        byte[] byArray = null;
        try {
            WaitingAudio waitingAudio = new WaitingAudio();
            Iterator<CupertinoPacketHolder> iterator = list.iterator();
            while (true) {
                byte[] byArray2;
                int n;
                int n2;
                byte[] byArray3;
                long l;
                if (iterator.hasNext()) {
                    CupertinoPacketHolder cupertinoPacketHolder = iterator.next();
                    AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                    l = cupertinoPacketHolder.getTimecode90();
                    int n3 = aMFPacket.getFirstByte();
                    int n4 = aMFPacket.getSecondByte();
                    byArray3 = aMFPacket.getData();
                    n2 = aMFPacket.getSize();
                    n = FLVUtils.getAudioCodec((int)n3);
                    if (n == 10 && n4 != 1) {
                        if (n4 != 0) continue;
                        this.n = AACUtils.decodeAACCodecConfig((byte[])byArray3, (int)2);
                        continue;
                    }
                    if (n != 10 || this.n == null) continue;
                    this.n.setSize(n2 - 2 + 7);
                    byArray2 = new byte[7];
                    if (this.m >= 0) {
                        this.n.setProfileObjectType(this.m);
                    }
                } else {
                    int n5 = waitingAudio.d;
                    if (n5 <= 0) {
                        return byArray;
                    }
                    byArray = new byte[n5];
                    int n6 = 0;
                    Iterator<PacketFragment> iterator2 = waitingAudio.f.iterator();
                    while (iterator2.hasNext()) {
                        PacketFragment packetFragment = iterator2.next();
                        System.arraycopy(packetFragment.getBuffer(), packetFragment.getOffset(), byArray, n6, packetFragment.getLen());
                        n6 += packetFragment.getLen();
                    }
                    return byArray;
                }
                AACUtils.frameToDTSBuffer((AACFrame)this.n, (byte[])byArray2, (int)0);
                waitingAudio.f.add(new PacketFragment(byArray2, 0, byArray2.length));
                waitingAudio.d += byArray2.length;
                waitingAudio.f.add(new PacketFragment(byArray3, 2, n2 - 2));
                waitingAudio.d += n2 - 2;
                waitingAudio.e = n;
                ++waitingAudio.c;
                if (waitingAudio.a == -1L) {
                    waitingAudio.a = l;
                }
                waitingAudio.b = l;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"\u0014-)?)(400\u0014\u0012\u0012\"'.#3!3/9b,;+9>\u000227>3#+\r5\u001a\u001d\u001ed\u007f", (int)(50 - -37)) + exception.toString());
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int c(int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 <= 0) return n2;
        ++n2;
        if ((n3 -= 170) <= 0) return n2;
        return n2 += n3 / 184 + (n3 % 184 > 0 ? 1 : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] dataPacketsToTS(ID3Frames iD3Frames, long l) {
        byte[] byArray = null;
        try {
            if (iD3Frames == null) {
                return byArray;
            }
            if (iD3Frames.getSize() <= 0) {
                return byArray;
            }
            byte[] byArray2 = iD3Frames.serialize(true, false, 0);
            if (byArray2 == null) {
                return byArray;
            }
            int n = 0;
            int n2 = byArray2.length;
            int n3 = this.c(n2);
            byArray = new byte[n3 * 188];
            boolean bl = false;
            int n4 = 189;
            boolean bl2 = true;
            int n5 = 32725;
            int n6 = 0;
            int n7 = 0;
            do {
                bl2 = true;
                int n8 = 0;
                int n9 = n2 - n;
                if (n9 > n5) {
                    n9 = n5;
                }
                ++n6;
                do {
                    int n10;
                    int n11;
                    int n12 = 0;
                    byArray[n7 + n12] = 71;
                    byArray[n7 + ++n12] = (byte)((bl2 ? 64 : 0) + (0x1F & this.c >> 8));
                    byArray[n7 + ++n12] = (byte)(this.c & 0xFF);
                    this.h = this.h == -1L ? 1L : ++this.h;
                    byArray[n7 + ++n12] = (byte)(16L + (this.h & 0xFL));
                    ++n12;
                    int n13 = 0;
                    if (bl2) {
                        n13 = 9 + (!bl ? 5 : 10);
                    }
                    if ((n11 = 188 - n12 - n13) > n9 - n8) {
                        n11 = n9 - n8;
                    }
                    if (n12 + n11 + n13 < 188) {
                        n10 = 188 - (n12 + n11 + n13);
                        int n14 = n7 + 3;
                        byArray[n14] = (byte)(byArray[n14] | 0x20);
                        if (n10 <= 1) {
                            byArray[n7 + n12] = 0;
                            ++n12;
                        } else {
                            byArray[n7 + n12] = (byte)(--n10 & 0xFF);
                            byArray[n7 + ++n12] = 0;
                            ++n12;
                            if (--n10 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n7 + n12, n10);
                            }
                            n12 += n10;
                        }
                    }
                    if (bl2) {
                        byArray[n7 + n12] = 0;
                        byArray[n7 + ++n12] = 0;
                        byArray[n7 + ++n12] = 1;
                        byArray[n7 + ++n12] = (byte)n4;
                        ++n12;
                        n10 = !bl ? 5 : 10;
                        int n15 = n9 + n10 + 3;
                        if (n15 >= 65536) {
                            System.out.println(Base64.getChars((String)"qihdfdl6-", (int)(55 * 3)) + n15);
                        }
                        BufferUtils.intToByteArray((int)n15, (byte[])byArray, (int)(n7 + n12), (int)2);
                        byArray[n7 + (n12 += 2)] = (byte)(n6 > 1 ? 128 : 132);
                        byArray[n7 + ++n12] = (byte)(bl ? 192 : 128);
                        byArray[n7 + ++n12] = (byte)n10;
                        long l2 = l;
                        byArray[n7 + ++n12 + 4] = (byte)(((l2 & 0x7FL) << 1) + 1L);
                        byArray[n7 + n12 + 3] = (byte)((l2 >>= 7) & 0xFFL);
                        byArray[n7 + n12 + 2] = (byte)((((l2 >>= 8) & 0x7FL) << 1) + 1L);
                        byArray[n7 + n12 + 1] = (byte)((l2 >>= 7) & 0xFFL);
                        byArray[n7 + n12 + 0] = (byte)((((l2 >>= 8) & 7L) << 1) + 1L + (long)(bl ? 48 : 32));
                        n12 += 5;
                    }
                    do {
                        if ((n10 = n11) > n2 - n) {
                            n10 = n2 - n;
                        }
                        System.arraycopy(byArray2, n, byArray, n7 + n12, n10);
                        n11 -= n10;
                    } while ((n12 += n10) < 188 && (n8 += n10) < n9 && (n += n10) < n2);
                    bl2 = false;
                    n7 += 188;
                } while (n8 < n9 && n < n2);
            } while (n < n2);
            return byArray;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"Sdbvfa\u007fywMIK}~uzthxfv+bf|hZjofk{cE}RUV,7", (int)(-22 - -38)) + exception.toString());
            return byArray;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] audioPacketsToTS(List<CupertinoPacketHolder> var1_1) {
        block80: {
            break block80;
lbl1:
            // 3 sources

            return var2_2;
        }
        var2_2 = null;
        try {
            block75: {
                block61: {
                    block57: {
                        block84: {
                            block64: {
                                block82: {
                                    block86: {
                                        block65: {
                                            block68: {
                                                block88: {
                                                    block89: {
                                                        block74: {
                                                            block78: {
                                                                block70: {
                                                                    block79: {
                                                                        block76: {
                                                                            block56: {
                                                                                block87: {
                                                                                    block77: {
                                                                                        block83: {
                                                                                            block59: {
                                                                                                block69: {
                                                                                                    block73: {
                                                                                                        block66: {
                                                                                                            block58: {
                                                                                                                block54: {
                                                                                                                    block72: {
                                                                                                                        block71: {
                                                                                                                            block50: {
                                                                                                                                block46: {
                                                                                                                                    block85: {
                                                                                                                                        block67: {
                                                                                                                                            block60: {
                                                                                                                                                block47: {
                                                                                                                                                    block62: {
                                                                                                                                                        block55: {
                                                                                                                                                            block45: {
                                                                                                                                                                block48: {
                                                                                                                                                                    block49: {
                                                                                                                                                                        block63: {
                                                                                                                                                                            block52: {
                                                                                                                                                                                block53: {
                                                                                                                                                                                    block51: {
                                                                                                                                                                                        block81: {
                                                                                                                                                                                            var3_3 = new WaitingAudio();
                                                                                                                                                                                            var4_5 = true;
                                                                                                                                                                                            var5_6 = var1_1.iterator();
                                                                                                                                                                                            break block81;
lbl10:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                var3_3.a = var8_11;
                                                                                                                                                                                                break block45;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
lbl13:
                                                                                                                                                                                            // 2 sources

                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                var25_30 = 188 - var23_28 - var24_29;
                                                                                                                                                                                                if (var25_30 <= var6_8 - var15_18) break block46;
                                                                                                                                                                                                break block47;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                        }
lbl18:
                                                                                                                                                                                        // 6 sources

                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            if (!var5_6.hasNext()) break block48;
                                                                                                                                                                                            break block49;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
lbl21:
                                                                                                                                                                                        // 2 sources

                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            var2_2[var22_27 + var23_28] = (byte)v0;
                                                                                                                                                                                            var28_33 = var7_10;
                                                                                                                                                                                            var30_34 = BufferUtils.longToByteArray((long)(var28_33 <<= 7));
                                                                                                                                                                                            var2_2[var22_27 + ++var23_28 + 4] = (byte)((var30_34[7] & 128) + 126);
                                                                                                                                                                                            var2_2[var22_27 + var23_28 + 3] = (byte)(var30_34[6] & 255);
                                                                                                                                                                                            var2_2[var22_27 + var23_28 + 2] = (byte)(var30_34[5] & 255);
                                                                                                                                                                                            var2_2[var22_27 + var23_28 + 1] = (byte)(var30_34[4] & 255);
                                                                                                                                                                                            var2_2[var22_27 + var23_28 + 0] = (byte)(var30_34[3] & 255);
                                                                                                                                                                                            var23_28 += 6;
                                                                                                                                                                                            if (var27_32 <= 0) ** GOTO lbl13
                                                                                                                                                                                            break block50;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            if (var14_17 != 2) ** GOTO lbl18
                                                                                                                                                                                            break block51;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
lbl36:
                                                                                                                                                                                        // 3 sources

                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            if (var23_28 < 188) break block52;
                                                                                                                                                                                            break block53;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
lbl39:
                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            if (this.n != null) break block54;
                                                                                                                                                                                            ** GOTO lbl18
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
lbl42:
                                                                                                                                                                                        // 2 sources

                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            var2_2[var22_27 + var23_28] = (byte)(v1 + (31 & this.b >> 8));
                                                                                                                                                                                            var2_2[var22_27 + ++var23_28] = (byte)(this.b & 255);
                                                                                                                                                                                            ++var23_28;
                                                                                                                                                                                            if (this.g != -1L) break block55;
                                                                                                                                                                                            break block56;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    var15_18 = 1;
                                                                                                                                                                                    var3_3.f.add(new PacketFragment(var12_14, var15_18, var13_16 - var15_18));
                                                                                                                                                                                    var3_3.d += var13_16 - var15_18;
                                                                                                                                                                                    var3_3.e = var14_17;
                                                                                                                                                                                    ++var3_3.c;
                                                                                                                                                                                    if (var3_3.a != -1L) break block45;
                                                                                                                                                                                    ** continue;
lbl57:
                                                                                                                                                                                    // 2 sources

                                                                                                                                                                                    while (true) {
                                                                                                                                                                                        AACUtils.frameToDTSBuffer((AACFrame)this.n, (byte[])var15_19, (int)0);
                                                                                                                                                                                        var3_3.f.add(new PacketFragment(var15_19, 0, var15_19.length));
                                                                                                                                                                                        var3_3.d += var15_19.length;
                                                                                                                                                                                        var3_3.f.add(new PacketFragment(var12_14, 2, var13_16 - 2));
                                                                                                                                                                                        var3_3.d += var13_16 - 2;
                                                                                                                                                                                        var3_3.e = var14_17;
                                                                                                                                                                                        ++var3_3.c;
                                                                                                                                                                                        if (var3_3.a != -1L) break block57;
                                                                                                                                                                                        break block58;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
lbl69:
                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                    while (true) {
                                                                                                                                                                                        v1 = 64;
                                                                                                                                                                                        ** GOTO lbl42
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
lbl72:
                                                                                                                                                                                    // 4 sources

                                                                                                                                                                                    while (true) {
                                                                                                                                                                                        var26_31 = var25_30;
                                                                                                                                                                                        if (var26_31 <= var19_24 - var17_22) break block59;
                                                                                                                                                                                        break block60;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
lbl76:
                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                    while (true) {
                                                                                                                                                                                        v2 = var22_27 + 3;
                                                                                                                                                                                        var2_2[v2] = (byte)(var2_2[v2] | 32);
                                                                                                                                                                                        var26_31 = 8;
                                                                                                                                                                                        var25_30 = 188 - var23_28 - var24_29 - var26_31;
                                                                                                                                                                                        if (var25_30 <= var6_8 - var15_18) break block61;
                                                                                                                                                                                        break block62;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
lbl83:
                                                                                                                                                                                    // 2 sources

                                                                                                                                                                                    while (var12_15) {
                                                                                                                                                                                        ** continue;
lbl85:
                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                        ** GOTO lbl76
                                                                                                                                                                                    }
                                                                                                                                                                                    break block82;
                                                                                                                                                                                }
lbl88:
                                                                                                                                                                                // 2 sources

                                                                                                                                                                                while (true) {
                                                                                                                                                                                    var21_26 = false;
                                                                                                                                                                                    var13_16 = 0;
                                                                                                                                                                                    var22_27 += 188;
                                                                                                                                                                                    if (var15_18 < var6_8) break block63;
                                                                                                                                                                                    ** GOTO lbl1
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    v3 = 32;
                                                                                                                                                                                    break block64;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
lbl97:
                                                                                                                                                                                // 1 sources

                                                                                                                                                                                while (true) {
                                                                                                                                                                                    var25_30 = var6_8 - var15_18;
                                                                                                                                                                                    ** GOTO lbl83
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            if (var15_18 < var6_8) ** GOTO lbl72
                                                                                                                                                                            ** continue;
                                                                                                                                                                        }
lbl104:
                                                                                                                                                                        // 2 sources

                                                                                                                                                                        while (true) {
                                                                                                                                                                            var23_28 = 0;
                                                                                                                                                                            var2_2[var22_27 + var23_28] = 71;
                                                                                                                                                                            ++var23_28;
                                                                                                                                                                            if (var21_26) {
                                                                                                                                                                                ** continue;
                                                                                                                                                                            }
                                                                                                                                                                            break block65;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    var6_7 = var5_6.next();
                                                                                                                                                                    var7_9 = var6_7.getPacket();
                                                                                                                                                                    var8_11 = var6_7.getTimecode90();
                                                                                                                                                                    var10_12 = var7_9.getFirstByte();
                                                                                                                                                                    var11_13 = var7_9.getSecondByte();
                                                                                                                                                                    var12_14 = var7_9.getData();
                                                                                                                                                                    var13_16 = var7_9.getSize();
                                                                                                                                                                    var14_17 = FLVUtils.getAudioCodec((int)var10_12);
                                                                                                                                                                    if (var14_17 != 10) break block83;
                                                                                                                                                                    break block84;
                                                                                                                                                                }
                                                                                                                                                                var6_8 = var3_3.d;
                                                                                                                                                                if (var6_8 > 0) break block85;
                                                                                                                                                                ** GOTO lbl1
                                                                                                                                                            }
                                                                                                                                                            var3_3.b = var8_11;
                                                                                                                                                            break block86;
lbl129:
                                                                                                                                                            // 1 sources

                                                                                                                                                            while (true) {
                                                                                                                                                                var28_33 = var7_10;
                                                                                                                                                                var2_2[var22_27 + var23_28 + 4] = (byte)(((var28_33 & 127L) << 1) + 1L);
                                                                                                                                                                var2_2[var22_27 + var23_28 + 3] = (byte)((var28_33 >>= 7) & 255L);
                                                                                                                                                                var2_2[var22_27 + var23_28 + 2] = (byte)((((var28_33 >>= 8) & 127L) << 1) + 1L);
                                                                                                                                                                var2_2[var22_27 + var23_28 + 1] = (byte)((var28_33 >>= 7) & 255L);
                                                                                                                                                                var28_33 >>= 8;
                                                                                                                                                                if (var11_13 == 0) break block66;
                                                                                                                                                                break block67;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        ++this.g;
                                                                                                                                                        break block87;
lbl141:
                                                                                                                                                        // 2 sources

                                                                                                                                                        while (true) {
                                                                                                                                                            var2_2[var22_27 + var23_28 + 0] = (byte)(((var28_33 & 7L) << 1) + 1L + (long)v4);
                                                                                                                                                            var23_28 += 5;
                                                                                                                                                            ** GOTO lbl72
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    var25_30 = var6_8 - var15_18;
                                                                                                                                                    break block61;
                                                                                                                                                    while (true) {
                                                                                                                                                        v5 = 5;
                                                                                                                                                        break block68;
                                                                                                                                                        break;
                                                                                                                                                    }
lbl151:
                                                                                                                                                    // 1 sources

                                                                                                                                                    while (true) {
                                                                                                                                                        var17_22 = 0;
                                                                                                                                                        if (var3_3.f.size() <= 0) ** GOTO lbl36
                                                                                                                                                        break block69;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                var25_30 = var6_8 - var15_18;
                                                                                                                                                break block46;
                                                                                                                                            }
                                                                                                                                            var26_31 = var19_24 - var17_22;
                                                                                                                                            break block59;
lbl161:
                                                                                                                                            // 1 sources

                                                                                                                                            while (true) {
                                                                                                                                                this.n.setSize(var13_16 - 2 + 7);
                                                                                                                                                var15_19 = new byte[7];
                                                                                                                                                if (this.m < 0) ** GOTO lbl57
                                                                                                                                                break block70;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        v4 = 16;
                                                                                                                                        ** GOTO lbl141
                                                                                                                                    }
                                                                                                                                    var9_20 = var7_10 = var3_3.a;
                                                                                                                                    var11_13 = 0;
                                                                                                                                    var12_15 = false;
                                                                                                                                    var13_16 = 0;
                                                                                                                                    var14_17 = this.a(var6_8);
                                                                                                                                    var2_2 = new byte[var14_17 * 188];
                                                                                                                                    var15_18 = 0;
                                                                                                                                    var16_21 = var3_3.f.remove(0);
                                                                                                                                    var17_22 = 0;
                                                                                                                                    var18_23 = var16_21.getOffset();
                                                                                                                                    var19_24 = var16_21.getLen();
                                                                                                                                    var20_25 = var16_21.getBuffer();
                                                                                                                                    var21_26 = true;
                                                                                                                                    var22_27 = 0;
                                                                                                                                    ** continue;
                                                                                                                                    while (true) {
                                                                                                                                        v6 = 5;
                                                                                                                                        break block71;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    while (true) {
                                                                                                                                        v7 = 128;
                                                                                                                                        break block72;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                }
lbl192:
                                                                                                                                // 4 sources

                                                                                                                                while (true) {
                                                                                                                                    if (!var21_26) ** GOTO lbl72
                                                                                                                                    break block73;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            System.arraycopy(RTPMPEGTSFill.FILL, 0, var2_2, var22_27 + var23_28, var27_32);
                                                                                                                            var23_28 += var27_32;
                                                                                                                            ** continue;
                                                                                                                        }
lbl200:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            var24_29 = 9 + v6;
                                                                                                                            break block74;
                                                                                                                            break;
                                                                                                                        }
lbl203:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            var26_31 = 188 - (var23_28 + var25_30 + var24_29);
                                                                                                                            v8 = var22_27 + 3;
                                                                                                                            var2_2[v8] = (byte)(var2_2[v8] | 32);
                                                                                                                            if (var26_31 <= 1) break block75;
                                                                                                                            break block76;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                    }
lbl210:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        var2_2[var22_27 + var23_28] = (byte)v7;
                                                                                                                        var2_2[var22_27 + ++var23_28] = (byte)var26_31;
                                                                                                                        var28_33 = var9_20;
                                                                                                                        var2_2[var22_27 + ++var23_28 + 4] = (byte)(((var28_33 & 127L) << 1) + 1L);
                                                                                                                        var2_2[var22_27 + var23_28 + 3] = (byte)((var28_33 >>= 7) & 255L);
                                                                                                                        var2_2[var22_27 + var23_28 + 2] = (byte)((((var28_33 >>= 8) & 127L) << 1) + 1L);
                                                                                                                        var2_2[var22_27 + var23_28 + 1] = (byte)((var28_33 >>= 7) & 255L);
                                                                                                                        var28_33 >>= 8;
                                                                                                                        if (var11_13 == 0) ** continue;
                                                                                                                        break block77;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                while (true) {
                                                                                                                    if (var14_17 != 10) ** continue;
                                                                                                                    ** continue;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var3_3.a = var8_11;
                                                                                                            break block57;
lbl228:
                                                                                                            // 1 sources

                                                                                                            while (true) {
                                                                                                                System.arraycopy(RTPMPEGTSFill.FILL, 0, var2_2, var22_27 + var23_28, var26_31);
                                                                                                                break block78;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        v4 = 32;
                                                                                                        ** continue;
                                                                                                    }
                                                                                                    var2_2[var22_27 + var23_28] = 0;
                                                                                                    var2_2[var22_27 + ++var23_28] = 0;
                                                                                                    var2_2[var22_27 + ++var23_28] = 1;
                                                                                                    var2_2[var22_27 + ++var23_28] = this.e;
                                                                                                    ++var23_28;
                                                                                                    if (var11_13 == 0) ** continue;
                                                                                                    break block88;
                                                                                                }
                                                                                                var16_21 = var3_3.f.remove(0);
                                                                                                var18_23 = var16_21.getOffset();
                                                                                                var19_24 = var16_21.getLen();
                                                                                                var20_25 = var16_21.getBuffer();
                                                                                                ** GOTO lbl36
lbl248:
                                                                                                // 1 sources

                                                                                                while (true) {
                                                                                                    this.n = AACUtils.decodeAACCodecConfig((byte[])var12_14, (int)2);
                                                                                                    ** GOTO lbl18
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            System.arraycopy(var20_25, var18_23 + var17_22, var2_2, var22_27 + var23_28, var26_31);
                                                                                            var23_28 += var26_31;
                                                                                            var15_18 += var26_31;
                                                                                            var25_30 -= var26_31;
                                                                                            if ((var17_22 += var26_31) >= var19_24) ** break;
                                                                                            ** continue;
                                                                                            ** continue;
lbl259:
                                                                                            // 1 sources

                                                                                            while (true) {
                                                                                                v7 = 192;
                                                                                                ** continue;
                                                                                                break;
                                                                                            }
                                                                                            while (true) {
                                                                                                v0 = 16;
                                                                                                ** GOTO lbl21
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        while (true) {
                                                                                            if (var14_17 != 10) ** continue;
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    v3 = 48;
                                                                                    break block64;
                                                                                }
lbl273:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    var2_2[var22_27 + var23_28] = (byte)(16L + (this.g & 15L));
                                                                                    ++var23_28;
                                                                                    var24_29 = 0;
                                                                                    if (!var21_26) break block74;
                                                                                    break block79;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            this.g = 1L;
                                                                            ** continue;
lbl282:
                                                                            // 1 sources

                                                                            while (true) {
                                                                                v0 = 144;
                                                                                ** continue;
                                                                                break;
                                                                            }
lbl285:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                var2_2[var22_27 + var23_28] = (byte)(var26_31 - 1 + var27_32 & 255);
                                                                                ++var23_28;
                                                                                if (var13_16 == 0) ** continue;
                                                                                ** continue;
                                                                                break;
                                                                            }
lbl290:
                                                                            // 1 sources

                                                                            while (true) {
                                                                                var27_32 = 0;
                                                                                ** GOTO lbl285
                                                                                break;
                                                                            }
                                                                        }
                                                                        var2_2[var22_27 + var23_28] = (byte)(--var26_31 & 255);
                                                                        var2_2[var22_27 + ++var23_28] = 0;
                                                                        ++var23_28;
                                                                        if (--var26_31 > 0) {
                                                                            ** continue;
                                                                        }
                                                                        break block78;
                                                                    }
                                                                    if (var11_13 == 0) ** continue;
                                                                    break block89;
                                                                }
                                                                this.n.setProfileObjectType(this.m);
                                                                ** continue;
                                                            }
                                                            var23_28 += var26_31;
                                                            ** GOTO lbl192
                                                        }
                                                        if ((var25_30 = 188 - var23_28 - var24_29) <= var6_8 - var15_18) ** GOTO lbl83
                                                        ** continue;
                                                    }
                                                    v6 = 10;
                                                    ** continue;
                                                }
                                                v5 = 10;
                                            }
                                            var26_31 = v5;
                                            var27_32 = var6_8 + var26_31 + 3;
                                            BufferUtils.intToByteArray((int)var27_32, (byte[])var2_2, (int)(var22_27 + var23_28), (int)2);
                                            var2_2[var22_27 + (var23_28 += 2)] = -128;
                                            ++var23_28;
                                            if (var11_13 == 0) ** continue;
                                            ** continue;
lbl325:
                                            // 1 sources

                                            while (true) {
                                                if (var11_13 != 0) ** GOTO lbl18
                                                ** continue;
                                                break;
                                            }
                                        }
                                        v1 = 0;
                                        ** continue;
                                    }
lbl332:
                                    // 2 sources

                                    while (true) {
                                        var4_5 = false;
                                        ** continue;
                                        break;
                                    }
                                }
                                if (var23_28 + var25_30 + var24_29 >= 188) ** GOTO lbl192
                                ** continue;
                            }
                            var2_2[var22_27 + var23_28 + 0] = (byte)(((var28_33 & 7L) << 1) + 1L + (long)v3);
                            var23_28 += 5;
                            if (var11_13 != 0) ** break;
                            ** continue;
                            ** continue;
                        }
                        if (var11_13 == 1) ** continue;
                        ** continue;
                    }
                    var3_3.b = var8_11;
                    ** continue;
                }
                if ((var27_32 = 188 - (var23_28 + var25_30 + var24_29 + var26_31)) < 0) ** break;
                ** continue;
                ** continue;
            }
            var2_2[var22_27 + var23_28] = 0;
            ++var23_28;
            ** continue;
        }
        catch (Exception var3_4) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"\u0011&$0$#175\u000f\u000f\r?<+$6*> 4i)<.\"#\u001d/,;4& \u0000:\u0002\u0004by", (int)(11 + 71)) + var3_4.toString());
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] videoPacketToTS(CupertinoPacketHolder cupertinoPacketHolder) {
        byte[] byArray = null;
        try {
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            boolean bl;
            boolean bl2;
            int n5;
            int n6;
            ArrayList<PacketFragment> arrayList;
            boolean bl3;
            long l;
            long l2;
            block42: {
                AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                long l3 = cupertinoPacketHolder.getTimecode90();
                if (aMFPacket.getSize() < 2) {
                    return byArray;
                }
                int n7 = aMFPacket.getFirstByte();
                int n8 = aMFPacket.getSecondByte();
                int n9 = FLVUtils.getVideoCodec((int)n7);
                byte[] byArray2 = aMFPacket.getData();
                int n10 = aMFPacket.getSize();
                if (n9 == 7 && n8 != 1) {
                    return byArray;
                }
                if (n9 != 7) {
                    return byArray;
                }
                int n11 = FLVUtils.getVideoTimecodeOffset((byte[])byArray2) * 90;
                l2 = l3;
                l = l2 + (long)n11;
                bl3 = true;
                arrayList = new ArrayList<PacketFragment>();
                byte[] byArray3 = new byte[4];
                byArray3[3] = 1;
                int n12 = 4;
                if (this.k != null) {
                    n12 = this.k.nalUnitLen;
                }
                n6 = 0;
                n5 = 0;
                int n13 = 5;
                bl2 = false;
                bl = false;
                boolean bl4 = false;
                while (n13 + n12 <= n10 && (n4 = BufferUtils.byteArrayToInt((byte[])byArray2, (int)n13, (int)n12)) > 0 && (n13 += n12) + n4 <= n10) {
                    n3 = byArray2[n13] & 0x1F;
                    if (n3 == 7) {
                        bl2 = true;
                    } else if (n3 == 8) {
                        bl = true;
                    } else if (n3 == 9) {
                        bl4 = true;
                    }
                    arrayList.add(new PacketFragment(byArray3, 0, byArray3.length));
                    byte[] byArray4 = byArray2;
                    int n14 = n13;
                    int n15 = n4;
                    if (n3 == 7 && this.l) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = this.a(byArray4, n14, n15);
                        byArray4 = liveStreamingCupertinoBlock.a;
                        n14 = liveStreamingCupertinoBlock.b;
                        n15 = liveStreamingCupertinoBlock.c;
                    }
                    arrayList.add(new PacketFragment(byArray4, n14, n15));
                    n6 += n4 + byArray3.length;
                    ++n5;
                    if ((n13 += n4) < n10) continue;
                }
                n4 = 0;
                n3 = FLVUtils.getFrameType((int)n7);
                n2 = 0;
                if (!bl4) {
                    if (!bl4) {
                        object = new byte[6];
                        object[3] = 1;
                        object[4] = 9;
                        object[5] = n3 == 1 ? 16 : (n3 == 3 ? 80 : 48);
                    }
                } else {
                    n2 = 2;
                }
                break block42;
                arrayList.add(n2, new PacketFragment((byte[])object, 0, ((byte[])object).length));
                ++n2;
                n6 += ((Object)object).length;
                ++n5;
                n4 = 1;
            }
            if (!(n3 != 1 || bl && bl2)) {
                if (n3 == 1 && !bl2 && this.j != null && this.j.sps != null) {
                    object = new byte[4];
                    object[3] = 1;
                    arrayList.add(n2, new PacketFragment((byte[])object, 0, ((Object)object).length));
                    ++n2;
                    byte[] byArray5 = this.j.sps;
                    int n16 = 0;
                    n = this.j.sps.length;
                    if (this.l) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = this.a(byArray5, n16, n);
                        byArray5 = liveStreamingCupertinoBlock.a;
                        n16 = liveStreamingCupertinoBlock.b;
                        n = liveStreamingCupertinoBlock.c;
                    }
                    arrayList.add(n2, new PacketFragment(byArray5, n16, n));
                    ++n2;
                    n6 += this.j.sps.length + ((Object)object).length;
                    ++n5;
                    n4 = 1;
                }
                if (n3 == 1 && !bl && this.j != null && this.j.ppss != null) {
                    object = this.j.ppss.iterator();
                    while (object.hasNext()) {
                        byte[] byArray6 = (byte[])object.next();
                        byte[] byArray7 = new byte[4];
                        byArray7[3] = 1;
                        arrayList.add(n2, new PacketFragment(byArray7, 0, byArray7.length));
                        arrayList.add(++n2, new PacketFragment(byArray6, 0, byArray6.length));
                        ++n2;
                        n6 += byArray6.length + byArray7.length;
                        ++n5;
                        n4 = 1;
                    }
                }
            }
            if (n5 <= 0) {
                return byArray;
            }
            int n17 = this.b(n6);
            byArray = new byte[n17 * 188];
            int n18 = 0;
            PacketFragment packetFragment = (PacketFragment)arrayList.remove(0);
            n = 0;
            int n19 = packetFragment.getOffset();
            int n20 = packetFragment.getLen();
            byte[] byArray8 = packetFragment.getBuffer();
            long l4 = l2;
            int n21 = 32725;
            int n22 = 0;
            boolean bl5 = false;
            int n23 = 0;
            do {
                boolean bl6 = true;
                boolean bl7 = true;
                int n24 = 0;
                int n25 = n6 - n18;
                if (n25 > n21) {
                    n25 = n21;
                }
                ++n23;
                do {
                    long l5;
                    int n26;
                    int n27;
                    int n28;
                    int n29;
                    block41: {
                        n29 = 0;
                        byArray[n22 + n29] = 71;
                        byArray[n22 + ++n29] = (byte)((bl6 ? 64 : 0) + (0x1F & this.a >> 8));
                        byArray[n22 + ++n29] = (byte)(this.a & 0xFF);
                        this.f = this.f == -1L ? 1L : ++this.f;
                        byArray[n22 + ++n29] = (byte)(16L + (this.f & 0xFL));
                        ++n29;
                        int n30 = 0;
                        if (bl6) {
                            n30 = 9 + (bl3 ? 10 : 5);
                        }
                        if ((n28 = 188 - n29 - n30) > n25 - n24) {
                            n28 = n25 - n24;
                        }
                        if (bl7) {
                            int n31 = n22 + 3;
                            byArray[n31] = (byte)(byArray[n31] | 0x20);
                            n27 = 8;
                            n28 = 188 - n29 - n30 - n27;
                            if (n28 > n25 - n24) {
                                n28 = n25 - n24;
                            }
                            n26 = 0;
                            if (n29 + n28 + n30 + n27 < 188) {
                                n26 = 188 - (n29 + n28 + n30 + n27);
                            }
                            byArray[n22 + n29] = (byte)(n27 - 1 + n26 & 0xFF);
                        }
                        if (n29 + n28 + n30 < 188) {
                            n27 = 188 - (n29 + n28 + n30);
                            int n32 = n22 + 3;
                            byArray[n32] = (byte)(byArray[n32] | 0x20);
                            if (n27 <= 1) {
                                byArray[n22 + n29] = 0;
                                ++n29;
                                break block41;
                            } else {
                                byArray[n22 + n29] = (byte)(--n27 & 0xFF);
                                byArray[n22 + ++n29] = 0;
                                ++n29;
                                if (--n27 > 0) {
                                    System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n22 + n29, n27);
                                }
                                n29 += n27;
                            }
                        }
                        break block41;
                        byArray[n22 + ++n29] = (byte)((bl5 ? 144 : 16) | (n3 == 1 ? 64 : 0));
                        l5 = l4;
                        byte[] byArray9 = BufferUtils.longToByteArray((long)(l5 <<= 7));
                        byArray[n22 + ++n29 + 4] = (byte)((byArray9[7] & 0x80) + 126);
                        byArray[n22 + n29 + 3] = (byte)(byArray9[6] & 0xFF);
                        byArray[n22 + n29 + 2] = (byte)(byArray9[5] & 0xFF);
                        byArray[n22 + n29 + 1] = (byte)(byArray9[4] & 0xFF);
                        byArray[n22 + n29 + 0] = (byte)(byArray9[3] & 0xFF);
                        n29 += 6;
                        if (n26 > 0) {
                            System.arraycopy(RTPMPEGTSFill.FILL, 0, byArray, n22 + n29, n26);
                            n29 += n26;
                        }
                        if ((n28 = 188 - n29 - n30) > n25 - n24) {
                            n28 = n25 - n24;
                        }
                        bl7 = false;
                    }
                    if (bl6) {
                        byArray[n22 + n29] = 0;
                        byArray[n22 + ++n29] = 0;
                        byArray[n22 + ++n29] = 1;
                        byArray[n22 + ++n29] = this.d;
                        ++n29;
                        n27 = !bl3 ? 5 : 10;
                        n26 = n25 + n27 + 3;
                        if (n26 >= 65536) {
                            System.out.println(Base64.getChars((String)"wkjjhfn0+", (int)(602 / 176)) + n26);
                        }
                        BufferUtils.intToByteArray((int)n26, (byte[])byArray, (int)(n22 + n29), (int)2);
                        byArray[n22 + (n29 += 2)] = (byte)(n23 > 1 ? 128 : 132);
                        byArray[n22 + ++n29] = (byte)(bl3 ? 192 : 128);
                        byArray[n22 + ++n29] = (byte)n27;
                        l5 = l;
                        byArray[n22 + ++n29 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                        byArray[n22 + n29 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                        byArray[n22 + n29 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                        byArray[n22 + n29 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                        byArray[n22 + n29 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                        n29 += 5;
                        if (bl3) {
                            l5 = l2;
                            byArray[n22 + n29 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                            byArray[n22 + n29 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                            byArray[n22 + n29 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                            byArray[n22 + n29 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                            byArray[n22 + n29 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                            n29 += 5;
                        }
                    }
                    do {
                        if ((n27 = n28) > n20 - n) {
                            n27 = n20 - n;
                        }
                        System.arraycopy(byArray8, n19 + n, byArray, n22 + n29, n27);
                        n29 += n27;
                        n18 += n27;
                        n28 -= n27;
                        n24 += n27;
                        if ((n += n27) < n20) continue;
                        n = 0;
                        if (arrayList.size() <= 0) continue;
                        packetFragment = (PacketFragment)arrayList.remove(0);
                        n19 = packetFragment.getOffset();
                        n20 = packetFragment.getLen();
                        byArray8 = packetFragment.getBuffer();
                    } while (n29 < 188 && n24 < n25 && n18 < n6);
                    bl6 = false;
                    bl5 = false;
                    n22 += 188;
                } while (n24 < n25 && n18 < n6);
            } while (n18 < n6);
            return byArray;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(FileChunk.toString((int)(65 + 22), (String)"\u0014-)?)(400\u0014\u0012\u0012\"'.#3!3/9b;'+5>\u000227>3#\f6\u000e\bf}") + exception.toString());
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void audioCodecConfigIngest(AMFPacket aMFPacket) {
        try {
            if (aMFPacket.getSize() < 2) {
                return;
            }
            int n = aMFPacket.getFirstByte();
            int n2 = aMFPacket.getSecondByte();
            int n3 = FLVUtils.getAudioCodec((int)n);
            byte[] byArray = aMFPacket.getData();
            int n4 = aMFPacket.getSize();
            if (n3 != 10) return;
            if (n2 == 1) return;
            if (n2 != 0) return;
            this.n = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)2);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"\u001e+/%36***\u0012\u0014\u0018() )9'55#|2!1?8\u001b6>>?\u001e11fheJjbct|3*", (int)(43 * 23)) + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void videoCodecConfigIngest(AMFPacket aMFPacket) {
        try {
            if (aMFPacket.getSize() < 2) {
                return;
            }
            int n = aMFPacket.getFirstByte();
            int n2 = aMFPacket.getSecondByte();
            int n3 = FLVUtils.getVideoCodec((int)n);
            byte[] byArray = aMFPacket.getData();
            int n4 = aMFPacket.getSize();
            if (n3 != 7) return;
            if (n2 == 1) return;
            if (n2 != 0) return;
            this.j = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n4 - 5));
            this.k = H264Utils.decodeAVCC((byte[])byArray, (int)5);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoTSPacketizer.class).error(Base64.getChars((String)"\u000637-;>\"\"\"\u001a\u001c\u00000181!?-=+t-59;0CnffgFiin`mBbjk|d+2", (int)(13 * 57)) + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public boolean isForceH264BaselineProfile() {
        return this.l;
    }

    public void setForceH264BaselineProfile(boolean bl) {
        this.l = bl;
    }

    public int getForceAACProfile() {
        return this.m;
    }

    public void setForceAACProfile(int n) {
        this.m = n;
    }

    public boolean isEnableDataEvents() {
        return this.o;
    }

    public void setEnableDataEvents(boolean bl) {
        this.o = bl;
    }

    class WaitingAudio {
        long a = -1L;
        long b = -1L;
        int c = 0;
        int d = 0;
        int e = 0;
        List<PacketFragment> f = new ArrayList<PacketFragment>();

        WaitingAudio() {
        }

        public void clear() {
            this.a = -1L;
            this.b = -1L;
            this.c = 0;
            this.d = 0;
            this.f.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEmpty() {
            if (this.d != 0) return false;
            return true;
        }

        public int size() {
            return this.size();
        }
    }
}

