/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String EXTXVERSIONPLACEHOLDER = "{ext-x-version}";
    public static final String EXTXVERSIONSTR = "#EXT-X-VERSION:{ext-x-version}";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYSTR_NODVR_PLACHOLDER = "{query_no_dvr}";
    public static final String RESOLUTIONPLACEHOLDER = "{resolution}";
    public static final String RESOLUTIONWIDTHPLACEHOLDER = "{resolution-width}";
    public static final String RESOLUTIONHEIGHTPLACEHOLDER = "{resolution-height}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String PLAYSTARTNAME = "{playStartName}";
    public static final String PLAYSTARTVALUE = "{playStartValue}";
    public static final String PLAYSTARTPLACHOLDER = "{playStartName}={playStartValue}";
    public static final String PLAYDURATIONNAME = "{playDurationName}";
    public static final String PLAYDURATIONVALUE = "{playDurationValue}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDurationName}={playDurationValue}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCIVPLACEHOLDER = "{encIV}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String ENCKEYSTRWITHIV = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\",IV=\"{encIV}\"";
    public static final String DISCONTINUITYSTR = "#EXT-X-DISCONTINUITY";
    public static final String RESOLUTIONSTR = ",RESOLUTION={resolution-width}x{resolution-height}";
    public static final String MEDIANAMEPLACEHOLDER = "{mediaName}";
    public static final String BITRATEPLACEHOLDER = "{bitrate}";
    public static final String FILENAMEPATTERN = "{mediaName}{bitrate}_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";
    public static final String DEFAULT_MEDIANAME = "media";
    public static final String DEFAULT_CHUNKLISTNAME = "chunklist";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.toString((int)(1097 / 220), (String)"*qu");
        switch (n) {
            case 2: {
                string = Base64.getChars((String)"'g{?", (int)(33 * 9));
            }
            default: {
                return string;
            }
            case 3: 
        }
        return Base64.getChars((String)"3\u007f~#", (int)(63 * 3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingCupertinoBlock> arrayList;
        List<LiveStreamingCupertinoBlock> list;
        Cipher cipher;
        if (cupertinoEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info(Base64.getChars((String)"IoqmZ~yilc_qryv`|lrjZokyojvnn,ehpuoXhi`iy}50pvwVzcy{`Yzoirz\u0013$!66,2>\u0018;%=%)+=jq", (int)(834 / 149)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), Base64.getChars((String)"JI^", (int)(37 - -6)));
            long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(FileChunk.toString((int)(79 + 46), (String)"\u001c\u001b\f/B@@+UMD[>Zjhigaw"), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerCupertinoChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.getChars((String)"Ge{k\\dcwryEwts|nrfxl\\uqgqplhh]}cg\u007f#kasckc`V~bvr ;]XM2qszc!+%519>\"##to", (int)(-15 - -26)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(n);
            n4 += liveStreamingCupertinoBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingCupertinoBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.getChars((String)"u78'", (int)(13 - 18)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(Base64.getChars((String)"(,3", (int)(11 * 55)));
            if (string3 != null || (string3 = (String)object.get(Base64.getChars((String)" $>", (int)(14 + 103)))) != null || (string3 = (String)object.get(FileChunk.toString((int)(26 - 46), (String)"/8>*\"%;=;&\"%=8722:s>er31<(sud"))) != null || (string3 = (String)object.get(FileChunk.toString((int)(488 / 154), (String)"`qucu|`dd\u007fy|jq|{}s8wrk((#1hlv"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.getChars((String)"2?\"", (int)(59 - -62)))) != null || (string2 = (String)object.get(Base64.getChars((String)"bwsawrnffy\u007f~hoby\u007fu>upe&*!7pyd", (int)(40 - 7)))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.getChars((String)"[qo\u007fHho{~-\u0011# / 2.2,8\b9=+=$8<<z<8>,cz\u00109$~3%/%7,e/)+&89).:ap\u001c'  u42xhl{>$*:s!*06%eoi{khxh||91~|zr6L", (int)(11 * 5)) + file + FileChunk.toString((int)(41 * 33), (String)"\u0014pk") + string2.length());
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new CupertinoEncInfo(string2, byArray, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n > 0) return n;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 2: {
                string = FileChunk.toString((int)(81 + -73), (String)"ey>j\"9>!") + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 10: 
        }
        if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
        return FileChunk.toString((int)(53 * 55), (String)".4q'i|yd") + mediaCodecInfoAudio.getAudioObjectType();
    }

    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return LiveStreamPacketizerCupertinoUtils.codecInfoVideoToCodecsStr(mediaCodecInfoVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo, boolean bl) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            case 7: {
                if (!bl) break;
                return Base64.getChars((String)"*:.\u007fafg|`d", (int)(96 + -21));
            }
            default: {
                return string;
            }
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return FileChunk.toString((int)(-58 - 41), (String)"|h|1/") + n2 + "." + n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToStreamMode(String var0) {
        var1_1 = 1;
        var2_2 = var0.lastIndexOf(".");
        if (var2_2 >= 0) ** GOTO lbl-1000
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = var0.substring(var2_2);
            if (StringUtils.isEmpty((String)var3_3)) {
                return var1_1;
            }
            if (var3_3.startsWith(Base64.getChars((String)"!qpq", (int)(13 * 43)))) {
                var1_1 = 3;
            }
            if (var3_3.startsWith(FileChunk.toString((int)(78 + 35), (String)"\u007f?#g")) == false) return var1_1;
            return 2;
        }
    }
}

