/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.support.SSLHandler;
import org.apache.mina.util.SessionLog;

public class SSLFilter
extends IoFilterAdapter {
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    public static final String DISABLE_ENCRYPTION_ONCE = SSLFilter.class.getName() + ".DisableEncryptionOnce";
    public static final String USE_NOTIFICATION = SSLFilter.class.getName() + ".UseNotification";
    public static final SSLFilterMessage SESSION_SECURED = new SSLFilterMessage("SESSION_SECURED");
    public static final SSLFilterMessage SESSION_UNSECURED = new SSLFilterMessage("SESSION_UNSECURED");
    private static final String NEXT_FILTER = SSLFilter.class.getName() + ".NextFilter";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean logConnectionInfo = false;

    public SSLFilter(SSLContext sSLContext) {
        if (sSLContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sSLContext;
    }

    public SSLSession getSSLSession(IoSession ioSession) {
        return (SSLSession)ioSession.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSSL(IoSession ioSession) throws SSLException {
        boolean bl;
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (sSLHandler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
                sSLHandler.destroy();
                sSLHandler.init();
                sSLHandler.handshake(nextFilter);
                bl = true;
            } else {
                bl = false;
            }
        }
        sSLHandler.flushScheduledEvents();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSSLStarted(IoSession ioSession) {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            return false;
        }
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            return !sSLHandler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSSL(IoSession ioSession) throws SSLException {
        WriteFuture writeFuture;
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)ioSession.getAttribute(NEXT_FILTER);
        SSLHandler sSLHandler2 = sSLHandler;
        synchronized (sSLHandler2) {
            writeFuture = this.initiateClosure(nextFilter, ioSession);
        }
        sSLHandler.flushScheduledEvents();
        return writeFuture;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean bl) {
        this.client = bl;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = stringArray;
    }

    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        if (ioFilterChain.contains(SSLFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one SSLFilter.");
        }
        IoSession ioSession = ioFilterChain.getSession();
        ioSession.setAttribute(NEXT_FILTER, nextFilter);
        SSLHandler sSLHandler = new SSLHandler(this, this.sslContext, ioSession);
        ioSession.setAttribute(SSL_HANDLER, sSLHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioFilterChain.getSession());
        synchronized (sSLHandler2) {
            sSLHandler.handshake(nextFilter);
        }
        sSLHandler.flushScheduledEvents();
    }

    public void onPreRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession ioSession = ioFilterChain.getSession();
        this.stopSSL(ioSession);
        ioSession.removeAttribute(NEXT_FILTER);
        ioSession.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (this.isSSLStarted(ioSession) && SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Closed: " + this.getSSLSessionHandler(ioSession));
                }
                sSLHandler.destroy();
            }
            sSLHandler.flushScheduledEvents();
        }
        finally {
            nextFilter.sessionClosed(ioSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws SSLException {
        SSLHandler sSLHandler;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (!this.isSSLStarted(ioSession) && sSLHandler.isInboundDone()) {
                sSLHandler.scheduleMessageReceived(nextFilter, object);
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Data Read: " + sSLHandler + " (" + byteBuffer + ')');
                }
                try {
                    sSLHandler.messageReceived(nextFilter, byteBuffer.buf());
                    this.handleSSLData(nextFilter, sSLHandler);
                    if (sSLHandler.isInboundDone()) {
                        if (sSLHandler.isOutboundDone()) {
                            if (SessionLog.isDebugEnabled(ioSession)) {
                                SessionLog.debug(ioSession, " SSL Session closed.");
                            }
                            sSLHandler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, ioSession);
                        }
                        if (byteBuffer.hasRemaining()) {
                            sSLHandler.scheduleMessageReceived(nextFilter, byteBuffer);
                        }
                    }
                }
                catch (SSLException sSLException) {
                    SSLHandshakeException sSLHandshakeException;
                    if (!sSLHandler.isHandshakeComplete()) {
                        SSLHandshakeException sSLHandshakeException2 = new SSLHandshakeException("SSL handshake failed.");
                        sSLHandshakeException2.initCause(sSLException);
                        sSLHandshakeException = sSLHandshakeException2;
                    }
                    throw sSLHandshakeException;
                }
            }
        }
        sSLHandler.flushScheduledEvents();
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (object instanceof EncryptedBuffer) {
            EncryptedBuffer encryptedBuffer = (EncryptedBuffer)object;
            encryptedBuffer.release();
            nextFilter.messageSent(ioSession, encryptedBuffer.originalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws SSLException {
        SSLHandler sSLHandler;
        boolean bl = true;
        SSLHandler sSLHandler2 = sSLHandler = this.getSSLSessionHandler(ioSession);
        synchronized (sSLHandler2) {
            if (!this.isSSLStarted(ioSession)) {
                sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
            } else if (ioSession.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                ioSession.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)writeRequest.getMessage();
                if (SessionLog.isDebugEnabled(ioSession)) {
                    SessionLog.debug(ioSession, " Filtered Write: " + sSLHandler);
                }
                if (sSLHandler.isWritingEncryptedData()) {
                    if (SessionLog.isDebugEnabled(ioSession)) {
                        SessionLog.debug(ioSession, "   already encrypted: " + byteBuffer);
                    }
                    sSLHandler.scheduleFilterWrite(nextFilter, writeRequest);
                } else if (sSLHandler.isHandshakeComplete()) {
                    if (SessionLog.isDebugEnabled(ioSession)) {
                        SessionLog.debug(ioSession, " encrypt: " + byteBuffer);
                    }
                    int n = byteBuffer.position();
                    sSLHandler.encrypt(byteBuffer.buf());
                    byteBuffer.position(n);
                    EncryptedBuffer encryptedBuffer = new EncryptedBuffer(SSLHandler.copy(sSLHandler.getOutNetBuffer()), byteBuffer);
                    if (SessionLog.isDebugEnabled(ioSession)) {
                        SessionLog.debug(ioSession, " encrypted buf: " + encryptedBuffer);
                    }
                    sSLHandler.scheduleFilterWrite(nextFilter, new IoFilter.WriteRequest(encryptedBuffer, writeRequest.getFuture()));
                } else {
                    if (!ioSession.isConnected()) {
                        if (SessionLog.isDebugEnabled(ioSession)) {
                            SessionLog.debug(ioSession, " Write request on closed session.");
                        }
                    } else {
                        if (SessionLog.isDebugEnabled(ioSession)) {
                            SessionLog.debug(ioSession, " Handshaking is not complete yet. Buffering write request.");
                        }
                        sSLHandler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                    }
                    bl = false;
                }
            }
        }
        if (bl) {
            sSLHandler.flushScheduledEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(final IoFilter.NextFilter nextFilter, final IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            nextFilter.filterClose(ioSession);
            return;
        }
        WriteFuture writeFuture = null;
        try {
            SSLHandler sSLHandler2 = sSLHandler;
            synchronized (sSLHandler2) {
                if (this.isSSLStarted(ioSession)) {
                    writeFuture = this.initiateClosure(nextFilter, ioSession);
                    writeFuture.addListener(new IoFutureListener(){

                        public void operationComplete(IoFuture ioFuture) {
                            nextFilter.filterClose(ioSession);
                        }
                    });
                }
            }
            sSLHandler.flushScheduledEvents();
        }
        finally {
            if (writeFuture == null) {
                nextFilter.filterClose(ioSession);
            }
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession ioSession) throws SSLException {
        SSLHandler sSLHandler = this.getSSLSessionHandler(ioSession);
        if (!sSLHandler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture(ioSession);
        }
        WriteFuture writeFuture = sSLHandler.writeNetBuffer(nextFilter);
        if (sSLHandler.isInboundDone()) {
            sSLHandler.destroy();
        }
        if (ioSession.containsAttribute(USE_NOTIFICATION)) {
            sSLHandler.scheduleMessageReceived(nextFilter, SESSION_UNSECURED);
        }
        return writeFuture;
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) throws SSLException {
        if (sSLHandler.isHandshakeComplete()) {
            sSLHandler.flushPreHandshakeEvents();
        }
        sSLHandler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, sSLHandler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SSLHandler sSLHandler) {
        IoSession ioSession = sSLHandler.getSession();
        sSLHandler.getAppBuffer().flip();
        if (!sSLHandler.getAppBuffer().hasRemaining()) {
            sSLHandler.getAppBuffer().clear();
            return;
        }
        if (SessionLog.isDebugEnabled(ioSession)) {
            SessionLog.debug(ioSession, " appBuffer: " + sSLHandler.getAppBuffer());
        }
        ByteBuffer byteBuffer = SSLHandler.copy(sSLHandler.getAppBuffer());
        sSLHandler.getAppBuffer().clear();
        if (SessionLog.isDebugEnabled(ioSession)) {
            SessionLog.debug(ioSession, " app data read: " + byteBuffer + " (" + byteBuffer.getHexDump() + ')');
        }
        sSLHandler.scheduleMessageReceived(nextFilter, byteBuffer);
    }

    private SSLHandler getSSLSessionHandler(IoSession ioSession) {
        SSLHandler sSLHandler = this.getSSLSessionHandler0(ioSession);
        if (sSLHandler == null) {
            throw new IllegalStateException();
        }
        if (sSLHandler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return sSLHandler;
    }

    private SSLHandler getSSLSessionHandler0(IoSession ioSession) {
        return (SSLHandler)ioSession.getAttribute(SSL_HANDLER);
    }

    public boolean isLogConnectionInfo() {
        return this.logConnectionInfo;
    }

    public void setLogConnectionInfo(boolean bl) {
        this.logConnectionInfo = bl;
    }

    private static class EncryptedBuffer
    extends ByteBufferProxy {
        private final ByteBuffer originalBuffer;

        private EncryptedBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            super(byteBuffer);
            this.originalBuffer = byteBuffer2;
        }
    }

    public static class SSLFilterMessage {
        private final String name;

        private SSLFilterMessage(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

