/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.common.BroadcastIoSession;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionConfigImpl;
import org.apache.mina.util.Queue;

public class DatagramSessionImpl
extends BaseIoSession
implements BroadcastIoSession {
    private final IoService wrapperManager;
    private final IoServiceConfig serviceConfig;
    private final DatagramSessionConfig config = new SessionConfigImpl();
    private final DatagramService managerDelegate;
    private final DatagramFilterChain filterChain;
    private final DatagramChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private SocketAddress remoteAddress;
    private SelectionKey key;
    private int readBufferSize;

    DatagramSessionImpl(IoService ioService, DatagramService datagramService, IoServiceConfig ioServiceConfig, DatagramChannel datagramChannel, IoHandler ioHandler, SocketAddress socketAddress, SocketAddress socketAddress2) {
        this.wrapperManager = ioService;
        this.managerDelegate = datagramService;
        this.filterChain = new DatagramFilterChain(this);
        this.ch = datagramChannel;
        this.writeRequestQueue = new Queue();
        this.handler = ioHandler;
        this.remoteAddress = datagramChannel.socket().getRemoteSocketAddress();
        this.localAddress = socketAddress2;
        this.serviceAddress = socketAddress;
        this.serviceConfig = ioServiceConfig;
        IoSessionConfig ioSessionConfig = ioServiceConfig.getSessionConfig();
        if (ioSessionConfig instanceof DatagramSessionConfig) {
            DatagramSessionConfig datagramSessionConfig = (DatagramSessionConfig)ioSessionConfig;
            this.config.setBroadcast(datagramSessionConfig.isBroadcast());
            this.config.setReceiveBufferSize(datagramSessionConfig.getReceiveBufferSize());
            this.readBufferSize = datagramSessionConfig.getReceiveBufferSize();
            this.config.setReuseAddress(datagramSessionConfig.isReuseAddress());
            this.config.setSendBufferSize(datagramSessionConfig.getSendBufferSize());
            this.config.setDatagramMaximumPacketSize(datagramSessionConfig.getDatagramMaximumPacketSize());
            if (this.config.getTrafficClass() != datagramSessionConfig.getTrafficClass()) {
                this.config.setTrafficClass(datagramSessionConfig.getTrafficClass());
            }
        }
    }

    public IoService getService() {
        return this.wrapperManager;
    }

    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public IoSessionConfig getConfig() {
        return this.config;
    }

    DatagramService getManagerDelegate() {
        return this.managerDelegate;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    DatagramChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.key = selectionKey;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0() {
        IoServiceConfig ioServiceConfig = this.getServiceConfig();
        if (ioServiceConfig instanceof DatagramServiceConfig) {
            ((DatagramServiceConfig)ioServiceConfig).getSessionRecycler().remove(this);
        }
        this.filterChain.fireFilterClose(this);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    public WriteFuture write(Object object, SocketAddress socketAddress) {
        if (!this.config.isBroadcast()) {
            throw new IllegalStateException("Non-broadcast session");
        }
        return super.write(object, socketAddress);
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteRequests() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteBytes() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.byteSize();
        }
    }

    public long getFirstWriteRequestId() {
        return -1L;
    }

    public TransportType getTransportType() {
        return TransportType.DATAGRAM;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(SocketAddress socketAddress) {
        this.remoteAddress = socketAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    protected void updateTrafficMask() {
        this.managerDelegate.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    private class SessionConfigImpl
    extends DatagramSessionConfigImpl
    implements DatagramSessionConfig {
        private SessionConfigImpl() {
        }

        public int getReceiveBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public void setReceiveBufferSize(int n) {
            if (DatagramSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setReceiveBufferSize(n);
                    DatagramSessionImpl.this.readBufferSize = n;
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }

        public boolean isBroadcast() {
            try {
                return DatagramSessionImpl.this.ch.socket().getBroadcast();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public void setBroadcast(boolean bl) {
            try {
                DatagramSessionImpl.this.ch.socket().setBroadcast(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public int getSendBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public void setSendBufferSize(int n) {
            if (DatagramSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setSendBufferSize(n);
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }

        public boolean isReuseAddress() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public void setReuseAddress(boolean bl) {
            try {
                DatagramSessionImpl.this.ch.socket().setReuseAddress(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        public int getTrafficClass() {
            if (DatagramSessionConfigImpl.isGetTrafficClassAvailable()) {
                try {
                    return DatagramSessionImpl.this.ch.socket().getTrafficClass();
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
            return 0;
        }

        public void setTrafficClass(int n) {
            if (DatagramSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setTrafficClass(n);
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }
    }
}

