/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.medialist.MediaList;
import com.wowza.wms.medialist.MediaListSegment;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupMember;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupRediness;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscoderStreamNameGroup {
    public static final int STATE_PREINIT = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_SHUTDOWN = 3;
    protected Object lock = new Object();
    protected String name = "";
    protected List<TranscoderStreamNameGroupMember> members = new ArrayList<TranscoderStreamNameGroupMember>();
    protected MediaList mediaList = new MediaList();
    protected MediaStreamMapGroup nameGroup = null;
    protected MediaListSegment mediaListSegment = new MediaListSegment();
    protected LiveStreamTranscoder liveStreamTranscoder = null;
    protected TranscoderStream transcodingStream = null;
    protected int lifecycle = 1;
    protected boolean isSent = false;

    public TranscoderStreamNameGroup() {
        this.mediaList.addSegment(this.mediaListSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(LiveStreamTranscoder liveStreamTranscoder) {
        int n;
        Object object = this.lock;
        synchronized (object) {
            if (this.isSent) return;
            if (this.lifecycle != 2) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            LiveStreamTranscoder liveStreamTranscoder2 = liveStreamTranscoder;
            this.validateMemberCodec(liveStreamTranscoder2, liveStreamTranscoder2.getTranscodingStream());
            n = 0;
        }
        synchronized (this.lock) {
            block13: {
                n = this.members.size();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (n > 0) break block13;
                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.copyValueOf((String)"\u00176$(4+&..>\u001e:=50?\u001d583\u0010*6/+r<:;\t/6&6+'+\u0013", (int)(39 * 5)) + liveStreamTranscoder.getContextStr() + Base64.copyValueOf((String)"T0+Blcj0v`|ae6`yj:usi>~degg(%os(`y+i`~{i+2", (int)(59 * 11)) + this.getName());
                return;
            }
            this.addInternal(liveStreamTranscoder);
            boolean bl = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.lifecycle == 2) {
                    this.isSent = true;
                } else {
                    bl = true;
                }
            }
            if (!bl) return;
            this.removeInternal(liveStreamTranscoder);
            return;
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = new MediaStreamMapGroup();
        mediaStreamMapGroup.setName(this.name);
        mediaStreamMapGroup.setMediaList(this.mediaList);
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            arrayList.addAll(this.members);
        }
        for (Object object : arrayList) {
            String string = ((TranscoderStreamNameGroupMember)object).getName();
            mediaStreamMapGroup.add(string);
        }
        mediaStreamMap.addNameGroup(mediaStreamMapGroup);
        synchronized (this.lock) {
            this.nameGroup = mediaStreamMapGroup;
            // ** MonitorExit[var7_8] (shouldn't be in output)
            liveStreamTranscoder.notifyRegisterStreamNameGroup(this);
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(Base64.copyValueOf((String)"Lk{uo~q{%3\u001176 '*\u0006('.\u000b?!: \u007f370\u001c8#=+4:0\u0006", (int)(112 + -56)) + liveStreamTranscoder.getContextStr() + FileChunk.equals((int)(9 * 27), (String)"\u000enu\u00173<y4:18~8rnws>%") + mediaStreamMapGroup.getName());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = null;
        Object object = this.lock;
        synchronized (object) {
            mediaStreamMapGroup = this.nameGroup;
            this.nameGroup = null;
        }
        if (mediaStreamMapGroup == null) return;
        mediaStreamMap.removeNameGroup(mediaStreamMapGroup);
        liveStreamTranscoder.notifyUnregisterStreamNameGroup(this);
        WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(Base64.copyValueOf((String)"\u000f.<0,#.&&6\u001625-('\u0005- +\b\">'#z'3:7/?\u00122);-n`nX", (int)(21 * 47)) + liveStreamTranscoder.getContextStr() + FileChunk.equals((int)(1218 / 175), (String)"[=([ofc{k/~p\u007fv4rdxmi ;") + mediaStreamMapGroup.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        this.liveStreamTranscoder = liveStreamTranscoder;
        this.transcodingStream = transcoderStream;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FileChunk.equals((int)(338 / 88), (String)"PkptdmZ~yilcAq|w"), liveStreamTranscoder.getStreamName());
        this.name = SystemUtils.expandEnvironmentVariables((String)this.name, hashMap);
        this.validateMembers(liveStreamTranscoder, transcoderStream);
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(LiveStreamTranscoder liveStreamTranscoder) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 3;
            if (this.isSent) {
                this.isSent = false;
                bl = true;
            }
        }
        if (!bl) return;
        this.removeInternal(liveStreamTranscoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkRediness(TranscoderStreamNameGroupRediness transcoderStreamNameGroupRediness) {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (!this.isSent) {
                arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
                arrayList.addAll(this.members);
            }
        }
        if (arrayList == null) {
            return;
        }
        if (arrayList.size() <= 0) {
            return;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TranscoderStreamNameGroupMember transcoderStreamNameGroupMember = (TranscoderStreamNameGroupMember)iterator.next();
            transcoderStreamNameGroupMember.checkRediness(transcoderStreamNameGroupRediness, this.liveStreamTranscoder, this.transcodingStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void validateMemberCodec(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        block17: {
            block25: {
                block20: {
                    block22: {
                        block21: {
                            block18: {
                                block19: {
                                    block23: {
                                        block24: {
                                            break block24;
                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.copyValueOf((String)"Jm!/1 +!#5\u001b=8.- \u0000.=4\u0015!; &y.8628<*:\r$/!!75\u001c", (int)(-23 - 43)) + var1_1.getContextStr() + FileChunk.equals((int)(-30 - 8), (String)"\u0007a|\u000e*-% /\r%(#\u0000:&?;\u0017") + var5_5.getName() + FileChunk.equals((int)(77 + -64), (String)"P.yyuw|4vys}z:ro=ppt!tbhlb'nfx+blcj0v`|ae,7") + FLVUtils.videoCodecToString((int)var7_8) + Base64.copyValueOf((String)"u~", (int)(-22 - -11)) + var8_9 + ")");
                                                var6_7 = true;
                                                ** GOTO lbl30
                                                break;
                                            }
lbl5:
                                            // 1 sources

                                            while (true) {
                                                var8_9 = Base64.copyValueOf((String)"phlff}e", (int)(7 * 19));
                                                break block17;
                                                break;
                                            }
lbl8:
                                            // 1 sources

                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.equals((int)(-6 - -54), (String)"Dcs}gvys}kIonx\u007fr\u000e /&\u00037)28g<* $*.$4\u001f6973%+\u0002") + var1_1.getContextStr() + FileChunk.equals((int)(-1 - 22), (String)"\u0014pk\u001f9<*1<\u001c290\u0011%7,*\u0000") + var5_5.getName() + FileChunk.equals((int)(15 + 57), (String)"\u0015i+>($!o3>667u?$x75/|+?3)%b%+7f))$/k+?!: kr") + FLVUtils.audioCodecToString((int)var7_8) + FileChunk.equals((int)(45 * 41), (String)"5>") + var8_9 + ")");
                                                var6_7 = true;
                                                break block18;
                                                break;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                while (true) {
                                                    var3_3.addAll(this.members);
                                                    break block19;
                                                    break;
                                                }
                                            }
                                        }
                                        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
                                        var4_4 = this.lock;
                                        synchronized (var4_4) {
                                            ** continue;
                                        }
lbl22:
                                        // 4 sources

                                        while (true) {
                                            if (!var5_5.isVideo) ** GOTO lbl30
                                            break block20;
lbl25:
                                            // 3 sources

                                            while (var4_4.hasNext()) {
                                                break block21;
                                            }
                                            break block22;
                                            break;
                                        }
lbl28:
                                        // 2 sources

                                        while (true) {
                                            if (var7_8 != 7) ** continue;
lbl30:
                                            // 3 sources

                                            if (!var6_7) ** GOTO lbl25
                                            break block23;
                                            break;
                                        }
lbl32:
                                        // 1 sources

                                        throw var5_6;
lbl34:
                                        // 1 sources

                                        while (true) {
                                            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.equals((int)(-55 - -29), (String)"\u00125)'9(#)+=\u0003% 658\u001865<\u001d)3(.qv`nj`drbElgii\u007f}T") + var1_1.getContextStr() + FileChunk.equals((int)(23 * 13), (String)"V6-]{bts~Zt{r_kunlF") + var5_5.getName() + Base64.copyValueOf((String)"^$dscaf*hcikl0xa3zzb7nxvrx=xpr!lbi`&`zf\u007f{6-", (int)(593 / 195)) + FLVUtils.audioCodecToString((int)var7_8) + Base64.copyValueOf((String)"$-", (int)(1046 / 247)) + var8_9 + ")");
                                            var6_7 = true;
                                            ** GOTO lbl22
                                            break;
                                        }
lbl38:
                                        // 1 sources

                                        while (true) {
                                            if (var7_8 != 2) {
                                                ** continue;
                                            }
                                            break block18;
                                            break;
                                        }
                                    }
                                    this.removeMember(var5_5);
                                    ** GOTO lbl25
lbl46:
                                    // 1 sources

                                    while (true) {
                                        if (FileChunk.equals((int)(63 * 39), (String)"tj/}3*/.26").equals(var8_9)) ** GOTO lbl22
                                        ** continue;
                                        break;
                                    }
                                }
                                var4_4 = var3_3.iterator();
                                ** GOTO lbl25
                            }
lbl53:
                            // 2 sources

                            while (true) {
                                if (var7_8 != 2) ** GOTO lbl22
                                ** continue;
                                break;
                            }
                            {
                                catch (Throwable var5_6) {
                                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl54 : MonitorExitStatement: MONITOREXIT : var4_4
                                    ** continue;
                                }
                            }
                        }
                        var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                        var6_7 = false;
                        if (var5_5.isAudio) ** break;
                        ** while (true)
                        break block25;
                    }
                    return;
lbl67:
                    // 1 sources

                    while (true) {
                        var8_9 = FileChunk.equals((int)(21 * 39), (String)"fz~xxow");
                        ** GOTO lbl28
                        break;
                    }
                }
                var7_8 = var5_5.geVideoCodec(var1_1, var2_2);
                var8_9 = var5_5.getMediaListRendition().getVideoCodecId();
                if (var8_9 == null) ** break;
                ** while (true)
                ** while (true)
            }
            var7_8 = var5_5.getAudioCodec(var1_1, var2_2);
            ** while ((var8_9 = var5_5.getMediaListRendition().getAudioCodecId()) == null)
        }
        ** while (var7_8 == 10)
lbl81:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateMembers(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
        var4_4 = this.lock;
        synchronized (var4_4) {
            var3_3.addAll(this.members);
        }
        var4_4 = var3_3.iterator();
        ** GOTO lbl29
        while (true) {
            var9_10 = this.lock;
            synchronized (var9_10) {
                if (var7_8.isAudioDisable()) {
                    var5_5.isAudio = false;
                }
                if (var7_8.isVideoDisable()) {
                    var5_5.isVideo = false;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var9_10
                if (true) ** GOTO lbl29
            }
            break;
        }
        while (true) {
            if (var7_8 != null && var8_9 != null) ** continue;
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.copyValueOf((String)"[bp|`wzrrjJniy|sQalgDvjsw&\u007fkgeio{u\\w~vpddC", (int)(38 - 23)) + var1_1.getContextStr() + FileChunk.equals((int)(25 * 33), (String)"D ;Oilz!,\f\") \u00015'<:k!(#-5#r7;0%w66.{9%7,4a+-d\u0000($'-/8l!'<$kr") + var6_7);
            this.removeMember(var5_5);
lbl29:
            // 4 sources

            while (var4_4.hasNext() != false) {
                var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                var6_7 = var5_5.getName();
                var7_8 = var2_2.getDestination(var6_7);
                var8_9 = var1_1.getTranscodingSession().getSessionDestination(var6_7);
                if (var7_8 == null || var7_8.isEnable()) ** continue;
                this.removeMember(var5_5);
            }
            return;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMemberCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.members.size();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName(String string) {
        String string2 = this.getName();
        if (string2 != null) return string2.replace(Base64.copyValueOf((String)"h6\u001d %#16\u0007!$294\u0014:18#", (int)(-26 + 102)), string);
        string2 = Base64.copyValueOf((String)"-qXcx|luBfaqt{Yyt\u007ffC", (int)(30 + 107)) + this.name;
        return string2.replace(Base64.copyValueOf((String)"h6\u001d %#16\u0007!$294\u0014:18#", (int)(-26 + 102)), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.name = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        Object object = this.lock;
        synchronized (object) {
            this.members.add(transcoderStreamNameGroupMember);
            transcoderStreamNameGroupMember.setLock(this.lock);
            this.mediaListSegment.addRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamNameGroupMember removeMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        TranscoderStreamNameGroupMember transcoderStreamNameGroupMember2 = null;
        Object object = this.lock;
        synchronized (object) {
            this.members.remove(transcoderStreamNameGroupMember);
            this.mediaListSegment.removeRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return transcoderStreamNameGroupMember2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TranscoderStreamNameGroupMember> getMembers() {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.members);
            return arrayList;
        }
    }
}

