/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.mutable;

import org.apache.commons.lang.mutable.Mutable;

public class MutableShort
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = -2135791679L;
    private short value;

    public MutableShort() {
    }

    public MutableShort(short s) {
        this.value = s;
    }

    public MutableShort(Number number) {
        this.value = number.shortValue();
    }

    public MutableShort(String string) throws NumberFormatException {
        this.value = Short.parseShort(string);
    }

    public Object getValue() {
        return new Short(this.value);
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(Object object) {
        this.setValue(((Number)object).shortValue());
    }

    public void increment() {
        this.value = (short)(this.value + 1);
    }

    public void decrement() {
        this.value = (short)(this.value - 1);
    }

    public void add(short s) {
        this.value = (short)(this.value + s);
    }

    public void add(Number number) {
        this.value = (short)(this.value + number.shortValue());
    }

    public void subtract(short s) {
        this.value = (short)(this.value - s);
    }

    public void subtract(Number number) {
        this.value = (short)(this.value - number.shortValue());
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public Short toShort() {
        return new Short(this.shortValue());
    }

    public boolean equals(Object object) {
        if (object instanceof MutableShort) {
            return this.value == ((MutableShort)object).shortValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public int compareTo(Object object) {
        MutableShort mutableShort = (MutableShort)object;
        short s = mutableShort.value;
        return this.value < s ? -1 : (this.value == s ? 0 : 1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

