/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.mp3;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameAttachedPicture;
import com.wowza.wms.mediareader.mp3.MP3StreamPosition;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3NodeData;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderMP3
implements IMediaReader {
    public static final int SYNCBLOCKSIZE = 10240;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected Bitstream bitstream = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = FileChunk.equals((int)(45 * 27), (String)"r0r");
    protected String mediaReaderExt = FileChunk.equals((int)(87 + 2), (String)"4*h");
    protected byte[] syncHeader;
    protected byte[] packetHeader;
    protected byte[] workBuffer;
    protected MediaReaderItem mediaReaderItem = null;
    protected MediaReaderMP3NodeData nodeData = null;
    protected int frequency = 0;
    protected int bitrate = 0;
    protected int samplesPerFrame = 0;
    protected long streamSize = 0L;
    protected long headerOffset = 0L;
    protected long tailOffset = 0L;
    protected long maxFrames = 0L;
    protected long duration = -1L;
    protected long length = 0L;
    protected int channels = 0;
    protected int layers = 3;
    protected List metaData = null;
    protected boolean justID3Tags = false;
    protected boolean readID3Tags = true;
    protected boolean readAttachedPictures = true;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = FileChunk.equals((int)(605 / 130), (String)"iu5");
    protected long currentSample = 0L;
    protected boolean bitrateErrorSent = false;
    protected int readAheadSize = 16384;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = Base64.copyValueOf((String)"gjk)\u007ff}qm#g`>U{aqvbEyw~tq\\}|erqQadbbz", (int)(159 / 36));
    protected IApplicationInstance appInstance = null;
    protected boolean calculateMoreAccurateFrameSize = false;
    protected int calculateMoreAccurateFrameWindow = 100;
    protected boolean isVBR = false;
    protected long saveLastAudioPos = 0L;
    protected int saveLastAudioSize = 0;
    protected Header h = null;
    protected Map<Integer, ID3V2FrameAttachedPicture> attachedPictures = new HashMap<Integer, ID3V2FrameAttachedPicture>();

    public MediaReaderMP3() {
        this.syncHeader = new byte[4];
        this.packetHeader = new byte[1];
        this.workBuffer = new byte[12];
        this.packetHeader[0] = 47;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.justID3Tags = wMSProperties.getPropertyBoolean(Base64.copyValueOf((String)".4v\f2;=\u0003\u000f\u007f\u0019/(#", (int)(13 + 54)), false);
        this.readID3Tags = wMSProperties.getPropertyBoolean(Base64.copyValueOf((String)"lr0V`gcAM9_mj}", (int)(24 - -9)), this.readID3Tags);
        this.readAttachedPictures = wMSProperties.getPropertyBoolean(FileChunk.equals((int)(699 / 120), (String)"hv4ZlkoMyznsywwD|ucmk\u007fh"), this.readAttachedPictures);
        this.readAheadSize = wMSProperties.getPropertyInt(Base64.copyValueOf((String)"20r\u0010&%!\u0007/-(.\u0018%7+", (int)(76 + 19)), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(Base64.copyValueOf((String)"3/3Sgb`Dnbim^yejijb", (int)(-14 - -12)), this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(Base64.copyValueOf((String)"\u007foat~\u007fRwvsdkK\u007fzxxl\\, 10", (int)(55 * 59)), this.randomAccessReaderClass);
        this.calculateMoreAccurateFrameSize = wMSProperties.getPropertyBoolean(FileChunk.equals((int)(87 + -42), (String)"nocsd~r`p[xj|[x\u007fhl~4$\u00041%(#\u0014!3/"), this.calculateMoreAccurateFrameSize);
        this.calculateMoreAccurateFrameWindow = wMSProperties.getPropertyInt(FileChunk.equals((int)(-72 + 75), (String)"`eierdh~nAb|jQrqfftbr^k{vyJwqdnu"), this.calculateMoreAccurateFrameWindow);
        if (!WMSLoggerFactory.getLogger(MediaReaderMP3.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.equals((int)(-23 - 19), (String)"\u001b2<0;\t9<::2\f\u0012pj(6t\u001a,+/\r%+.4\u0002;)1ov") + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"\u001e11?6\n<;?9/\u0013\u000f3/os7WcflHbnmiZ}yvuvf/6", (int)(41 * 59)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.equals((int)(96 + -26), (String)"\u000b\", +\u0019),**\"\u001c\u0002`z8&d\u0012,)/\u0015\u0019m\u000b!&1yd") + this.justID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"Kbl`kYiljjb\\B :xf$J|{\u007fUY-Kafq9$", (int)(1468 / 230)) + this.readID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"\u0012%%+\"\u0016 '#-;\u0007\u001b\u007fc<*15\u0013' 45?==\n2?)+-er8#", (int)(21 * 35)) + this.readAttachedPictures);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"NaaofZlkoi\u007fC_#?`rzqyzYzy~onLzaegqGigt{3*", (int)(43 * 9)) + this.randomAccessReaderClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String var1_1, String var2_2) {
        var3_3 = this.lock;
        synchronized (var3_3) {
            block7: {
                if (this.fileStream.isOpen()) {
                    this.close();
                }
                try {
                    this.fileStream.open();
                    this.fileReader.open();
                    this.bitstream = new Bitstream((IRandomAccessReader)this.fileReader);
                    this.errorReported = false;
                    v0 = this;
                    this.appInstance.notifyMediaReaderOpen((IMediaReader)v0, v0.stream);
                    this.readMetadata();
                    v1 = this;
                    this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)v1, v1.stream);
lbl19:
                    // 2 sources

                    return;
                }
                catch (Exception var4_5) {
                    if (this.errorReported) break block7;
                }
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"jvbf3*", (int)(5 * 33)) + var4_5.toString());
            }
            this.errorReported = true;
            ** continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            Object object = this.lock;
            // MONITORENTER : object
            if (this.bitstream != null) {
                this.bitstream.close();
            }
            this.bitstream = null;
            try {
                if (this.fileReader != null) {
                    WMSLoggerFactory.getLogger(null).debug(FileChunk.equals((int)(612 / 101), (String)"Kbl`kYiljjb\\B :vzxk|A}uq{Me`ffvX"));
                    this.fileReader.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"`hjubSocgi_kntt`N.5", (int)(380 / 97)) + exception.toString());
            }
            try {
                if (this.fileStream != null) {
                    WMSLoggerFactory.getLogger(null).debug(FileChunk.equals((int)(53 * 13), (String)"\\ww}tDry}\u007fiQM-1#--0!\u001e .$,\u0019?>(/\"\r"));
                    this.fileStream.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(433 / 120), (String)"`hjubSocgi^z}up\u007fN.5") + exception.toString());
            }
            this.frequency = 0;
            this.samplesPerFrame = 0;
            this.streamSize = 0L;
            this.maxFrames = 0L;
            this.headerOffset = 0L;
            this.tailOffset = 0L;
            this.duration = -1L;
            this.length = 0L;
            this.bitrate = 0;
            // MONITOREXIT : object
            MediaReaderMP3 mediaReaderMP3 = this;
            this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderMP3, mediaReaderMP3.stream);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(-23 + 45), (String)"u{wj\u007f!<") + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public boolean isOpen() {
        if (this.fileStream == null) {
            return false;
        }
        return this.fileStream.isOpen();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetadata() throws Exception {
        block37: {
            block34: {
                block33: {
                    block35: {
                        block31: {
                            block29: {
                                block30: {
                                    try {
                                        block36: {
                                            this.length = this.fileStream.length();
                                            var1_1 = this.bitstream.readFrame();
                                            if (var1_1 == null) break block29;
                                            this.frequency = var1_1.frequency();
                                            this.bitrate = var1_1.bitrate();
                                            this.samplesPerFrame = var1_1.samples_per_frame();
                                            this.headerOffset = this.bitstream.header_pos();
                                            this.tailOffset = this.bitstream.tail_size();
                                            this.streamSize = this.length - this.headerOffset - this.tailOffset;
                                            this.isVBR = var1_1.vbr();
                                            this.maxFrames = var1_1.max_number_of_frames((int)this.streamSize);
                                            this.duration = this.frequency > 0 ? Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency) : 0L;
                                            switch (var1_1.mode()) {
                                                case 2: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 1: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 3: {
                                                    this.channels = 1;
                                                }
lbl23:
                                                // 4 sources

                                                default: {
                                                    break block36;
                                                }
                                                case 0: 
                                            }
                                            this.channels = 2;
                                        }
                                        this.layers = var1_1.layer();
                                        if (this.readID3Tags) {
                                            ** break;
lbl31:
                                            // 1 sources

                                            this.decodeID3V2Tags();
                                        }
                                        this.bitstream.closeFrame();
                                        break block29;
                                    }
                                    catch (Exception var1_2) {
                                        if (this.errorReported) break block30;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(639 / 109), (String)"jvbfR;V6-") + var1_2.toString());
                                }
                                this.errorReported = true;
                            }
                            if (this.calculateMoreAccurateFrameSize && !this.isVBR) {
                                block32: {
                                    try {
                                        this.bitstream.rewind();
                                        var1_3 = -1L;
                                        var3_6 = 0;
                                        var4_7 = 0;
                                        while (true) {
                                            if (var1_3 > 0L) {
                                                var5_10 = (int)(this.fileReader.getFilePointer() - var1_3);
                                                var3_6 += var5_10;
                                                if (++var4_7 > this.calculateMoreAccurateFrameWindow) break;
                                            }
                                            var1_3 = this.fileReader.getFilePointer();
                                            var5_9 = this.bitstream.readFrame();
                                            if (var5_9 == null) break;
                                            this.bitstream.closeFrame();
                                        }
                                        if (var4_7 <= 0 || (var5_11 = (double)var3_6 / (double)var4_7) <= 0.0) break block31;
                                        this.maxFrames = (int)Math.round((double)this.streamSize / var5_11);
                                        if (this.frequency > 0) {
                                            this.duration = Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency);
                                        }
                                        break block31;
                                    }
                                    catch (Exception var1_5) {
                                        if (this.errorReported) break block32;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"kuciS;W1,", (int)(321 / 66)) + var1_5.toString());
                                }
                                this.errorReported = true;
                            }
                        }
                        if (this.duration > 0L) {
                            if (this.metaData == null) {
                                this.metaData = new ArrayList<E>();
                            }
                            var1_1 = new AMFDataObj();
                            var2_13 = (double)this.duration / 1000.0;
                            var1_1.put(FileChunk.equals((int)(19 * 7), (String)"asui}cdb"), (AMFData)new AMFDataItem(var2_13));
                            var1_1.put(Base64.copyValueOf((String)"bqaohkfnnodj", (int)(501 / 151)), (AMFData)new AMFDataItem(Base64.copyValueOf((String)")ey9", (int)(65 + -26))));
                            if (this.frequency > 0) {
                                var1_1.put(FileChunk.equals((int)(21 * 57), (String)"l{ky~aryezrjxn~"), (AMFData)new AMFDataItem(this.frequency));
                            }
                            if (this.streamSize > 0L && this.duration > 0L) {
                                var1_1.put(FileChunk.equals((int)(33 * 53), (String)"4#316>:(<,>4$"), (AMFData)new AMFDataItem(this.streamSize * 1000L / (this.duration * 1024L)));
                            }
                            var4_8 = new AMFDataList();
                            var4_8.add((AMFData)new AMFDataItem(Base64.copyValueOf((String)"86\u0014?/=\u0019?+a", (int)(57 * 47))));
                            var4_8.add((AMFData)var1_1);
                            var5_12 = var4_8.serialize();
                            this.metaData.add(ByteBuffer.wrap(var5_12));
                        }
                        try {
                            this.bitstream.rewind();
                            this.packetHeader[0] = 34;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] + (this.channels - 1));
                            if (this.frequency < 32000) break block33;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] | 12);
                            break block34;
                        }
                        catch (Exception var1_4) {
                            if (this.errorReported) break block35;
                        }
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(1283 / 216), (String)"jvbfR8V6-") + var1_4.toString());
                    }
                    this.errorReported = true;
                    ** GOTO lbl107
                }
                if (this.frequency < 22050) break block37;
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 8);
            }
lbl101:
            // 3 sources

            while (true) {
                v0 = this;
                if (v0.isConfigDecodeCapable(v0.stream)) {
                    this.packetHeader[0] = 46;
                    if (this.channels >= 2) {
                        this.packetHeader[0] = (byte)(this.packetHeader[0] | 1);
                    }
                }
lbl107:
                // 6 sources

                if (this.duration > 0L) return;
                throw new Exception(Base64.copyValueOf((String)"HV4(ocgi-h`b|sg4{yc8o{wuy0?Zdpl$asui}cdb#.\\uty3c|z{8wuo<{kq#5+,*e65'9/9 4to", (int)(875 / 172)) + this.mediaName);
            }
        }
        if (this.frequency < 11025) ** GOTO lbl101
        this.packetHeader[0] = (byte)(this.packetHeader[0] | 4);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean isConfigDecodeCapable(IMediaStream iMediaStream) {
        if (iMediaStream == null) return false;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) >= 0) return true;
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeID3V2Tags() {
        block81: {
            block80: {
                block102: {
                    block68: {
                        block74: {
                            block83: {
                                block82: {
                                    var1_1 = null;
                                    ** try [egrp 1[TRYBLOCK] [18 : 113->2708)] { 
lbl3:
                                    // 1 sources

                                    break block82;
lbl4:
                                    // 1 sources

                                    catch (Exception var2_2) {
                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)";ebmgaLB4^;^jk~4/", (int)(31 * 33)) + var2_2.toString());
                                        var2_2.printStackTrace();
                                    }
lbl7:
                                    // 3 sources

                                    while (true) {
                                        try {
                                            if (var1_1 == null) return;
                                            var1_1.close();
                                            return;
                                        }
                                        catch (Exception var2_4) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(58 + 72), (String)"ffgjbbAM9]>Yohc+2") + var2_4.toString());
                                            return;
                                        }
                                        break;
                                    }
                                }
                                var1_1 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                var1_1.open();
                                var2_3 = 0;
                                var3_5 = new AMFDataObj();
                                var4_6 = new MP3File(var1_1, false);
                                if (var4_6 == null) break block74;
                                if (this.stream == null) break block83;
                                v0 /* !! */  = var5_7 = this.stream.getStreams().getVHost().getMp3TagMap();
lbl24:
                                // 2 sources

                                while (true) {
                                    if (!var4_6.hasID3v2Tag()) ** GOTO lbl104
                                    var6_10 = var4_6.getID3v2Tag();
                                    var7_11 = var6_10.iterator();
lbl28:
                                    // 4 sources

                                    while (true) {
                                        block75: {
                                            block94: {
                                                block76: {
                                                    block93: {
                                                        block92: {
                                                            block71: {
                                                                block84: {
                                                                    block91: {
                                                                        block73: {
                                                                            block90: {
                                                                                block69: {
                                                                                    if (!var7_11.hasNext()) break block84;
                                                                                    var8_26 = Base64.copyValueOf((String)"phlff}e", (int)(385 / 73));
                                                                                    var9_27 = Base64.copyValueOf((String)"sicge|b", (int)(251 / 39));
                                                                                    ** try [egrp 9[TRYBLOCK] [17, 16 : 2216->2708)] { 
lbl33:
                                                                                    // 1 sources

                                                                                    break block68;
lbl34:
                                                                                    // 1 sources

                                                                                    catch (Exception var10_29) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(3 * 27), (String)"570;13\u001e\u001cj\fi\b<9,za , <o}h\"/2v") + (String)var9_27 + Base64.copyValueOf((String)"%pfd|o1", (int)(1245 / 213)) + var8_26 + FileChunk.equals((int)(-19 - -46), (String)";yolpr;") + var10_29.toString());
                                                                                        continue;
                                                                                    }
lbl37:
                                                                                    // 1 sources

                                                                                    catch (UnsupportedOperationException var10_30) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"ffgjbbAM9]>Yohc+2q{qo>\"9q~e'", (int)(48 + 114)) + (String)var9_27 + FileChunk.equals((int)(49 * 41), (String)"y,:0(;e") + var8_26 + Base64.copyValueOf((String)"};-2.0y", (int)(17 * 13)) + var10_30.toString());
                                                                                        continue;
                                                                                    }
lbl-1000:
                                                                                    // 1 sources

                                                                                    {
                                                                                        while (true) {
                                                                                            block86: {
                                                                                                block70: {
                                                                                                    block85: {
                                                                                                        if (var6_10.getSongTitle() == null || var6_10.getSongTitle().length() <= 0) break block69;
                                                                                                        break block85;
                                                                                                        while (true) {
                                                                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                            break block70;
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    var7_11 = Base64.copyValueOf((String)"'c\u0000;;1\u00031-6>", (int)(-13 - 2));
                                                                                                    var8_26 = var6_10.getSongTitle();
                                                                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                    break block86;
                                                                                                }
lbl52:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    ++var2_3;
                                                                                                    break block69;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            var3_5.put((String)var9_27.get(FileChunk.equals((int)(40 - -31), (String)"))$/")), (AMFData)new AMFDataItem(var8_26));
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
lbl58:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        block89: {
                                                                                            block72: {
                                                                                                block88: {
                                                                                                    block87: {
                                                                                                        ** try [egrp 3[TRYBLOCK] [3, 4 : 714->841)] { 
lbl60:
                                                                                                        // 1 sources

                                                                                                        break block87;
lbl61:
                                                                                                        // 1 sources

                                                                                                        catch (UnsupportedOperationException var7_12) {
                                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"o+Hssy\\/,/&*1|g", (int)(49 * 9)) + var7_12.toString());
                                                                                                            break block71;
                                                                                                        }
                                                                                                    }
                                                                                                    if (var6_10.getSongComment() == null || var6_10.getSongComment().length() <= 0) break block71;
                                                                                                    break block88;
                                                                                                    while (true) {
                                                                                                        var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                        break block72;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var7_11 = FileChunk.equals((int)(151 / 36), (String)"r4UhfnIda`kad");
                                                                                                var8_26 = var6_10.getSongComment();
                                                                                                if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                break block89;
                                                                                            }
lbl76:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                ++var2_3;
                                                                                                break block71;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        var3_5.put((String)var9_27.get(FileChunk.equals((int)(-34 - -45), (String)"em`k")), (AMFData)new AMFDataItem(var8_26));
                                                                                        ** continue;
lbl82:
                                                                                        // 1 sources

                                                                                        catch (Exception var7_18) {
                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"k/L//%\u0000+(+\"&=pk", (int)(66 + 123)) + var7_18.toString());
                                                                                            break block71;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                if (var6_10.getLeadArtist() == null || var6_10.getLeadArtist().length() <= 0) ** GOTO lbl179
                                                                                break block90;
                                                                                while (true) {
                                                                                    var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                    break block73;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var7_11 = FileChunk.equals((int)(23 * 63), (String)"\u007f;GiljNbe{``");
                                                                            var8_26 = var6_10.getLeadArtist();
                                                                            if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                            break block91;
                                                                        }
lbl98:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            ++var2_3;
                                                                            break;
                                                                        }
                                                                    }
                                                                    var3_5.put((String)var9_27.get(Base64.copyValueOf((String)"#/\"5", (int)(55 * 27))), (AMFData)new AMFDataItem(var8_26));
                                                                    ** continue;
                                                                }
                                                                if (var4_6.hasID3v1Tag()) {
                                                                    var6_10 = var4_6.getID3v1Tag();
                                                                    ** continue;
                                                                }
                                                                break block74;
                                                            }
                                                            ** try [egrp 5[TRYBLOCK] [7, 8 : 1191->1318)] { 
lbl111:
                                                            // 1 sources

                                                            break block92;
lbl112:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_14) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"s7TggmLic|j*1", (int)(434 / 77)) + var7_14.toString());
                                                                break block75;
                                                            }
                                                        }
                                                        if (var6_10.getSongGenre() == null || var6_10.getSongGenre().length() <= 0) break block75;
                                                        break block93;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block76;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = Base64.copyValueOf((String)"p6[fdlKh`}u", (int)(410 / 65));
                                                    var8_26 = var6_10.getSongGenre();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block94;
                                                }
lbl127:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block75;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(Base64.copyValueOf((String)">0?6", (int)(-22 - 26))), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                        }
lbl134:
                                        // 2 sources

                                        while (true) {
                                            block97: {
                                                block77: {
                                                    block96: {
                                                        block95: {
                                                            ** try [egrp 6[TRYBLOCK] [10, 9 : 1318->1443)] { 
lbl136:
                                                            // 1 sources

                                                            break block95;
lbl137:
                                                            // 1 sources

                                                            catch (Exception var7_13) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"|:X\u007fol{_g~vpdXvXvyip$?", (int)(15 + 123)) + var7_13.toString());
                                                                break block74;
                                                            }
lbl140:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_16) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.equals((int)(483 / 100), (String)"r4RuijaEy`ljb^|Rxwcz\"9") + var7_16.toString());
                                                                break block74;
                                                            }
                                                        }
                                                        if (var6_10.getTrackNumberOnAlbum() == null || var6_10.getTrackNumberOnAlbum().length() <= 0) break block74;
                                                        break block96;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block77;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = FileChunk.equals((int)(4 + 59), (String)"iq\u00150\"'.\b2%+/9\u0003#\u000f#2$?");
                                                    var8_26 = var6_10.getTrackNumberOnAlbum();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block97;
                                                }
lbl155:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block74;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(FileChunk.equals((int)(29 * 35), (String)"994?")), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                            break;
                                        }
lbl-1000:
                                        // 4 sources

                                        {
                                            while (true) {
                                                block99: {
                                                    block78: {
                                                        block98: {
                                                            if (var6_10.getYearReleased() == null || var6_10.getYearReleased().length() <= 0) ** GOTO lbl58
                                                            break block98;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block78;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = FileChunk.equals((int)(12 + 64), (String)":|\u0017*1#\u00006807$==");
                                                        var8_26 = var6_10.getYearReleased();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block99;
                                                    }
lbl173:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** continue;
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(Base64.copyValueOf((String)"kgjm", (int)(966 / 171))), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                                break;
                                            }
                                        }
lbl179:
                                        // 4 sources

                                        while (true) {
                                            try {
                                                block101: {
                                                    block79: {
                                                        block100: {
                                                            if (var6_10.getAlbumTitle() == null || var6_10.getAlbumTitle().length() <= 0) ** GOTO lbl-1000
                                                            break block100;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block79;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = Base64.copyValueOf((String)"?{\n /;\"\u00048&?1", (int)(59 * 43));
                                                        var8_26 = var6_10.getAlbumTitle();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block101;
                                                    }
lbl192:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** GOTO lbl-1000
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(FileChunk.equals((int)(81 + 62), (String)"aq|w")), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                            }
                                            catch (Exception var7_21) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(21 * 53), (String)"/k\u001a0?+2\u0014(6/!\u007ff") + var7_21.toString());
                                                ** GOTO lbl-1000
                                            }
                                            catch (UnsupportedOperationException var7_22) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.equals((int)(-36 - 3), (String)"/k\u001a0?+2\u0014(6/!\u007ff") + var7_22.toString());
                                                ** continue;
                                            }
                                            break;
                                        }
                                        catch (UnsupportedOperationException var7_23) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.copyValueOf((String)"`&T|{\u007f]ojvsu8#", (int)(87 + 63)) + var7_23.toString());
                                        }
lbl207:
                                        // 1 sources

                                        catch (Exception var7_24) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(46 + 10), (String)"n(ItrzYz.3'yd") + var7_24.toString());
                                            ** continue;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            v0 /* !! */  = new HashMap<K, V>();
                            ** while (true)
                        }
                        if (!(var5_7 = WMSLoggerFactory.getLogger(MediaReaderMP3.class)).isDebugEnabled()) {
                            var5_7 = null;
                        }
                        this.metaData = null;
                        if (var2_3 <= 0) ** GOTO lbl7
                        if (this.metaData != null) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var5_7 != null) {
                                    for (var6_8 = 0; var6_8 < var2_3; ++var6_8) {
                                        var7_11 = var3_5.getKey(var6_8);
                                        var8_26 = (AMFDataItem)var3_5.get((String)var7_11);
                                        var5_7.debug(Base64.copyValueOf((String)"kkOC;3*", (int)(832 / 171)) + (String)var7_11 + "=" + var8_26.toString());
                                    }
                                }
                                var6_9 = new AMFDataList();
                                var6_9.add((AMFData)new AMFDataItem(FileChunk.equals((int)(-24 - -60), (String)"kkOC;")));
                                var6_9.add((AMFData)var3_5);
                                var7_11 = var6_9.serialize();
                                this.metaData.add(ByteBuffer.wrap((byte[])var7_11));
                                ** continue;
                                break;
                            }
                        }
                        this.metaData = new ArrayList<E>();
                        ** while (true)
                        catch (Exception var7_25) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"l*Px\u007f{Asvjwq<'", (int)(-28 - -54)) + var7_25.toString());
                            ** continue;
                        }
lbl238:
                        // 1 sources

                        ** GOTO lbl179
                    }
                    var10_28 = (AbstractID3v2Frame)var7_11.next();
                    var11_31 = var10_28.getBody();
                    if (var11_31 == null) ** GOTO lbl28
                    var9_27 = var10_28.getIdentifier();
                    var12_32 = var9_27;
                    if (var12_32.length() > 4) break block102;
lbl246:
                    // 2 sources

                    while (true) {
                        var8_26 = var11_31.getBriefDescription();
                        if (var8_26 == null) ** GOTO lbl28
                        if (this.readAttachedPictures) break block80;
lbl250:
                        // 4 sources

                        while (true) {
                            var13_33 = (Map)var5_7.get(var12_32);
                            if (var13_33 != null) {
                                var14_37 = (String)var13_33.get(Base64.copyValueOf((String)"q!,'", (int)(19 * 37)));
                                if (var14_37 == null) {
                                    var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
lbl256:
                                    // 3 sources

                                    while (true) {
                                        ++var2_3;
                                        ** continue;
                                        break;
                                    }
                                }
                                break block81;
                            }
                            var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
                            ** GOTO lbl256
                            break;
                        }
                        break;
                    }
                }
                var12_32 = var12_32.substring(0, 4);
                ** while (true)
            }
            if (!var12_32.equals(FileChunk.equals((int)(12 - 35), (String)"\b\u001a\u0002\u000f"))) ** GOTO lbl250
            var13_34 = 0;
            var14_38 = 16;
            var15_39 = null;
            var16_40 = null;
            var17_41 = null;
            try {
                var18_42 = (Long)var11_31.getObject(FileChunk.equals((int)(992 / 161), (String)"Rbp}*Nbnaky\u007fu"));
                if (var18_42 != null) {
                    var13_34 = var18_42.intValue();
                }
                if ((var19_44 = (Long)var11_31.getObject(FileChunk.equals((int)(59 * 41), (String)"\u0003=6\"\"*<z\u000f%-;"))) != null) {
                    var14_38 = var19_44.intValue();
                }
                var15_39 = (String)var11_31.getObject(Base64.copyValueOf((String)"HOJM)^r|h", (int)(55 * 3)));
                var16_40 = (String)var11_31.getObject(Base64.copyValueOf((String)"Gaveuay~bcc", (int)(466 / 117)));
                var17_41 = (byte[])var11_31.getObject(FileChunk.equals((int)(53 * 59), (String)"Gqznnnx>[!5#"));
lbl281:
                // 2 sources

                while (true) {
                    if (var17_41 == null) ** GOTO lbl250
                    break;
                }
            }
            catch (Exception var18_43) {
                ** continue;
            }
            {
                var18_42 = new ID3V2FrameAttachedPicture();
                var18_42.setTextEncoding(var13_34);
                var18_42.setPictureType(var14_38);
                var18_42.setPictureData(var17_41);
                if (var15_39 != null) {
                    var18_42.setMimeType(var15_39);
                }
                if (var16_40 != null) {
                    var18_42.setDescription(var16_40);
                }
                this.attachedPictures.put(new Integer(var14_38), (ID3V2FrameAttachedPicture)var18_42);
                ** continue;
            }
        }
        var3_5.put(var14_37, (AMFData)new AMFDataItem(var8_26));
        ** while (true)
    }

    public List getMetadata() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rewind() {
        if (this.bitstream == null) {
            return;
        }
        synchronized (this.lock) {
            this.bitstream.rewind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected long sample2TC(long l) {
        return l * 1000L / (long)this.frequency;
    }

    protected long tc2Sample(long l) {
        return l * (long)this.frequency / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void touchClient() {
        if (this.stream == null) {
            return;
        }
        IClient iClient = this.stream.getClient();
        if (iClient != null) {
            iClient.touch();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlaylistSeekResult seek(long l, int n) {
        MP3StreamPosition mP3StreamPosition;
        long l2;
        long l3;
        PlaylistSeekResult playlistSeekResult = null;
        if (l <= 0L) {
            l = 0L;
        }
        if (!this.fileStream.exists()) {
            return null;
        }
        if (this.duration > 0L) {
            block18: {
                if (l > this.duration) {
                    l = this.duration;
                }
                l3 = -1L;
                l2 = 0L;
                mP3StreamPosition = null;
                if (l <= 0L) {
                    l3 = this.headerOffset;
                    l2 = 0L;
                } else {
                    long l4 = this.headerOffset + this.streamSize * l / this.duration;
                    if (l4 >= this.headerOffset + this.streamSize) {
                        l3 = this.headerOffset + this.streamSize;
                        l2 = this.maxFrames * (long)this.samplesPerFrame;
                    } else {
                        try {
                            mP3StreamPosition = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                            mP3StreamPosition.open();
                            long l5 = 10240L;
                            if (l4 + l5 > mP3StreamPosition.length()) {
                                long l6 = this.maxFrames > 0L ? this.streamSize / this.maxFrames : 256L;
                                if (l6 > 0L && l6 < l4) {
                                    l4 -= l6;
                                }
                                l5 = mP3StreamPosition.length() - l4;
                            }
                            mP3StreamPosition.seek(l4);
                            byte[] byArray = new byte[(int)l5];
                            this.touchClient();
                            mP3StreamPosition.read(byArray, 0, byArray.length);
                            this.touchClient();
                            int n2 = MP3Utils.decodeFirstChunkMP3((byte[])byArray, (int)0, (long)byArray.length, (int)this.bitrate);
                            this.touchClient();
                            if (n2 >= 0) {
                                l3 = l4 + (long)n2;
                                l2 = this.maxFrames * (long)this.samplesPerFrame * l / this.duration;
                                break block18;
                            }
                            if ((double)l * 100.0 / (double)this.duration > 95.0) {
                                l3 = this.headerOffset + this.streamSize;
                                l2 = this.maxFrames * (long)this.samplesPerFrame;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                if (mP3StreamPosition != null) {
                    mP3StreamPosition.close();
                }
            }
            catch (Exception exception) {}
            mP3StreamPosition = null;
            if (l3 >= 0L) {
                playlistSeekResult = new PlaylistSeekResult(0L);
                MP3StreamPosition mP3StreamPosition2 = new MP3StreamPosition(l3, l2);
                playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition2, this.sample2TC(l2), 8, 0);
                playlistSeekResult.setVideoStreamPos(null);
            }
        }
        if (playlistSeekResult != null) return playlistSeekResult;
        l3 = this.headerOffset;
        l2 = 0L;
        playlistSeekResult = new PlaylistSeekResult(0L);
        mP3StreamPosition = new MP3StreamPosition(l3, l2);
        playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition, 0L, 8, 0);
        playlistSeekResult.setVideoStreamPos(null);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMediaReaderStreamPosition getStreamPosition() {
        MP3StreamPosition mP3StreamPosition = new MP3StreamPosition();
        try {
            mP3StreamPosition.setSample(this.currentSample);
            if (this.fileStream == null) return mP3StreamPosition;
            mP3StreamPosition.setFilePos(this.fileStream.getFilePointer());
            return mP3StreamPosition;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"`m}Lb`h^`y\u007ffvf/6", (int)(17 * 23)) + exception.toString());
            return mP3StreamPosition;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        MP3StreamPosition mP3StreamPosition = (MP3StreamPosition)iMediaReaderStreamPosition;
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(mP3StreamPosition.getFilePos());
            }
            this.currentSample = mP3StreamPosition.getSample();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(246 / 38), (String)"ab|Ocgi]af~ewa.5") + exception.toString());
            return;
        }
    }

    public int rewriteLastPacket(int n, long l, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, long[] lArray, FastPlaySettings fastPlaySettings) {
        return 0;
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        block50: {
            block51: {
                block49: {
                    block59: {
                        block48: {
                            var12_12 = 0;
                            if (this.justID3Tags) {
                                var8_8.setHitEnd(true);
                                return var12_12;
                            }
                            if (this.duration <= 0L) {
                                var8_8.setHitEnd(true);
                                return var12_12;
                            }
                            // MONITORENTER : this.lock
                            if (this.bitstream != null) break block48;
                            var8_8.setHitEnd(true);
                            // MONITOREXIT : var13_13
                            return var12_12;
                        }
                        // MONITOREXIT : var13_13
                        var13_13 = null;
                        var14_14 = 0;
                        var15_16 = var7_7.getMaxTC();
                        var17_17 = var6_6.getLastAudioTC();
                        var19_18 = this.currentSample;
                        try lbl-1000:
                        // 3 sources

                        {
                            while ((var13_13 = this.bitstream.readFrame()) != null) {
                                block57: {
                                    block56: {
                                        block55: {
                                            block53: {
                                                block54: {
                                                    block52: {
                                                        // MONITORENTER : this.lock
                                                        if (var6_6.isBreakLoop()) {
                                                            // MONITOREXIT : var21_19
                                                            break block49;
                                                        }
                                                        var22_21 = var6_6.isSendAbsAudioTC();
                                                        if (this.bitstream.framesize > 0) break block52;
                                                        if (this.bitrateErrorSent) break block53;
                                                        break block54;
                                                    }
                                                    var23_22 = var3_3.getId();
                                                    var24_23 = this.stream.getSrc();
                                                    var25_24 = this.bitstream.framesize + 5;
                                                    var26_25 = 8;
                                                    var27_26 = var3_3;
                                                    var28_27 = var27_26.isNew();
                                                    var29_28 = var28_27 | var22_21;
                                                    var27_26.setNew(false);
                                                    var30_29 = 0L;
                                                    if (!var6_6.isSendAbsAudioTC()) break block55;
                                                    var6_6.setSendAbsAudioTC(false);
                                                    var30_29 = this.sample2TC(var19_18);
                                                    if ((var30_29 += var6_6.getStartTCOffset()) < 0L) {
                                                        this.bitstream.closeFrame();
                                                        // MONITOREXIT : var21_19
                                                        continue;
                                                    }
                                                    break block56;
                                                }
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"\n--#*\u001e(/+5#\u001f\u0003g{!%1-?\u000b=>5:42xc\n !&< <.l+<.=4r =/3wp", (int)(-61 - -4)) + this.bitstream.framesize + FileChunk.equals((int)(25 * 23), (String)"6na\u000f\"=e$\"h-?.l9!o%?!&$%9%,<>{\u0011\rm\u007f\"(61%1#g  -#)?n;80<segnw3;*(r"));
                                                this.bitrateErrorSent = true;
                                            }
                                            // MONITOREXIT : var21_19
                                            break block49;
                                        }
                                        var30_29 = this.sample2TC(var19_18) - var17_17;
                                    }
                                    var6_6.setLastAudioTC(var17_17 += var30_29);
                                    var6_6.incAudioPacketCount();
                                    var6_6.setLastTC(var17_17);
                                    this.currentSample = var19_18 += (long)this.samplesPerFrame;
                                    var8_8.setLastTC(var17_17);
                                    var8_8.incAudioPackets();
                                    ++var14_14;
                                    var32_30 = 1;
                                    if (var11_11) {
                                        var30_29 = 0L;
                                    }
                                    this.workBuffer[0] = (byte)(255 & var23_22);
                                    if (var29_28 || var27_26.getSrc() != var24_23) {
                                        this.workBuffer[8] = (byte)(255 & var24_23);
                                        this.workBuffer[9] = (byte)(255 & var24_23 >> 8);
                                        this.workBuffer[10] = (byte)(255 & var24_23 >> 16);
                                        this.workBuffer[11] = (byte)(255 & var24_23 >> 24);
                                        var27_26.setSrc(var24_23);
                                        var32_30 += 4;
                                        var29_28 = true;
                                    }
                                    if (var29_28 || var27_26.getSize() == var25_24) {
                                        // empty if block
                                    }
                                    this.workBuffer[4] = (byte)(255 & var25_24 >> 16);
                                    this.workBuffer[5] = (byte)(255 & var25_24 >> 8);
                                    this.workBuffer[6] = (byte)(255 & var25_24);
                                    this.workBuffer[7] = (byte)var26_25;
                                    var27_26.setSize(var25_24);
                                    var27_26.setType(var26_25);
                                    var32_30 += 4;
                                    var29_28 = true;
                                    var33_31 = false;
                                    if (var29_28 || var27_26.getTimecode() != var30_29) {
                                        if (var30_29 >= 0xFFFFFFL) {
                                            this.workBuffer[1] = -1;
                                            this.workBuffer[2] = -1;
                                            this.workBuffer[3] = -1;
                                            var33_31 = true;
                                        } else {
                                            this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                            this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                            this.workBuffer[3] = (byte)(255L & var30_29);
                                        }
                                        var27_26.setTimecode(var30_29);
                                        var32_30 += 3;
                                        var29_28 = true;
                                    }
                                    if (AMFObj.AMFDEBUGHEADERSIZE) {
                                        var34_33 = Base64.copyValueOf((String)"FEONNNXIGUPVVFF_M]BW~xt\u007fMe`ffvHV420em=?S50", (int)(45 * 3)) + var32_30;
                                        if (var32_30 <= 4) {
                                            WMSLoggerFactory.getLogger(null).error(var34_33);
                                        } else {
                                            WMSLoggerFactory.getLogger(null).info(var34_33);
                                        }
                                    }
                                    if (var23_22 < 64) break block57;
                                    var34_32 = new byte[2];
                                    switch (var32_30) {
                                        case 1: {
                                            var34_32[0] = -64;
                                            break;
                                        }
                                        case 8: {
                                            var34_32[0] = 64;
                                            break;
                                        }
                                        case 4: {
                                            var34_32[0] = -128;
                                            break;
                                        }
                                        case 12: {
                                            var34_32[0] = 0;
                                        }
                                    }
                                    var34_32[1] = (byte)(var23_22 - 64 & 255);
                                    var2_2.write(var34_32, 0, 2);
                                    var2_2.write(this.workBuffer, 1, var32_30 - 1);
                                    var12_12 += var32_30 + 1;
                                    ** break;
                                }
                                switch (var32_30) {
                                    case 12: {
                                        break;
                                    }
                                    case 4: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 128);
                                        break;
                                    }
                                    case 8: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 64);
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                    case 1: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 192);
                                    }
                                }
                                var2_2.write(this.workBuffer, 0, var32_30);
                                var12_12 += var32_30;
                                ** break;
lbl150:
                                // 2 sources

                                if (var33_31) {
                                    this.workBuffer[0] = (byte)(255L & var30_29 >> 24);
                                    this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                    this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                    this.workBuffer[3] = (byte)(255L & var30_29);
                                    var2_2.write(this.workBuffer, 0, 4);
                                    var12_12 = 4;
                                }
                                var13_13.getSyncHeader(this.syncHeader);
                                var2_2.write(this.packetHeader, 0, 1);
                                ++var12_12;
                                var2_2.write(this.syncHeader, 0, 4);
                                var12_12 += 4;
                                var9_9[1] = var9_9[1] + 1L;
                                if (var25_24 > 0) {
                                    var34_34 = this.bitstream.framesize;
                                    var35_35 = 0;
                                    var36_36 = 0;
                                    var37_37 = 5;
lbl168:
                                    // 2 sources

                                    while (var37_37 == 0) {
                                        if (var23_22 >= 64) {
                                            this.workBuffer[0] = -64;
                                            this.workBuffer[1] = (byte)(var23_22 - 64 & 255);
                                            var2_2.write(this.workBuffer, 0, 2);
                                            var12_12 += 2;
                                        } else {
                                            this.workBuffer[0] = (byte)(255 & var23_22 | 192);
                                            var2_2.write(this.workBuffer, 0, 1);
                                            ++var12_12;
                                        }
                                        if (var33_31) {
                                            this.workBuffer[0] = (byte)(255L & var30_29 >> 24);
                                            this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                            this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                            this.workBuffer[3] = (byte)(255L & var30_29);
                                            var2_2.write(this.workBuffer, 0, 4);
                                            var12_12 = 4;
                                        }
                                        break block50;
                                    }
                                    break block50;
                                }
                                ** GOTO lbl203
                            }
                            break block49;
                        }
                        catch (Exception var21_20) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.copyValueOf((String)"jlv4$\u0012\"'.#3;sj", (int)(101 + -40)) + var21_20.toString());
                            var21_20.printStackTrace();
                            break block51;
                        }
lbl196:
                        // 1 sources

                        while (var14_14 > 0) {
                            // MONITOREXIT : var21_19
                            break block49;
                        }
                        break block59;
lbl200:
                        // 1 sources

                        while (true) {
                            var37_37 = 0;
                            if ((var35_35 += var36_36) != var34_34) ** GOTO lbl168
lbl203:
                            // 2 sources

                            this.bitstream.closeFrame();
                            if (var15_16 == 0L) ** GOTO lbl196
                            if (var17_17 < var15_16) break;
                            // MONITOREXIT : var21_19
                            break block49;
                            break;
                        }
                    }
                    // MONITOREXIT : var21_19
                    ** GOTO lbl-1000
                }
                if (var13_13 == null) {
                    var8_8.setHitEnd(true);
                }
            }
            var8_8.setTotalSize(var12_12);
            var9_9[0] = var9_9[0] + (long)var12_12;
            return var12_12;
lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2.write(this.bitstream.frame_bytes, var35_35, var36_36);
                    var12_12 += var36_36;
                    ** continue;
                    break;
                }
            }
        }
        if ((var36_36 = var6_6.getWriteControl().getChunkSize() - var37_37) <= var34_34 - var35_35) ** GOTO lbl-1000
        var36_36 = var34_34 - var35_35;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        long l = 0L;
        if (this.duration >= 0L) {
            return this.duration;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        Bitstream bitstream = null;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            bitstream = new Bitstream(iRandomAccessReader);
            Header header = bitstream.readFrame();
            if (header != null) {
                n = header.frequency();
                n2 = header.samples_per_frame();
                long l4 = bitstream.header_pos();
                long l5 = bitstream.tail_size();
                l2 = iRandomAccessReader.length() - l4 - l5;
                bl = header.vbr();
                int n3 = header.max_number_of_frames((int)l2);
                l3 = n > 0 ? Math.round(1000.0 * (double)n2 * (double)n3 / (double)n) : 0L;
                bitstream.closeFrame();
            }
            bitstream.close();
            iRandomAccessReader.close();
            l = l3;
        }
        catch (Exception exception) {}
        if (this.calculateMoreAccurateFrameSize && !bl) {
            double d;
            int n4;
            int n5;
            long l6;
            try {
                bitstream.rewind();
                l6 = -1L;
                n5 = 0;
                n4 = 0;
            }
            catch (Exception exception) {
            }
            while (true) {
                if (l6 > 0L) {
                    int n6 = (int)(iRandomAccessReader.getFilePointer() - l6);
                    n5 += n6;
                    if (++n4 > this.calculateMoreAccurateFrameWindow) break;
                }
                l6 = iRandomAccessReader.getFilePointer();
                Header header = bitstream.readFrame();
                if (header == null) break;
                bitstream.closeFrame();
            }
            if (n4 > 0 && !((d = (double)n5 / (double)n4) <= 0.0)) {
                int n7 = (int)Math.round((double)l2 / d);
                if (n > 0) {
                    l3 = Math.round(1000.0 * (double)n2 * (double)n7 / (double)n);
                }
                l = l3;
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.fileStream == null) return 0L;
        long l = this.fileStream.length();
        return l;
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        synchronized (this.lock) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket createPacket(Header header) {
        int n = 8;
        AMFPacket aMFPacket = new AMFPacket(n, 0, this.bitstream.framesize + 4 + 1);
        try {
            byte[] byArray = aMFPacket.getData();
            byArray[0] = this.packetHeader[0];
            header.getSyncHeader(this.syncHeader);
            aMFPacket.addDataEx(this.syncHeader, 0, 1, 4);
            aMFPacket.addDataEx(this.bitstream.frame_bytes, 0, 5, this.bitstream.framesize);
            return aMFPacket;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.equals((int)(-32 - -10), (String)"\u0007.($/\u001d5066&\u0018\u0006dv:(>=);\u000fabifp?&") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
    }
}

