/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.io.FileChunk;
import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class QTWriterContextTrackAtomBase {
    protected List<QTWriterTmpItem> savedBlocks = new ArrayList<QTWriterTmpItem>();
    protected QTWriterContextTrack track = null;
    protected int rowsPerBlock = 0;
    protected int bytesPerRow = 0;
    protected byte[] block = null;
    protected int currRow = 0;
    protected int count = 0;
    protected int appendCount = 0;
    protected int appendBlockCount = 0;

    public QTWriterContextTrackAtomBase(QTWriterContextTrack qTWriterContextTrack, int n, int n2) {
        this.track = qTWriterContextTrack;
        this.rowsPerBlock = n;
        this.bytesPerRow = n2;
        this.block = new byte[n * n2];
    }

    public void insertBlock(int n, String string, long l, int n2) {
        QTWriterTmpItem qTWriterTmpItem = new QTWriterTmpItem(string, l, n2);
        this.savedBlocks.add(n, qTWriterTmpItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flushBlock(byte[] byArray, String string, int n) {
        try {
            byte[] byArray2 = new byte[8];
            System.arraycopy(string.getBytes(), 0, byArray2, 0, 4);
            BufferUtils.intToByteArray((int)n, (byte[])byArray2, (int)4, (int)4);
            long l = 0L;
            RandomAccessFile randomAccessFile = this.track.getContext().getTmpOut();
            Object object = randomAccessFile;
            synchronized (object) {
                RandomAccessFile randomAccessFile2 = randomAccessFile;
                randomAccessFile2.seek(randomAccessFile2.length());
                randomAccessFile.write(byArray2);
                l = randomAccessFile.getFilePointer();
                randomAccessFile.write(byArray, 0, n);
                randomAccessFile.getFD().sync();
            }
            object = new QTWriterTmpItem(string, l, n);
            this.savedBlocks.add((QTWriterTmpItem)object);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackAtomBase.class).error(FileChunk.lastIndexOf((int)(33 + 13), (String)"_[Gc{gqgUxvm\u007fchIl~#*\u00037+(\u0004&;,d- 8='\u0012==0?ov") + exception.toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getSavedBlock(int n) {
        byte[] byArray = null;
        if (n >= this.savedBlocks.size()) return byArray;
        QTWriterTmpItem qTWriterTmpItem = this.savedBlocks.get(n);
        try {
            RandomAccessFile randomAccessFile;
            byArray = new byte[qTWriterTmpItem.getSize()];
            RandomAccessFile randomAccessFile2 = randomAccessFile = this.track.getContext().getTmpOut();
            synchronized (randomAccessFile2) {
                randomAccessFile.seek(qTWriterTmpItem.getOffset());
                randomAccessFile.readFully(byArray);
                return byArray;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackAtomBase.class).error(FileChunk.lastIndexOf((int)(57 + 1), (String)"KOKowk%3\u0001,*1#?<\u001d8*/&\u000f;?<\u00102'0x0=-\u001873>5e`") + exception.toString());
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] getBlock(int n) {
        byte[] byArray = null;
        if (n < this.savedBlocks.size()) {
            return this.getSavedBlock(n);
        }
        if (this.currRow <= 0) return byArray;
        byArray = new byte[this.currRow * this.bytesPerRow];
        System.arraycopy(this.block, 0, byArray, 0, this.currRow * this.bytesPerRow);
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBlockCount() {
        int n;
        block2: {
            block1: {
                if (this.currRow <= 0) break block1;
                break block2;
            }
            n = 0;
            return n + this.savedBlocks.size();
        }
        n = 1;
        return n + this.savedBlocks.size();
    }

    public int getItemCount() {
        return this.count;
    }

    public void flush() {
    }

    public int getAppendCount() {
        return this.appendCount;
    }

    public void setAppendCount(int n) {
        this.appendCount = n;
    }

    public int getAppendBlockCount() {
        return this.appendBlockCount;
    }

    public void setAppendBlockCount(int n) {
        this.appendBlockCount = n;
    }
}

