/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.mp3;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameAttachedPicture;
import com.wowza.wms.mediareader.mp3.MP3StreamPosition;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3NodeData;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderMP3
implements IMediaReader {
    public static final int SYNCBLOCKSIZE = 10240;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected Bitstream bitstream = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = Base64.valueOf((String)"iu5", (int)(93 + 39));
    protected String mediaReaderExt = Base64.valueOf((String)"g{?", (int)(14 - 4));
    protected byte[] syncHeader;
    protected byte[] packetHeader;
    protected byte[] workBuffer;
    protected MediaReaderItem mediaReaderItem = null;
    protected MediaReaderMP3NodeData nodeData = null;
    protected int frequency = 0;
    protected int bitrate = 0;
    protected int samplesPerFrame = 0;
    protected long streamSize = 0L;
    protected long headerOffset = 0L;
    protected long tailOffset = 0L;
    protected long maxFrames = 0L;
    protected long duration = -1L;
    protected long length = 0L;
    protected int channels = 0;
    protected int layers = 3;
    protected List metaData = null;
    protected boolean justID3Tags = false;
    protected boolean readID3Tags = true;
    protected boolean readAttachedPictures = true;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.valueOf((String)"vl.", (int)(21 + 38));
    protected long currentSample = 0L;
    protected boolean bitrateErrorSent = false;
    protected int readAheadSize = 16384;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = FileChunk.lastIndexOf((int)(70 + 6), (String)"/\"#a'>%)5{?8v\u001d3)9>*\r!/&,)\u0004%$-:9\u0019),**\"");
    protected IApplicationInstance appInstance = null;
    protected boolean calculateMoreAccurateFrameSize = false;
    protected int calculateMoreAccurateFrameWindow = 100;
    protected boolean isVBR = false;
    protected long saveLastAudioPos = 0L;
    protected int saveLastAudioSize = 0;
    protected Header h = null;
    protected Map<Integer, ID3V2FrameAttachedPicture> attachedPictures = new HashMap<Integer, ID3V2FrameAttachedPicture>();

    public MediaReaderMP3() {
        this.syncHeader = new byte[4];
        this.packetHeader = new byte[1];
        this.workBuffer = new byte[12];
        this.packetHeader[0] = 47;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.justID3Tags = wMSProperties.getPropertyBoolean(FileChunk.lastIndexOf((int)(-21 - 22), (String)"8&d\u0012,)/\u0015\u0019m\u000b!&1"), false);
        this.readID3Tags = wMSProperties.getPropertyBoolean(FileChunk.lastIndexOf((int)(100 + 88), (String)"qm-M% &\n\u0000v\u0012&/:"), this.readID3Tags);
        this.readAttachedPictures = wMSProperties.getPropertyBoolean(Base64.valueOf((String)"vl.Lz!%\u000370$%/--\u001a\"/9;=5\"", (int)(9 + 50)), this.readAttachedPictures);
        this.readAheadSize = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(46 - 20), (String)"wk/O{~d@jfeaUnrl"), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(35 + -27), (String)"ey9YiljNxtsw@g\u007fp\u007f|h"), this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(Base64.valueOf((String)"(:2912\u0001\"!&76\u0014\")-/9\u000f!/<#", (int)(10 + 80)), this.randomAccessReaderClass);
        this.calculateMoreAccurateFrameSize = wMSProperties.getPropertyBoolean(FileChunk.lastIndexOf((int)(54 - -57), (String)",1=1&84\"2\u00156(>\u001d>=*r`vfBwgjmZcqi"), this.calculateMoreAccurateFrameSize);
        this.calculateMoreAccurateFrameWindow = wMSProperties.getPropertyInt(FileChunk.lastIndexOf((int)(726 / 105), (String)"efdj\u007fgmykB\u007fcwRwvceym\u007f]n|szWhlgkr"), this.calculateMoreAccurateFrameWindow);
        if (!WMSLoggerFactory.getLogger(MediaReaderMP3.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"\u0010;;i`PfeacuEY9%a}=]upvR|pwsKp`~&=", (int)(-40 - -37)) + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"T\u007f\u007fu|LzaegqIU5)ey9YiljNxtsw@g\u007fp\u007f|h!<", (int)(13 * 61)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(55 * 45), (String)"FiignBtswqg[G+7wk/Wkl4\b\u0006p\u0010$!4ri") + this.justID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"\u001d46:5\u000736<<(\u0016\fnp20r\u0010&%!\u000f\u0003{\u001d+,?wn", (int)(29 + 51)) + this.readID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(2 - -2), (String)"I`bni[ojhh|B@\"<aqtrVlm{xtxzOibvvv`u=(") + this.readAttachedPictures);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(7 * 43), (String)"@kkyp@vuqseUI)5n|p{/,\u0003 ' 54\u001a,+/)?\r#1\"!it") + this.randomAccessReaderClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String var1_1, String var2_2) {
        var3_3 = this.lock;
        synchronized (var3_3) {
            block7: {
                if (this.fileStream.isOpen()) {
                    this.close();
                }
                try {
                    this.fileStream.open();
                    this.fileReader.open();
                    this.bitstream = new Bitstream((IRandomAccessReader)this.fileReader);
                    this.errorReported = false;
                    v0 = this;
                    this.appInstance.notifyMediaReaderOpen((IMediaReader)v0, v0.stream);
                    this.readMetadata();
                    v1 = this;
                    this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)v1, v1.stream);
lbl19:
                    // 2 sources

                    return;
                }
                catch (Exception var4_5) {
                    if (this.errorReported) break block7;
                }
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(-8 - 62), (String)"ukys$?") + var4_5.toString());
            }
            this.errorReported = true;
            ** continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            Object object = this.lock;
            // MONITORENTER : object
            if (this.bitstream != null) {
                this.bitstream.close();
            }
            this.bitstream = null;
            try {
                if (this.fileReader != null) {
                    WMSLoggerFactory.getLogger(null).debug(FileChunk.lastIndexOf((int)(17 - 57), (String)"\u0015<>2=\u000f;>$$0\u000e\u0014vh$$&9.\u0017+'#5\u00037200$\n"));
                    this.fileReader.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(19 * 13), (String)"446)>\u0007;73eSgb``tZ2)") + exception.toString());
            }
            try {
                if (this.fileStream != null) {
                    WMSLoggerFactory.getLogger(null).debug(Base64.valueOf((String)"HccahXnmik}]A!=wyyd}B|rpxMkrdcnY", (int)(1104 / 192)));
                    this.fileStream.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"mc\u007fbwHr|zrKmh~}pC%`", (int)(4 + 42)) + exception.toString());
            }
            this.frequency = 0;
            this.samplesPerFrame = 0;
            this.streamSize = 0L;
            this.maxFrames = 0L;
            this.headerOffset = 0L;
            this.tailOffset = 0L;
            this.duration = -1L;
            this.length = 0L;
            this.bitrate = 0;
            // MONITOREXIT : object
            MediaReaderMP3 mediaReaderMP3 = this;
            this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderMP3, mediaReaderMP3.stream);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"l|~av.5", (int)(69 + 106)) + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public boolean isOpen() {
        if (this.fileStream == null) {
            return false;
        }
        return this.fileStream.isOpen();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetadata() throws Exception {
        block37: {
            block34: {
                block33: {
                    block35: {
                        block31: {
                            block29: {
                                block30: {
                                    try {
                                        block36: {
                                            this.length = this.fileStream.length();
                                            var1_1 = this.bitstream.readFrame();
                                            if (var1_1 == null) break block29;
                                            this.frequency = var1_1.frequency();
                                            this.bitrate = var1_1.bitrate();
                                            this.samplesPerFrame = var1_1.samples_per_frame();
                                            this.headerOffset = this.bitstream.header_pos();
                                            this.tailOffset = this.bitstream.tail_size();
                                            this.streamSize = this.length - this.headerOffset - this.tailOffset;
                                            this.isVBR = var1_1.vbr();
                                            this.maxFrames = var1_1.max_number_of_frames((int)this.streamSize);
                                            this.duration = this.frequency > 0 ? Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency) : 0L;
                                            switch (var1_1.mode()) {
                                                case 2: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 1: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 3: {
                                                    this.channels = 1;
                                                }
lbl23:
                                                // 4 sources

                                                default: {
                                                    break block36;
                                                }
                                                case 0: 
                                            }
                                            this.channels = 2;
                                        }
                                        this.layers = var1_1.layer();
                                        if (this.readID3Tags) {
                                            ** break;
lbl31:
                                            // 1 sources

                                            this.decodeID3V2Tags();
                                        }
                                        this.bitstream.closeFrame();
                                        break block29;
                                    }
                                    catch (Exception var1_2) {
                                        if (this.errorReported) break block30;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(199 / 34), (String)"jvbfR;V6-") + var1_2.toString());
                                }
                                this.errorReported = true;
                            }
                            if (this.calculateMoreAccurateFrameSize && !this.isVBR) {
                                block32: {
                                    try {
                                        this.bitstream.rewind();
                                        var1_3 = -1L;
                                        var3_6 = 0;
                                        var4_7 = 0;
                                        while (true) {
                                            if (var1_3 > 0L) {
                                                var5_10 = (int)(this.fileReader.getFilePointer() - var1_3);
                                                var3_6 += var5_10;
                                                if (++var4_7 > this.calculateMoreAccurateFrameWindow) break;
                                            }
                                            var1_3 = this.fileReader.getFilePointer();
                                            var5_9 = this.bitstream.readFrame();
                                            if (var5_9 == null) break;
                                            this.bitstream.closeFrame();
                                        }
                                        if (var4_7 <= 0 || (var5_11 = (double)var3_6 / (double)var4_7) <= 0.0) break block31;
                                        this.maxFrames = (int)Math.round((double)this.streamSize / var5_11);
                                        if (this.frequency > 0) {
                                            this.duration = Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency);
                                        }
                                        break block31;
                                    }
                                    catch (Exception var1_5) {
                                        if (this.errorReported) break block32;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(11 + 114), (String)"2.:nZ0^>%") + var1_5.toString());
                                }
                                this.errorReported = true;
                            }
                        }
                        if (this.duration > 0L) {
                            if (this.metaData == null) {
                                this.metaData = new ArrayList<E>();
                            }
                            var1_1 = new AMFDataObj();
                            var2_13 = (double)this.duration / 1000.0;
                            var1_1.put(FileChunk.lastIndexOf((int)(70 + 124), (String)"&66$2.''"), (AMFData)new AMFDataItem(var2_13));
                            var1_1.put(FileChunk.lastIndexOf((int)(88 + -56), (String)"atfjkficmjco"), (AMFData)new AMFDataItem(FileChunk.lastIndexOf((int)(40 - 47), (String)"w7+o")));
                            if (this.frequency > 0) {
                                var1_1.put(Base64.valueOf((String)"grl`exm`~cucsgq", (int)(1119 / 164)), (AMFData)new AMFDataItem(this.frequency));
                            }
                            if (this.streamSize > 0L && this.duration > 0L) {
                                var1_1.put(Base64.valueOf((String)"k~hdakqesauas", (int)(-37 - -47)), (AMFData)new AMFDataItem(this.streamSize * 1000L / (this.duration * 1024L)));
                            }
                            var4_8 = new AMFDataList();
                            var4_8.add((AMFData)new AMFDataItem(FileChunk.lastIndexOf((int)(5 * 15), (String)"$\"\u0000+;1\u00153'5")));
                            var4_8.add((AMFData)var1_1);
                            var5_12 = var4_8.serialize();
                            this.metaData.add(ByteBuffer.wrap(var5_12));
                        }
                        try {
                            this.bitstream.rewind();
                            this.packetHeader[0] = 34;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] + (this.channels - 1));
                            if (this.frequency < 32000) break block33;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] | 12);
                            break block34;
                        }
                        catch (Exception var1_4) {
                            if (this.errorReported) break block35;
                        }
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"$<( \u0014b\fhs", (int)(34 - 55)) + var1_4.toString());
                    }
                    this.errorReported = true;
                    ** GOTO lbl107
                }
                if (this.frequency < 22050) break block37;
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 8);
            }
lbl101:
            // 3 sources

            while (true) {
                v0 = this;
                if (v0.isConfigDecodeCapable(v0.stream)) {
                    this.packetHeader[0] = 46;
                    if (this.channels >= 2) {
                        this.packetHeader[0] = (byte)(this.packetHeader[0] | 1);
                    }
                }
lbl107:
                // 6 sources

                if (this.duration > 0L) return;
                throw new Exception(FileChunk.lastIndexOf((int)(66 + 4), (String)"\u000b\u0017{i,\" (n)?#?2 u88,y,:04:q`\u001b'1+e\"2:(>\"##`o\u0003478t\"?;4y44(}8*nbvjkk&wzfzn~aw50") + this.mediaName);
            }
        }
        if (this.frequency < 11025) ** GOTO lbl101
        this.packetHeader[0] = (byte)(this.packetHeader[0] | 4);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean isConfigDecodeCapable(IMediaStream iMediaStream) {
        if (iMediaStream == null) return false;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) >= 0) return true;
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeID3V2Tags() {
        block81: {
            block80: {
                block102: {
                    block68: {
                        block74: {
                            block83: {
                                block82: {
                                    var1_1 = null;
                                    ** try [egrp 1[TRYBLOCK] [18 : 112->2711)] { 
lbl3:
                                    // 1 sources

                                    break block82;
lbl4:
                                    // 1 sources

                                    catch (Exception var2_2) {
                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(51 * 51), (String)"mohcikFT\"D!@tqd\"9") + var2_2.toString());
                                        var2_2.printStackTrace();
                                    }
lbl7:
                                    // 3 sources

                                    while (true) {
                                        try {
                                            if (var1_1 == null) return;
                                            var1_1.close();
                                            return;
                                        }
                                        catch (Exception var2_4) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"**3>66\u001d\u0011e\u0001j\r;</g~", (int)(-17 - 1)) + var2_4.toString());
                                            return;
                                        }
                                        break;
                                    }
                                }
                                var1_1 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                var1_1.open();
                                var2_3 = 0;
                                var3_5 = new AMFDataObj();
                                var4_6 = new MP3File(var1_1, false);
                                if (var4_6 == null) break block74;
                                if (this.stream == null) break block83;
                                v0 /* !! */  = var5_7 = this.stream.getStreams().getVHost().getMp3TagMap();
lbl24:
                                // 2 sources

                                while (true) {
                                    if (!var4_6.hasID3v2Tag()) ** GOTO lbl104
                                    var6_10 = var4_6.getID3v2Tag();
                                    var7_11 = var6_10.iterator();
lbl28:
                                    // 4 sources

                                    while (true) {
                                        block75: {
                                            block94: {
                                                block76: {
                                                    block93: {
                                                        block92: {
                                                            block71: {
                                                                block84: {
                                                                    block91: {
                                                                        block73: {
                                                                            block90: {
                                                                                block69: {
                                                                                    if (!var7_11.hasNext()) break block84;
                                                                                    var8_26 = Base64.valueOf((String)"uoimkrh", (int)(-37 + 69));
                                                                                    var9_27 = Base64.valueOf((String)"~bf``g\u007f", (int)(-10 - -53));
                                                                                    ** try [egrp 9[TRYBLOCK] [17, 16 : 2217->2711)] { 
lbl33:
                                                                                    // 1 sources

                                                                                    break block68;
lbl34:
                                                                                    // 1 sources

                                                                                    catch (Exception var10_29) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"{ebmgaLB4^;^jk~4/r~vj=/6|}` ", (int)(-66 - 31)) + (String)var9_27 + Base64.valueOf((String)"7nxvny'", (int)(27 * 21)) + var8_26 + Base64.valueOf((String)"l(<=?#h", (int)(37 + 39)) + var10_29.toString());
                                                                                        continue;
                                                                                    }
lbl37:
                                                                                    // 1 sources

                                                                                    catch (UnsupportedOperationException var10_30) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"``ehllCO?[<[qva)4wysa0 ;wxg%", (int)(819 / 190)) + (String)var9_27 + FileChunk.lastIndexOf((int)(112 + 102), (String)"v!95/>f") + var8_26 + FileChunk.lastIndexOf((int)(34 + 53), (String)"w=+(4.g") + var10_30.toString());
                                                                                        continue;
                                                                                    }
lbl-1000:
                                                                                    // 1 sources

                                                                                    {
                                                                                        while (true) {
                                                                                            block86: {
                                                                                                block70: {
                                                                                                    block85: {
                                                                                                        if (var6_10.getSongTitle() == null || var6_10.getSongTitle().length() <= 0) break block69;
                                                                                                        break block85;
                                                                                                        while (true) {
                                                                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                            break block70;
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    var7_11 = Base64.valueOf((String)"p6[fdlXdzcu", (int)(26 + 108));
                                                                                                    var8_26 = var6_10.getSongTitle();
                                                                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                    break block86;
                                                                                                }
lbl52:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    ++var2_3;
                                                                                                    break block69;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            var3_5.put((String)var9_27.get(FileChunk.lastIndexOf((int)(52 + 81), (String)"kgjm")), (AMFData)new AMFDataItem(var8_26));
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
lbl58:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        block89: {
                                                                                            block72: {
                                                                                                block88: {
                                                                                                    block87: {
                                                                                                        ** try [egrp 3[TRYBLOCK] [3, 4 : 714->840)] { 
lbl60:
                                                                                                        // 1 sources

                                                                                                        break block87;
lbl61:
                                                                                                        // 1 sources

                                                                                                        catch (UnsupportedOperationException var7_12) {
                                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(55 + 49), (String)">x\u0019$\"*\r =<7= ov") + var7_12.toString());
                                                                                                            break block71;
                                                                                                        }
                                                                                                    }
                                                                                                    if (var6_10.getSongComment() == null || var6_10.getSongComment().length() <= 0) break block71;
                                                                                                    break block88;
                                                                                                    while (true) {
                                                                                                        var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                        break block72;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var7_11 = FileChunk.lastIndexOf((int)(20 + 71), (String)"-m\u000e11'\u0002-.) (3");
                                                                                                var8_26 = var6_10.getSongComment();
                                                                                                if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                break block89;
                                                                                            }
lbl76:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                ++var2_3;
                                                                                                break block71;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        var3_5.put((String)var9_27.get(Base64.valueOf((String)"iido", (int)(60 + -21))), (AMFData)new AMFDataItem(var8_26));
                                                                                        ** continue;
lbl82:
                                                                                        // 1 sources

                                                                                        catch (Exception var7_18) {
                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"u5ViioJefah`{*1", (int)(607 / 192)) + var7_18.toString());
                                                                                            break block71;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                if (var6_10.getLeadArtist() == null || var6_10.getLeadArtist().length() <= 0) ** GOTO lbl179
                                                                                break block90;
                                                                                while (true) {
                                                                                    var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                    break block73;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var7_11 = FileChunk.lastIndexOf((int)(45 * 23), (String)"}=AkntP`g}fb");
                                                                            var8_26 = var6_10.getLeadArtist();
                                                                            if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                            break block91;
                                                                        }
lbl98:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            ++var2_3;
                                                                            break;
                                                                        }
                                                                    }
                                                                    var3_5.put((String)var9_27.get(Base64.valueOf((String)"`n}t", (int)(113 + -99))), (AMFData)new AMFDataItem(var8_26));
                                                                    ** continue;
                                                                }
                                                                if (var4_6.hasID3v1Tag()) {
                                                                    var6_10 = var4_6.getID3v1Tag();
                                                                    ** continue;
                                                                }
                                                                break block74;
                                                            }
                                                            ** try [egrp 5[TRYBLOCK] [7, 8 : 1193->1319)] { 
lbl111:
                                                            // 1 sources

                                                            break block92;
lbl112:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_14) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(732 / 183), (String)"r4UhfnMnb\u007fk50") + var7_14.toString());
                                                                break block75;
                                                            }
                                                        }
                                                        if (var6_10.getSongGenre() == null || var6_10.getSongGenre().length() <= 0) break block75;
                                                        break block93;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block76;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = FileChunk.lastIndexOf((int)(104 + 109), (String)"#g\u000477=\u001c93,:");
                                                    var8_26 = var6_10.getSongGenre();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block94;
                                                }
lbl127:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block75;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(Base64.valueOf((String)"687>", (int)(7 - 47))), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                        }
lbl134:
                                        // 2 sources

                                        while (true) {
                                            block97: {
                                                block77: {
                                                    block96: {
                                                        block95: {
                                                            ** try [egrp 6[TRYBLOCK] [10, 9 : 1319->1445)] { 
lbl136:
                                                            // 1 sources

                                                            break block95;
lbl137:
                                                            // 1 sources

                                                            catch (Exception var7_13) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(45 * 3), (String)"q9]xjof@z}swa[{W{zlw!<") + var7_13.toString());
                                                                break block74;
                                                            }
lbl140:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_16) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.lastIndexOf((int)(56 + 118), (String)"x>Dcsp\u007f[czz|hTr\\r}5,xc") + var7_16.toString());
                                                                break block74;
                                                            }
                                                        }
                                                        if (var6_10.getTrackNumberOnAlbum() == null || var6_10.getTrackNumberOnAlbum().length() <= 0) break block74;
                                                        break block96;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block77;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = Base64.valueOf((String)"=}\u0019<.3:\u001c&973%\u00177\u001b7>(3", (int)(-36 - -15));
                                                    var8_26 = var6_10.getTrackNumberOnAlbum();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block97;
                                                }
lbl155:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block74;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(FileChunk.lastIndexOf((int)(3 * 63), (String)"s\u007fr%")), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                            break;
                                        }
lbl-1000:
                                        // 4 sources

                                        {
                                            while (true) {
                                                block99: {
                                                    block78: {
                                                        block98: {
                                                            if (var6_10.getYearReleased() == null || var6_10.getYearReleased().length() <= 0) ** GOTO lbl58
                                                            break block98;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block78;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = FileChunk.lastIndexOf((int)(86 + -13), (String)"?{\u0012),<\u001d5=72'02");
                                                        var8_26 = var6_10.getYearReleased();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block99;
                                                    }
lbl173:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** continue;
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(Base64.valueOf((String)"tzqx", (int)(30 + 124))), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                                break;
                                            }
                                        }
lbl179:
                                        // 4 sources

                                        while (true) {
                                            try {
                                                block101: {
                                                    block79: {
                                                        block100: {
                                                            if (var6_10.getAlbumTitle() == null || var6_10.getAlbumTitle().length() <= 0) ** GOTO lbl-1000
                                                            break block100;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block79;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = Base64.valueOf((String)"#g\u00164;/6\b4*3e", (int)(7 * 35));
                                                        var8_26 = var6_10.getAlbumTitle();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block101;
                                                    }
lbl192:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** GOTO lbl-1000
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(FileChunk.lastIndexOf((int)(-58 + 89), (String)"qalg")), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                            }
                                            catch (Exception var7_21) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(319 / 90), (String)"u5Dje}d^bxak50") + var7_21.toString());
                                                ** GOTO lbl-1000
                                            }
                                            catch (UnsupportedOperationException var7_22) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"*l\u001f3\"4/\u0017-1*\"ri", (int)(54 + 38)) + var7_22.toString());
                                                ** continue;
                                            }
                                            break;
                                        }
                                        catch (UnsupportedOperationException var7_23) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"'c\u001f142\u0016*-3((g~", (int)(42 - 57)) + var7_23.toString());
                                        }
lbl207:
                                        // 1 sources

                                        catch (Exception var7_24) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"}=^aawVw}fp,7", (int)(57 + -14)) + var7_24.toString());
                                            ** continue;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            v0 /* !! */  = new HashMap<K, V>();
                            ** while (true)
                        }
                        if (!(var5_7 = WMSLoggerFactory.getLogger(MediaReaderMP3.class)).isDebugEnabled()) {
                            var5_7 = null;
                        }
                        this.metaData = null;
                        if (var2_3 <= 0) ** GOTO lbl7
                        if (this.metaData != null) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var5_7 != null) {
                                    for (var6_8 = 0; var6_8 < var2_3; ++var6_8) {
                                        var7_11 = var3_5.getKey(var6_8);
                                        var8_26 = (AMFDataItem)var3_5.get((String)var7_11);
                                        var5_7.debug(FileChunk.lastIndexOf((int)(64 + -52), (String)"ccGK#+2") + (String)var7_11 + "=" + var8_26.toString());
                                    }
                                }
                                var6_9 = new AMFDataList();
                                var6_9.add((AMFData)new AMFDataItem(Base64.valueOf((String)"kkOC;", (int)(322 / 73))));
                                var6_9.add((AMFData)var3_5);
                                var7_11 = var6_9.serialize();
                                this.metaData.add(ByteBuffer.wrap((byte[])var7_11));
                                ** continue;
                                break;
                            }
                        }
                        this.metaData = new ArrayList<E>();
                        ** while (true)
                        catch (Exception var7_25) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"s7KmhnJ~yg|d+2", (int)(45 * 57)) + var7_25.toString());
                            ** continue;
                        }
lbl238:
                        // 1 sources

                        ** GOTO lbl179
                    }
                    var10_28 = (AbstractID3v2Frame)var7_11.next();
                    var11_31 = var10_28.getBody();
                    if (var11_31 == null) ** GOTO lbl28
                    var9_27 = var10_28.getIdentifier();
                    var12_32 = var9_27;
                    if (var12_32.length() > 4) break block102;
lbl246:
                    // 2 sources

                    while (true) {
                        var8_26 = var11_31.getBriefDescription();
                        if (var8_26 == null) ** GOTO lbl28
                        if (this.readAttachedPictures) break block80;
lbl250:
                        // 4 sources

                        while (true) {
                            var13_33 = (Map)var5_7.get(var12_32);
                            if (var13_33 != null) {
                                var14_37 = (String)var13_33.get(Base64.valueOf((String)"~p\u007fv", (int)(-42 - 38)));
                                if (var14_37 == null) {
                                    var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
lbl256:
                                    // 3 sources

                                    while (true) {
                                        ++var2_3;
                                        ** continue;
                                        break;
                                    }
                                }
                                break block81;
                            }
                            var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
                            ** GOTO lbl256
                            break;
                        }
                        break;
                    }
                }
                var12_32 = var12_32.substring(0, 4);
                ** while (true)
            }
            if (!var12_32.equals(FileChunk.lastIndexOf((int)(37 + 81), (String)"\u0017\u0007\u0011\u001a"))) ** GOTO lbl250
            var13_34 = 0;
            var14_38 = 16;
            var15_39 = null;
            var16_40 = null;
            var17_41 = null;
            try {
                var18_42 = (Long)var11_31.getObject(FileChunk.lastIndexOf((int)(621 / 152), (String)"P`~s(Ldhcigaw"));
                if (var18_42 != null) {
                    var13_34 = var18_42.intValue();
                }
                if ((var19_44 = (Long)var11_31.getObject(FileChunk.lastIndexOf((int)(612 / 148), (String)"Tles}{o+Xt~j"))) != null) {
                    var14_38 = var19_44.intValue();
                }
                var15_39 = (String)var11_31.getObject(FileChunk.lastIndexOf((int)(27 * 39), (String)"PWRE!Vzt`"));
                var16_40 = (String)var11_31.getObject(FileChunk.lastIndexOf((int)(47 * 63), (String)"Uw`wg\u007fglpuu"));
                var17_41 = (byte[])var11_31.getObject(Base64.valueOf((String)"C}vbbj|:_}i\u007f", (int)(61 * 15)));
lbl281:
                // 2 sources

                while (true) {
                    if (var17_41 == null) ** GOTO lbl250
                    break;
                }
            }
            catch (Exception var18_43) {
                ** continue;
            }
            {
                var18_42 = new ID3V2FrameAttachedPicture();
                var18_42.setTextEncoding(var13_34);
                var18_42.setPictureType(var14_38);
                var18_42.setPictureData(var17_41);
                if (var15_39 != null) {
                    var18_42.setMimeType(var15_39);
                }
                if (var16_40 != null) {
                    var18_42.setDescription(var16_40);
                }
                this.attachedPictures.put(new Integer(var14_38), (ID3V2FrameAttachedPicture)var18_42);
                ** continue;
            }
        }
        var3_5.put(var14_37, (AMFData)new AMFDataItem(var8_26));
        ** while (true)
    }

    public List getMetadata() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rewind() {
        if (this.bitstream == null) {
            return;
        }
        synchronized (this.lock) {
            this.bitstream.rewind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected long sample2TC(long l) {
        return l * 1000L / (long)this.frequency;
    }

    protected long tc2Sample(long l) {
        return l * (long)this.frequency / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void touchClient() {
        if (this.stream == null) {
            return;
        }
        IClient iClient = this.stream.getClient();
        if (iClient != null) {
            iClient.touch();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlaylistSeekResult seek(long l, int n) {
        MP3StreamPosition mP3StreamPosition;
        long l2;
        long l3;
        PlaylistSeekResult playlistSeekResult = null;
        if (l <= 0L) {
            l = 0L;
        }
        if (!this.fileStream.exists()) {
            return null;
        }
        if (this.duration > 0L) {
            block18: {
                if (l > this.duration) {
                    l = this.duration;
                }
                l3 = -1L;
                l2 = 0L;
                mP3StreamPosition = null;
                if (l <= 0L) {
                    l3 = this.headerOffset;
                    l2 = 0L;
                } else {
                    long l4 = this.headerOffset + this.streamSize * l / this.duration;
                    if (l4 >= this.headerOffset + this.streamSize) {
                        l3 = this.headerOffset + this.streamSize;
                        l2 = this.maxFrames * (long)this.samplesPerFrame;
                    } else {
                        try {
                            mP3StreamPosition = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                            mP3StreamPosition.open();
                            long l5 = 10240L;
                            if (l4 + l5 > mP3StreamPosition.length()) {
                                long l6 = this.maxFrames > 0L ? this.streamSize / this.maxFrames : 256L;
                                if (l6 > 0L && l6 < l4) {
                                    l4 -= l6;
                                }
                                l5 = mP3StreamPosition.length() - l4;
                            }
                            mP3StreamPosition.seek(l4);
                            byte[] byArray = new byte[(int)l5];
                            this.touchClient();
                            mP3StreamPosition.read(byArray, 0, byArray.length);
                            this.touchClient();
                            int n2 = MP3Utils.decodeFirstChunkMP3((byte[])byArray, (int)0, (long)byArray.length, (int)this.bitrate);
                            this.touchClient();
                            if (n2 >= 0) {
                                l3 = l4 + (long)n2;
                                l2 = this.maxFrames * (long)this.samplesPerFrame * l / this.duration;
                                break block18;
                            }
                            if ((double)l * 100.0 / (double)this.duration > 95.0) {
                                l3 = this.headerOffset + this.streamSize;
                                l2 = this.maxFrames * (long)this.samplesPerFrame;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                if (mP3StreamPosition != null) {
                    mP3StreamPosition.close();
                }
            }
            catch (Exception exception) {}
            mP3StreamPosition = null;
            if (l3 >= 0L) {
                playlistSeekResult = new PlaylistSeekResult(0L);
                MP3StreamPosition mP3StreamPosition2 = new MP3StreamPosition(l3, l2);
                playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition2, this.sample2TC(l2), 8, 0);
                playlistSeekResult.setVideoStreamPos(null);
            }
        }
        if (playlistSeekResult != null) return playlistSeekResult;
        l3 = this.headerOffset;
        l2 = 0L;
        playlistSeekResult = new PlaylistSeekResult(0L);
        mP3StreamPosition = new MP3StreamPosition(l3, l2);
        playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition, 0L, 8, 0);
        playlistSeekResult.setVideoStreamPos(null);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMediaReaderStreamPosition getStreamPosition() {
        MP3StreamPosition mP3StreamPosition = new MP3StreamPosition();
        try {
            mP3StreamPosition.setSample(this.currentSample);
            if (this.fileStream == null) return mP3StreamPosition;
            mP3StreamPosition.setFilePos(this.fileStream.getFilePointer());
            return mP3StreamPosition;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"c`rAaeo[cd`{uc(3", (int)(356 / 75)) + exception.toString());
            return mP3StreamPosition;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        MP3StreamPosition mP3StreamPosition = (MP3StreamPosition)iMediaReaderStreamPosition;
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(mP3StreamPosition.getFilePos());
            }
            this.currentSample = mP3StreamPosition.getSample();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(27 * 13), (String)"8%5\u0004*( \u0016(!'>.>wn") + exception.toString());
            return;
        }
    }

    public int rewriteLastPacket(int n, long l, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, long[] lArray, FastPlaySettings fastPlaySettings) {
        return 0;
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        block50: {
            block51: {
                block49: {
                    block59: {
                        block48: {
                            var12_12 = 0;
                            if (this.justID3Tags) {
                                var8_8.setHitEnd(true);
                                return var12_12;
                            }
                            if (this.duration <= 0L) {
                                var8_8.setHitEnd(true);
                                return var12_12;
                            }
                            // MONITORENTER : this.lock
                            if (this.bitstream != null) break block48;
                            var8_8.setHitEnd(true);
                            // MONITOREXIT : var13_13
                            return var12_12;
                        }
                        // MONITOREXIT : var13_13
                        var13_13 = null;
                        var14_14 = 0;
                        var15_16 = var7_7.getMaxTC();
                        var17_17 = var6_6.getLastAudioTC();
                        var19_18 = this.currentSample;
                        try lbl-1000:
                        // 3 sources

                        {
                            while ((var13_13 = this.bitstream.readFrame()) != null) {
                                block57: {
                                    block56: {
                                        block55: {
                                            block53: {
                                                block54: {
                                                    block52: {
                                                        // MONITORENTER : this.lock
                                                        if (var6_6.isBreakLoop()) {
                                                            // MONITOREXIT : var21_19
                                                            break block49;
                                                        }
                                                        var22_21 = var6_6.isSendAbsAudioTC();
                                                        if (this.bitstream.framesize > 0) break block52;
                                                        if (this.bitrateErrorSent) break block53;
                                                        break block54;
                                                    }
                                                    var23_22 = var3_3.getId();
                                                    var24_23 = this.stream.getSrc();
                                                    var25_24 = this.bitstream.framesize + 5;
                                                    var26_25 = 8;
                                                    var27_26 = var3_3;
                                                    var28_27 = var27_26.isNew();
                                                    var29_28 = var28_27 | var22_21;
                                                    var27_26.setNew(false);
                                                    var30_29 = 0L;
                                                    if (!var6_6.isSendAbsAudioTC()) break block55;
                                                    var6_6.setSendAbsAudioTC(false);
                                                    var30_29 = this.sample2TC(var19_18);
                                                    if ((var30_29 += var6_6.getStartTCOffset()) < 0L) {
                                                        this.bitstream.closeFrame();
                                                        // MONITOREXIT : var21_19
                                                        continue;
                                                    }
                                                    break block56;
                                                }
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"\\ww}tDry}\u007fiQM-173+7!\u0015'$#,>8vm\u0000*70&:\"0v1*87>|.7%%aj", (int)(45 * 21)) + this.bitstream.framesize + FileChunk.lastIndexOf((int)(127 + 90), (String)"pt{\u0011<'\u007f\"$b'1 f3'i?%?8>??#&60u\u001b\u0007ky82(/?+e!jjcmcu(}bjb-?=(1yqdf8"));
                                                this.bitrateErrorSent = true;
                                            }
                                            // MONITOREXIT : var21_19
                                            break block49;
                                        }
                                        var30_29 = this.sample2TC(var19_18) - var17_17;
                                    }
                                    var6_6.setLastAudioTC(var17_17 += var30_29);
                                    var6_6.incAudioPacketCount();
                                    var6_6.setLastTC(var17_17);
                                    this.currentSample = var19_18 += (long)this.samplesPerFrame;
                                    var8_8.setLastTC(var17_17);
                                    var8_8.incAudioPackets();
                                    ++var14_14;
                                    var32_30 = 1;
                                    if (var11_11) {
                                        var30_29 = 0L;
                                    }
                                    this.workBuffer[0] = (byte)(255 & var23_22);
                                    if (var29_28 || var27_26.getSrc() != var24_23) {
                                        this.workBuffer[8] = (byte)(255 & var24_23);
                                        this.workBuffer[9] = (byte)(255 & var24_23 >> 8);
                                        this.workBuffer[10] = (byte)(255 & var24_23 >> 16);
                                        this.workBuffer[11] = (byte)(255 & var24_23 >> 24);
                                        var27_26.setSrc(var24_23);
                                        var32_30 += 4;
                                        var29_28 = true;
                                    }
                                    if (var29_28 || var27_26.getSize() == var25_24) {
                                        // empty if block
                                    }
                                    this.workBuffer[4] = (byte)(255 & var25_24 >> 16);
                                    this.workBuffer[5] = (byte)(255 & var25_24 >> 8);
                                    this.workBuffer[6] = (byte)(255 & var25_24);
                                    this.workBuffer[7] = (byte)var26_25;
                                    var27_26.setSize(var25_24);
                                    var27_26.setType(var26_25);
                                    var32_30 += 4;
                                    var29_28 = true;
                                    var33_31 = false;
                                    if (var29_28 || var27_26.getTimecode() != var30_29) {
                                        if (var30_29 >= 0xFFFFFFL) {
                                            this.workBuffer[1] = -1;
                                            this.workBuffer[2] = -1;
                                            this.workBuffer[3] = -1;
                                            var33_31 = true;
                                        } else {
                                            this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                            this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                            this.workBuffer[3] = (byte)(255L & var30_29);
                                        }
                                        var27_26.setTimecode(var30_29);
                                        var32_30 += 3;
                                        var29_28 = true;
                                    }
                                    if (AMFObj.AMFDEBUGHEADERSIZE) {
                                        var34_33 = FileChunk.lastIndexOf((int)(11 * 23), (String)"\u001c\u0013\u0019DD@VCMCFLLXXEWKT]tvzuGsv||hVL.$&og31Y?&") + var32_30;
                                        if (var32_30 <= 4) {
                                            WMSLoggerFactory.getLogger(null).error(var34_33);
                                        } else {
                                            WMSLoggerFactory.getLogger(null).info(var34_33);
                                        }
                                    }
                                    if (var23_22 < 64) break block57;
                                    var34_32 = new byte[2];
                                    switch (var32_30) {
                                        case 1: {
                                            var34_32[0] = -64;
                                            break;
                                        }
                                        case 8: {
                                            var34_32[0] = 64;
                                            break;
                                        }
                                        case 4: {
                                            var34_32[0] = -128;
                                            break;
                                        }
                                        case 12: {
                                            var34_32[0] = 0;
                                        }
                                    }
                                    var34_32[1] = (byte)(var23_22 - 64 & 255);
                                    var2_2.write(var34_32, 0, 2);
                                    var2_2.write(this.workBuffer, 1, var32_30 - 1);
                                    var12_12 += var32_30 + 1;
                                    ** break;
                                }
                                switch (var32_30) {
                                    case 12: {
                                        break;
                                    }
                                    case 4: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 128);
                                        break;
                                    }
                                    case 8: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 64);
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                    case 1: {
                                        this.workBuffer[0] = (byte)(this.workBuffer[0] | 192);
                                    }
                                }
                                var2_2.write(this.workBuffer, 0, var32_30);
                                var12_12 += var32_30;
                                ** break;
lbl150:
                                // 2 sources

                                if (var33_31) {
                                    this.workBuffer[0] = (byte)(255L & var30_29 >> 24);
                                    this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                    this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                    this.workBuffer[3] = (byte)(255L & var30_29);
                                    var2_2.write(this.workBuffer, 0, 4);
                                    var12_12 = 4;
                                }
                                var13_13.getSyncHeader(this.syncHeader);
                                var2_2.write(this.packetHeader, 0, 1);
                                ++var12_12;
                                var2_2.write(this.syncHeader, 0, 4);
                                var12_12 += 4;
                                var9_9[1] = var9_9[1] + 1L;
                                if (var25_24 > 0) {
                                    var34_34 = this.bitstream.framesize;
                                    var35_35 = 0;
                                    var36_36 = 0;
                                    var37_37 = 5;
lbl168:
                                    // 2 sources

                                    while (var37_37 == 0) {
                                        if (var23_22 >= 64) {
                                            this.workBuffer[0] = -64;
                                            this.workBuffer[1] = (byte)(var23_22 - 64 & 255);
                                            var2_2.write(this.workBuffer, 0, 2);
                                            var12_12 += 2;
                                        } else {
                                            this.workBuffer[0] = (byte)(255 & var23_22 | 192);
                                            var2_2.write(this.workBuffer, 0, 1);
                                            ++var12_12;
                                        }
                                        if (var33_31) {
                                            this.workBuffer[0] = (byte)(255L & var30_29 >> 24);
                                            this.workBuffer[1] = (byte)(255L & var30_29 >> 16);
                                            this.workBuffer[2] = (byte)(255L & var30_29 >> 8);
                                            this.workBuffer[3] = (byte)(255L & var30_29);
                                            var2_2.write(this.workBuffer, 0, 4);
                                            var12_12 = 4;
                                        }
                                        break block50;
                                    }
                                    break block50;
                                }
                                ** GOTO lbl203
                            }
                            break block49;
                        }
                        catch (Exception var21_20) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"swosmYkhghz|*1", (int)(1168 / 243)) + var21_20.toString());
                            var21_20.printStackTrace();
                            break block51;
                        }
lbl196:
                        // 1 sources

                        while (var14_14 > 0) {
                            // MONITOREXIT : var21_19
                            break block49;
                        }
                        break block59;
lbl200:
                        // 1 sources

                        while (true) {
                            var37_37 = 0;
                            if ((var35_35 += var36_36) != var34_34) ** GOTO lbl168
lbl203:
                            // 2 sources

                            this.bitstream.closeFrame();
                            if (var15_16 == 0L) ** GOTO lbl196
                            if (var17_17 < var15_16) break;
                            // MONITOREXIT : var21_19
                            break block49;
                            break;
                        }
                    }
                    // MONITOREXIT : var21_19
                    ** GOTO lbl-1000
                }
                if (var13_13 == null) {
                    var8_8.setHitEnd(true);
                }
            }
            var8_8.setTotalSize(var12_12);
            var9_9[0] = var9_9[0] + (long)var12_12;
            return var12_12;
lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2.write(this.bitstream.frame_bytes, var35_35, var36_36);
                    var12_12 += var36_36;
                    ** continue;
                    break;
                }
            }
        }
        if ((var36_36 = var6_6.getWriteControl().getChunkSize() - var37_37) <= var34_34 - var35_35) ** GOTO lbl-1000
        var36_36 = var34_34 - var35_35;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        long l = 0L;
        if (this.duration >= 0L) {
            return this.duration;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        Bitstream bitstream = null;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            bitstream = new Bitstream(iRandomAccessReader);
            Header header = bitstream.readFrame();
            if (header != null) {
                n = header.frequency();
                n2 = header.samples_per_frame();
                long l4 = bitstream.header_pos();
                long l5 = bitstream.tail_size();
                l2 = iRandomAccessReader.length() - l4 - l5;
                bl = header.vbr();
                int n3 = header.max_number_of_frames((int)l2);
                l3 = n > 0 ? Math.round(1000.0 * (double)n2 * (double)n3 / (double)n) : 0L;
                bitstream.closeFrame();
            }
            bitstream.close();
            iRandomAccessReader.close();
            l = l3;
        }
        catch (Exception exception) {}
        if (this.calculateMoreAccurateFrameSize && !bl) {
            double d;
            int n4;
            int n5;
            long l6;
            try {
                bitstream.rewind();
                l6 = -1L;
                n5 = 0;
                n4 = 0;
            }
            catch (Exception exception) {
            }
            while (true) {
                if (l6 > 0L) {
                    int n6 = (int)(iRandomAccessReader.getFilePointer() - l6);
                    n5 += n6;
                    if (++n4 > this.calculateMoreAccurateFrameWindow) break;
                }
                l6 = iRandomAccessReader.getFilePointer();
                Header header = bitstream.readFrame();
                if (header == null) break;
                bitstream.closeFrame();
            }
            if (n4 > 0 && !((d = (double)n5 / (double)n4) <= 0.0)) {
                int n7 = (int)Math.round((double)l2 / d);
                if (n > 0) {
                    l3 = Math.round(1000.0 * (double)n2 * (double)n7 / (double)n);
                }
                l = l3;
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.fileStream == null) return 0L;
        long l = this.fileStream.length();
        return l;
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        synchronized (this.lock) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket createPacket(Header header) {
        int n = 8;
        AMFPacket aMFPacket = new AMFPacket(n, 0, this.bitstream.framesize + 4 + 1);
        try {
            byte[] byArray = aMFPacket.getData();
            byArray[0] = this.packetHeader[0];
            header.getSyncHeader(this.syncHeader);
            aMFPacket.addDataEx(this.syncHeader, 0, 1, 4);
            aMFPacket.addDataEx(this.bitstream.frame_bytes, 0, 5, this.bitstream.framesize);
            return aMFPacket;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.lastIndexOf((int)(95 + -32), (String)"R%%+\"\u0016 '#-;\u0007\u001b\u007fc-=50&6\u000445<=-`{") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
    }
}

