/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.lang.Entities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.lang.text.StrBuilder;

public class StringEscapeUtils {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    public static String escapeJava(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, false, false);
    }

    public static void escapeJava(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, false, false);
    }

    public static String escapeJavaScript(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, true, true);
    }

    public static void escapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, true, true);
    }

    private static String escapeJavaStyleString(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(stringWriter, string, bl, bl2);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    private static void escapeJavaStyleString(Writer writer, String string, boolean bl, boolean bl2) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                writer.write("\\u" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c > '\u00ff') {
                writer.write("\\u0" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c > '\u007f') {
                writer.write("\\u00" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            writer.write("\\u00" + StringEscapeUtils.hex(c));
                            break;
                        }
                        writer.write("\\u000" + StringEscapeUtils.hex(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    if (bl) {
                        writer.write(92);
                    }
                    writer.write(39);
                    continue block13;
                }
                case '\"': {
                    writer.write(92);
                    writer.write(34);
                    continue block13;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block13;
                }
                case '/': {
                    if (bl2) {
                        writer.write(92);
                    }
                    writer.write(47);
                    continue block13;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringEscapeUtils.unescapeJava(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    public static void unescapeJava(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StrBuilder strBuilder = new StrBuilder(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                strBuilder.append(c);
                if (strBuilder.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(strBuilder.toString(), 16);
                    writer.write((char)n2);
                    strBuilder.setLength(0);
                    bl2 = false;
                    bl = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NestableRuntimeException("Unable to parse unicode value: " + strBuilder, numberFormatException);
                }
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            writer.write(c);
        }
        if (bl) {
            writer.write(92);
        }
    }

    public static String unescapeJavaScript(String string) {
        return StringEscapeUtils.unescapeJava(string);
    }

    public static void unescapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.unescapeJava(writer, string);
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            StringEscapeUtils.escapeHtml(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    public static void escapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.escape(writer, string);
    }

    public static String unescapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            StringEscapeUtils.unescapeHtml(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    public static void unescapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.unescape(writer, string);
    }

    public static void escapeXml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.XML.escape(writer, string);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        return Entities.XML.escape(string);
    }

    public static void unescapeXml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.XML.unescape(writer, string);
    }

    public static String unescapeXml(String string) {
        if (string == null) {
            return null;
        }
        return Entities.XML.unescape(string);
    }

    public static String escapeSql(String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.replace(string, "'", "''");
    }

    public static String escapeCsv(String string) {
        if (StringUtils.containsNone(string, CSV_SEARCH_CHARS)) {
            return string;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StringEscapeUtils.escapeCsv(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    public static void escapeCsv(Writer writer, String string) throws IOException {
        if (StringUtils.containsNone(string, CSV_SEARCH_CHARS)) {
            if (string != null) {
                writer.write(string);
            }
            return;
        }
        writer.write(34);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                writer.write(34);
            }
            writer.write(c);
        }
        writer.write(34);
    }

    public static String unescapeCsv(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StringEscapeUtils.unescapeCsv(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new UnhandledException(iOException);
        }
    }

    public static void unescapeCsv(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() < 2) {
            writer.write(string);
            return;
        }
        if (string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\"') {
            writer.write(string);
            return;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (StringUtils.containsAny(string2, CSV_SEARCH_CHARS)) {
            string = StringUtils.replace(string2, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR);
        }
        writer.write(string);
    }
}

