/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;

public class ReadThrottleFilterBuilder {
    public static final String COUNTER = ReadThrottleFilterBuilder.class.getName() + ".counter";
    public static final String SUSPENDED_READS = ReadThrottleFilterBuilder.class.getName() + ".suspendedReads";
    private volatile int maximumConnectionBufferSize = 0x100000;

    public void setMaximumConnectionBufferSize(int n) {
        this.maximumConnectionBufferSize = n;
    }

    public void attach(IoFilterChain ioFilterChain) {
        String string = this.getThreadPoolFilterEntryName(ioFilterChain.getAll());
        ioFilterChain.addBefore(string, this.getClass().getName() + ".add", new Add());
        ioFilterChain.addAfter(string, this.getClass().getName() + ".release", new Release());
    }

    public void attach(DefaultIoFilterChainBuilder defaultIoFilterChainBuilder) {
        String string = this.getThreadPoolFilterEntryName(defaultIoFilterChainBuilder.getAll());
        defaultIoFilterChainBuilder.addBefore(string, this.getClass().getName() + ".add", new Add());
        defaultIoFilterChainBuilder.addAfter(string, this.getClass().getName() + ".release", new Release());
    }

    private String getThreadPoolFilterEntryName(List list) {
        for (IoFilterChain.Entry entry : list) {
            if (!entry.getFilter().getClass().isAssignableFrom(ExecutorFilter.class)) continue;
            return entry.getName();
        }
        throw new IllegalStateException("Chain does not contain a ExecutorFilter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(IoSession ioSession, int n) {
        IoSession ioSession2 = ioSession;
        synchronized (ioSession2) {
            int n2 = this.getCounter(ioSession) + n;
            ioSession.setAttribute(COUNTER, new Integer(n2));
            if (n2 >= this.maximumConnectionBufferSize && ioSession.getTrafficMask().isReadable()) {
                ioSession.suspendRead();
                ioSession.setAttribute(SUSPENDED_READS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(IoSession ioSession, int n) {
        IoSession ioSession2 = ioSession;
        synchronized (ioSession2) {
            int n2 = Math.max(0, this.getCounter(ioSession) - n);
            ioSession.setAttribute(COUNTER, new Integer(n2));
            if (n2 < this.maximumConnectionBufferSize && this.isSuspendedReads(ioSession)) {
                ioSession.resumeRead();
            }
            ioSession.removeAttribute(SUSPENDED_READS);
        }
    }

    private boolean isSuspendedReads(IoSession ioSession) {
        Boolean bl = (Boolean)ioSession.getAttribute(SUSPENDED_READS);
        return null != bl && bl != false;
    }

    private int getCounter(IoSession ioSession) {
        Integer n = (Integer)ioSession.getAttribute(COUNTER);
        return null == n ? 0 : n;
    }

    private class Add
    extends IoFilterAdapter {
        private Add() {
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
            if (object instanceof ByteBuffer) {
                ReadThrottleFilterBuilder.this.add(ioSession, ((ByteBuffer)object).remaining());
            }
            nextFilter.messageReceived(ioSession, object);
        }
    }

    private class Release
    extends IoFilterAdapter {
        private Release() {
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
            if (object instanceof ByteBuffer) {
                ReadThrottleFilterBuilder.this.release(ioSession, ((ByteBuffer)object).capacity());
            }
            nextFilter.messageReceived(ioSession, object);
        }
    }
}

