/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerApplicationContextCupertinoStreamer;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerCupertinoIndexBase
implements IHTTPStreamerCupertinoIndex {
    protected List<IHTTPStreamerCupertinoIndexItem> items = new ArrayList<IHTTPStreamerCupertinoIndexItem>();
    protected String titleStr = "";
    protected CupertinoEncInfo encInfo = null;
    protected IHTTPStreamerApplicationContext appContext = null;
    protected IApplicationInstance appInstance = null;
    protected String streamExt = null;
    protected String streamName = null;
    protected IMediaStream stream = null;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected int chunkDurationTarget = 10000;
    protected boolean init = true;
    protected boolean relativePlaylistItems = true;
    protected boolean relativePlaylistPlaylists = true;
    protected int streamMode = 1;
    protected int audioBitrate = -1;
    protected int audioCodec = 10;
    protected int videoBitrate = -1;
    protected double duration = 0.0;
    protected WMSProperties properties = new WMSProperties();
    protected long playStart = 0L;
    protected long playDuration = -1L;
    protected MediaCodecInfoVideo codecInfoVideo = new MediaCodecInfoVideo();
    protected MediaCodecInfoAudio codecInfoAudio = new MediaCodecInfoAudio();

    @Override
    public void init(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3, long l, long l2) {
        this.appContext = iHTTPStreamerApplicationContext;
        this.appInstance = iHTTPStreamerApplicationContext.getAppInstance();
        this.streamExt = string2;
        this.streamName = string3;
        this.httpStreamerSession = iHTTPStreamerSession;
        this.playStart = l;
        this.playDuration = l2;
        this.codecInfoVideo.setCodecId(7);
        this.codecInfoAudio.setCodecId(10);
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean(Base64.regionMatches((String)"\u007fkcqe{eqEzvaushhTjzmr", (int)(21 * 25)), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean(FileChunk.getChars((int)(1155 / 182), (String)"tbdh~bzh^cqh~zga_c}ti"), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean(Base64.regionMatches((String)"4-)?)(400RdnbplpbXekr`d}{Yew~g", (int)(13 * 19)), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean(Base64.regionMatches((String)">+/%36***\u0014\"$(>\":(\u001e#1(>:'!\u001f#=4)", (int)(61 * 33)), this.relativePlaylistItems);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(1032 / 169), (String)"tbdh~bzh^cqh~zgaF{y`vroim"), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean(FileChunk.getChars((int)(87 + -81), (String)"tbdh~bzh^cqh~zgaF{y`vroim"), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean(Base64.regionMatches((String)")><(<;9?=\u0001197#1/?\u000b0<'3irvShd\u007fkaz~x", (int)(110 + 124)), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean(Base64.regionMatches((String)"`qucu|`dd^hbndxdvDywntpioLq\u007fflhqww", (int)(665 / 200)), this.relativePlaylistPlaylists);
    }

    @Override
    public String getStreamNameByBitrate(long l) {
        return this.streamName;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String adjustStreamName(String string) {
        String string2 = "";
        String string3 = Base64.regionMatches((String)"6,i", (int)(15 + 108));
        if ((string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, this.httpStreamerSession)) == null) return string;
        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string3);
        string = stringArray[0];
        string3 = stringArray[1];
        boolean bl = string.indexOf(FileChunk.getChars((int)(25 + 17), (String)"0$#")) >= 0;
        int n = string.indexOf("?");
        if (bl) return string;
        if (n < 0) return string;
        string2 = string.substring(n + 1);
        return string.substring(0, n);
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public IHTTPStreamerApplicationContext getApplicationContext() {
        return this.appContext;
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.streamName);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        String string = hTTPStreamerCupertinoIndexBase.adjustStreamName(hTTPStreamerCupertinoIndexBase.streamName);
        if (string == null) {
            return arrayList;
        }
        arrayList.add(string);
        return arrayList;
    }

    @Override
    public List<Long> getStreamBitrates() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(Long.valueOf(this.videoBitrate + this.audioBitrate));
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public LiveStreamPacketizerCupertinoChunk getChunk(String string, boolean bl) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = null;
        int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
        if (n <= 0) return liveStreamPacketizerCupertinoChunk;
        int n2 = n - 1;
        IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = n2 < this.items.size() ? this.items.get(n - 1) : null;
        if (iHTTPStreamerCupertinoIndexItem == null) {
            return liveStreamPacketizerCupertinoChunk;
        }
        liveStreamPacketizerCupertinoChunk = new LiveStreamPacketizerCupertinoChunk(n);
        this.fillChunk(iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
        return liveStreamPacketizerCupertinoChunk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (!this.init) {
            return;
        }
        WMSProperties wMSProperties = this.appContext.getProperties();
        WMSProperties wMSProperties2 = this.appContext.getAppInstance().getHTTPStreamerProperties();
        this.chunkDurationTarget = wMSProperties.getPropertyInt(Base64.regionMatches((String)"\u007fukqkEwqeqohf]kykhz", (int)(24 + 4)), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties2.getPropertyInt(FileChunk.getChars((int)(45 + -22), (String)"tpltpXhl~thmmPdt`m}"), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties.getPropertyInt(FileChunk.getChars((int)(-38 - 48), (String)"i~|h|{y\u007f}P|`x|\\lhzhtqq\u0014 0$!1"), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties2.getPropertyInt(Base64.regionMatches((String)"gpvbz}cecNfz~zVfftb~wwNznz{k", (int)(88 + 76)), this.chunkDurationTarget);
        this.init = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        Object object;
        String string;
        String string2 = null;
        CupertinoEncInfo cupertinoEncInfo = iHTTPStreamerCupertinoIndexItem.getEncInfo();
        if (cupertinoEncInfo == null) {
            return string2;
        }
        int n = cupertinoEncInfo.getEncMethod();
        if (!CupertinoEncInfo.isMethodReportedInPlaylist(n)) {
            return string2;
        }
        if (CupertinoEncInfo.isMethodReportedWithKeyHeader(n)) {
            string = cupertinoEncInfo.getEncUrl();
            if (string == null) {
                return string2;
            }
            object = "";
            byte[] byArray = cupertinoEncInfo.getEncIVBytes();
            if (byArray != null) {
                object = (String)object + FileChunk.getChars((int)(19 * 21), (String)"#YG/#l") + BufferUtils.encodeHexString((byte[])byArray);
            }
            if (cupertinoEncInfo.getEncKeyFormat() != null) {
                object = (String)object + FileChunk.getChars((int)(25 * 25), (String)"}\u0019\u0016\r\u0013\u0019\u0005\u0015\u0018\u000ef~") + cupertinoEncInfo.getEncKeyFormat() + "\"";
            }
            if (cupertinoEncInfo.getEncKeyFormatVersion() != null) {
                object = (String)object + Base64.regionMatches((String)"*LMPLD^@O[FT@@]ZX*:", (int)(447 / 65)) + cupertinoEncInfo.getEncKeyFormatVersion() + "\"";
            }
            string2 = Base64.regionMatches((String)"2WK@8N:S\\C!QXJWOE?xakejm}bdhp\"ZBX/1opxts|cnnqc=", (int)(5 * 29)).replace("{encmethod}", CupertinoEncInfo.encMethodToString(cupertinoEncInfo.getEncMethod())) + (String)object + "\n";
            String string3 = "?";
            if (string.indexOf("?") >= 0) {
                string3 = "&";
            }
            string2 = string2.replace(FileChunk.getChars((int)(25 * 31), (String)"|mgi`it{}|l"), string + string3 + FileChunk.getChars((int)(27 * 51), (String)":36!7?:"));
        }
        if (!CupertinoEncInfo.isMethodReportedWithPlayReadyHeader(n)) return string2;
        string = cupertinoEncInfo.getEncPlayReadyHeader();
        if (string == null) {
            return string2;
        }
        string2 = "";
        object = cupertinoEncInfo.getEncIVBytes();
        if (object == null) return string2 + FileChunk.getChars((int)(3 * 55), (String)"&C_\\$R&ECG\"@CZWF/mgtxcIy|zf\b$#'!7;").replace("{playReadyHeader}", string) + "\n";
        string2 = string2 + Base64.regionMatches((String)":_CH0F2\u000b\u0004\u001byh\f\u0010zx1", (int)(-37 - 34)) + BufferUtils.encodeHexString((byte[])object) + "\n";
        return string2 + FileChunk.getChars((int)(3 * 55), (String)"&C_\\$R&ECG\"@CZWF/mgtxcIy|zf\b$#'!7;").replace("{playReadyHeader}", string) + "\n";
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPlaylistStr(boolean bl) {
        this.init();
        StringBuffer stringBuffer = new StringBuffer();
        String string = Math.round(this.chunkDurationTarget / 1000) + "";
        int n = 3;
        if (this.appContext != null && this.appContext instanceof HTTPStreamerApplicationContextCupertinoStreamer) {
            n = ((HTTPStreamerApplicationContextCupertinoStreamer)this.appContext).getExtXVersion();
        }
        stringBuffer.append(FileChunk.getChars((int)(653 / 113), (String)"&C_\\D9^\u0006"));
        if (n > 0) {
            stringBuffer.append(FileChunk.getChars((int)(-37 - 7), (String)"w\u0010\u000e\u0003u\u0001w\r\u0019\u000f\r\u0016\u000f\u000fx8!=2j0d<.>>' >,").replace("{ext-x-version}", n + "") + "\n");
        }
        long l = 10L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {}
        long l2 = 0L;
        Iterator<IHTTPStreamerCupertinoIndexItem> iterator = this.items.iterator();
        if (this.items.size() > 0) {
            l2 = this.items.get(0).getStartTimecode();
        }
        while (iterator.hasNext()) {
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = iterator.next();
            int n2 = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l2) / 1000.0);
            if (n2 <= 0) {
                n2 = 1;
            }
            if ((long)n2 > l) {
                l = n2;
            }
            l2 += (long)(n2 * 1000);
        }
        stringBuffer.append(Base64.regionMatches((String)";\\BO1E3KASEFPASUI]CDB7", (int)(79 + -55)) + l + "" + "\n");
        stringBuffer.append(FileChunk.getChars((int)(-14 - 40), (String)"i\u000e\u0014\u0019c\u0017}\u001c\u0017\u0017\u001d\u0014{\u0004\u001d\b\u000f\u001e\u0012\u001e\u001beqK"));
        String string2 = "";
        String string3 = Base64.regionMatches((String)"i`bni", (int)(511 / 106));
        long l3 = 0L;
        long l4 = 0L;
        Iterator<IHTTPStreamerCupertinoIndexItem> iterator2 = this.items.iterator();
        if (this.items.size() > 0) {
            l3 = this.items.get(0).getStartTimecode();
        }
        while (true) {
            int n3;
            if (!iterator2.hasNext()) {
                stringBuffer.append(FileChunk.getChars((int)(453 / 98), (String)"'@^S%Q'NBIBFCE\u0018"));
                return stringBuffer.toString();
            }
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = iterator2.next();
            String string4 = this.a(iHTTPStreamerCupertinoIndexItem);
            if (string4 != null && !string4.equals(string2)) {
                stringBuffer.append(string4);
                string2 = string4;
            }
            if ((n3 = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l3) / 1000.0)) <= 0) {
                n3 = 1;
            }
            l3 += (long)(n3 * 1000);
            ++l4;
            String string5 = this.relativePlaylistItems ? FileChunk.getChars((int)(63 + 98), (String)"zdjh`hfelw4w|{jbho") : FileChunk.getChars((int)(-14 - -31), (String)"jv|yt\u007fye6azlmrvc`vjkk{(shz{Ec}{q\u007fqvi:mdlk\u007fzq`1d&(.&*$+\"5v1:9(<6-");
            int n4 = this.streamMode;
            if (bl) {
                switch (this.audioCodec) {
                    case 1: {
                        n4 = 4;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 10: {
                        n4 = 3;
                        break;
                    }
                }
            }
            stringBuffer.append(Base64.regionMatches((String)"%BP]CEJ7", (int)(466 / 75)) + n3 + "," + this.titleStr + "\n");
            stringBuffer.append(string5.replace(FileChunk.getChars((int)(10 + -4), (String)"}aaeoem`kr"), "{mediaName}{bitrate}_{index}{ext}".replace(FileChunk.getChars((int)(9 * 37), (String)"6#*483\u001d583*"), string3).replace(Base64.regionMatches((String)"}nfmosq", (int)(1369 / 224)), l4 + "")).replace(FileChunk.getChars((int)(50 + 32), (String)")6,!+"), LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(n4)) + "\n");
        }
    }

    @Override
    public int addIndexItem(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        this.items.add(iHTTPStreamerCupertinoIndexItem);
        return this.items.size() - 1;
    }

    @Override
    public int getIndexCount() {
        return this.items.size();
    }

    @Override
    public IHTTPStreamerCupertinoIndexItem getIndexItem(int n) {
        if (n >= this.items.size()) {
            return null;
        }
        return this.items.get(n);
    }

    @Override
    public String getTitleStr() {
        return this.titleStr;
    }

    @Override
    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDoEncryption() {
        if (this.encInfo == null) return false;
        return true;
    }

    @Override
    public CupertinoEncInfo getEncInfo() {
        return this.encInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getEncURL() {
        if (this.encInfo == null) {
            return null;
        }
        String string = this.encInfo.getEncUrl();
        return string;
    }

    @Override
    public IHTTPStreamerSession getHttpStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int getStreamMode() {
        return this.streamMode;
    }

    @Override
    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    @Override
    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    @Override
    public int getID3Bitrate(boolean bl) {
        return 0;
    }

    @Override
    public void setAudioBitrate(int n) {
        this.audioBitrate = n;
    }

    @Override
    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    @Override
    public void setVideoBitrate(int n) {
        this.videoBitrate = n;
    }

    @Override
    public int getAudioCodec() {
        return this.audioCodec;
    }

    @Override
    public void setAudioCodec(int n) {
        this.audioCodec = n;
    }

    @Override
    public ID3Frames getID3FramesHeader() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooter() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesHeaderAudio() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooterAudio() {
        return null;
    }

    @Override
    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    @Override
    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getCodecsStr() {
        String string = null;
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        String string2 = hTTPStreamerCupertinoIndexBase.a(hTTPStreamerCupertinoIndexBase.codecInfoAudio);
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase2 = this;
        String string3 = hTTPStreamerCupertinoIndexBase2.a(hTTPStreamerCupertinoIndexBase2.codecInfoVideo);
        if (string3 != null && string2 != null) {
            return string3 + FileChunk.getChars((int)(213 / 46), (String)"(%") + string2;
        }
        if (string3 != null) {
            return string3;
        }
        if (string2 == null) return null;
        return string2;
    }

    @Override
    public String getCodecsAudioStr() {
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        return hTTPStreamerCupertinoIndexBase.a(hTTPStreamerCupertinoIndexBase.codecInfoAudio);
    }

    @Override
    public String getResolutionStr() {
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        return hTTPStreamerCupertinoIndexBase.b(hTTPStreamerCupertinoIndexBase.codecInfoVideo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 10: {
                if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
                return FileChunk.getChars((int)(834 / 193), (String)"iu2f&=:%") + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 2: 
        }
        return Base64.regionMatches((String)"xf#y7.+2", (int)(1 - -52)) + mediaCodecInfoAudio.getAudioObjectType();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            default: {
                return string;
            }
            case 7: 
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return Base64.regionMatches((String)"'1+xd", (int)(71 + 127)) + n2 + "." + n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String b(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double d) {
        this.duration = d;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public long getPlayStart() {
        return this.playStart;
    }

    @Override
    public void setPlayStart(long l) {
        this.playStart = l;
    }

    @Override
    public long getPlayDuration() {
        return this.playDuration;
    }

    @Override
    public void setPlayDuration(long l) {
        this.playDuration = l;
    }

    @Override
    public abstract void fillChunk(IHTTPStreamerCupertinoIndexItem var1, LiveStreamPacketizerCupertinoChunk var2, boolean var3);
}

