/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncryptorBase;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264Utils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CupertinoEncryptorSampleAES
extends CupertinoEncryptorBase {
    public static final int BLOCKSIZE = 16;
    public static final int VIDEO_ENC_INTERVAL = 10;
    public static final int VIDEO_MIN_NALUNIT_SIZE = 48;
    public static final int VIDEO_SKIPHEADER_SIZE = 32;
    public static final int AUDIO_AAC_SKIPHEADER_SIZE = 23;
    public static final int AUDIO_AAC_MIN_FRAME_SIZE = 39;
    public static final int AUDIO_AC3_SKIPHEADER_SIZE = 16;
    public static final int AUDIO_AC3_MIN_FRAME_SIZE = 32;
    private CupertinoEncInfo a = null;
    private SecretKeySpec b = null;
    private Cipher c = null;
    private byte[] d = new byte[16];
    private IvParameterSpec e = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(CupertinoEncInfo cupertinoEncInfo, int n, int n2) {
        this.a = cupertinoEncInfo;
        this.b = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), Base64.regionMatches((String)"FMZ", (int)(120 + 15)));
        if (cupertinoEncInfo.getEncIVBytes() != null) {
            System.arraycopy(cupertinoEncInfo.getEncIVBytes(), 0, this.d, 0, Math.min(cupertinoEncInfo.getEncIVBytes().length, this.d.length));
        } else {
            BufferUtils.longToByteArray((long)n, (byte[])this.d, (int)8, (int)8);
        }
        this.e = new IvParameterSpec(this.d);
        try {
            this.c = Cipher.getInstance(FileChunk.getChars((int)(43 * 25), (String)"RQF9TZZ5UsM\u007f{$(,$"), "BC");
            this.c.init(1, (Key)this.b, this.e);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(FileChunk.getChars((int)(43 + -5), (String)"Erxlx\u007fecaJ~r`jdayeKxwkpx_Z\u0013o+--1|g") + exception.toString());
            return;
        }
    }

    public void close() {
        this.b = null;
        this.c = null;
    }

    public boolean isChunkEncryptor() {
        return false;
    }

    public boolean isSampleEncryptor() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encryptVideoNALUnit(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        if (n2 <= 48) return byArray2;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = 32;
        int n4 = (n2 - n3) / 16;
        if ((n2 - n3) % 16 == 0) {
            --n4;
        }
        try {
            this.c.init(1, (Key)this.b, this.e);
            for (int i = 0; i < n4; n3 += 16, ++i) {
                if (i % 10 != 0) continue;
                this.c.update(byArray2, n3, 16, byArray2, n3);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.regionMatches((String)"Rgcqgb~vv_u\u007fogotnpPehvkmHOX\"h`lbhbgB|rrwW[WIswk\u001b$, 6<63\u0015sj", (int)(8 + 9)) + exception.toString());
        }
        if (!H264Utils.needsNALEscape((byte[])byArray2, (int)0, (int)byArray2.length)) return byArray2;
        return H264Utils.nalEscape((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encryptAudioFrame(int n, byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2 = null;
        switch (n) {
            case 1: {
                if (n3 + n4 < 32) return byArray2;
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                int n5 = 16 - n4;
                int n6 = (n3 - n5) / 16;
                try {
                    this.c.init(1, (Key)this.b, this.e);
                    int n7 = 0;
                    while (n7 < n6) {
                        this.c.update(byArray2, n5, 16, byArray2, n5);
                        n5 += 16;
                        ++n7;
                    }
                    return byArray2;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(FileChunk.getChars((int)(28 + 90), (String)"\u0015\"(<(/531\u001anbpztqiu[hg{`hOJC?w}wgoglXo\u007furXmalgXakeuqy~V6-") + exception.toString());
                    break;
                }
            }
            case 10: {
                if (n3 + n4 < 39) return byArray2;
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                int n8 = 23 - n4;
                int n9 = (n3 - n8) / 16;
                try {
                    this.c.init(1, (Key)this.b, this.e);
                    int n10 = 0;
                    while (n10 < n9) {
                        this.c.update(byArray2, n8, 16, byArray2, n8);
                        n8 += 16;
                        ++n10;
                    }
                    break;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.regionMatches((String)"Erxlx\u007fecaJ~r`jdayeKxwkpx_ZS/gmgw\u007fw|H\u007foebH}q|wHq{ueainF&=", (int)(223 / 34)) + exception.toString());
                }
            }
        }
        return byArray2;
    }
}

