/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean a = true;
    private PacketTimecodeDebug b = null;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{10, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(true);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(false);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(byArray, 0, byArray.length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            Object var18_19 = null;
            aMFPacket4 = null;
            ResponseFunction responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createSeekMessage(Base64.regionMatches((String)"ii[}k\u007fy~", (int)(731 / 111)));
            responseFunction.setSrc(iMediaStream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put(Base64.regionMatches((String)"*%/)", (int)(7 * 15)), (AMFData)new AMFDataItem(Base64.regionMatches((String)"Go\u007f_y|jq|<Wuaw9Km{ih", (int)(11 * 27))));
            responseFunction.addBody((AMFData)aMFPacket4);
            n += responseFunction.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 == null) return n;
        byte by2 = (byte)aMFPacket3.getFirstByte();
        aMFPacket4 = null;
        if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
            aMFPacket4.addData(byArray, 0, byArray.length);
        }
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket4 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
        }
        lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
        lArray[3] = lArray[3] + 1L;
        n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket2 == null) return n;
        return n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        this.isDebugLog = WMSLoggerFactory.getLogger(LivePlayer.class).isDebugEnabled();
        if (wMSProperties == null) return;
        this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(51 - 34), (String)"u{`uwzrTvmY}szhievkPmth|}fbbj"), this.disableLowBandwidthThrottling);
        this.instantOn = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(-20 - 59), (String)"x|``txcWw"), this.instantOn);
        this.instantOnBufferTime = wMSProperties.getPropertyInt(FileChunk.getChars((int)(1117 / 192), (String)"lht|hd\u007fCcLzvwwa@|{r"), this.instantOnBufferTime);
        this.waitForBufferFill = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(29 * 59), (String)"xqxfU{gTb~\u007f\u007fiZtrs"), this.waitForBufferFill);
        this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(159 / 38), (String)"sdosNfxIykhjbZwjRgwz}"), this.waitForBufferKeyFrame);
        this.behindDropDFrames = wMSProperties.getPropertyInt(Base64.regionMatches((String)"-59;=0\u0011$8(\u001d\u001c)=0;,", (int)(41 * 55)), this.behindDropDFrames);
        this.behindDropPFrames = wMSProperties.getPropertyInt(Base64.regionMatches((String)"%-!#%(\t<  \u0001\u0014!583$", (int)(-35 - 22)), this.behindDropPFrames);
        this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt(Base64.regionMatches((String)"cgkmkbCzfz@J\u007fobub", (int)(74 + 55)), this.behindDropKFrames);
        this.behindDropAudio = wMSProperties.getPropertyInt(FileChunk.getChars((int)(35 + -21), (String)"ljxx|wPgygYl~rs"), this.behindDropAudio);
        this.maximumLiveLatency = wMSProperties.getPropertyInt(FileChunk.getChars((int)(63 * 23), (String)"dks`dxjqdvz{ywc}wyb"), this.maximumLiveLatency);
        this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(442 / 80), (String)"vcilFxbkd`n|E{~qvys}j"), this.sendOriginalTimecodes);
        this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt(Base64.regionMatches((String)"\"446&084=\u000e(2(8\u000e>cjgwWl|b\\axn\u007feact", (int)(71 + 41)), this.referenceWritePacketSizeThreshold);
        this.referenceWrite = wMSProperties.getPropertyBoolean(Base64.regionMatches((String)"e}\u007f\u007fiys}z\u00173+7!", (int)(61 * 3)), this.referenceWrite);
        this.a = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(482 / 87), (String)"`hfjeoOucobyrAgfpwzUxhpyom"), this.a);
        boolean bl = false;
        bl = wMSProperties.getPropertyBoolean(Base64.regionMatches((String)"ttpfsZcc\u007fvsu{OJRPQc`o`rSadox", (int)(-12 - -28)), bl);
        if (!bl) {
            if (!this.isDebugLog) return;
        }
        this.b = new PacketTimecodeDebug();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testVideoFrame(int n, int n2) {
        if ((n & 1 << ((n2 & 0x30) >> 4) - 1) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.workBuffer = new byte[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        synchronized (this.lock) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            LivePlayer livePlayer = this;
            livePlayer.isEnhancedSeekCapable = livePlayer.isEnhancedSeekCapable(livePlayer.stream.getParent());
            if (this.a) {
                LivePlayer livePlayer2 = this;
                livePlayer2.isBurstCapable = livePlayer2.isBurstCapable(livePlayer2.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)FileChunk.getChars((int)(884 / 183), (String)"|(uwgz"), (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.regionMatches((String)"ppwcfe", (int)(238 / 60)), "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object = null;
                            AMFDataObj aMFDataObj = null;
                            object = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object.createSeekMessage(Base64.regionMatches((String)"hfZ~jxx}", (int)(88 + -49)));
                            object.setSrc(this.stream.getParent().getSrc());
                            object.setType(18);
                            object.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put(FileChunk.getChars((int)(-66 - -32), (String)"=0$$"), (AMFData)new AMFDataItem(Base64.regionMatches((String)"Fl~Xx\u007fkn}?Vr`t8Dlxho", (int)(-46 - 42))));
                            object.addBody((AMFData)aMFDataObj);
                            n += object.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer3 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer3.getEnhanceSeekPacket(livePlayer3.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer4 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer4.getEnhanceSeekPacket(livePlayer4.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object = new byte[5];
                        object[0] = (ResponseFunction)23;
                        object[1] = (ResponseFunction)2;
                        object[2] = (ResponseFunction)false;
                        object[3] = (ResponseFunction)false;
                        object[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object, 0, ((ResponseFunction)object).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(55 + 97), (String)"kmh~}p"), "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.startPacketsSent == this.packetsSent) return n;
            this.sendBurstEnd(outputStream, this.stream.getParent());
            return n;
        }
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected long[] getLastPacketTimecodes(List<AMFPacket> var1_1) {
        var2_2 = new long[]{-1L, -1L};
        var3_3 = var1_1.size() - 1;
        if (true) ** GOTO lbl8
        block0: while (true) {
            var2_2[1] = var6_6;
            while (var2_2[0] < 0L || var2_2[1] < 0L) {
                --var3_3;
lbl8:
                // 2 sources

                if (var3_3 < 0) return var2_2;
                var4_4 = var1_1.get(var3_3);
                var5_5 = var4_4.getType();
                var6_6 = var4_4.getAbsTimecode();
                if (var5_5 != 8) {
                    if (var5_5 != 9 || var2_2[1] != -1L) continue;
                    continue block0;
                }
                if (var2_2[0] != -1L) continue;
                var2_2[0] = var6_6;
            }
            break;
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.stream.getParent().getPlayer().switchPlay();
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent == this.packetsSent) return n;
        this.sendBurstEnd(outputStream, this.stream.getParent());
        return n;
    }

    /*
     * Exception decompiling
     */
    protected int playAllInternal(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 7000->7054)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen != 0.0) {
            return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null) return n;
        return n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        if (iMediaStream != null) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (!bl2) return;
            IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            if (iMediaStream == null) return;
            AMFPacket aMFPacket = this.getLastPacket(iMediaStream);
            if (aMFPacket == null) return;
            this.lastSeq = aMFPacket.getSeq();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)Base64.regionMatches((String)"s!~~`c", (int)(107 + -96)), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.getChars((int)(67 + 72), (String)"xx\u007fkn}"), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)FileChunk.getChars((int)(197 / 35), (String)"}+txfy"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.regionMatches((String)"*.)9<3", (int)(-47 - -40)), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean(FileChunk.getChars((int)(3 * 27), (String)"8!\u001f=#3\u0005=)?:(8,\u001a$&'"), bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    @Override
    public void switchPlay() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (WMSLoggerFactory.isGlobalLogValueSet((String)Base64.regionMatches((String)"e3l0.1", (int)(-55 - 12)))) return;
        WMSLoggerFactory.putGlobalLogValue((String)Base64.regionMatches((String)"3a>> #", (int)(123 + 80)), (Object)new Long(l));
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }

    private class PacketTimecodeDebug {
        long a = -1L;
        long b = -1L;
        long c = -1L;
        int d = 0;
        long e = -1L;
        long f = -1L;
        long g = -1L;
        int h = 0;
        long i = -1L;

        private PacketTimecodeDebug() {
        }
    }
}

