/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.LiveReceiver;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.record.MediaStreamRecord;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaStreamLiveRecord
extends MediaStreamRecord
implements IMediaStreamTimecodeControl {
    protected LiveReceiver liveReceiver = new LiveReceiver();
    protected boolean recordDataPackets = true;

    public void init(MediaStreamMap mediaStreamMap, int n, WMSProperties wMSProperties) {
        super.init(mediaStreamMap, n, wMSProperties);
        this.liveReceiver.init((IMediaStream)this);
        int n2 = this.getProperties().getPropertyInt(FileChunk.getChars((int)(77 + -66), (String)"fmubfftsfp|y{ym\u007fu\u007fd"), 8000);
        this.liveReceiver.setMaximumLiveLatency(n2);
        int n3 = this.getProperties().getPropertyInt(FileChunk.getChars((int)(21 * 41), (String)"0?'\u0010 !(!15\u0017-;\u0019./\" +"), 200);
        this.liveReceiver.setMaximumPacketsPerSecond(n3);
        this.liveReceiver.setSrc(n);
        MediaStreamLiveRecord mediaStreamLiveRecord = this;
        mediaStreamLiveRecord.setMetaDataProvider(mediaStreamLiveRecord.liveReceiver);
        WMSProperties wMSProperties2 = this.getProperties();
        this.recordDataPackets = wMSProperties2.getPropertyBoolean(Base64.regionMatches((String)"0&'*4#\f(>*\u001c,-$5%!", (int)(106 + 88)), this.recordDataPackets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addVideoData(byte[] byArray, int n, int n2) {
        super.addVideoData(byArray, n, n2);
        long l = 0L;
        int n3 = 0;
        Object object = ((MediaStream)this).lock;
        synchronized (object) {
            l = ((MediaStream)this).videoTC;
            n3 = ((MediaStream)this).videoSize;
        }
        this.liveReceiver.addVideoData(byArray, n, n2, n3, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDataData(byte[] byArray, int n, int n2) {
        if (this.recordDataPackets) {
            super.addDataData(byArray, n, n2);
        }
        long l = 0L;
        int n3 = 0;
        Object object = ((MediaStream)this).lock;
        synchronized (object) {
            l = ((MediaStream)this).dataTC;
            n3 = ((MediaStream)this).dataSize;
        }
        this.liveReceiver.addDataData(byArray, n, n2, n3, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAudioData(byte[] byArray, int n, int n2) {
        super.addAudioData(byArray, n, n2);
        long l = 0L;
        int n3 = 0;
        Object object = ((MediaStream)this).lock;
        synchronized (object) {
            l = ((MediaStream)this).audioTC;
            n3 = ((MediaStream)this).audioSize;
        }
        this.liveReceiver.addAudioData(byArray, n, n2, n3, l);
    }

    public long getMaxTimecode() {
        return this.liveReceiver.getMaxTimecode();
    }

    public int getPacketCount() {
        return this.liveReceiver.getPacketCount();
    }

    public AMFPacket getLastPacket() {
        return this.liveReceiver.getLastPacket();
    }

    public AMFPacket getLastKeyFrame() {
        return this.liveReceiver.getLastKeyFrame();
    }

    public List<AMFPacket> getPlayPackets() {
        return this.liveReceiver.getPlayPackets();
    }

    public void shutdown() {
        this.liveReceiver.shutdown();
        super.shutdown();
    }

    public void close() {
        super.close();
        this.liveReceiver.close();
    }

    public void trim() {
        super.trim();
        this.liveReceiver.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateLoggingValues() {
        super.updateLoggingValues();
        if (this.isPlay()) {
            return;
        }
        this.liveReceiver.updateLoggingValues();
    }

    public long getTimecodeOffset() {
        return this.liveReceiver.getTimecodeOffset();
    }

    public long getLastReceivedAudioTC() {
        return this.liveReceiver.getLastReceivedAudioTC();
    }

    public long getLastReceivedVideoTC() {
        return this.liveReceiver.getLastReceivedVideoTC();
    }

    public long getLastReceivedDataTC() {
        return this.liveReceiver.getLastReceivedDataTC();
    }

    public long getLastSentAudioTC() {
        return this.liveReceiver.getLastSentAudioTC();
    }

    public long getLastSentVideoTC() {
        return this.liveReceiver.getLastSentVideoTC();
    }

    public long getLastSentDataTC() {
        return this.liveReceiver.getLastSentDataTC();
    }

    public long getLastFlushAudioTC() {
        return this.liveReceiver.getLastFlushAudioTC();
    }

    public long getLastFlushVideoTC() {
        return this.liveReceiver.getLastFlushVideoTC();
    }

    public long getLastFlushDataTC() {
        return this.liveReceiver.getLastFlushDataTC();
    }

    public long getLastFlushTimecode() {
        return this.liveReceiver.getLastFlushTimecode();
    }

    public long getLastFlushRTTimecode() {
        return this.liveReceiver.getLastFlushRTTimecode();
    }

    public long getLastFlushTime() {
        return this.liveReceiver.getLastFlushTime();
    }

    public long getLastPacketTC() {
        return this.liveReceiver.getLastPacketTC();
    }

    public long getFirstPacketTC() {
        return this.liveReceiver.getFirstPacketTC();
    }

    public void resetTimecodes() {
        super.resetRecord();
        this.liveReceiver.resetTimecodes();
    }

    public AMFPacket getAudioCodecConfigPacket(long l) {
        return this.liveReceiver.getAudioCodecConfigPacket(l);
    }

    public AMFPacket getVideoCodecConfigPacket(long l) {
        return this.liveReceiver.getVideoCodecConfigPacket(l);
    }

    public void addAudioCodecConfigPacket(long l, AMFPacket aMFPacket) {
        this.liveReceiver.addAudioCodecConfigPacket(l, aMFPacket);
    }

    public void addVideoCodecConfigPacket(long l, AMFPacket aMFPacket) {
        this.liveReceiver.addVideoCodecConfigPacket(l, aMFPacket);
    }

    public void flush() {
        this.liveReceiver.flush();
    }

    public void startAudioPacket() {
        this.liveReceiver.startAudioPacket();
    }

    public void startVideoPacket() {
        this.liveReceiver.startVideoPacket();
    }

    public void startDataPacket() {
        this.liveReceiver.startDataPacket();
    }

    public ILiveStreamPacketizer getLiveStreamPacketizer(String string) {
        return this.liveReceiver.getLiveStreamPacketizer(string);
    }

    public int getPublishVideoCodecId() {
        return this.liveReceiver.getVideoCodecId();
    }

    public int getPublishAudioCodecId() {
        return this.liveReceiver.getAudioCodecId();
    }

    public void setPublishVideoCodecId(int n) {
        this.liveReceiver.setVideoCodecId(n);
    }

    public void setPublishAudioCodecId(int n) {
        this.liveReceiver.setAudioCodecId(n);
    }

    public boolean isPublishStreamReady(boolean bl, boolean bl2) {
        return this.liveReceiver.isPublishStreamReady(bl, bl2);
    }
}

