/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.Queue;

public class SocketConnector
extends BaseIoConnector {
    private static volatile int nextId = 0;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private SocketConnectorConfig defaultConfig = new SocketConnectorConfig();
    private final Queue connectQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private final Executor executor;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;
    private int workerTimeout = 60;

    public SocketConnector() {
        this(1, new NewThreadExecutor());
    }

    public SocketConnector(int n, Executor executor) {
        if (n < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = n;
        this.ioProcessors = new SocketIoProcessor[n];
        for (int i = 0; i < n; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketConnectorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Must be >= 0");
        }
        this.workerTimeout = n;
    }

    public ConnectFuture connect(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        return this.connect(socketAddress, null, ioHandler, ioServiceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + socketAddress.getClass());
        }
        if (socketAddress2 != null && !(socketAddress2 instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + socketAddress2.getClass());
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        SocketChannel socketChannel = null;
        boolean bl = false;
        try {
            socketChannel = SocketChannel.open();
            socketChannel.socket().setReuseAddress(true);
            if (socketAddress2 != null) {
                socketChannel.socket().bind(socketAddress2);
            }
            socketChannel.configureBlocking(false);
            if (socketChannel.connect(socketAddress)) {
                DefaultConnectFuture defaultConnectFuture = new DefaultConnectFuture();
                this.newSession(socketChannel, ioHandler, ioServiceConfig, defaultConnectFuture);
                bl = true;
                DefaultConnectFuture defaultConnectFuture2 = defaultConnectFuture;
                return defaultConnectFuture2;
            }
            bl = true;
        }
        catch (IOException iOException) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(iOException);
            return connectFuture;
        }
        finally {
            if (!bl && socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
        ConnectionRequest connectionRequest = new ConnectionRequest(socketChannel, ioHandler, ioServiceConfig);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException2) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException2);
                }
                return DefaultConnectFuture.newFailedFuture(iOException);
            }
        }
        object = this.connectQueue;
        synchronized (object) {
            this.connectQueue.push(connectionRequest);
        }
        this.selector.wakeup();
        return connectionRequest;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketConnectorConfig socketConnectorConfig) {
        if (socketConnectorConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = socketConnectorConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute(new NamePreservingRunnable(this.worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest connectionRequest;
            Object object = this.connectQueue;
            synchronized (object) {
                connectionRequest = (ConnectionRequest)this.connectQueue.pop();
            }
            if (connectionRequest == null) break;
            object = connectionRequest.channel;
            try {
                ((AbstractSelectableChannel)object).register(this.selector, 8, connectionRequest);
            }
            catch (IOException iOException) {
                connectionRequest.setException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set set) {
        for (SelectionKey selectionKey : set) {
            if (!selectionKey.isConnectable()) continue;
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            ConnectionRequest connectionRequest = (ConnectionRequest)selectionKey.attachment();
            boolean bl = false;
            try {
                socketChannel.finishConnect();
                this.newSession(socketChannel, connectionRequest.handler, connectionRequest.config, connectionRequest);
                bl = true;
            }
            catch (Throwable throwable) {
                connectionRequest.setException(throwable);
            }
            finally {
                selectionKey.cancel();
                if (bl) continue;
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
        set.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedOutSessions(Set set) {
        long l = System.currentTimeMillis();
        for (SelectionKey selectionKey : set) {
            ConnectionRequest connectionRequest;
            if (!selectionKey.isValid() || l < (connectionRequest = (ConnectionRequest)selectionKey.attachment()).deadline) continue;
            connectionRequest.setException(new ConnectException());
            try {
                selectionKey.channel().close();
            }
            catch (IOException iOException) {
                ExceptionMonitor.getInstance().exceptionCaught(iOException);
            }
            finally {
                selectionKey.cancel();
            }
        }
    }

    private void newSession(SocketChannel socketChannel, IoHandler ioHandler, IoServiceConfig ioServiceConfig, ConnectFuture connectFuture) throws IOException {
        SocketSessionImpl socketSessionImpl = new SocketSessionImpl(this, this.nextProcessor(), this.getListeners(), ioServiceConfig, socketChannel, ioHandler, socketChannel.socket().getRemoteSocketAddress());
        try {
            this.getFilterChainBuilder().buildFilterChain(socketSessionImpl.getFilterChain());
            ioServiceConfig.getFilterChainBuilder().buildFilterChain(socketSessionImpl.getFilterChain());
            ioServiceConfig.getThreadModel().buildFilterChain(socketSessionImpl.getFilterChain());
        }
        catch (Throwable throwable) {
            throw (IOException)new IOException("Failed to create a session.").initCause(throwable);
        }
        socketSessionImpl.getIoProcessor().addNew(socketSessionImpl);
        connectFuture.setSession(socketSessionImpl);
    }

    private SocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    private class ConnectionRequest
    extends DefaultConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private ConnectionRequest(SocketChannel socketChannel, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
            this.channel = socketChannel;
            long l = ioServiceConfig instanceof IoConnectorConfig ? ((IoConnectorConfig)ioServiceConfig).getConnectTimeoutMillis() : ((IoConnectorConfig)SocketConnector.this.getDefaultConfig()).getConnectTimeoutMillis();
            this.deadline = System.currentTimeMillis() + l;
            this.handler = ioHandler;
            this.config = ioServiceConfig;
        }
    }

    private class Worker
    implements Runnable {
        private long lastActive = System.currentTimeMillis();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = Thread.currentThread().getPriority();
            Thread.currentThread().setName(SocketConnector.this.threadName);
            Thread.currentThread().setPriority(10);
            block12: while (true) {
                try {
                    while (true) {
                        int n2 = SocketConnector.this.selector.select(1000L);
                        SocketConnector.this.registerNew();
                        if (n2 > 0) {
                            SocketConnector.this.processSessions(SocketConnector.this.selector.selectedKeys());
                        }
                        SocketConnector.this.processTimedOutSessions(SocketConnector.this.selector.keys());
                        if (SocketConnector.this.selector.keys().isEmpty()) {
                            if (System.currentTimeMillis() - this.lastActive <= (long)SocketConnector.this.workerTimeout * 1000L) continue;
                            Object object = SocketConnector.this.lock;
                            synchronized (object) {
                                if (SocketConnector.this.selector.keys().isEmpty() && SocketConnector.this.connectQueue.isEmpty()) {
                                    SocketConnector.this.worker = null;
                                    try {
                                        SocketConnector.this.selector.close();
                                    }
                                    catch (IOException iOException) {
                                        ExceptionMonitor.getInstance().exceptionCaught(iOException);
                                    }
                                    finally {
                                        SocketConnector.this.selector = null;
                                    }
                                    break block12;
                                }
                                continue block12;
                            }
                        }
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                    }
                    continue;
                }
                break;
            }
            Thread.currentThread().setPriority(n);
        }
    }
}

