/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerSanJoseUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String SESSIONIDPLACHOLDER = "{session-id}";
    public static final String BITRATEPLACHOLDER = "{bitrate}";
    public static final String KBITRATEPLACHOLDER = "{kbitrate}";
    public static final String BOOTSTRAPIDPLACEHOLDER = "{bootstrapId}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYHEXSTRPLACHOLDER = "{query-hex}";
    public static final String PLAYLISTPLACHOLDER = "playlist_b{bitrate}_w{session-id}.abst{query}";
    public static final String PLAYSTARTPLACHOLDER = "{playStart}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDuration}";
    public static final String RANDOMPLACHOLDER = "{randomId}";
    public static final String MEDIAPLACHOLDER = "media{randomId}_b{bitrate}_w{session-id}{query-hex}.abst/";
    public static final String VODMEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}{query-hex}{playStart}{playDuration}.abst/";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String FILENAMEPATTERN = "media_{index}{ext}";
    public static final String URLPATTERN = "http://{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.getChars((int)(-16 - -46), (String)"0ks");
        switch (n) {
            case 2: {
                string = Base64.regionMatches((String)"h*8z", (int)(61 - -9));
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.getChars((int)(9 + 116), (String)"s?>c");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseEncInfo sanJoseEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingSanJoseBlock> arrayList;
        List<LiveStreamingSanJoseBlock> list;
        Cipher cipher;
        if (sanJoseEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info(FileChunk.getChars((int)(85 + -66), (String)"_}csDlk\u007fzqM\u007f|kdvj~`tTig@d\u007fh i|da{Dtu|}mi!<|z{\u0002.7-'<\u0005&;=&.\u001f(-:\"8&*\u0004'9!1=?)f}") + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(sanJoseEncInfo.getEncKeyBytes(), Base64.regionMatches((String)"DCT", (int)(254 / 45)));
            long l = liveStreamPacketizerSanJoseChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(FileChunk.getChars((int)(-6 - -46), (String)"ILY$OOM @ZQ@#Ews|pt|"), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerSanJoseChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingSanJoseBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error(FileChunk.getChars((int)(96 + 12), (String)"\u0000$8*\u0003% 658\u00066;2?/5';-S`lIkvcR|`fx\"h`lbhbgW}cys#:ZYN3.29\"fjft~x}cdb7.") + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerSanJoseChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = list.get(n);
            n4 += liveStreamingSanJoseBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen()) : cipher.update(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingSanJoseBlock liveStreamingSanJoseBlock2 = new LiveStreamingSanJoseBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingSanJoseBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SanJoseEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.regionMatches((String)"k-\"1", (int)(14 - 41)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(Base64.regionMatches((String)"zb}", (int)(3 * 5)));
            if (string3 != null || (string3 = (String)object.get(FileChunk.getChars((int)(766 / 132), (String)"ptn"))) != null || (string3 = (String)object.get(FileChunk.getChars((int)(-52 + 103), (String)"paeselpttoilz!,+-#h'\";xxsa8<#"))) != null || (string3 = (String)object.get(FileChunk.getChars((int)(541 / 97), (String)"fswm{~bbb}{bts~}{q:y|i*.%3jrh"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.regionMatches((String)"nc~", (int)(363 / 63)))) != null || (string2 = (String)object.get(FileChunk.getChars((int)(61 * 15), (String)"paeselpttoilzalkmc(gb{883!fkv"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() != 32) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.regionMatches((String)"OmscT|{oja]ol{tfznpdTmi\u007fihtpp.hljp?&Lmp*gici{x1{}wzde}zn5<Pkl4a &dtpg*0>.?mf|bq1;5'74,<((u}20.&b\u0018", (int)(592 / 153)) + file + FileChunk.getChars((int)(45 + 62), (String)"\u0016vm") + string2.length());
                } else {
                    byArray = BufferUtils.decodeHexString((String)string2);
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new SanJoseEncInfo(string2, byArray, string3);
    }
}

