/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Throwable nestable = null;
    public static boolean topDown = true;
    public static boolean trimStackFrames = true;
    public static boolean matchSubclasses = true;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    public NestableDelegate(Nestable nestable) {
        if (!(nestable instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.nestable = (Throwable)((Object)nestable);
    }

    public String getMessage(int n) {
        Throwable throwable;
        if ((class$org$apache$commons$lang$exception$Nestable == null ? (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")) : class$org$apache$commons$lang$exception$Nestable).isInstance(throwable = this.getThrowable(n))) {
            return ((Nestable)((Object)throwable)).getMessage(0);
        }
        return throwable.getMessage();
    }

    public String getMessage(String string) {
        String string2;
        Throwable throwable = ExceptionUtils.getCause(this.nestable);
        String string3 = string2 = throwable == null ? null : throwable.getMessage();
        if (throwable == null || string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        return string + ": " + string2;
    }

    public String[] getMessages() {
        Throwable[] throwableArray = this.getThrowables();
        String[] stringArray = new String[throwableArray.length];
        for (int i = 0; i < throwableArray.length; ++i) {
            stringArray[i] = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(throwableArray[i]) ? ((Nestable)((Object)throwableArray[i])).getMessage(0) : throwableArray[i].getMessage();
        }
        return stringArray;
    }

    public Throwable getThrowable(int n) {
        if (n == 0) {
            return this.nestable;
        }
        Throwable[] throwableArray = this.getThrowables();
        return throwableArray[n];
    }

    public int getThrowableCount() {
        return ExceptionUtils.getThrowableCount(this.nestable);
    }

    public Throwable[] getThrowables() {
        return ExceptionUtils.getThrowables(this.nestable);
    }

    public int indexOfThrowable(Class clazz, int n) {
        if (clazz == null) {
            return -1;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + n);
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables(this.nestable);
        if (n >= throwableArray.length) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + n + " >= " + throwableArray.length);
        }
        if (matchSubclasses) {
            for (int i = n; i < throwableArray.length; ++i) {
                if (!clazz.isAssignableFrom(throwableArray[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = n; i < throwableArray.length; ++i) {
                if (!clazz.equals(throwableArray[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            PrintWriter printWriter = new PrintWriter(printStream, false);
            this.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        Object object;
        Throwable throwable = this.nestable;
        if (ExceptionUtils.isThrowableNested()) {
            if (throwable instanceof Nestable) {
                ((Nestable)((Object)throwable)).printPartialStackTrace(printWriter);
            } else {
                throwable.printStackTrace(printWriter);
            }
            return;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (throwable != null) {
            object = this.getStackFrames(throwable);
            arrayList.add((String[])object);
            throwable = ExceptionUtils.getCause(throwable);
        }
        object = "Caused by: ";
        if (!topDown) {
            object = "Rethrown as: ";
            Collections.reverse(arrayList);
        }
        if (trimStackFrames) {
            this.trimStackFrames(arrayList);
        }
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    printWriter.println(stringArray[i]);
                }
                if (!iterator.hasNext()) continue;
                printWriter.print((String)object);
            }
        }
    }

    protected String[] getStackFrames(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        if (throwable instanceof Nestable) {
            ((Nestable)((Object)throwable)).printPartialStackTrace(printWriter);
        } else {
            throwable.printStackTrace(printWriter);
        }
        return ExceptionUtils.getStackFrames(stringWriter.getBuffer().toString());
    }

    protected void trimStackFrames(List list) {
        int n = list.size();
        for (int i = n - 1; i > 0; --i) {
            String[] stringArray = (String[])list.get(i);
            String[] stringArray2 = (String[])list.get(i - 1);
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray2));
            ExceptionUtils.removeCommonFrames(arrayList, arrayList2);
            int n2 = stringArray.length - arrayList.size();
            if (n2 <= 0) continue;
            arrayList.add("\t... " + n2 + " more");
            list.set(i, arrayList.toArray(new String[arrayList.size()]));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

