/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStreamDestination;
import com.wowza.wms.transcoder.model.TranscoderStreamDestinationAudio;
import com.wowza.wms.transcoder.model.TranscoderStreamDestinationVideo;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroups;
import com.wowza.wms.transcoder.model.TranscoderStreamSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscoderStream {
    public static final String STREAMNAME_PLACEHOLDERNAME = "SourceStreamName";
    public static final String AUDIOBITRATE_PLACEHOLDERNAME = "SourceAudioBitrate";
    public static final String VIDEOBITRATE_PLACEHOLDERNAME = "SourceVideoBitrate";
    public static final String STREAMNAME_PLACEHOLDER = "${SourceStreamName}";
    public static final String AUDIOBITRATE_PLACEHOLDER = "${SourceAudioBitrate}";
    public static final String VIDEOBITRATE_PLACEHOLDER = "${SourceVideoBitrate}";
    public static final int TRANSCODING_PASSTHROUGH = -1;
    public static final int TRANSCODING_DISABLE = -2;
    public static final int ENCODING_IMPLEMENTATION_DEFAULT = 0;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_DEFAULT = 0;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC = 1;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_NVIDIACUDA = 2;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_OPENCL = 3;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC2 = 4;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_NVIDIACUDA2 = 5;
    public static final int DECODING_VIDEO_IMPLEMENTATION_DEFAULT = 0;
    public static final int DECODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC = 1;
    public static final int DECODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC_AUTO = 1;
    public static final int DECODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC_SOFTWARE = 2;
    public static final int ENCODING_AUDIO_IMPLEMENTATION_DEFAULT = 0;
    public static final int DECODING_AUDIO_IMPLEMENTATION_DEFAULT = 0;
    public static final int FRAMESIZE_FITMODE_LETTERBOX = 1;
    public static final int FRAMESIZE_FITMODE_FITWIDTH = 2;
    public static final int FRAMESIZE_FITMODE_FITHEIGHT = 3;
    public static final int FRAMESIZE_FITMODE_CROP = 4;
    public static final int FRAMESIZE_FITMODE_STRETCH = 5;
    public static final int FRAMESIZE_FITMODE_MATCHSOURCE = 6;
    public static final int FOURCC_YV12 = 842094169;
    public static final int FOURCC_I420 = 808596553;
    public static final int FOURCC_NV12 = 842094158;
    public static final int FOURCC_ARGB = 1111970369;
    public static final int FOURCC_BGRA = 1095911234;
    public static final int FOURCC_VUYA = 1096373590;
    private TranscoderStreamSource a = new TranscoderStreamSource();
    private Map<String, TranscoderStreamDestination> b = new HashMap<String, TranscoderStreamDestination>();
    private TranscoderStreamNameGroups c = new TranscoderStreamNameGroups();

    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        this.c.init(liveStreamTranscoder, transcoderStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        if (this.b.size() > 0) return false;
        return true;
    }

    public void close(LiveStreamTranscoder liveStreamTranscoder) {
    }

    public void shutdown(LiveStreamTranscoder liveStreamTranscoder) {
        this.c.shutdown(liveStreamTranscoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfPassThroughAudioEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationAudio transcoderStreamDestinationAudio = transcoderStreamDestination.getAudio();
                if (transcoderStreamDestinationAudio == null || !transcoderStreamDestinationAudio.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfTrueAudioEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationAudio transcoderStreamDestinationAudio = transcoderStreamDestination.getAudio();
                if (transcoderStreamDestinationAudio == null || transcoderStreamDestinationAudio.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfPassThroughVideoEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationVideo transcoderStreamDestinationVideo = transcoderStreamDestination.getVideo();
                if (transcoderStreamDestinationVideo == null || !transcoderStreamDestinationVideo.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfTrueVideoEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationVideo transcoderStreamDestinationVideo = transcoderStreamDestination.getVideo();
                if (transcoderStreamDestinationVideo == null || transcoderStreamDestinationVideo.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    public TranscoderStreamSource getSource() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putDestination(String string, TranscoderStreamDestination transcoderStreamDestination) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            this.b.put(string, transcoderStreamDestination);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamDestination getDestination(String string) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            return this.b.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamDestination removeDestination(String string) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            return this.b.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getDestinationNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            hashSet.addAll(this.b.keySet());
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TranscoderStreamDestination> getDestinations() {
        ArrayList<TranscoderStreamDestination> arrayList = new ArrayList<TranscoderStreamDestination>();
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            arrayList.addAll(this.b.values());
            return arrayList;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Base64.regionMatches((String)"tDcs}gvysqw}Hho{~-{b", (int)(22 + 25)));
        stringBuffer.append(Base64.regionMatches((String)".1*2\"'~f", (int)(23 * 43)) + this.a.toString() + Base64.regionMatches((String)"yp}", (int)(41 * 3)));
        stringBuffer.append(FileChunk.getChars((int)(16 + 57), (String)"-/88$ .$8==i"));
        List<TranscoderStreamDestination> list = this.getDestinations();
        Iterator<TranscoderStreamDestination> iterator = list.iterator();
        int n = 0;
        boolean bl = true;
        while (true) {
            TranscoderStreamDestination transcoderStreamDestination;
            if (!bl || (bl = false) || !true) {
                stringBuffer.append(transcoderStreamDestination.toString());
                ++n;
            }
            if (!iterator.hasNext()) {
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
            transcoderStreamDestination = iterator.next();
            if (n <= 0) continue;
            stringBuffer.append(FileChunk.getChars((int)(43 * 19), (String)"=2"));
        }
    }

    public TranscoderStreamNameGroups getNameGroups() {
        return this.c;
    }
}

