/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean a = true;
    private PacketTimecodeDebug b = null;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{10, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(true);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(false);
        try {
            outputStream.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(byArray, 0, byArray.length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            Object var18_19 = null;
            aMFPacket4 = null;
            ResponseFunction responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createSeekMessage(FileChunk.startsWith((int)(29 - 28), (String)"nlPpdrr{"));
            responseFunction.setSrc(iMediaStream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put(FileChunk.startsWith((int)(27 - -30), (String)"zu\u007fy"), (AMFData)new AMFDataItem(Base64.replace((String)"Go\u007f_y|jq|<Wuaw9Km{ih", (int)(9 * 33))));
            responseFunction.addBody((AMFData)aMFPacket4);
            n += responseFunction.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 == null) return n;
        byte by2 = (byte)aMFPacket3.getFirstByte();
        aMFPacket4 = null;
        if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
            aMFPacket4.addData(byArray, 0, byArray.length);
        }
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket4 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
        }
        lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
        lArray[3] = lArray[3] + 1L;
        n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket2 == null) return n;
        return n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        this.isDebugLog = WMSLoggerFactory.getLogger(LivePlayer.class).isDebugEnabled();
        if (wMSProperties == null) return;
        this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(-43 - -22), (String)"/%>/-<4\u001e<#\u001779<.3?(5\n7rnvwhlh`"), this.disableLowBandwidthThrottling);
        this.instantOn = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(113 / 36), (String)"jjvrff}Ee"), this.instantOn);
        this.instantOnBufferTime = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(769 / 160), (String)"mkusig~DbO{ivt`G}xs"), this.instantOnBufferTime);
        this.waitForBufferFill = wMSProperties.getPropertyBoolean(Base64.replace((String)".;2(\u001b1-\u00024$%!7\u0000.$%", (int)(55 + 34)), this.waitForBufferFill);
        this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean(Base64.replace((String)"6#*0\u0003)5\n<,-)?\u0005*)\u0017 290", (int)(13 * 37)), this.waitForBufferKeyFrame);
        this.behindDropDFrames = wMSProperties.getPropertyInt(Base64.replace((String)"#'+-+\"\u0003:&:\u000f\n?/\"5\"", (int)(5 * 45)), this.behindDropDFrames);
        this.behindDropPFrames = wMSProperties.getPropertyInt(Base64.replace((String)"aamoilMxd|]H}q|w`", (int)(435 / 114)), this.behindDropPFrames);
        this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt(Base64.replace((String)"muy{}pQdxhR\\i}p{l", (int)(39 * 57)), this.behindDropKFrames);
        this.behindDropAudio = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(21 * 17), (String)"'#/!'.\u000f>\">\u000e%5;<"), this.behindDropAudio);
        this.maximumLiveLatency = wMSProperties.getPropertyInt(Base64.replace((String)"ne}jn~lk~hdacqew}wl", (int)(241 / 61)), this.maximumLiveLatency);
        this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean(Base64.replace((String)"gpxsWks|us\u007fs\u0014(/&'*\"\";", (int)(89 + -37)), this.sendOriginalTimecodes);
        this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt(Base64.replace((String)"m%''1!+%\"\u001f;#?)\u001d/,;4&\u0000=/3\u00030+?(422;", (int)(9 * 7)), this.referenceWritePacketSizeThreshold);
        this.referenceWrite = wMSProperties.getPropertyBoolean(Base64.replace((String)"qaccumgin[\u007fg{u", (int)(910 / 236)), this.referenceWrite);
        this.a = wMSProperties.getPropertyBoolean(Base64.replace((String)"fjddkmMsem`glCe`vux[vjr\u007fio", (int)(697 / 203)), this.a);
        boolean bl = false;
        bl = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(2 - 11), (String)"3=;/<\u0013(*8ohldVQKWXhi`iyZf}ta"), bl);
        if (!bl) {
            if (!this.isDebugLog) return;
        }
        this.b = new PacketTimecodeDebug();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testVideoFrame(int n, int n2) {
        if ((n & 1 << ((n2 & 0x30) >> 4) - 1) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.workBuffer = new byte[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        synchronized (this.lock) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            LivePlayer livePlayer = this;
            livePlayer.isEnhancedSeekCapable = livePlayer.isEnhancedSeekCapable(livePlayer.stream.getParent());
            if (this.a) {
                LivePlayer livePlayer2 = this;
                livePlayer2.isBurstCapable = livePlayer2.isBurstCapable(livePlayer2.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)Base64.replace((String)"}+txfy", (int)(50 + 83)), (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.startsWith((int)(90 + 67), (String)"njme`o"), "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object = null;
                            AMFDataObj aMFDataObj = null;
                            object = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object.createSeekMessage(Base64.replace((String)"ii[}k\u007fy~", (int)(870 / 143)));
                            object.setSrc(this.stream.getParent().getSrc());
                            object.setType(18);
                            object.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put(Base64.replace((String)"ficm", (int)(783 / 132)), (AMFData)new AMFDataItem(Base64.replace((String)"Hb|Z~yilc!Tpfr:Fbvjm", (int)(1579 / 252))));
                            object.addBody((AMFData)aMFDataObj);
                            n += object.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer3 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer3.getEnhanceSeekPacket(livePlayer3.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer4 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer4.getEnhanceSeekPacket(livePlayer4.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object = new byte[5];
                        object[0] = (ResponseFunction)23;
                        object[1] = (ResponseFunction)2;
                        object[2] = (ResponseFunction)false;
                        object[3] = (ResponseFunction)false;
                        object[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object, 0, ((ResponseFunction)object).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.startsWith((int)(-66 - -29), (String)"((/;>-"), "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.startPacketsSent == this.packetsSent) return n;
            this.sendBurstEnd(outputStream, this.stream.getParent());
            return n;
        }
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected long[] getLastPacketTimecodes(List<AMFPacket> var1_1) {
        var2_2 = new long[]{-1L, -1L};
        var3_3 = var1_1.size() - 1;
        if (true) ** GOTO lbl8
        block0: while (true) {
            var2_2[1] = var6_6;
            while (var2_2[0] < 0L || var2_2[1] < 0L) {
                --var3_3;
lbl8:
                // 2 sources

                if (var3_3 < 0) return var2_2;
                var4_4 = var1_1.get(var3_3);
                var5_5 = var4_4.getType();
                var6_6 = var4_4.getAbsTimecode();
                if (var5_5 != 8) {
                    if (var5_5 != 9 || var2_2[1] != -1L) continue;
                    continue block0;
                }
                if (var2_2[0] != -1L) continue;
                var2_2[0] = var6_6;
            }
            break;
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.stream.getParent().getPlayer().switchPlay();
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent == this.packetsSent) return n;
        this.sendBurstEnd(outputStream, this.stream.getParent());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playAllInternal(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        var7_7 = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        var8_8 = true;
        var9_9 = true;
        var10_10 = -1;
        synchronized (this.stream.getParent()) {
            var8_8 = this.stream.getParent().isReceiveAudio();
            var9_9 = this.stream.getParent().isReceiveVideo();
            var10_10 = this.stream.getParent().getReceiveVideoFPS();
            // ** MonitorExit[var11_12] (shouldn't be in output)
            var11_11 = System.currentTimeMillis();
            if (this.b != null) {
                var13_13 = 0L;
                if (this.b.i >= 0L) {
                    var13_13 = var11_11 - this.b.i;
                }
                this.b.i = var11_11;
                var15_15 = FileChunk.startsWith((int)(31 + 104), (String)"Ka\u007fo[`lwjb?``q{rL") + this.stream.getParent().getContextStr() + FileChunk.startsWith((int)(-26 - 39), (String)"Bza07~") + var13_13;
                if (this.isDebugLog) {
                    WMSLoggerFactory.getLogger(null).debug((String)var15_15);
                } else {
                    WMSLoggerFactory.getLogger(null).info((String)var15_15);
                }
            }
            var13_14 = this.lock;
            synchronized (var13_14) {
                block150: {
                    block134: {
                        block145: {
                            block138: {
                                block135: {
                                    block143: {
                                        block136: {
                                            block133: {
                                                block166: {
                                                    block161: {
                                                        block140: {
                                                            block165: {
                                                                block163: {
                                                                    block164: {
                                                                        block144: {
                                                                            block162: {
                                                                                block132: {
                                                                                    block154: {
                                                                                        block158: {
                                                                                            block159: {
                                                                                                block160: {
                                                                                                    block141: {
                                                                                                        block142: {
                                                                                                            block155: {
                                                                                                                block139: {
                                                                                                                    block137: {
                                                                                                                        block148: {
                                                                                                                            block149: {
                                                                                                                                block147: {
                                                                                                                                    block146: {
                                                                                                                                        var14_18 = this.liveSwitch.get();
                                                                                                                                        var15_15 = this.getPlayPackets(var1_1);
                                                                                                                                        var16_19 = var1_1.getLastKeyFrame();
                                                                                                                                        if (this.checkStreamProperties) {
                                                                                                                                            v0 = this;
                                                                                                                                            v0.isEnhancedSeekCapable = v0.isEnhancedSeekCapable(v0.stream.getParent());
                                                                                                                                            if (this.a) {
                                                                                                                                                v1 = this;
                                                                                                                                                v1.isBurstCapable = v1.isBurstCapable(v1.stream.getParent());
                                                                                                                                            }
                                                                                                                                            if ((var17_20 = this.stream.getParent().getClient()) != null && var17_20.getLiveRepeaterCapabilities() > 0) {
                                                                                                                                                this.sendOriginalTimecodes = true;
                                                                                                                                            }
                                                                                                                                            this.checkStreamProperties = false;
                                                                                                                                        }
                                                                                                                                        var17_20 = (Client)this.stream.getParent().getClient();
                                                                                                                                        var18_21 = var17_20.getSendChunkSize();
                                                                                                                                        var19_22 = 7;
                                                                                                                                        var20_23 = false;
                                                                                                                                        var21_24 = 0L;
                                                                                                                                        var23_25 = null;
                                                                                                                                        var24_26 = null;
                                                                                                                                        var25_27 = var17_20.getWriteListener();
                                                                                                                                        var26_28 = FileChunk.startsWith((int)(-56 - -32), (String)";=8.- ") + this.stream.getParent().getSrc();
                                                                                                                                        var27_29 = var15_15.size();
                                                                                                                                        if (var27_29 != 0) break block146;
                                                                                                                                        this.bufferEmptyOnce = true;
                                                                                                                                        ** GOTO lbl224
                                                                                                                                    }
                                                                                                                                    var28_31 = (AMFPacket)var15_15.get(0);
                                                                                                                                    if (!this.waitForBufferFill || !this.sendFirstKeyFrame) ** GOTO lbl324
                                                                                                                                    var29_33 = true;
                                                                                                                                    var30_34 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                                                                                                                                    if (this.waitForBufferFillStarTime == -1L) break block147;
                                                                                                                                    if (var11_11 - this.waitForBufferFillStarTime <= var30_34 || this.waitForBufferKeyFrame) break block148;
                                                                                                                                    break block149;
                                                                                                                                }
                                                                                                                                this.waitForBufferFillStarTime = var11_11;
                                                                                                                                break block148;
                                                                                                                            }
                                                                                                                            var29_33 = false;
                                                                                                                        }
                                                                                                                        if (!var29_33 || var30_34 <= 0L) ** GOTO lbl324
                                                                                                                        var32_38 = (AMFPacket)var15_15.get(var27_29 - 1);
                                                                                                                        if (var32_38.getAbsTimecode() - var28_31.getAbsTimecode() < var30_34) ** GOTO lbl224
                                                                                                                        if (!this.waitForBufferKeyFrame || var16_19 != null) ** GOTO lbl324
                                                                                                                        break block150;
lbl77:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            if (var42_66 < 0L) {
                                                                                                                                var42_66 = 0L;
                                                                                                                            }
                                                                                                                            var39_58 = var5_5;
                                                                                                                            this.lastTC = var42_66;
                                                                                                                            this.lastDataTC = var42_66;
                                                                                                                            var6_6[4] = var6_6[4] + (long)var28_31.getSize();
                                                                                                                            var6_6[5] = var6_6[5] + 1L;
                                                                                                                            break block132;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            v2 = (int)(this.lastSeq - var29_32 + 1L);
                                                                                                                            ** GOTO lbl327
                                                                                                                            break;
                                                                                                                        }
lbl89:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            v3 = this;
                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v3.getEnhanceSeekPacket(v3.stream.getParent(), var28_31.getFirstByte(), true), var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                            break block133;
                                                                                                                            break;
                                                                                                                        }
lbl93:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            this.lastTCFilter = var19_22;
                                                                                                                            ** GOTO lbl360
                                                                                                                            break;
                                                                                                                        }
lbl96:
                                                                                                                        // 3 sources

                                                                                                                        while (true) {
                                                                                                                            var48_91 = true;
                                                                                                                            if (var23_25 == null) {
                                                                                                                                var23_25 = this.getLastKeyFrame(var1_1);
                                                                                                                                var48_91 = false;
                                                                                                                            }
                                                                                                                            if (!var9_9) {
                                                                                                                                var23_25 = null;
                                                                                                                            }
                                                                                                                            if (var23_25 == null) ** GOTO lbl649
                                                                                                                            if (this.sendFirstVideoFrame) {
                                                                                                                                var49_100 = var1_1.getVideoCodecConfigPacket(var23_25.getAbsTimecode());
                                                                                                                                if (var49_100 != null) {
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var49_100, var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                                }
                                                                                                                                this.sendFirstVideoFrame = false;
                                                                                                                                var46_77 = true;
                                                                                                                            }
                                                                                                                            if (var46_77 && this.isEnhancedSeekCapable) {
                                                                                                                                v4 = this;
                                                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v4.getEnhanceSeekPacket(v4.stream.getParent(), var23_25.getFirstByte(), true), var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                            }
                                                                                                                            var6_6[2] = var6_6[2] + (long)var23_25.getSize();
                                                                                                                            var6_6[3] = var6_6[3] + 1L;
                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var23_25, var42_66, var4_4, this.workBuffer, var18_21);
                                                                                                                            var4_4.setNew(true);
                                                                                                                            if (!this.isEnhancedSeekCapable) ** GOTO lbl690
                                                                                                                            var49_99 = var23_25.getSeq();
                                                                                                                            var51_106 = (int)(var49_99 - var29_32 + 1L);
                                                                                                                            if (var48_91) {
                                                                                                                                this.waitForKeyFrame = false;
                                                                                                                            }
                                                                                                                            if (!var48_91 || var51_106 < 0 || var51_106 >= var27_29) ** GOTO lbl690
                                                                                                                            var52_110 = 0;
                                                                                                                            var53_115 = var51_106;
                                                                                                                            break block134;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            block153: {
                                                                                                                                block152: {
                                                                                                                                    block151: {
                                                                                                                                        if (var44_71 != 8 || !this.sendFirstAudioFrame) break block151;
                                                                                                                                        var47_82 = new AMFPacket(8, var1_1.getSrc(), 0);
                                                                                                                                        if (var47_82 != null) {
                                                                                                                                            var6_6[0] = var6_6[0] + 0L;
                                                                                                                                            var6_6[1] = var6_6[1] + 1L;
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), (AMFPacket)var47_82, var42_66, var3_3, this.workBuffer, var18_21);
                                                                                                                                            var3_3.setNew(true);
                                                                                                                                        }
                                                                                                                                        if ((var48_93 = var1_1.getAudioCodecConfigPacket(var28_31.getAbsTimecode())) != null) {
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var48_93, var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                                        }
                                                                                                                                        break block152;
                                                                                                                                    }
                                                                                                                                    if (var44_71 != 9 || !this.sendFirstVideoFrame) break block135;
                                                                                                                                    var47_82 = var1_1.getVideoCodecConfigPacket(var28_31.getAbsTimecode());
                                                                                                                                    if (var47_82 == null) break block153;
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), (AMFPacket)var47_82, var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                                    break block153;
                                                                                                                                }
                                                                                                                                this.sendFirstAudioFrame = false;
                                                                                                                                break block135;
                                                                                                                            }
                                                                                                                            this.sendFirstVideoFrame = false;
                                                                                                                            var46_77 = true;
                                                                                                                            break block135;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            if (var39_59 == -1L) {
                                                                                                                                var39_59 = var49_96;
                                                                                                                            }
                                                                                                                            var41_65 = var49_96;
                                                                                                                            break block136;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            var41_65 = var56_125;
                                                                                                                            ** GOTO lbl606
                                                                                                                            break;
                                                                                                                        }
lbl158:
                                                                                                                        // 3 sources

                                                                                                                        while (true) {
                                                                                                                            var31_35 = var35_45 < 0 ? 0 : var35_45;
                                                                                                                            ** GOTO lbl338
                                                                                                                            break;
                                                                                                                        }
lbl161:
                                                                                                                        // 2 sources

                                                                                                                        while (var14_18.switchTimecodeFound) {
                                                                                                                            break block137;
                                                                                                                        }
                                                                                                                        break block154;
                                                                                                                        while (true) {
                                                                                                                            var14_18.switchTimecodeFound = true;
                                                                                                                            ** GOTO lbl161
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            if (this.firstPacketTC == -1L) {
                                                                                                                                var42_66 = 0L;
                                                                                                                                this.firstPacketTC = var40_60;
                                                                                                                            } else {
                                                                                                                                var42_66 = var40_60 - this.firstPacketTC;
                                                                                                                            }
                                                                                                                            if (this.sendOriginalTimecodes) {
                                                                                                                                var42_66 = var40_60;
                                                                                                                            }
                                                                                                                            if (var42_66 < 0L) break block132;
                                                                                                                            var39_58 = var3_3;
                                                                                                                            this.lastTC = var42_66;
                                                                                                                            this.lastAudioTC = var42_66;
                                                                                                                            var45_72 = var28_31.getSize();
                                                                                                                            var6_6[0] = var6_6[0] + (long)var45_72;
                                                                                                                            var6_6[1] = var6_6[1] + 1L;
                                                                                                                            break block132;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            var49_98 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                                                                                                                            var50_103 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                                                                                                                            var51_104 = this.b.e + (var42_66 - this.b.f) - var47_83;
                                                                                                                            var53_114 = var51_104 + "";
                                                                                                                            if (var51_104 > 0L) {
                                                                                                                                var53_114 = " " + var51_104;
                                                                                                                            }
                                                                                                                            var54_122 = var42_66 - this.b.g;
                                                                                                                            var56_126 = Base64.replace((String)"\u001b1/?\u000b0<':2o#6 ,)\u001c", (int)(57 * 15)) + this.stream.getParent().getContextStr() + FileChunk.startsWith((int)(8 + 102), (String)"\u0013up96!ne.") + var49_98 + Base64.replace((String)";og$", (int)(63 * 37)) + (String)var50_103 + FileChunk.startsWith((int)(-22 - -42), (String)"4au") + var42_66 + "/" + var54_122 + ":" + var47_83 + ":" + var53_114;
                                                                                                                            if (this.isDebugLog) {
                                                                                                                                WMSLoggerFactory.getLogger(null).debug(var56_126);
                                                                                                                            } else {
                                                                                                                                WMSLoggerFactory.getLogger(null).info(var56_126);
                                                                                                                            }
                                                                                                                            this.b.g = var42_66;
                                                                                                                            break block138;
                                                                                                                            break;
                                                                                                                        }
lbl198:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            v5 = this;
                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v5.getEnhanceSeekPacket(v5.stream.getParent(), var28_31.getFirstByte(), false), var42_66, var39_58, this.workBuffer, var18_21);
                                                                                                                            break block139;
lbl202:
                                                                                                                            // 1 sources

                                                                                                                            while (true) {
                                                                                                                                var48_94 = new ArrayList<E>();
                                                                                                                                var49_102 = var28_31.getAbsTimecode();
                                                                                                                                var47_82.onStreamStart(var48_94, var49_102);
                                                                                                                                if (var48_94.size() <= 0) ** GOTO lbl96
                                                                                                                                var51_108 = null;
                                                                                                                                var52_111 = null;
                                                                                                                                var51_108 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                                                                                                                var51_108.createSeekMessage(FileChunk.startsWith((int)(6 + 66), (String)"''\u0019?-9;<"));
                                                                                                                                var51_108.setSrc(this.stream.getParent().getSrc());
                                                                                                                                var51_108.setType(18);
                                                                                                                                var51_108.setTimecode(var42_66);
                                                                                                                                var52_111 = new AMFDataObj();
                                                                                                                                var52_111.put(Base64.replace((String)"47=?", (int)(49 * 39)), (AMFData)new AMFDataItem(Base64.replace((String)"\u0007/?\u001f9<*1<|\u00175!7y\u000b-;)(", (int)(39 * 15))));
                                                                                                                                var51_108.addBody((AMFData)var52_111);
                                                                                                                                var7_7 += var51_108.write(var2_2, true, var18_21);
                                                                                                                                var53_117 = var48_94.iterator();
                                                                                                                                while (true) {
                                                                                                                                    if (!var53_117.hasNext()) ** GOTO lbl96
                                                                                                                                    var54_120 = (AMFPacket)var53_117.next();
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var54_120, var42_66, var5_5, this.workBuffer, var18_21);
                                                                                                                                }
                                                                                                                                break;
                                                                                                                            }
lbl224:
                                                                                                                            // 6 sources

                                                                                                                            while (true) {
                                                                                                                                var27_30 = 0L;
                                                                                                                                if (this.avgPacketSizeCount > (long)(this.avgPacketSizes.length << 1)) {
                                                                                                                                    var27_30 = this.avgPacketSizeTotal / (long)this.avgPacketSizes.length;
                                                                                                                                    if (this.referenceWritePacketSizeThreshold > 0) {
                                                                                                                                        v6 = this.referenceWrite = var27_30 >= (long)this.referenceWritePacketSizeThreshold;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (this.isDebugLog) {
                                                                                                                                    var29_32 = System.currentTimeMillis();
                                                                                                                                    var31_36 = this.lastSendTime == -1L ? 0L : var29_32 - this.lastSendTime;
                                                                                                                                    this.lastSendTime = var29_32;
                                                                                                                                    WMSLoggerFactory.getLogger(LivePlayer.class).debug(FileChunk.startsWith((int)(40 - -44), (String)"'083\u0003") + this.stream.getParent().getClientId() + Base64.replace((String)"Bza1*> |", (int)(116 + -53)) + var7_7 + ":" + var27_30 + Base64.replace((String)"n)9=&6&o", (int)(-56 - -38)) + var19_22 + Base64.replace((String)"y.218d", (int)(18 + 71)) + var31_36 + FileChunk.startsWith((int)(314 / 98), (String)"#pJ`a{l~1") + var21_24 + Base64.replace((String)".}gcf)", (int)(97 + -51)) + this.referenceWrite);
                                                                                                                                }
                                                                                                                                if (var24_26 == null) return var7_7;
                                                                                                                                var24_26.totalLen = var7_7;
                                                                                                                                this.lastSentLiveTracker = var24_26;
                                                                                                                                var25_27.getPendingTracker().putInfo(var26_28, var24_26);
                                                                                                                                return var7_7;
                                                                                                                            }
lbl241:
                                                                                                                            // 2 sources

                                                                                                                            while (true) {
                                                                                                                                if (!this.sendOriginalTimecodes) ** GOTO lbl77
                                                                                                                                var42_66 = var40_60;
                                                                                                                                ** continue;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            while (true) {
                                                                                                                                this.stream.getParent().setSendPlayStopLogEvent(false);
                                                                                                                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.startsWith((int)(737 / 171), (String)"wqtbid"), "stop", 200, this.stream.getParent().getName());
                                                                                                                                this.stream.getParent().notifyActionStop();
                                                                                                                                break block140;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            var38_52 = Math.abs(var46_78) < Math.abs(var43_70) ? var46_78 : var43_70;
                                                                                                                            break block141;
                                                                                                                            break;
                                                                                                                        }
lbl253:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            if (this.sendOriginalTimecodes) {
                                                                                                                                var42_66 = var40_60;
                                                                                                                            }
                                                                                                                            if (var42_66 < 0L) break block132;
                                                                                                                            var39_58 = var4_4;
                                                                                                                            this.lastTC = var42_66;
                                                                                                                            this.lastVideoTC = var42_66;
                                                                                                                            if (!var9_9 && var47_86 == 7) {
                                                                                                                                var49_101 = Math.min(var28_31.getSize(), 5);
                                                                                                                                var28_31 = var28_31.clone();
                                                                                                                                var28_31.truncatePacket(var49_101);
                                                                                                                            }
                                                                                                                            var45_72 = var28_31.getSize();
                                                                                                                            var6_6[2] = var6_6[2] + (long)var45_72;
                                                                                                                            var6_6[3] = var6_6[3] + 1L;
                                                                                                                            break block132;
                                                                                                                            while (true) {
                                                                                                                                this.waitForKeyFrame = true;
                                                                                                                                ** GOTO lbl297
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            while (true) {
                                                                                                                                if (var44_71 == 9 && var14_18.switchVideoKeyFrameSeq >= 0L && var40_60 >= var14_18.switchTimecodeTarget && !var14_18.switchTimecodeFound) ** continue;
                                                                                                                                ** GOTO lbl161
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            break;
                                                                                                                        }
lbl274:
                                                                                                                        // 1 sources

                                                                                                                        while (var19_22 == 7) {
                                                                                                                            var19_22 = 3;
                                                                                                                            break block142;
                                                                                                                        }
                                                                                                                        break block155;
lbl278:
                                                                                                                        // 1 sources

                                                                                                                        while (this.lastReceiveAudio != var8_8) {
                                                                                                                            if (var8_8) {
                                                                                                                                var7_7 += this.stream.getParent().sendLivePlaySeek(var2_2, this.stream.getParent().getName(), var42_66);
                                                                                                                            }
                                                                                                                            if ((var47_88 = new AMFPacket(8, var1_1.getSrc(), 0)) != null) {
                                                                                                                                var6_6[0] = var6_6[0] + 0L;
                                                                                                                                var6_6[1] = var6_6[1] + 1L;
                                                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_88, var42_66, var3_3, this.workBuffer, var18_21);
                                                                                                                            }
                                                                                                                            this.lastReceiveAudio = var8_8;
                                                                                                                            break block143;
                                                                                                                        }
                                                                                                                        break block143;
lbl288:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            this.b.e = var47_83;
                                                                                                                            this.b.f = var42_66;
                                                                                                                            ++this.b.h;
                                                                                                                            this.b.g = var42_66;
                                                                                                                            break block138;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                    }
lbl295:
                                                                                                                    // 3 sources

                                                                                                                    while (true) {
                                                                                                                        if (var19_22 == 0 || var19_22 == 1) ** continue;
lbl297:
                                                                                                                        // 2 sources

                                                                                                                        if (var36_47 == -1L) ** GOTO lbl224
                                                                                                                        this.lastSeq = var36_47;
                                                                                                                        ** GOTO lbl224
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        var35_45 = var34_43;
                                                                                                                        ** GOTO lbl569
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                while (true) {
                                                                                                                    var46_77 = false;
                                                                                                                    break block144;
                                                                                                                    break;
                                                                                                                }
                                                                                                                while (true) {
                                                                                                                    var49_97 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                                                                                                                    var50_103 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                                                                                                                    var51_105 = this.b.a + (var42_66 - this.b.b) - var47_83;
                                                                                                                    var53_113 = var51_105 + "";
                                                                                                                    if (var51_105 > 0L) {
                                                                                                                        var53_113 = " " + var51_105;
                                                                                                                    }
                                                                                                                    var54_118 = var42_66 - this.b.c;
                                                                                                                    var56_124 = FileChunk.startsWith((int)(-3 - 60), (String)"\r+5!\u0015*&1,8e:$**?\n") + this.stream.getParent().getContextStr() + FileChunk.startsWith((int)(1 + 119), (String)"\u0005cz38/dox") + var49_97 + Base64.replace((String)"5em\"", (int)(-61 - 14)) + (String)var50_103 + FileChunk.startsWith((int)(271 / 58), (String)"$qe") + var42_66 + "/" + var54_118 + ":" + var47_83 + ":" + var53_113;
                                                                                                                    if (this.isDebugLog) {
                                                                                                                        WMSLoggerFactory.getLogger(null).debug(var56_124);
                                                                                                                    } else {
                                                                                                                        WMSLoggerFactory.getLogger(null).info(var56_124);
                                                                                                                    }
                                                                                                                    this.b.c = var42_66;
                                                                                                                    break block138;
                                                                                                                    break;
                                                                                                                }
                                                                                                                while (true) {
                                                                                                                    block157: {
                                                                                                                        block156: {
                                                                                                                            if (var33_41 > 2) ** GOTO lbl224
lbl324:
                                                                                                                            // 4 sources

                                                                                                                            var29_32 = var28_31.getSeq();
                                                                                                                            if (this.lastSeq != -1L) ** continue;
                                                                                                                            v2 = 0;
lbl327:
                                                                                                                            // 2 sources

                                                                                                                            if ((var31_35 = v2) < 0) {
                                                                                                                                var31_35 = 0;
                                                                                                                            }
                                                                                                                            if (var31_35 < var27_29) ** break;
                                                                                                                            ** continue;
                                                                                                                            if (this.bufferEmptyOnce && !this.waitForBufferFill || !this.instantOn || !this.sendFirstKeyFrame) break block156;
                                                                                                                            var32_39 = -1L;
                                                                                                                            var34_43 = var27_29 - 1;
                                                                                                                            var35_45 = -1;
                                                                                                                            this.trackerBufferTime = 0L;
                                                                                                                            var36_49 = this.stream.getParent().getBufferTime();
                                                                                                                            ** GOTO lbl667
                                                                                                                        }
                                                                                                                        if (var31_35 == 0 && this.lastSeq != -1L && (var28_31 = (AMFPacket)var15_15.get(var31_35)).getSeq() != this.lastSeq + 1L) {
                                                                                                                            this.waitForKeyFrame = true;
                                                                                                                        }
                                                                                                                        if ((var33_40 = (var32_37 = var25_27.getLastTracker()) == null ? null : (LiveTracker)var32_37.getInfo(var26_28)) == null || this.lastSentLiveTracker == null || var33_40.trackerSeq < this.trackerStartSeq) break block157;
                                                                                                                        var34_44 = var32_37.getSent();
                                                                                                                        var36_49 = var32_37.getSize();
                                                                                                                        var38_53 = var33_40.firstTC + (var33_40.lastTC - var33_40.firstTC) * var34_44 / var36_49;
                                                                                                                        var21_24 = this.lastSentLiveTracker.lastTC - var38_53 - this.trackerBufferTime;
                                                                                                                        if (!this.disableLowBandwidthThrottling) {
                                                                                                                            if (var21_24 > (long)this.behindDropAudio) {
                                                                                                                                var20_23 = true;
                                                                                                                            }
                                                                                                                            if (var21_24 > (long)this.behindDropKFrames) {
                                                                                                                                var19_22 = 0;
                                                                                                                            } else if (var21_24 > (long)this.behindDropPFrames) {
                                                                                                                                var19_22 = 1;
                                                                                                                            } else if (var21_24 > (long)this.behindDropDFrames) {
                                                                                                                                var19_22 = 3;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.lastTCFilter == var19_22) ** GOTO lbl93
                                                                                                                        WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.replace((String)"\u001115.>.\u0006", (int)(17 * 7)) + var26_28 + FileChunk.startsWith((int)(31 * 5), (String)"F&=xvlugq>-") + this.lastTCFilter + "-" + var19_22 + Base64.replace((String)"82|rserl#", (int)(44 + 101)) + var21_24 + FileChunk.startsWith((int)(46 - 6), (String)"(zoexYM5") + this.lastSentLiveTracker.lastTC + Base64.replace((String)"&umjobzhj[S+", (int)(836 / 131)) + var33_40.lastTC + Base64.replace((String)"%drnooyXdcj*", (int)(1266 / 253)) + this.trackerBufferTime + Base64.replace((String)"&sk3", (int)(1461 / 236)) + this.lastTC);
                                                                                                                        ** continue;
                                                                                                                    }
                                                                                                                    this.lastTCOffset = var21_24;
                                                                                                                    var34_42 = var10_10;
                                                                                                                    if (var34_42 >= -1) break block142;
                                                                                                                    if (var34_42 == -2) ** GOTO lbl274
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            if (var34_42 == -3 && (var19_22 == 7 || var19_22 == 3)) {
                                                                                                                var19_22 = 1;
                                                                                                                this.waitForKeyFrame = true;
                                                                                                            }
                                                                                                        }
                                                                                                        var35_45 = 300;
                                                                                                        if (var14_18 == null) break block145;
                                                                                                        var36_48 = this.stream.getParent().getStreams().getStream(var14_18.getName());
                                                                                                        var37_50 = null;
                                                                                                        if (var36_48 != null) {
                                                                                                            var37_50 = var36_48.getPlayPackets();
                                                                                                        }
                                                                                                        if (var14_18.switchMode != -1) break block158;
                                                                                                        if (var14_18.getPlayerTransition() == 12) {
                                                                                                            var14_18.switchMode = 1;
                                                                                                        }
                                                                                                        var38_52 = 0L;
                                                                                                        if (var14_18.switchMode != -1) break block159;
                                                                                                        var40_61 = 1;
                                                                                                        if (var37_50 == null || var37_50.size() <= 0) break block160;
                                                                                                        var41_63 = this.getLastPacketTimecodes((List<AMFPacket>)var15_15);
                                                                                                        var42_67 = this.getLastPacketTimecodes(var37_50);
                                                                                                        var43_70 = -1L;
                                                                                                        var45_73 = false;
                                                                                                        var46_78 = -1L;
                                                                                                        var48_90 = 0;
                                                                                                        if (var41_63[0] >= 0L && var42_67[0] >= 0L) {
                                                                                                            var43_70 = var42_67[0] - var41_63[0];
                                                                                                            var45_73 = true;
                                                                                                        }
                                                                                                        if (var41_63[1] >= 0L && var42_67[1] >= 0L) {
                                                                                                            var46_78 = var42_67[1] - var41_63[1];
                                                                                                            var48_90 = 1;
                                                                                                        }
                                                                                                        if (var45_73 && var48_90 != 0) ** continue;
                                                                                                        var38_52 = var48_90 != 0 ? var46_78 : var43_70;
                                                                                                    }
                                                                                                    if (Math.abs(var38_52) <= (long)var35_45) {
                                                                                                        var40_61 = 0;
                                                                                                    }
                                                                                                }
                                                                                                var14_18.switchMode = var40_61;
                                                                                            }
                                                                                            switch (var14_18.switchMode) {
                                                                                                case 1: {
                                                                                                    var14_18.switchTimecodeOffset = var38_52;
                                                                                                    break;
                                                                                                }
                                                                                                case 0: {
                                                                                                    var14_18.switchTimecodeOffset = 0L;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (var14_18.lastSeq != -1L || var37_50 == null || (var38_54 = var37_50.size()) <= 0) ** GOTO lbl602
                                                                                        var39_59 = -1L;
                                                                                        var41_65 = -1L;
                                                                                        var43_70 = -1L;
                                                                                        var45_74 = -1L;
                                                                                        var47_85 = var31_35;
                                                                                        ** GOTO lbl617
lbl418:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            var41_62 = v7;
                                                                                            if (var41_62 < 0) {
                                                                                                var41_62 = 0;
                                                                                            }
                                                                                            if (var41_62 >= var38_57) break block145;
                                                                                            var42_69 = var41_62;
                                                                                            ** GOTO lbl720
                                                                                            break;
                                                                                        }
                                                                                        while (true) {
                                                                                            ++var38_51;
                                                                                            ** GOTO lbl437
                                                                                            while (true) {
                                                                                                var45_72 = var28_31.getSize();
                                                                                                var6_6[6] = var6_6[6] + (long)var45_72;
                                                                                                var6_6[7] = var6_6[7] + 1L;
                                                                                                break block132;
                                                                                                break;
                                                                                            }
                                                                                            break;
                                                                                        }
lbl433:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            this.checkWorkBuffer(var18_21);
                                                                                            var36_47 = -1L;
                                                                                            var38_51 = var31_35;
lbl437:
                                                                                            // 2 sources

                                                                                            if (var38_51 >= var27_29) ** GOTO lbl295
                                                                                            var28_31 = (AMFPacket)var15_15.get(var38_51);
                                                                                            var39_58 = null;
                                                                                            var40_60 = var28_31.getAbsTimecode();
                                                                                            var42_66 = 0L;
                                                                                            var44_71 = var28_31.getType();
                                                                                            var45_72 = 0;
                                                                                            if (var14_18 != null) ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    switch (var44_71) {
                                                                                        default: {
                                                                                            WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info(Base64.replace((String)"\u000e&/%ql\u001a\u0003\u001c\u00024!#\u0007!$294)a|2++046\u0010-+!+-sj>\"&!8>q\"27>3#x-#+9g~", (int)(31 - -40)) + var28_31.getType());
                                                                                            break block132;
                                                                                        }
                                                                                        case 15: 
                                                                                        case 18: {
                                                                                            if (this.firstPacketTC != -1L) ** GOTO lbl458
                                                                                            var42_66 = 0L;
                                                                                            this.firstPacketTC = var40_60;
                                                                                            ** GOTO lbl241
                                                                                        }
                                                                                        case 8: {
                                                                                            if (var8_8) ** GOTO lbl460
                                                                                            break block132;
                                                                                        }
lbl458:
                                                                                        // 1 sources

                                                                                        var42_66 = var40_60 - this.firstPacketTC;
                                                                                        ** continue;
lbl460:
                                                                                        // 1 sources

                                                                                        if (!var20_23) ** continue;
                                                                                        break block132;
                                                                                        case 9: 
                                                                                    }
                                                                                    var46_79 = var28_31.getFirstByte();
                                                                                    var47_86 = FLVUtils.getVideoCodec((int)var46_79);
                                                                                    if (!var9_9 && var47_86 != 7) break block132;
                                                                                    var48_92 = var19_22 == 7;
                                                                                    if (!var48_92) {
                                                                                        var48_92 = this.testVideoFrame(var19_22, var46_79);
                                                                                    }
                                                                                    if (!var48_92) ** continue;
                                                                                    if (!this.waitForKeyFrame) break block161;
                                                                                    if (FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) break block162;
                                                                                }
                                                                                if (var45_72 > 0) {
                                                                                    this.avgPacketSizeTotal -= (long)this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)];
                                                                                    this.avgPacketSizeTotal += (long)var45_72;
                                                                                    this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)] = var45_72;
                                                                                    ++this.avgPacketSizeCount;
                                                                                }
                                                                                if (var39_58 == null) break block144;
                                                                                if (!this.sentPlayStart) {
                                                                                    if (this.sendPlayStop) {
                                                                                        var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_66, this.stream.getParent().getName());
                                                                                        this.sendPlayStop = false;
                                                                                    }
                                                                                    var7_7 += this.stream.getParent().sendLivePlayStart(var2_2, this.stream.getParent().getName(), var42_66, this.sendOriginalTimecodes != false ? 0L : this.firstPacketTC);
                                                                                    this.sentPlayStart = true;
                                                                                    this.sendPlayStop = true;
                                                                                    this.stream.getParent().setSendPlayStopLogEvent(true);
                                                                                    WMSLoggerFactory.putGlobalLogValue((String)Base64.replace((String)"q'x|b}", (int)(-94 + 103)), (Object)new Long(0L));
                                                                                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.replace((String)"261!$+", (int)(45 * 5)), "play", 200, this.stream.getParent().getName());
                                                                                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                                                                                    var5_5.setNew(true);
                                                                                    var3_3.setNew(true);
                                                                                    var4_4.setNew(true);
                                                                                }
                                                                                if (!this.sendPlaySwitch) break block163;
                                                                                this.sendPlaySwitch = false;
                                                                                var7_7 += this.stream.getParent().sendLivePlaySwitch(var2_2, var1_1.getName(), var42_66);
                                                                                var46_80 = var1_1.getMetaDataProvider();
                                                                                var47_87 = new ArrayList<E>();
                                                                                var48_95 = var28_31.getAbsTimecode();
                                                                                var46_80.onStreamStart(var47_87, var48_95);
                                                                                if (var47_87.size() <= 0) break block163;
                                                                                var50_103 = var47_87.iterator();
                                                                                break block164;
                                                                            }
                                                                            WMSLoggerFactory.getLogger(LivePlayer.class).debug(FileChunk.startsWith((int)(241 / 69), (String)"telrAg{AnuK|n}t(3rzcy|"));
                                                                            this.waitForKeyFrame = false;
                                                                            break block161;
                                                                        }
                                                                        var36_47 = var28_31.getSeq();
                                                                        if (!(this.playLen > 0.0) || var42_66 < Math.round(this.playLen)) ** continue;
                                                                        break block165;
                                                                    }
                                                                    while (var50_103.hasNext()) {
                                                                        var51_109 = (AMFPacket)var50_103.next();
                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var51_109, var42_66, var5_5, this.workBuffer, var18_21);
                                                                    }
                                                                }
                                                                if (var24_26 == null) {
                                                                    var24_26 = new LiveTracker();
                                                                    var24_26.firstTC = var40_60;
                                                                }
                                                                var24_26.lastTC = var40_60;
                                                                var46_77 = false;
                                                                if (!this.sendFirstKeyFrame) ** GOTO lbl278
                                                                var47_82 = var1_1.getMetaDataProvider();
                                                                if (var47_82 != null) ** break;
                                                                ** continue;
                                                                ** continue;
                                                            }
                                                            if (this.stream.getParent().isSendPlayStopLogEvent()) ** continue;
                                                        }
                                                        var7_7 += this.stream.getParent().sendPlayStatus(var2_2, var42_66, 2, 0.0, 0.0);
                                                        var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_66, this.stream.getParent().getName());
                                                        this.playlistEnd = true;
                                                        ** continue;
                                                    }
                                                    if (this.firstPacketTC != -1L) break block166;
                                                    var42_66 = 0L;
                                                    this.firstPacketTC = var40_60;
                                                    ** GOTO lbl253
                                                }
                                                var42_66 = var40_60 - this.firstPacketTC;
                                                ** continue;
lbl542:
                                                // 1 sources

                                                while ((var38_57 = var37_50.size()) > 0) {
                                                    block167: {
                                                        var28_31 = (AMFPacket)var37_50.get(0);
                                                        var39_59 = var28_31.getSeq();
                                                        if (var14_18.lastSeq != -1L) break block167;
                                                        v7 = 0;
                                                        ** GOTO lbl418
                                                    }
                                                    v7 = (int)(var14_18.lastSeq - var39_59 + 1L);
                                                    ** continue;
lbl551:
                                                    // 1 sources

                                                    ** GOTO lbl418
                                                }
                                                break block145;
lbl553:
                                                // 1 sources

                                                while (var44_71 == 9) {
                                                    if (this.b.d >= 30) ** continue;
                                                    this.b.a = var47_83;
                                                    this.b.b = var42_66;
                                                    this.b.c = var42_66;
                                                    ++this.b.d;
                                                    break block138;
                                                }
                                                break block138;
lbl561:
                                                // 2 sources

                                                while (true) {
                                                    block168: {
                                                        block169: {
                                                            var39_59 = var28_31.getAbsTimecode();
                                                            if (var32_39 == -1L) {
                                                                var32_39 = var39_59;
                                                            } else {
                                                                if (var35_45 == -1) {
                                                                    this.trackerBufferTime = var32_39 - var39_59;
                                                                }
                                                                if (var35_45 == -1 && var32_39 - var39_59 > var36_49) ** continue;
                                                            }
lbl569:
                                                            // 3 sources

                                                            if (var38_55 != 9) break block168;
                                                            var41_64 = FLVUtils.isVideoKeyFrame((AMFPacket)var28_31);
                                                            if (!this.isEnhancedSeekCapable) break block169;
                                                            if (var35_45 == -1 || !var41_64) break block168;
                                                            var23_25 = var28_31;
                                                            if (this.instantOnBufferTime > 0 && var32_39 - var39_59 < (long)this.instantOnBufferTime) break block168;
                                                            ** GOTO lbl158
                                                        }
                                                        if (var41_64) {
                                                            var23_25 = var28_31;
                                                        }
                                                    }
                                                    if (this.isEnhancedSeekCapable || var35_45 == -1) ** GOTO lbl666
                                                    ** GOTO lbl158
                                                    break;
                                                }
lbl582:
                                                // 1 sources

                                                while (true) {
                                                    block172: {
                                                        block173: {
                                                            block170: {
                                                                block171: {
                                                                    if (var54_119 < 0) break block170;
                                                                    var28_31 = (AMFPacket)var37_50.get(var54_119);
                                                                    var55_123 = var28_31.getType();
                                                                    var56_125 = var28_31.getAbsTimecode();
                                                                    if (var55_123 != 8) break block171;
                                                                    if (var41_65 == -1L) ** continue;
                                                                    if (var41_65 - var56_125 < var51_107) break block172;
                                                                    var53_116 = var54_119;
                                                                    break block170;
                                                                }
                                                                if (var55_123 != 9) break block172;
                                                                if (var45_74 == -1L) break block173;
                                                                if (var45_74 - var56_125 < var51_107) break block172;
                                                                var53_116 = var54_119;
                                                            }
                                                            if (var53_116 < 0) {
                                                                var53_116 = 0;
                                                            }
                                                            var28_31 = (AMFPacket)var37_50.get(var53_116);
                                                            var14_18.lastSeq = var28_31.getSeq();
lbl602:
                                                            // 2 sources

                                                            if (var14_18.lastSeq >= 0L && var14_18.switchVideoKeyFrameSeq < 0L && var37_50 != null) ** GOTO lbl542
                                                            break block145;
                                                        }
                                                        var45_74 = var56_125;
                                                    }
                                                    --var54_119;
                                                    continue;
                                                    break;
                                                }
                                            }
                                            while (true) {
                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var28_31, var42_66, var39_58, this.workBuffer, var18_21);
                                                if (!var46_77 || !this.isEnhancedSeekCapable) ** continue;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        while (true) {
                                            block175: {
                                                block176: {
                                                    block174: {
                                                        ++var47_85;
lbl617:
                                                        // 2 sources

                                                        if (var47_85 >= var27_29) break block174;
                                                        var28_31 = (AMFPacket)var15_15.get(var47_85);
                                                        var48_90 = var28_31.getType();
                                                        var49_96 = var28_31.getAbsTimecode();
                                                        if (var48_90 == 8) ** continue;
                                                        if (var48_90 != 9) continue;
                                                        if (var43_70 != -1L) break block175;
                                                        break block176;
                                                    }
                                                    var47_84 = var45_74 - var43_70;
                                                    var49_96 = var41_65 - var39_59;
                                                    var51_107 = Math.max(var47_84, var49_96);
                                                    var39_59 = -1L;
                                                    var41_65 = -1L;
                                                    var43_70 = -1L;
                                                    var45_74 = -1L;
                                                    var53_116 = -1;
                                                    var54_119 = var38_54 - 1;
                                                    ** continue;
                                                }
                                                var43_70 = var49_96;
                                            }
                                            var45_74 = var49_96;
                                        }
                                        while (true) {
                                            var46_81 = var28_31.getFirstByte();
                                            var47_84 = var28_31.getAbsTimecode();
                                            var14_18.switchVideoKeyFrameSeq = var43_70 - 1L;
                                            var14_18.switchTimecodeTarget = var47_84 + var14_18.switchTimecodeOffset;
                                            if (true) ** GOTO lbl718
                                            break;
                                        }
lbl647:
                                        // 2 sources

                                        while (true) {
                                            var46_77 = false;
lbl649:
                                            // 2 sources

                                            this.trackerStartSeq = var24_26.trackerSeq;
                                            this.sendFirstKeyFrame = false;
                                            this.lastReceiveAudio = var8_8;
                                            this.lastReceiveVideo = var9_9;
                                            this.lastReceiveVideoFPS = var10_10;
                                            break;
                                        }
                                    }
                                    if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) ** continue;
                                }
                                if (this.b == null) break block138;
                                var47_83 = System.currentTimeMillis();
                                if (var44_71 != 8) ** GOTO lbl553
                                if (this.b.h >= 30) ** continue;
                                ** continue;
                            }
                            if (!var46_77 || !this.isEnhancedSeekCapable) ** continue;
                            ** continue;
lbl-1000:
                            // 1 sources

                            {
                                if (var38_55 == 8) ** GOTO lbl561
lbl666:
                                // 2 sources

                                --var34_43;
lbl667:
                                // 2 sources

                                if (var34_43 >= 0) ** break;
                                ** continue;
                                var28_31 = (AMFPacket)var15_15.get(var34_43);
                                var38_55 = var28_31.getType();
                                if (var38_55 != 9) ** break;
                                ** continue;
                                ** while (true)
                            }
lbl674:
                            // 2 sources

                            while (true) {
                                this.lastReceiveVideo = var9_9;
                                ** GOTO lbl433
                                break;
                            }
                        }
                        while (true) {
                            if (!this.sendFirstKeyFrame && this.lastReceiveVideo != var9_9) ** break;
                            ** continue;
                            if (!var9_9) ** GOTO lbl674
                            this.waitForKeyFrame = true;
                            ** continue;
                            break;
                        }
                    }
                    while (true) {
                        block179: {
                            block181: {
                                block180: {
                                    block178: {
                                        block177: {
                                            if (var53_115 >= var38_51) break block177;
                                            var54_121 = (AMFPacket)var15_15.get(var53_115);
                                            if (var54_121.getType() == 9) break block178;
                                            break block179;
                                        }
                                        if (!var46_77 || !this.isEnhancedSeekCapable) ** GOTO lbl647
                                        break block180;
                                    }
                                    var55_123 = var54_121.getFirstByte();
                                    if (FLVUtils.getFrameType((int)var55_123) != 3) break block181;
                                    break block179;
                                }
                                v8 = this;
                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v8.getEnhanceSeekPacket(v8.stream.getParent(), var23_25.getFirstByte(), false), var42_66, var39_58, this.workBuffer, var18_21);
                                ** continue;
                            }
                            var6_6[2] = var6_6[2] + (long)var54_121.getSize();
                            var6_6[3] = var6_6[3] + 1L;
                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var54_121, var42_66, var4_4, this.workBuffer, var18_21);
                            ++var52_110;
                        }
                        ++var53_115;
                    }
                }
                var33_41 = 0;
                var34_43 = 0;
                while (true) {
                    if (var34_43 >= var27_29 || (var35_46 = (AMFPacket)var15_15.get(var34_43)).getType() == 9 && ++var33_41 > 2) ** continue;
                    ++var34_43;
                }
                while (true) {
                    if (FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) ** continue;
lbl718:
                    // 2 sources

                    while (true) {
                        ++var42_69;
lbl720:
                        // 2 sources

                        if (var42_69 >= var38_57) ** continue;
                        var28_31 = (AMFPacket)var37_50.get(var42_69);
                        var43_70 = var28_31.getSeq();
                        var45_75 = var28_31.getType();
                        var14_18.lastSeq = var43_70;
                        if (var45_75 == 9) ** continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen != 0.0) {
            return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null) return n;
        return n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        if (iMediaStream != null) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (!bl2) return;
            IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            if (iMediaStream == null) return;
            AMFPacket aMFPacket = this.getLastPacket(iMediaStream);
            if (aMFPacket == null) return;
            this.lastSeq = aMFPacket.getSeq();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)FileChunk.startsWith((int)(-11 - -32), (String)"m;dhvi"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), FileChunk.startsWith((int)(39 + 93), (String)"wqtbid"), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)FileChunk.startsWith((int)(5 * 57), (String)"e3lpnq"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.replace((String)"|dcwry", (int)(17 * 63)), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean(Base64.replace((String)"'<\u001c8$6\u00060&29-?)\u001999:", (int)(-46 - -28)), bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    @Override
    public void switchPlay() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (WMSLoggerFactory.isGlobalLogValueSet((String)Base64.replace((String)"i?`dze", (int)(96 + -47)))) return;
        WMSLoggerFactory.putGlobalLogValue((String)Base64.replace((String)"m;dhvi", (int)(31 * 43)), (Object)new Long(l));
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }

    private class PacketTimecodeDebug {
        long a = -1L;
        long b = -1L;
        long c = -1L;
        int d = 0;
        long e = -1L;
        long f = -1L;
        long g = -1L;
        int h = 0;
        long i = -1L;

        private PacketTimecodeDebug() {
        }
    }
}

