/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayWriteControl;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadySampleInfo;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.IQTDataDataToAMF;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderH264
implements IMediaReader,
IQTDataDataToAMF {
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = FileChunk.startsWith((int)(57 * 25), (String)"|b'");
    protected String mediaReaderExt = FileChunk.startsWith((int)(-58 - 33), (String)"hv3");
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.replace((String)"lr7", (int)(33 - 32));
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected int cursorType = 2;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected Object readAheadLock = new Object();
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 16384;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected long dataSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = Base64.replace((String)"dgd$|cztn>x}=P|dr{mHzryqrAbafwvTbimoy", (int)(-7 - -14));
    protected String randomAccessReadOptimizerClass = FileChunk.startsWith((int)(81 + -17), (String)"#./m3*1=)g#$b\u001f/!4>?\u0012763$+\u000b?:8\u0012.+),+9!7");
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = 0;
    protected String trackDataCharSet = FileChunk.startsWith((int)(59 - -41), (String)"\u0011\u0011\u0000jp");
    protected long onMetadataSample = -1L;
    protected boolean bufferSeekIO = false;
    protected IQTDataDataToAMF dataDataToAMFHandler = this;
    protected Map<String, PlayReadyKeyInfo> playReadyDecryptorKeys = new HashMap<String, PlayReadyKeyInfo>();
    static long a = -1L;

    public MediaReaderH264() {
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(163 / 45), (String)"nt1TbimKcilj\\ykw"), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(515 / 141), (String)"nt1TbimKcilj[bxutqg"), this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt(Base64.replace((String)"9%b\u001e6=?#\u001e(89%3\u0011*> ", (int)(99 + 113)), this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean(Base64.replace((String)"nt1EfkaoYiljNxtsw", (int)(765 / 239)), this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(FileChunk.startsWith((int)(821 / 207), (String)"qekbheHihi~}]upvvfVzvkj"), this.randomAccessReaderClass);
        this.randomAccessReadOptimizerClass = wMSProperties.getPropertyStr(Base64.replace((String)"#3=0:;\u0016;:?(/\u000f;>$\u000e27-(/=-;\t'->=", (int)(85 + 124)), this.randomAccessReadOptimizerClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(-33 - 36), (String)"vl)Kl%\u0005+04)'>\u001b 0."), this.useDisplaySize);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(1155 / 230), (String)"gsanlxXiheF_"), this.bufferSeekIO);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(5 + 64), (String)"#*1\n<,-)?\u001d*5:\u001b\u001c"), this.bufferSeekIO);
        if (!WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.replace((String)"T\u007f\u007fu|LzaegqL703&dz?^hokQywrpF\u007fm}#:", (int)(-2 - -27)) + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.replace((String)"\u0015<>2=\u000f;>ddpK632)ey>YiljNxtsw@g\u007fp\u007f|h!<", (int)(64 + 56)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(49 * 37), (String)"XssqxH~}y{mH347*hv3AgnntO{ivt`@}os-8") + this.indexBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(-63 - 6), (String)"Vyyw~\u0012$#'!7\u000eu~}d9-#* =\u0010101&%\u0005=8>>.\u001e2>32xc") + this.randomAccessReaderClass);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.replace((String)"I`bni[ojhh|G\"'&=ftxswt[x\u007fxmlRdcgawIw|`gbvh|L|pa`.5", (int)(506 / 115)) + this.randomAccessReadOptimizerClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            block18: {
                block16: {
                    Exception exception3;
                    block17: {
                        IRandomAccessReader iRandomAccessReader;
                        QTParseContext qTParseContext;
                        block15: {
                            block13: {
                                block14: {
                                    if (this.metaFileStream.isOpen()) {
                                        this.close();
                                    }
                                    try {
                                        this.metaFileStream.open();
                                        this.videoFileStream.open();
                                        this.errorReported = false;
                                        break block13;
                                    }
                                    catch (Exception exception2) {
                                        if (this.errorReported) break block14;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, FileChunk.startsWith((int)(187 / 33), (String)"HccahXnmik}X#$':zfrvB+F&=") + exception2.toString(), null, Base64.replace((String)"bwabpd", (int)(5 * 61)), "comment", 404, this.mediaName);
                                }
                                this.errorReported = true;
                            }
                            if (this.metaFileStream == null) return;
                            if (!this.metaFileStream.isOpen()) return;
                            try {
                                this.length = this.metaFileStream.length();
                                qTParseContext = new QTParseContext();
                                qTParseContext.setClientId(this.stream.getClientId());
                                qTParseContext.setIndexBufferSize(this.indexBufferSize);
                                qTParseContext.setParseAudioTrack(this.openAudioTrack);
                                qTParseContext.setParseVideoTrack(this.openVideoTrack);
                                qTParseContext.setIndexFilePtr(this.metaFileStream);
                                iRandomAccessReader = this.metaFileStream;
                                if (!this.bufferSeekIO) break block15;
                                int n = this.indexBufferSize;
                                iRandomAccessReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.metaFileStream, n, n / 2);
                                iRandomAccessReader.open();
                            }
                            catch (Exception exception3) {
                                if (this.errorReported) break block16;
                                break block17;
                            }
                        }
                        IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
                        this.container = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
                        if (this.bufferSeekIO) {
                            iRandomAccessReader.close();
                            iRandomAccessReader = null;
                        }
                        if (this.container != null) {
                            MediaReaderH264 mediaReaderH264 = this;
                            this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                            QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                            QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                            QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                            this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, this.cursorType);
                            if (this.cursor != null) {
                                this.videoSampleCount = this.cursor.getVideoSampleCount();
                                this.audioSampleCount = this.cursor.getAudioSampleCount();
                                this.dataSampleCount = this.cursor.getDataSampleCount();
                            }
                            this.readMetadata();
                            MediaReaderH264 mediaReaderH2642 = this;
                            this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderH2642, mediaReaderH2642.stream);
                            if (qTParseContext.getIndexRefCount() <= 0) {
                                this.metaFileStream.close();
                                this.metaFileStream = null;
                            }
                        }
                        if (this.container != null) return;
                        if (!this.errorReported) {
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, FileChunk.startsWith((int)(40 - 3), (String)"HccahXnmik}X#$':;yg}w ;Yolp2a2\"66/)/i,\" (n)?#?2 u\r\u001a\bm\u0007"), null, FileChunk.startsWith((int)(490 / 92), (String)"vcu~lx"), "comment", 500, this.mediaName);
                        }
                        this.errorReported = true;
                        break block18;
                    }
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.replace((String)"Jmmcj^hokucZ!\"!8xh|t@.@$?", (int)(41 - 34)) + exception3.toString(), null, FileChunk.startsWith((int)(343 / 56), (String)"ubz\u007foy"), "comment", 404, this.mediaName);
                }
                this.errorReported = true;
                this.container = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.container == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.replace((String)"LggmdTbimoyD?8;>~bvz/6", (int)(37 * 45)) + exception.toString());
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.dataSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        this.onMetadataSample = -1L;
        MediaReaderH264 mediaReaderH264 = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void readMetadata() {
        block28: {
            if (this.container == null) {
                this.metaData = null;
                return;
            }
            this.metaData = new ArrayList<E>();
            var1_1 = new AMFDataMixedArray();
            var2_2 = this.container.getMoovAtom();
            var3_3 = var2_2.getVideoTrack(this.trackIndexVideo);
            var4_4 = var3_3 == null ? null : var3_3.getMdiaAtom().getMinfAtom().getStblAtom();
            var5_5 = var2_2.getAudioTrack(this.trackIndexAudio);
            v0 = var6_6 = var5_5 == null ? null : var5_5.getMdiaAtom().getMinfAtom().getStblAtom();
            if (this.cursor == null || (var7_8 = this.cursor.getDataSampleCount()) <= 0L || !this.a(var2_2, this.trackIndexData)) break block28;
            var9_12 = this.getStreamPosition();
            var10_17 = 0;
            if (true) ** GOTO lbl203
lbl15:
            // 3 sources

            while (true) {
                var13_25.add((AMFData)var16_36 /* !! */ );
                ** GOTO lbl44
                break;
            }
lbl18:
            // 1 sources

            while (true) {
                block31: {
                    block35: {
                        block32: {
                            block33: {
                                block34: {
                                    block30: {
                                        block29: {
                                            if (var9_10 >= var8_9) break block29;
                                            var10_16 = var2_2.getTrak(var9_10);
                                            if (var10_16 != null) break block30;
                                            break block31;
                                        }
                                        var1_1.put(Base64.replace((String)"qtfkbcejb", (int)(335 / 62)), (AMFData)var7_7);
                                        if (var6_6 != null) {
                                            var1_1.put(FileChunk.startsWith((int)(-4 - 53), (String)"&=-#$/%/!>4> "), (AMFData)new AMFDataItem(var6_6.getAudioChannels()));
                                            var1_1.put(FileChunk.startsWith((int)(-65 - -30), (String)"<+;).1\")5*\":(>."), (AMFData)new AMFDataItem(var5_5.getMdiaAtom().getTimescale()));
                                        }
                                        if (var4_4 == null) break block32;
                                        var9_15 = var3_3.getMdiaAtom().getTimescale();
                                        var11_22 = 0.0;
                                        if (var4_4.getTimeToSample() == null) break block33;
                                        break block34;
                                    }
                                    var11_18 = new AMFDataObj();
                                    var11_18.put(Base64.replace((String)"uknavefdl", (int)(18 + -17)), (AMFData)new AMFDataItem(var10_16.getMdiaAtom().getTimescale()));
                                    var11_18.put(FileChunk.startsWith((int)(4 + 56), (String)"pxpx4)"), (AMFData)new AMFDataItem(var10_16.getMdiaAtom().getDuration()));
                                    var12_23 = var10_16.getLanguageStr();
                                    if (var12_23.length() <= 0) {
                                        var12_23 = FileChunk.startsWith((int)(53 * 3), (String)"znf");
                                    }
                                    var11_18.put(FileChunk.startsWith((int)(7 * 59), (String)"q\u007fqgtcda"), (AMFData)new AMFDataItem(var12_23));
                                    var13_25 = new AMFDataArray();
                                    var14_30 = var10_16.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
                                    var15_33 = var14_30.iterator();
lbl44:
                                    // 2 sources

                                    if (!var15_33.hasNext()) break block35;
                                    var16_36 /* !! */  = new AMFDataObj();
                                    var17_38 = var15_33.next();
                                    var16_36 /* !! */ .put(FileChunk.startsWith((int)(330 / 48), (String)"ufeyfnxt~j"), (AMFData)new AMFDataItem((String)var17_38));
                                    if (!var17_38.equals(FileChunk.startsWith((int)(606 / 165), (String)"w|6a")) || (var18_39 /* !! */  = (byte[])var10_16.getMdiaAtom().getMinfAtom().getStblAtom().getTX3GData()) == null) ** GOTO lbl15
                                    var19_40 = new AMFDataObj();
                                    var16_36 /* !! */ .put(FileChunk.startsWith((int)(27 * 37), (String)"#-/+> 9=;)=7"), (AMFData)var19_40);
                                    var20_42 = new AMFDataObj();
                                    var16_36 /* !! */ .put(FileChunk.startsWith((int)(28 - 23), (String)"acai|f\u007fxhv{r~j"), (AMFData)var20_42);
                                    var16_36 /* !! */ .put(Base64.replace((String)">2/-2>ygnbcv", (int)(-48 - -42)), (AMFData)new AMFDataItem(var18_39 /* !! */ .displayFlags));
                                    var16_36 /* !! */ .put(FileChunk.startsWith((int)(29 * 63), (String)"kkwo}gg~j`g{|dxtzwtb~ww"), (AMFData)new AMFDataItem(var18_39 /* !! */ .justificationHoriz));
                                    var16_36 /* !! */ .put(Base64.replace((String)"l~niw|amhvwqoaajk\u007feb`", (int)(37 - 11)), (AMFData)new AMFDataItem(var18_39 /* !! */ .justificationVert));
                                    var16_36 /* !! */ .put(Base64.replace((String)"quv}pjvoux~qs/3", (int)(39 * 21)), (AMFData)new AMFDataItem(var18_39 /* !! */ .backgroundColor));
                                    var20_42.put(Base64.replace((String)"wku", (int)(202 / 64)), (AMFData)new AMFDataItem(var18_39 /* !! */ .textBox[0]));
                                    var20_42.put(FileChunk.startsWith((int)(62 + 89), (String)"eq~ro"), (AMFData)new AMFDataItem(var18_39 /* !! */ .textBox[3]));
                                    var20_42.put(FileChunk.startsWith((int)(175 / 48), (String)"oacr"), (AMFData)new AMFDataItem(var18_39 /* !! */ .textBox[1]));
                                    var20_42.put(Base64.replace((String)"jf~\u007fc`", (int)(99 + 69)), (AMFData)new AMFDataItem(var18_39 /* !! */ .textBox[2]));
                                    var19_40.put(FileChunk.startsWith((int)(-15 - 10), (String)"4<(8?/%/="), (AMFData)new AMFDataItem(var18_39 /* !! */ .startChar));
                                    var19_40.put(FileChunk.startsWith((int)(680 / 107), (String)"ciljbj~"), (AMFData)new AMFDataItem(var18_39 /* !! */ .endChar));
                                    var19_40.put(FileChunk.startsWith((int)(59 * 17), (String)"-##:&4"), (AMFData)new AMFDataItem(var18_39 /* !! */ .fontId));
                                    var19_40.put(FileChunk.startsWith((int)(1673 / 244), (String)"`fkly\u007fuaki|pu`"), (AMFData)new AMFDataItem(var18_39 /* !! */ .faceStyleFlags));
                                    var19_40.put(Base64.replace((String)"ekkrtaso", (int)(580 / 192)), (AMFData)new AMFDataItem(var18_39 /* !! */ .fontSize));
                                    var19_40.put(FileChunk.startsWith((int)(11 * 41), (String)"7!=2$'%%9"), (AMFData)new AMFDataItem(var18_39 /* !! */ .textColor));
                                    if (var18_39 /* !! */ .fonts.size() <= 0) ** GOTO lbl15
                                    var21_43 = new AMFDataObj();
                                    var16_36 /* !! */ .put(FileChunk.startsWith((int)(-3 - -29), (String)"|trirvsu"), (AMFData)var21_43);
                                    var22_45 = var18_39 /* !! */ .fonts.keySet().iterator();
                                    while (true) {
                                        if (var22_45.hasNext()) ** break;
                                        ** continue;
                                        var23_47 /* !! */  = var22_45.next();
                                        var24_48 = var18_39 /* !! */ .fonts.get(var23_47 /* !! */ );
                                        var21_43.put(var24_48.fontId + "", (AMFData)new AMFDataItem(var24_48.fontName));
                                    }
                                }
                                var13_29 = var4_4.getTimeToSample().get(0, 1);
                                var11_22 = (double)var9_15 / (double)var13_29;
                            }
                            var1_1.put(Base64.replace((String)"\u007fcoibh}q|wauas", (int)(53 * 37)), (AMFData)new AMFDataItem(var11_22));
                        }
                        var1_1.put(Base64.replace((String)",/,1>&", (int)(42 + 67)), (AMFData)new AMFDataItem(2.0));
                        if (var4_4 != null && (var9_11 = var4_4.getAVCCData()) != null) {
                            var1_1.put(FileChunk.startsWith((int)(20 - 41), (String)"*:.\"*&4>"), (AMFData)new AMFDataItem(var9_11.getAvcLevel()));
                            var1_1.put(FileChunk.startsWith((int)(507 / 81), (String)"gqkyxdjdbj"), (AMFData)new AMFDataItem(var9_11.getAvcProfile()));
                        }
                        if (var6_6 != null) {
                            var1_1.put(Base64.replace((String)"i|nbcnakur{w", (int)(4 - -36)), (AMFData)new AMFDataItem(var6_6.getDataTypes().get(0)));
                        }
                        if (var4_4 != null) {
                            var1_1.put(FileChunk.startsWith((int)(33 * 25), (String)"os\u007fyr}p$$!* "), (AMFData)new AMFDataItem(var4_4.getDataTypes().get(0)));
                        }
                        if (var4_4 != null) {
                            if (this.useDisplaySize) {
                                var1_1.put(FileChunk.startsWith((int)(47 + 112), (String)"hievk"), (AMFData)new AMFDataItem(var4_4.getDisplayWidth()));
                                var1_1.put(Base64.replace((String)"wehekp", (int)(-11 - -42)), (AMFData)new AMFDataItem(var4_4.getDisplayHeight()));
                            } else {
                                var1_1.put(FileChunk.startsWith((int)(49 - 18), (String)"hievk"), (AMFData)new AMFDataItem(var4_4.getFrameWidth()));
                                var1_1.put(Base64.replace((String)"mcnoa~", (int)(55 * 3)), (AMFData)new AMFDataItem(var4_4.getFrameHeight()));
                            }
                            var1_1.put(Base64.replace((String)"qjxw~Ktzk(", (int)(63 * 9)), (AMFData)new AMFDataItem(var4_4.getFrameWidth()));
                            var1_1.put(FileChunk.startsWith((int)(-20 - -39), (String)"uft{rP|s|ti"), (AMFData)new AMFDataItem(var4_4.getFrameHeight()));
                            var1_1.put(FileChunk.startsWith((int)(905 / 206), (String)"`luwdhs\\eizg"), (AMFData)new AMFDataItem(var4_4.getDisplayWidth()));
                            var1_1.put(FileChunk.startsWith((int)(27 - -25), (String)"p|egtxcSytyw4"), (AMFData)new AMFDataItem(var4_4.getDisplayHeight()));
                            var9_14 = var4_4.getFrameRate();
                            if (var9_14 > 0.0) {
                                var1_1.put(Base64.replace((String)"bwgjm{k\u007fi", (int)(641 / 136)), (AMFData)new AMFDataItem(var9_14));
                            }
                        }
                        var1_1.put(FileChunk.startsWith((int)(1328 / 230), (String)"hih~yexeyg`~"), (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
                        var9_13 = 0.0;
                        if (var5_5 != null) {
                            var11_20 = var5_5.getMdiaAtom().getTimescale();
                            var13_26 = var5_5.getMdiaAtom().getDuration();
                            var9_13 = (double)var13_26 / (double)var11_20;
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(93 + 10), (String)"&=-#$\b8<.$8==n") + var9_13 + ":" + var11_20 + ":" + var13_26);
                        }
                        var11_21 = 0.0;
                        if (var3_3 != null) {
                            var13_28 = var3_3.getMdiaAtom().getTimescale();
                            var15_35 = var3_3.getMdiaAtom().getDuration();
                            var11_21 = (double)var15_35 / (double)var13_28;
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(37 * 45), (String)"wkgajBrzh~bcc4") + var11_21 + ":" + var13_28 + ":" + var15_35);
                        }
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(365 / 78), (String)"`ptf|`ee6") + Math.max(var9_13, var11_21));
                        var13_27 = Math.max(var9_13, var11_21);
                        this.duration = Math.round(var13_27 * 1000.0);
                        var1_1.put(Base64.replace((String)"&66$2.''", (int)(23 + 75)), (AMFData)new AMFDataItem(var13_27));
                        var15_34 = new AMFDataList();
                        var15_34.add((AMFData)new AMFDataItem(FileChunk.startsWith((int)(-22 - 19), (String)"86\u0014?/=\u0019?+!")));
                        var15_34.add((AMFData)var1_1);
                        var16_36 /* !! */  = (AMFDataObj)var15_34.serialize();
                        this.metaData.add(ByteBuffer.wrap((byte[])var16_36 /* !! */ ));
                        if (var6_6 == null) return;
                        var17_38 = var6_6.getDataTypes();
                        var18_39 /* !! */  = this.getAudioCodecConfig(0L);
                        if (!var17_38.contains(FileChunk.startsWith((int)(41 * 41), (String)"?\u007fc'"))) {
                            if (var17_38.contains(Base64.replace((String)"kw<h", (int)(406 / 59))) == false) return;
                            if (var18_39 /* !! */  != null) return;
                        }
                        this.audioType = 47;
                        this.audioExtraSize = 1;
                        this.audioCodec = 2;
                        return;
                    }
                    var11_18.put(FileChunk.startsWith((int)(27 * 19), (String)"rcnticcmziye}zf\u007f\u007f"), (AMFData)var13_25);
                    var7_7.add((AMFData)var11_18);
                }
                ++var9_10;
                continue;
                break;
            }
        }
lbl146:
        // 2 sources

        while (true) {
            var7_7 = new AMFDataArray();
            var8_9 = var2_2.getTrakCount();
            var9_10 = 0;
            ** continue;
            break;
        }
        do {
            block36: {
                block38: {
                    block37: {
                        if (var11_19 != 18 && var11_19 != 15) break block36;
                        try {
                            var14_31 = this.cursor.getFileLoc();
                            var16_37 = this.cursor.getSize();
                            if (var16_37 <= 0L) {
                            }
                        }
                        catch (Exception var14_32) {}
                        break block36;
                        var18_39 /* !! */  = new byte[(int)var16_37];
                        var19_41 = 0;
                        // MONITORENTER : this.videoFileStream
                        this.videoFileStream.seek(var14_31);
                        var19_41 = this.videoFileStream.read(var18_39 /* !! */ , 0, (int)var16_37);
                        // MONITOREXIT : var20_42
                        if ((long)var19_41 != var16_37 || (var20_42 = new AMFDataList(var18_39 /* !! */ )) == null || var20_42.size() <= 1 || var20_42.get(0).getType() != 2) break block36;
                        var21_43 = var20_42.getString(0);
                        if (var21_43.equals(Base64.replace((String)"DvcsLh~jJ\u007fobu", (int)(-4 - -8)))) {
                            var20_42.remove(0);
                        }
                        if (var20_42.size() <= 1 || var20_42.get(0).getType() != 2 || !(var21_43 = var20_42.getString(0)).equalsIgnoreCase(Base64.replace((String)"$\"\u0000+;1\u00153'5", (int)(4 - 25))) || (var22_46 = var20_42.get(1).getType()) != 3 && var22_46 != 8) break block36;
                        if (var22_46 == 3) break block37;
                        if (var22_46 == 8) {
                            var23_47 /* !! */  = (AMFDataMixedArray)var20_42.get(1);
                            var24_48 = var23_47 /* !! */ .getKeys();
                            var25_49 = var24_48.iterator();
                            while (var25_49.hasNext()) {
                                var26_50 = (String)var25_49.next();
                                var27_51 = var23_47 /* !! */ .get(var26_50);
                                var1_1.put(var26_50, var27_51);
                            }
                        }
                        break block38;
                    }
                    var23_47 /* !! */  = (AMFDataObj)var20_42.get(1);
                    var24_48 = var23_47 /* !! */ .getKeys();
                    var25_49 = var24_48.iterator();
                    while (var25_49.hasNext()) {
                        var26_50 = (String)var25_49.next();
                        var27_51 = var23_47 /* !! */ .get(var26_50);
                        var1_1.put(var26_50, var27_51);
                    }
                }
                this.onMetadataSample = this.cursor.getSample();
            }
            if (this.onMetadataSample >= 0L) break;
            this.cursor.moveNextSample();
            if (this.cursor.isAtEnd()) break;
            ++var10_17;
lbl203:
            // 2 sources

            if (var10_17 >= 10) break;
            var11_19 = this.cursor.getCurrentType();
        } while ((var12_24 = this.cursor.getTimeMillis()) <= 0L);
        this.setStreamPosition(var9_12);
        ** while (true)
        catch (Throwable var21_44) {
            // MONITOREXIT : var20_42
            throw var21_44;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private final boolean a(QTAtommoov qTAtommoov, int n) {
        block3: {
            String string;
            Iterator<String> iterator;
            boolean bl;
            block2: {
                bl = false;
                QTAtomtrak qTAtomtrak = qTAtommoov.getDataTrack(n);
                QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
                if (qTAtomstbl == null) return bl;
                List<String> list = qTAtomstbl.getDataTypes();
                iterator = list.iterator();
                if (!true) break block2;
                if (!iterator.hasNext()) return bl;
                if ((string = iterator.next()).toLowerCase().indexOf(FileChunk.startsWith((int)(47 - 49), (String)"?2f1")) >= 0) break block3;
            }
            do {
                if (string.toLowerCase().indexOf(Base64.replace((String)"obv\"", (int)(94 + 80))) >= 0) return true;
                if (!iterator.hasNext()) return bl;
            } while ((string = iterator.next()).toLowerCase().indexOf(FileChunk.startsWith((int)(47 - 49), (String)"?2f1")) < 0);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            qTParseContext.setIndexFilePtr(iRandomAccessReader);
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.replace((String)" 7'-*\u00022:(>\"##t", (int)(5 * 13)) + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(FileChunk.startsWith((int)(40 - 6), (String)"tj``iC}{k\u007feb`5") + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {}
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container != null) {
            return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample(), !this.cursor.isAtDataEnd() ? this.cursor.getDataSample() : -1L);
        }
        return new H264StreamPosition();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        long l3 = h264StreamPosition.getDataSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
        if (l3 < 0L) {
            this.cursor.setDataAtEnd();
            return;
        }
        this.cursor.setDataSample(l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.videoFileStream == null) return 0L;
        long l = this.videoFileStream.length();
        return l;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.metaFileStream.getPath();
    }

    public void rewind() {
        if (this.container != null) {
            this.cursor.setAudioSample(0L);
            this.cursor.setVideoSample(0L);
            this.cursor.setDataSample(0L);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long l, int n) {
        if (l > 0L) {
            return this.internalSeek(l, n);
        }
        l = 0L;
        return this.internalSeek(l, n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected PlaylistSeekResult internalSeek(long var1_1, int var3_2) {
        block20: {
            block19: {
                block18: {
                    var4_3 = new PlaylistSeekResult(var1_1);
                    if (this.container == null) {
                        return var4_3;
                    }
                    var5_5 = -1L;
                    var7_6 = -1L;
                    var9_7 = -1L;
                    var11_8 = -1L;
                    if (this.cursor.containsAudio()) {
                        v0 = this.cursor;
                        var5_5 = v0.audioTimecodeToSample(v0.audioTimeMillisToTimecode(var1_1));
                    }
                    if (!this.cursor.containsData()) ** GOTO lbl18
                    v1 = this.cursor;
                    var11_8 = v1.dataTimecodeToSample(v1.dataTimeMillisToTimecode(var1_1));
                    if (var11_8 < 0L) ** GOTO lbl18
                    var13_9 = 0;
lbl16:
                    // 2 sources

                    while (true) {
                        if (var13_9 < 10 && (var16_4 = this.cursor.dataTimecodeToTimeMillis(var14_13 = this.cursor.dataSampleToTimecode(var11_8))) < var1_1) break block18;
lbl18:
                        // 4 sources

                        while (true) {
                            block22: {
                                block21: {
                                    if (!this.cursor.containsVideo()) ** GOTO lbl37
                                    v2 = this.cursor;
                                    var9_7 = v2.videoTimecodeToSample(v2.videoTimeMillisToTimecode(var1_1));
                                    switch (var3_2) {
                                        case 4: {
                                            ** break;
                                        }
                                        case 3: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 3);
                                            ** break;
                                        }
                                        case 1: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 1);
                                            ** break;
                                        }
                                        case 2: {
                                            var7_6 = this.cursor.videoFindKeySample(var9_7, 2);
                                            ** break;
                                        }
                                        default: {
                                            if (var7_6 >= 0L) break block21;
                                            break block22;
                                        }
                                    }
lbl37:
                                    // 5 sources

                                    if (var7_6 >= 0L) break block21;
                                }
                                var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L, -1L));
                                ** GOTO lbl72
                            }
                            var13_10 = this.cursor.videoSampleToTimecode(var7_6);
                            var15_14 = this.cursor.videoTimecodeToTimeMillis(var13_10);
                            var17_15 = this.cursor.audioTimeMillisToTimecode(var15_14);
                            var19_16 = this.cursor.audioTimecodeToSample(var17_15);
                            var21_17 = this.cursor.dataTimeMillisToTimecode(var15_14);
                            var23_18 = this.cursor.dataTimecodeToSample(var21_17);
                            if (var23_18 < 0L) break block19;
                            var25_19 = 0;
                            if (true) ** GOTO lbl108
                            break;
                        }
lbl51:
                        // 1 sources

                        while (true) {
                            var11_8 = -1L;
                            ** continue;
                            break;
                        }
lbl54:
                        // 4 sources

                        while (var11_8 >= 0L) {
                            this.cursor.resetDataAtEnd();
                            break block20;
                        }
                        break block20;
                        break;
                    }
                    while (true) {
                        var23_18 = -1L;
                        break block19;
                        while (true) {
                            var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                            var17_15 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                            var19_16 = this.cursor.videoSampleToTimecode(var9_7);
                            var21_17 = this.cursor.videoTimecodeToTimeMillis(var19_16);
                            var13_11 = Math.min(var17_15, var21_17);
                            this.cursor.resetAudioAtEnd();
                            this.cursor.resetVideoAtEnd();
                            ** GOTO lbl54
                            break;
                        }
lbl70:
                        // 2 sources

                        while (true) {
                            block23: {
                                this.cursor.resetVideoAtEnd();
lbl72:
                                // 2 sources

                                var13_11 = 0L;
                                if (var5_5 >= 0L && var9_7 >= 0L) ** continue;
                                if (var9_7 < 0L) break block23;
                                var15_14 = this.cursor.videoSampleToTimecode(var9_7);
                                var13_11 = this.cursor.videoTimecodeToTimeMillis(var15_14);
                                this.cursor.resetVideoAtEnd();
                                ** GOTO lbl54
                            }
                            if (var5_5 < 0L) ** GOTO lbl54
                            var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                            var13_11 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                            this.cursor.resetAudioAtEnd();
                            ** GOTO lbl54
                            break;
                        }
                        break;
                    }
                }
                ** while (!this.cursor.getDataSampleValid((long)(var11_8 + 1L)))
lbl87:
                // 1 sources

                ++var11_8;
                ++var13_9;
                ** while (true)
            }
lbl91:
            // 2 sources

            while (true) {
                block24: {
                    var17_15 = this.cursor.audioSampleToTimecode(var19_16);
                    var25_20 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                    if (var25_20 < var15_14 && this.cursor.getAudioSampleValid(var19_16 + 1L)) {
                        var17_15 = this.cursor.audioSampleToTimecode(++var19_16);
                    }
                    var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(var19_16, var7_6, var23_18));
                    if (var5_5 < 0L) break block24;
                    var27_21 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                    var4_3.setResultVideoTimecode(Math.min(var27_21, var15_14));
                    ** GOTO lbl70
                }
                var4_3.setResultVideoTimecode(var15_14);
                ** continue;
                break;
            }
            do {
                if (!this.cursor.getDataSampleValid(var23_18 + 1L)) ** continue;
                ++var23_18;
                ++var25_19;
lbl108:
                // 2 sources

            } while (var25_19 < 10 && (var28_23 = this.cursor.dataTimecodeToTimeMillis(var26_22 = this.cursor.dataSampleToTimecode(var23_18))) < var15_14);
            ** while (true)
        }
        var4_3.setResults((IMediaReaderStreamPosition)new H264StreamPosition(var5_5, var9_7, var11_8), var13_11, 8, 1);
        var4_3.setResultTimecode(var13_11);
        var4_3.setSearchTimecode(var1_1);
        return var4_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        if (h264ReadAheadPacket == null) return h264Cursor.getSampleDesc();
        return h264ReadAheadPacket.getSampleDesc();
    }

    /*
     * Exception decompiling
     */
    public int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 711->734)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte getFirstByte(H264Cursor h264Cursor) {
        byte by = 0;
        int n = h264Cursor.getCurrentType();
        switch (n) {
            case 9: {
                if (!h264Cursor.isKeyFrame()) return 39;
                return 23;
            }
            case 15: 
            case 18: {
                by = 0;
            }
            default: {
                return by;
            }
            case 8: 
        }
        return (byte)this.audioType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), true, n2 != 0 ? 2 : 1, null);
            }
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            if (iFasterByteArrayWriteControl == null) return n5;
            iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), false, n2 != 0 ? 2 : 1, null);
            return n5 += n6;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.replace((String)"[r|p{Iy|zzrI050+ci`hdhiiMbt+2", (int)(-10 - -32)) + exception.toString());
            return n5;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     */
    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        Object object;
        Object object2;
        int n3;
        block9: {
            QTAtommdia qTAtommdia;
            QTAtommoov qTAtommoov;
            byte[] byArray;
            QTAtomstbl qTAtomstbl;
            block8: {
                n3 = 0;
                switch (n) {
                    case 9: {
                        qTAtomstbl = null;
                        byArray = null;
                        qTAtommoov = this.container.getMoovAtom();
                        if (qTAtommoov == null) {
                            break;
                        }
                        break block8;
                    }
                    case 8: {
                        return n3;
                    }
                }
                break block9;
            }
            object2 = qTAtommoov.getVideoTrack(this.trackIndexVideo);
            if (object2 != null && (qTAtommdia = ((QTAtomtrak)object2).getMdiaAtom()) != null && (object = qTAtommdia.getMinfAtom()) != null && (qTAtomstbl = ((QTAtomminf)object).getStblAtom()) != null) {
                AVCCData aVCCData;
                long l = playlistCursor.getVideoSampleDesc();
                if (l < 0L) {
                    l = 0L;
                }
                if ((aVCCData = qTAtomstbl.getAVCCData((int)l)) != null) {
                    byArray = aVCCData.getAvccBytes();
                }
            }
        }
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        object2 = new byte[5];
        int n5 = 0;
        object = new int[5];
        object[1] = false;
        object[2] = n2;
        object[0] = 9;
        object2[0] = 23;
        object2[1] = 2;
        object2[2] = false;
        object2[3] = false;
        object2[4] = false;
        object[1] = 5;
        n5 = this.directOutputBuf((int[])object, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, (byte[])object2);
        lArray[2] = lArray[2] + (long)n5;
        lArray[3] = lArray[3] + 1L;
        return n3 += n5;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        Object var5_4 = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) return byArray;
        AVCCData aVCCData = qTAtomstbl.getAVCCData((int)l);
        if (aVCCData == null) return byArray;
        return aVCCData.getAvccBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int sendVideoTrakData(int var1_1, boolean var2_2, IMediaStream var3_3, OutputStream var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10, byte[] var11_11) {
        block11: {
            block7: {
                block9: {
                    block10: {
                        block6: {
                            block8: {
                                var12_12 = 0;
                                var13_13 = false;
                                var14_14 = var6_6.getWriteControl().getChunkSize();
                                this.checkWorkBuffer(var14_14);
                                if (var11_11 != null) break block8;
                                break block9;
lbl7:
                                // 2 sources

                                return var12_12;
lbl9:
                                // 1 sources

                                while (true) {
                                    var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                                    var12_12 += var16_16;
                                    var9_9[2] = var9_9[2] + (long)var16_16;
                                    var9_9[3] = var9_9[3] + 1L;
                                    ++var18_18;
                                    break block6;
                                    break;
                                }
lbl16:
                                // 2 sources

                                while (true) {
                                    if (var18_18 >= v0) ** GOTO lbl7
                                    ** continue;
                                    break;
                                }
lbl19:
                                // 1 sources

                                while (true) {
                                    v0 = 2;
                                    ** GOTO lbl16
                                    break;
                                }
                            }
                            v1 = var11_11.length;
                            break block10;
                        }
lbl26:
                        // 2 sources

                        while (var13_13) {
                            ** continue;
lbl28:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        break block11;
                    }
lbl31:
                    // 2 sources

                    while (true) {
                        var15_15 = new byte[v1 + 5];
                        var16_16 = 0;
                        var17_17 = new int[5];
                        var17_17[1] = 0;
                        var17_17[2] = var1_1;
                        var17_17[0] = 9;
                        if (var11_11 != null) ** break;
                        ** continue;
                        break block7;
                        break;
                    }
                }
                v1 = 0;
                ** while (true)
            }
            var15_15[0] = 23;
            var15_15[1] = 0;
            var15_15[2] = 0;
            var15_15[3] = 0;
            var15_15[4] = 0;
            System.arraycopy(var11_11, 0, var15_15, 5, var11_11.length);
            var17_17[1] = var11_11.length + 5;
            var17_17[2] = 0;
            var2_2 = false;
            var18_18 = 0;
            ** GOTO lbl26
        }
        v0 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        ESDSData eSDSData = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) {
            return byArray;
        }
        eSDSData = qTAtomstbl.getESDSData((int)l);
        if (eSDSData != null) return eSDSData.specData;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 8;
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -81;
        byArray2[1] = 0;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        nArray[1] = byArray.length + 2;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings == null) return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        if (fastPlaySettings.getDirection() >= 0) return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        block39: {
            var11_11 = 0;
            var12_12 = false;
            var13_13 = false;
            var14_14 = false;
            var15_15 = 0;
            var16_16 = var7_7.getMaxTC();
            this.videoFileStream.setDirecton(1);
            var18_17 = var6_6.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var18_17);
            var19_18 = 0L;
            var21_19 = 0L;
            ** GOTO lbl189
lbl-1000:
            // 1 sources

            {
                block42: {
                    block43: {
                        block40: {
                            block41: {
                                block50: {
                                    block44: {
                                        while (var27_23 >= var16_16) {
                                            // MONITOREXIT : var23_20
                                            break block39;
                                        }
                                        break block43;
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastVideoTC() & 0xFFFFFFFFL);
                                            ** GOTO lbl94
                                            break;
                                        }
                                        while (true) {
                                            var6_6.setSendAbsBroadcastTC(false);
                                            ** GOTO lbl109
                                            break;
                                        }
lbl23:
                                        // 2 sources

                                        while (true) {
                                            var11_11 += var33_33;
                                            ** GOTO lbl51
lbl26:
                                            // 1 sources

                                            while (this.videoCodec == 7) {
                                                v0 = true;
                                                ** GOTO lbl69
                                            }
                                            ** GOTO lbl63
                                            break;
                                        }
lbl30:
                                        // 1 sources

                                        while (this.videoCodec != 7) {
                                            break block40;
                                        }
                                        break block44;
                                        while (true) {
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl131
                                            break;
                                        }
lbl36:
                                        // 1 sources

                                        while (true) {
                                            var9_9[6] = var9_9[6] + (long)this.chunkHeaderValues[1];
                                            var9_9[7] = var9_9[7] + 1L;
                                            ** break;
                                            break;
                                        }
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var30_26 + var6_6.getStartTCOffset());
                                            var27_23 = var30_26;
                                            ** GOTO lbl91
                                            break;
                                        }
                                        while (true) {
                                            block48: {
                                                block47: {
                                                    block45: {
                                                        block46: {
                                                            if (var10_10) {
                                                                this.chunkHeaderValues[2] = 0;
                                                            }
                                                            if (var21_19 == var6_6.getVideoSampleDesc()) break block45;
                                                            var31_28 = this.getVideoCodecConfig(var21_19);
                                                            var32_30 = var6_6.compareAndSetVideoCodecConfig(var31_28);
                                                            if (var32_30 == 0) break block46;
lbl51:
                                                            // 2 sources

                                                            var6_6.setVideoSampleDesc(var21_19);
                                                            break block45;
                                                        }
                                                        v1 = this;
                                                        var33_33 = v1.sendVideoTrakData(v1.chunkHeaderValues[2], (boolean)var29_24, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var10_10, var31_28);
                                                        if (var33_33 <= 0) ** GOTO lbl23
                                                        break block47;
                                                    }
                                                    var6_6.setLastVideoTC(var27_23);
                                                    var6_6.incVideoPacketCount();
                                                    var25_22 = var27_23;
                                                    if (!var1_1.isReceiveVideo()) ** GOTO lbl26
lbl63:
                                                    // 2 sources

                                                    v0 = false;
                                                    break block48;
                                                }
                                                var29_24 = 0;
                                                this.chunkHeaderValues[2] = 0;
                                                ** continue;
                                            }
                                            var31_27 = v0;
                                            v2 = this;
                                            var32_30 = v2.directOutput(v2.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, var31_27);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incVideoPackets();
                                            if (this.videoSampleCount > 0L && var19_18 == this.videoSampleCount - 1L) {
                                                v3 = this;
                                                var33_33 = v3.directOutput(v3.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, true);
                                                var11_11 += var33_33;
                                                var8_8.incVideoPackets();
                                            }
                                            var12_12 = true;
                                            var13_13 = true;
                                            var9_9[2] = var9_9[2] + (long)var32_30;
                                            var9_9[3] = var9_9[3] + 1L;
                                            break block40;
                                            break;
                                        }
lbl86:
                                        // 2 sources

                                        while (true) {
                                            var29_24 = var6_6.isSendAbsVideoTC();
                                            if (!var6_6.isSendAbsVideoTC()) ** continue;
                                            if ((var30_26 = var6_6.getForceVideoTC()) >= 0L) ** continue;
                                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
lbl91:
                                            // 2 sources

                                            if (this.chunkHeaderValues[2] < 0) break block40;
                                            var6_6.setForceVideoTC(-1L);
                                            var6_6.setSendAbsVideoTC(false);
lbl94:
                                            // 2 sources

                                            var30_25 = var7_7.testVideoFrame(this.chunkHeaderValues[3]);
                                            if (this.chunkHeaderValues[2] >= 0 && var30_25) ** continue;
                                            if (var30_25) ** break;
                                            ** continue;
                                            break;
                                        }
                                        while (true) {
                                            var31_27 = false;
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl137
                                            break;
                                        }
lbl102:
                                        // 2 sources

                                        while (true) {
                                            var32_30 = var6_6.isSendAbsBroadcastTC();
                                            if (var6_6.isSendAbsBroadcastTC()) {
                                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                if (this.chunkHeaderValues[2] >= 0) ** continue;
                                                break block40;
                                            } else {
                                                this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastBroadcastTC() & 0xFFFFFFFFL);
lbl109:
                                                // 2 sources

                                                var6_6.setLastBroadcastTC(var27_23);
                                                var6_6.incDataPacketCount();
                                                var25_22 = var27_23;
                                                if (var10_10) {
                                                    this.chunkHeaderValues[2] = 0;
                                                }
                                                v4 = this;
                                                var33_33 = v4.directOutput(v4.chunkHeaderValues, var19_18, (boolean)var32_30, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                                var11_11 += var33_33;
                                                var9_9[4] = var9_9[4] + (long)var33_33;
                                                var9_9[5] = var9_9[5] + 1L;
                                                var24_21 = true;
                                            }
                                            break block40;
                                            break;
                                        }
lbl121:
                                        // 1 sources

                                        while (!var7_7.isAudioFilter()) {
                                            block49: {
                                                var31_27 = var6_6.isSendAbsAudioTC();
                                                if (var6_6.isSendAbsAudioTC()) {
                                                    this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                    if (this.chunkHeaderValues[2] < 0) break block40;
                                                    var6_6.setSendAbsAudioTC(false);
                                                } else {
                                                    this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
                                                }
                                                if (this.chunkHeaderValues[2] < 0) ** break;
                                                if (var10_10) ** continue;
lbl131:
                                                // 2 sources

                                                if (var21_19 == var6_6.getAudioSampleDesc()) break block49;
                                                var32_31 = this.getAudioCodecConfig(var21_19);
                                                var33_33 = var6_6.compareAndSetAudioCodecConfig(var32_31);
                                                if (var33_33 == 0) {
                                                    v5 = this;
                                                    if ((var34_34 = v5.sendAudioTrakData(v5.chunkHeaderValues[2], var31_27, var1_1, var2_2, var3_3, var6_6, var7_7, var8_8, var9_9, var10_10, var32_31)) > 0) ** continue;
                                                }
lbl137:
                                                // 4 sources

                                                var6_6.setAudioSampleDesc(var21_19);
                                            }
                                            var6_6.setLastAudioTC(var27_23);
                                            var6_6.incAudioPacketCount();
                                            var25_22 = var27_23;
                                            v6 = this;
                                            var32_30 = v6.directOutput(v6.chunkHeaderValues, var19_18, var31_27, var1_1.getSrc(), var2_2, var3_3, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incAudioPackets();
                                            var12_12 = true;
                                            var14_14 = true;
                                            var9_9[0] = var9_9[0] + (long)var32_30;
                                            var9_9[1] = var9_9[1] + 1L;
                                            break block40;
                                        }
                                        break block40;
                                        block24: while (true) {
                                            switch (this.chunkHeaderValues[0]) {
                                                case 8: {
                                                    if (var1_1.isReceiveAudio()) break;
                                                    break block40;
                                                }
                                                case 9: {
                                                    if (var1_1.isReceiveVideo()) break block24;
                                                    ** GOTO lbl30
                                                }
                                                case 15: 
                                                case 18: {
                                                    if (this.onMetadataSample < 0L) ** GOTO lbl102
                                                    break block41;
                                                }
                                            }
                                            if (!var7_7.isSkipAudio()) ** GOTO lbl121
                                            break block40;
                                            break;
                                        }
                                    }
                                    if (!var6_6.isWaitForKeyFrame()) ** GOTO lbl86
                                    var29_24 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                                    if (var29_24) break block50;
                                    break block40;
                                }
                                var6_6.setWaitForKeyFrame(false);
                                ** continue;
                            }
                            if (var19_18 == this.onMetadataSample) ** break;
                            ** continue;
                        }
                        var8_8.setLastTC(var27_23);
                        ++var15_15;
                        this.cursor.moveNextSample();
                        if (var16_16 != 0L) ** GOTO lbl-1000
                        if (var13_13 || var15_15 > 20) {
                            // MONITOREXIT : var23_20
                            break block39;
                        }
                    }
                    // MONITOREXIT : var23_20
lbl189:
                    // 2 sources

                    var23_20 = this.lock;
                    // MONITORENTER : var23_20
                    if (var6_6.isBreakLoop()) {
                        // MONITOREXIT : var23_20
                        break block39;
                    }
                    if (!this.cursor.isAtEnd()) break block42;
                    var8_8.setHitEnd(true);
                    // MONITOREXIT : var23_20
                    break block39;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.getCurrentType();
                v7 = this;
                this.chunkHeaderValues[3] = v7.getFirstByte(v7.cursor);
                var19_18 = this.cursor.getSample();
                v8 = this;
                var21_19 = v8.getSampleDesc(v8.cursor, var19_18, this.chunkHeaderValues[0]);
                var24_21 = false;
                var25_22 = 0L;
                var27_23 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (var16_16 <= 0L || var27_23 < var16_16) ** continue;
                // MONITOREXIT : var23_20
            }
        }
        var8_8.setTotalSize(var11_11);
        return var11_11;
        catch (Throwable var35_35) {
            // MONITOREXIT : var23_20
            throw var35_35;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [42[UNCONDITIONALDOLOOP], 41[UNCONDITIONALDOLOOP]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutput(int[] nArray, long l, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, H264Cursor h264Cursor, boolean bl2) {
        int n3 = 0;
        try {
            int n4;
            int n5;
            boolean bl3;
            int n6;
            int n7;
            int n8;
            byte[] byArray2;
            int n9;
            long l2;
            block31: {
                int n10;
                int n11;
                block30: {
                    block28: {
                        block29: {
                            block27: {
                                block26: {
                                    l2 = (long)nArray[2] & 0xFFFFFFFFL;
                                    int n12 = nArray[0];
                                    n9 = 0;
                                    byArray2 = null;
                                    n8 = 0;
                                    int n13 = 0;
                                    H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n12, l);
                                    if (h264ReadAheadPacket != null) {
                                        byArray2 = h264ReadAheadPacket.getBuffer();
                                        n8 = h264ReadAheadPacket.getBufferOffet();
                                        n13 = (int)h264ReadAheadPacket.getSize();
                                        if (n13 > 0 && (n12 == 18 || n12 == 15) && byArray2[n8] == 0) {
                                            n12 = 15;
                                        }
                                        n9 = n13;
                                    }
                                    if (bl2) {
                                        n9 = 0;
                                    }
                                    nArray[1] = n9;
                                    n7 = 0;
                                    if (n12 == 8) {
                                        n7 = this.audioExtraSize;
                                    } else if (n12 == 9) {
                                        n7 = 5;
                                    }
                                    n9 += n7;
                                    n6 = aMFObj.getId();
                                    boolean bl4 = aMFObj.isNew();
                                    boolean bl5 = bl4 | bl;
                                    bl3 = false;
                                    aMFObj.setNew(false);
                                    n11 = 0;
                                    byArray[0] = (byte)(0xFF & n6);
                                    if (l2 >= 0xFFFFFFL) {
                                        byArray[1] = -1;
                                        byArray[2] = -1;
                                        byArray[3] = -1;
                                        bl3 = true;
                                    } else {
                                        byArray[1] = (byte)(0xFFL & l2 >> 16);
                                        byArray[2] = (byte)(0xFFL & l2 >> 8);
                                        byArray[3] = (byte)(0xFFL & l2);
                                    }
                                    byArray[4] = (byte)(0xFF & n9 >> 16);
                                    byArray[5] = (byte)(0xFF & n9 >> 8);
                                    byArray[6] = (byte)(0xFF & n9);
                                    byArray[7] = (byte)n12;
                                    n11 += 8;
                                    aMFObj.setSize(n9);
                                    aMFObj.setType(n12);
                                    aMFObj.setTimecode(l2);
                                    if (bl5 || aMFObj.getSrc() != n) {
                                        byArray[8] = (byte)(0xFF & n);
                                        byArray[9] = (byte)(0xFF & n >> 8);
                                        byArray[10] = (byte)(0xFF & n >> 16);
                                        byArray[11] = (byte)(0xFF & n >> 24);
                                        n11 += 4;
                                        aMFObj.setSrc(n);
                                    }
                                    if (n6 < 64) break block26;
                                    n5 = n6 - 64;
                                    if (n5 <= 255) break block27;
                                    break block28;
                                }
                                if (n11 >= 12) break block29;
                                byArray[0] = (byte)(byArray[0] | 0x40);
                                break block29;
                            }
                            n10 = 2;
                            break block30;
                        }
                        outputStream.write(byArray, 0, n11);
                        n3 += n11;
                        break block31;
                    }
                    n10 = 3;
                }
                n4 = n10;
                byte[] byArray3 = new byte[n4];
                if (n11 < 12) {
                    byArray3[0] = (byte)(64 + (n4 - 2));
                }
                byArray3[1] = (byte)(0xFF & n5);
                if (n4 == 3) {
                    byArray3[2] = (byte)(0xFF & n5 >> 8);
                }
                outputStream.write(byArray3, 0, n4);
                outputStream.write(byArray, 1, n11 - 1);
                n3 += n11 + 1;
            }
            if (bl3) {
                byArray[0] = (byte)(0xFFL & l2 >> 24);
                byArray[1] = (byte)(0xFFL & l2 >> 16);
                byArray[2] = (byte)(0xFFL & l2 >> 8);
                byArray[3] = (byte)(0xFFL & l2);
                outputStream.write(byArray, 0, 4);
                n3 = 4;
            }
            n5 = 1;
            if (n9 <= 0) return n3;
            n4 = n9;
            int n14 = 0;
            int n15 = 0;
            byte[] byArray4 = null;
            int n16 = 0;
            byArray4 = byArray2;
            n16 = n8;
            do {
                if (n14 > 0) {
                    if (n6 < 64) {
                        byArray[0] = (byte)(0xFF & n6 | 0xC0);
                        outputStream.write(byArray, 0, 1);
                        ++n3;
                    } else {
                        int n17 = n6 - 64;
                        int n18 = n17 > 255 ? 3 : 2;
                        byArray[0] = (byte)(192 + (n18 - 2));
                        byArray[1] = (byte)(0xFF & n17);
                        if (n18 == 3) {
                            byArray[2] = (byte)(0xFF & n17 >> 8);
                        }
                        outputStream.write(byArray, 0, n18);
                        n3 += n18;
                    }
                    if (bl3) {
                        byArray[0] = (byte)(0xFFL & l2 >> 24);
                        byArray[1] = (byte)(0xFFL & l2 >> 16);
                        byArray[2] = (byte)(0xFFL & l2 >> 8);
                        byArray[3] = (byte)(0xFFL & l2);
                        outputStream.write(byArray, 0, 4);
                        n3 = 4;
                    }
                }
                if ((n15 = n2) > n4 - n14) {
                    n15 = n4 - n14;
                }
                try {
                    if (n7 > 0 && n5 != 0) {
                        byArray[0] = this.getFirstByte(h264Cursor);
                        byArray[1] = 1;
                        if (n7 >= 5 && h264Cursor.getCurrentType() == 9) {
                            int n19 = h264Cursor.getCTTSMillis();
                            byArray[2] = (byte)(n19 >> 16 & 0xFF);
                            byArray[3] = (byte)(n19 >> 8 & 0xFF);
                            byArray[4] = (byte)(n19 & 0xFF);
                        }
                        outputStream.write(byArray, 0, n7);
                    }
                    if (byArray4 != null) {
                        int n20 = n5 == 0 ? n15 : n15 - n7;
                        outputStream.write(byArray4, n16, n20);
                        n16 += n20;
                    }
                    n5 = 0;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.startsWith((int)(907 / 218), (String)"I`bni[ojhh|G\"'&=p|dr{mUnhmkk:!Rqkgjbe)xnmigaw1{}d`b7~pv~&=") + exception.toString());
                    exception.printStackTrace();
                }
                n3 += n15;
            } while ((n14 += n15) != n4);
            return n3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.startsWith((int)(780 / 130), (String)"Kbl`kYiljjbY % ;r~j|yoShjouu8#") + exception.toString());
            exception.printStackTrace();
            return n3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] var1_1, boolean var2_2, int var3_3, OutputStream var4_4, AMFObj var5_5, byte[] var6_6, int var7_7, byte[] var8_8) {
        block27: {
            block25: {
                block26: {
                    block24: {
                        block23: {
                            var9_9 = 0;
                            try {
                                var10_11 = (long)var1_1[2] & 0xFFFFFFFFL;
                                var12_12 = var1_1[1];
                                var13_13 = var1_1[0];
                                var14_14 = var5_5.getId();
                                var15_15 = var5_5.isNew();
                                var16_16 = var15_15 | var2_2;
                                var17_17 = false;
                                var5_5.setNew(false);
                                var18_18 = 0;
                                var6_6[0] = (byte)(255 & var14_14);
                                if (var10_11 < 0xFFFFFFL) break block23;
                                var6_6[1] = -1;
                                var6_6[2] = -1;
                                var6_6[3] = -1;
                                var17_17 = true;
                            }
                            catch (Exception var10_10) {
                                WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.replace((String)"I`bni[ojhh|G\"'&=p|dr{mUnhmkkBtd9$", (int)(13 + -9)) + var10_10.toString());
                                var10_10.printStackTrace();
                                return var9_9;
                            }
lbl23:
                            // 2 sources

                            while (true) {
                                var6_6[4] = (byte)(255 & var12_12 >> 16);
                                var6_6[5] = (byte)(255 & var12_12 >> 8);
                                var6_6[6] = (byte)(255 & var12_12);
                                var6_6[7] = (byte)var13_13;
                                var18_18 += 8;
                                var5_5.setSize(var12_12);
                                var5_5.setType(var13_13);
                                var5_5.setTimecode(var10_11);
                                if (var16_16 || var5_5.getSrc() != var3_3) {
                                    var6_6[8] = (byte)(255 & var3_3);
                                    var6_6[9] = (byte)(255 & var3_3 >> 8);
                                    var6_6[10] = (byte)(255 & var3_3 >> 16);
                                    var6_6[11] = (byte)(255 & var3_3 >> 24);
                                    var18_18 += 4;
                                    var5_5.setSrc(var3_3);
                                }
                                if (var14_14 >= 64) {
                                    var19_19 = var14_14 - 64;
                                    if (var19_19 > 255) {
                                        break block24;
                                    }
                                } else {
                                    if (var18_18 < 12) {
                                        var6_6[0] = (byte)(var6_6[0] | 64);
                                    }
                                    var4_4.write(var6_6, 0, var18_18);
                                    var9_9 += var18_18;
                                    break block25;
                                }
                                v0 = 2;
                                break block26;
                                break;
                            }
                        }
                        var6_6[1] = (byte)(255L & var10_11 >> 16);
                        var6_6[2] = (byte)(255L & var10_11 >> 8);
                        var6_6[3] = (byte)(255L & var10_11);
                        ** while (true)
                    }
                    v0 = 3;
                }
                var20_20 = v0;
                var21_22 = new byte[var20_20];
                if (var18_18 < 12) {
                    var21_22[0] = (byte)(64 + (var20_20 - 2));
                }
                var21_22[1] = (byte)(255 & var19_19);
                if (var20_20 == 3) {
                    var21_22[2] = (byte)(255 & var19_19 >> 8);
                }
                var4_4.write(var21_22, 0, var20_20);
                var4_4.write(var6_6, 1, var18_18 - 1);
                var9_9 += var18_18 + 1;
            }
            if (var17_17) {
                var6_6[0] = (byte)(255L & var10_11 >> 24);
                var6_6[1] = (byte)(255L & var10_11 >> 16);
                var6_6[2] = (byte)(255L & var10_11 >> 8);
                var6_6[3] = (byte)(255L & var10_11);
                var4_4.write(var6_6, 0, 4);
                var9_9 = 4;
            }
            if (var12_12 <= 0) return var9_9;
            var19_19 = var12_12;
            var20_20 = 0;
            var21_21 = 0;
            ** GOTO lbl-1000
            while (true) {
                v1 = 2;
                ** GOTO lbl87
                break;
            }
lbl85:
            // 1 sources

            while (true) {
                v1 = 3;
lbl87:
                // 2 sources

                var23_25 = v1;
                var6_6[0] = (byte)(192 + (var23_25 - 2));
                var6_6[1] = (byte)(255 & var22_23);
                if (var23_25 == 3) {
                    var6_6[2] = (byte)(255 & var22_23 >> 8);
                }
                var4_4.write(var6_6, 0, var23_25);
                var9_9 += var23_25;
                break block27;
                break;
            }
lbl95:
            // 1 sources

            while (true) {
                if ((var22_23 = var14_14 - 64) <= 255) ** continue;
                ** continue;
                break;
            }
        }
lbl99:
        // 2 sources

        while (true) {
            if (!var17_17) ** GOTO lbl117
            var6_6[0] = (byte)(255L & var10_11 >> 24);
            var6_6[1] = (byte)(255L & var10_11 >> 16);
            var6_6[2] = (byte)(255L & var10_11 >> 8);
            var6_6[3] = (byte)(255L & var10_11);
            var4_4.write(var6_6, 0, 4);
            var9_9 = 4;
            ** if (true) goto lbl112
            break;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                var9_9 += var21_21;
                if ((var20_20 += var21_21) == var19_19) {
                    return var9_9;
                } else {
                    ** GOTO lbl-1000
                }
                break;
            }
        }
lbl112:
        // 1 sources

        ** GOTO lbl117
lbl-1000:
        // 3 sources

        {
            block29: {
                block28: {
                    if (var20_20 <= 0) break block28;
                    if (var14_14 >= 64) {
                        ** continue;
                    }
                    break block29;
                }
                if ((var21_21 = var7_7) > var19_19 - var20_20) {
                    var21_21 = var19_19 - var20_20;
                }
                ** GOTO lbl-1000
            }
            var6_6[0] = (byte)(255 & var14_14 | 192);
            var4_4.write(var6_6, 0, 1);
            ++var9_9;
            ** continue;
lbl-1000:
            // 1 sources

            {
                var4_4.write(var8_8, var20_20, var21_21);
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info(Base64.replace((String)"\"27>3#by", (int)(19 + 95)) + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) {
                wMSLogger.info(FileChunk.startsWith((int)(52 - 6), (String)"$%:bs~dystwlto&=") + n2);
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest var1_1) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        block13: {
                            block11: {
                                block12: {
                                    block10: {
                                        var2_2 = null;
                                        var3_3 = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                        var4_4 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                        var5_5 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                        if (this.cursorReadAhead != null) break block15;
                                        break block16;
lbl7:
                                        // 2 sources

                                        while (this.cursorReadAhead.isAtEnd()) {
                                            break block10;
                                        }
                                        break block17;
lbl10:
                                        // 1 sources

                                        while (true) {
                                            var2_2 = this.readAheadCache.remove(0);
                                            var2_2.clear();
                                            break block11;
                                            while (true) {
                                                if (!this.cursorReadAhead.isAtEnd()) break block12;
                                                break block13;
                                                break;
                                            }
lbl17:
                                            // 1 sources

                                            while (true) {
                                                var2_2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                                                if (this.stream == null) break block10;
                                                break block14;
                                                break;
                                            }
                                            break;
                                        }
lbl21:
                                        // 1 sources

                                        while (true) {
                                            this.cursorReadAhead.setCurrentPosition(var1_1.getCursorPosition());
                                            ** GOTO lbl7
                                            break;
                                        }
                                    }
lbl25:
                                    // 3 sources

                                    return var2_2;
                                }
lbl28:
                                // 2 sources

                                while (true) {
                                    var8_7 = this.cursorReadAhead.getSize();
                                    var10_8 = this.cursorReadAhead.getCurrentType();
                                    var11_9 = this.cursorReadAhead.getSample();
                                    var13_10 = this.cursorReadAhead.getSampleDesc();
                                    var2_2.addPacket(var10_8, var11_9, this.cursorReadAhead.getFileLoc(), var8_7, var13_10);
                                    this.cursorReadAhead.moveNextSample();
                                    if ((var6_6 += var8_7) <= (long)this.readAheadSize) ** continue;
                                    break block13;
                                    break;
                                }
lbl38:
                                // 1 sources

                                while (true) {
                                    this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
                                    ** GOTO lbl7
                                    break;
                                }
                            }
lbl42:
                            // 2 sources

                            while (true) {
                                var2_2.setFileStream(this.videoFileStream);
                                var2_2.setReadAheadTrigger(this.readAheadTrigger);
                                var6_6 = 0L;
                                ** continue;
                                break;
                            }
                        }
                        if (var2_2 == null) ** GOTO lbl25
                        ** while (true)
                    }
                    this.stream.getStreams().getVHost().getIOScheduler().executeRaw((Runnable)var2_2);
                    ** while (true)
lbl53:
                    // 1 sources

                    while (true) {
                        var2_2 = new H264ReadAheadRequest();
                        var2_2.setDataTrack(var5_5);
                        var2_2.setDataDataToAMFHandler(this.dataDataToAMFHandler);
                        ** continue;
                        break;
                    }
                }
                this.cursorReadAhead = new H264Cursor(var3_3, var4_4, var5_5);
                break block15;
            }
            ** while (this.readAheadCache.size() <= 0)
lbl63:
            // 1 sources

            ** while (true)
        }
        ** while (var1_1 == null)
lbl66:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket = null;
        Object object = this.readAheadLock;
        synchronized (object) {
            block12: {
                block13: {
                    block11: {
                        if (this.currReadAhead == null) break block11;
                        this.currReadAhead.waitForComplete();
                        h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                        if (h264ReadAheadPacket != null) break block12;
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                    this.currReadAhead = this.nextReadAhead;
                    this.nextReadAhead = null;
                    if (this.currReadAhead == null) break block13;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block12;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.tiggerNextReadAhead(null);
                if (this.currReadAhead != null) {
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket == null) {
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                }
            }
            if (h264ReadAheadPacket == null) return h264ReadAheadPacket;
            if (this.nextReadAhead != null) return h264ReadAheadPacket;
            if (!h264ReadAheadPacket.isAfterTrigger) return h264ReadAheadPacket;
            MediaReaderH264 mediaReaderH264 = this;
            mediaReaderH264.nextReadAhead = mediaReaderH264.tiggerNextReadAhead(mediaReaderH264.currReadAhead);
            return h264ReadAheadPacket;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 191->1048)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket a(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = 23;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket b(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = -81;
        byArray2[1] = 0;
        aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket getFramePacket(int[] nArray, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        int n;
        int n2;
        AMFPacket aMFPacket = null;
        try {
            n2 = nArray[0];
            n = 0;
            h264ReadAheadPacket = this.getReadAheadPacket(n2, l);
            if (h264ReadAheadPacket != null) {
                n = (int)h264ReadAheadPacket.getSize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(FileChunk.startsWith((int)(1654 / 241), (String)"Kbl`kYiljjbY % ;qrl_hzqxN~cjgw>%") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
        if (n <= 0) return aMFPacket;
        int n3 = 5;
        if (n2 != 8) {
            if (n2 == 18 || n2 == 15) {
                n3 = 0;
            }
        } else {
            n3 = this.audioExtraSize;
        }
        aMFPacket = new AMFPacket(nArray[0], 0, n + n3);
        byte[] byArray = aMFPacket.getData();
        byArray[0] = (byte)this.chunkHeaderValues[3];
        if (n3 > 1) {
            byArray[1] = 1;
        }
        if (n3 == 5) {
            int n4 = this.cursor.getCTTSMillis();
            byArray[2] = (byte)(n4 >> 16 & 0xFF);
            byArray[3] = (byte)(n4 >> 8 & 0xFF);
            byArray[4] = (byte)(n4 & 0xFF);
        }
        byte[] byArray2 = null;
        int n5 = 0;
        if (h264ReadAheadPacket != null) {
            byArray2 = h264ReadAheadPacket.getBuffer();
            n5 = h264ReadAheadPacket.boffset;
        }
        aMFPacket.addDataEx(byArray2, n5, n3, n);
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountVideo() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getVideoTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountAudio() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getAudioTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountData() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getDataTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getAudioTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageData(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getDataTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackDataTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackAudioTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackDataAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoTrackId(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoWidth(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackWidth();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoHeight(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackHeight();
        return l;
    }

    public String getTrackDataCharSet() {
        return this.trackDataCharSet;
    }

    public void setTrackDataCharSet(String string) {
        this.trackDataCharSet = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] dataDataToAMF(QTAtomtrak qTAtomtrak, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = null;
        AMFDataList aMFDataList = null;
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl != null && (n3 = qTAtomstbl.getDataTrackType()) == 2) {
            aMFDataList = new AMFDataList();
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataList.add((AMFData)new AMFDataItem(FileChunk.startsWith((int)(834 / 235), (String)"ljQc\u007f|Mk\u007fm")));
            aMFDataList.add((AMFData)aMFDataObj);
            String string = qTAtomtrak.getLanguageStr();
            aMFDataObj.put(Base64.replace((String)"&6,!", (int)(-62 - -48)), (AMFData)new AMFDataItem(""));
            aMFDataObj.put(FileChunk.startsWith((int)(83 + -4), (String)";\"018=1"), (AMFData)new AMFDataItem(qTAtomtrak.getTrackIndex()));
            aMFDataObj.put(Base64.replace((String)"q\u007fq'4#$!", (int)(57 * 37)), (AMFData)new AMFDataItem(string));
            if (n2 >= 2) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n, (int)2);
                if (n5 > 0 && n5 <= n2 - (n4 += 2)) {
                    String string2 = "";
                    try {
                        string2 = new String(byArray, n + n4, n2 - n4, this.trackDataCharSet);
                    }
                    catch (Exception exception) {}
                    aMFDataObj.put(Base64.replace((String)"k%96", (int)(37 * 19)), (AMFData)new AMFDataItem(string2));
                }
            }
        }
        if (aMFDataList == null) return byArray2;
        return aMFDataList.serialize(0);
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int n) {
        this.cursorType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPlayReadyDecryptorKey(PlayReadyKeyInfo playReadyKeyInfo) {
        String string = FileChunk.startsWith((int)(27 * 33), (String)".2600wo");
        byte[] byArray = playReadyKeyInfo.getKeyId();
        if (byArray != null) {
            string = BufferUtils.encodeHexString((byte[])byArray);
        }
        this.playReadyDecryptorKeys.put(string, playReadyKeyInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyAudioTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyVideoTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadyMediaInfo getPlayReadyInfo() {
        PlayReadyMediaInfo playReadyMediaInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov != null) return this.container.getMoovAtom().getPlayReadyInfo();
        return playReadyMediaInfo;
    }
}

