/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.impl;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkArtifact;
import com.wowza.wms.dvr.DvrChunkStorageInfo;
import com.wowza.wms.dvr.DvrManifestChunkEntry;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPacketHolder;
import com.wowza.wms.dvr.DvrStreamStoreBase;
import com.wowza.wms.dvr.IDvrStreamManager;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.impl.DvrChunkInterceptorFactory;
import com.wowza.wms.dvr.impl.DvrPersistedManifest;
import com.wowza.wms.dvr.impl.DvrPurgeControllerFactory;
import com.wowza.wms.dvr.impl.IDvrChunkInterceptorDelegate;
import com.wowza.wms.dvr.io.DvrChunkReaderUtils;
import com.wowza.wms.dvr.io.DvrFileSystemFactory;
import com.wowza.wms.dvr.io.DvrManifestWriterFactory;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrRecordableStreamStore
extends DvrStreamStoreBase
implements IDvrStreamStore {
    private static final Class<DvrRecordableStreamStore> a = DvrRecordableStreamStore.class;
    protected boolean storageSystemInitialized;
    protected String streamContainer;
    private IDvrChunkInterceptorDelegate b = null;

    public DvrRecordableStreamStore(IDvrStreamManager iDvrStreamManager, String string) {
        super(iDvrStreamManager, string);
        this.canRecord = true;
        this.canPlay = true;
        IApplicationInstance iApplicationInstance = this.dvrManager.getApplicationInstance();
        this.streamContainer = this.initStreamContainer(iApplicationInstance, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DvrChunkStorageInfo storeChunks(int n, DvrPacketHolder dvrPacketHolder, int n2, DvrPacketHolder dvrPacketHolder2, int n3, DvrPacketHolder dvrPacketHolder3) {
        if (this.b == null) return super.storeChunks(n, dvrPacketHolder, n2, dvrPacketHolder2, n3, dvrPacketHolder3);
        if (this.b.shouldStoreChunk(n, dvrPacketHolder, n2, dvrPacketHolder2, n3, dvrPacketHolder3)) return super.storeChunks(n, dvrPacketHolder, n2, dvrPacketHolder2, n3, dvrPacketHolder3);
        return new DvrChunkStorageInfo(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        super.init();
        String string = this.properties.getPropertyStr(Base64.replace((String)"3.+\u00193)35\u0016nugqg`vsg{Nn`hindt", (int)(39 * 49)), "");
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        this.b = DvrChunkInterceptorFactory.createInstance(this, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initializeStorageSystem() {
        if (this.storageSystemInitialized) return;
        IApplicationInstance iApplicationInstance = this.dvrManager.getApplicationInstance();
        this.fileSystem = DvrFileSystemFactory.createInstance((IApplicationInstance)iApplicationInstance, (String)this.dvrManager.getDvrFileSystemClass(), (String)this.dvrManager.getDvrStorageDir(), (String)this.streamContainer);
        this.manifestWriter = DvrManifestWriterFactory.createInstance((IApplicationInstance)iApplicationInstance, (String)this.manifestPersisterClass, (IDvrFileSystem)this.fileSystem, (IDvrStreamStore)this);
        if (!this.fileSystem.doesFileSystemExist() && !this.fileSystem.createFileSystem()) {
            String string = String.format(FileChunk.startsWith((int)(1330 / 203), (String)"#t&`dbxdocykw@`zdv\u007f|Iboi{r[$q^$?&Rfhhgi-z`0r`vuas7~pv~<ngl4$/ca6"), Base64.replace((String)"M|y^hm`busqxpEcj|{vOiqme", (int)(-28 - -37)), this.getContextStr(), this.fileSystem);
            WMSLoggerFactory.getLogger(a).error(string);
        }
        this.storageSystemInitialized = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void stopIfMaximumRecordingReached() {
        int n = 8;
        if (this.hasVideo()) {
            n = 9;
        }
        if (this.manifest != null) {
            long l = this.manifest.getRecordedDuration(n);
            if (this.maxRecordingLengthSeconds <= 0L) return;
            if (!((double)l > (double)(this.maxRecordingLengthSeconds * 1000L) * 1.1)) return;
            WMSLoggerFactory.getLogger(a).warn(String.format(FileChunk.startsWith((int)(49 * 49), (String)"\u001ag0\u0019e|g\u0005(2\"!8#o\"41<&1?9?y6>2:*7 nd#!a&tmjeeh~.jhrwvppr989H~\u007frl{ioe#wqiwxln%"), this.getContextStr(), this.maxRecordingLengthSeconds));
            this.stopRecording();
            return;
        }
    }

    protected void initPurgeController() {
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        dvrRecordableStreamStore.purgeController = DvrPurgeControllerFactory.createInstance(dvrRecordableStreamStore, dvrRecordableStreamStore.purgeControlClass);
    }

    protected String initStreamContainer(IApplicationInstance iApplicationInstance, String string) {
        String string2 = this.normalizeStreamName(string);
        String string3 = iApplicationInstance.getContextStr() + IDvrFileSystem.separator + string2;
        return string3;
    }

    protected DvrChunk retrieveChunkFromDvrStore(DvrManifestChunkEntry dvrManifestChunkEntry) {
        DvrChunk dvrChunk = null;
        DvrChunkArtifact dvrChunkArtifact = dvrManifestChunkEntry.getDvrArtifact();
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        dvrChunk = DvrChunkReaderUtils.retrieveChunk((IDvrStreamStore)dvrRecordableStreamStore, (IApplicationInstance)dvrRecordableStreamStore.dvrManager.getApplicationInstance(), (String)dvrChunkArtifact.getPath());
        return dvrChunk;
    }

    public void createManifest() {
        DvrRecordableStreamStore dvrRecordableStreamStore = this;
        this.manifest = new DvrPersistedManifest(dvrRecordableStreamStore, dvrRecordableStreamStore.manifestWriter);
        this.manifest.initialize();
        this.isManifestLoaded = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getUniqueContainerSet(SortedSet<String> sortedSet, Collection<DvrManifestEntry> collection) {
        if (collection == null) {
            return;
        }
        Iterator<DvrManifestEntry> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DvrManifestEntry dvrManifestEntry = iterator.next();
            this.addUniqueContainer(sortedSet, dvrManifestEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addUniqueContainer(SortedSet<String> sortedSet, DvrManifestEntry dvrManifestEntry) {
        if (dvrManifestEntry == null) return;
        if (!(dvrManifestEntry instanceof DvrManifestChunkEntry)) return;
        DvrChunkArtifact dvrChunkArtifact = ((DvrManifestChunkEntry)dvrManifestEntry).getDvrArtifact();
        if (dvrChunkArtifact == null) return;
        sortedSet.add(dvrChunkArtifact.container);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void removeArtifacts(Collection<DvrManifestEntry> collection) {
        if (collection == null) return;
        if (collection.isEmpty()) return;
        if (this.fileSystem == null) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        this.getUniqueContainerSet(treeSet, collection);
        Iterator<DvrManifestEntry> iterator = collection.iterator();
        boolean bl = true;
        block0: while (true) {
            DvrManifestEntry dvrManifestEntry;
            if (!bl || (bl = false) || !true) {
                DvrChunkArtifact dvrChunkArtifact = ((DvrManifestChunkEntry)dvrManifestEntry).getDvrArtifact();
                this.fileSystem.delete(dvrChunkArtifact.getPath());
            }
            while (iterator.hasNext()) {
                dvrManifestEntry = iterator.next();
                if (dvrManifestEntry != null && dvrManifestEntry instanceof DvrManifestChunkEntry) continue block0;
            }
            break;
        }
        this.manifestWriter.purgeIndividualManifests(treeSet);
    }
}

