/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.xml.transform.TransformerException;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.MbeansSourceMBean;
import org.apache.commons.modeler.modules.ModelerSource;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MbeansSource
extends ModelerSource
implements MbeansSourceMBean {
    Registry registry;
    String type;
    boolean loading = true;
    List mbeans = new ArrayList();
    static boolean loaderLoaded = false;
    private Document document;
    private HashMap object2Node = new HashMap();
    long lastUpdate;
    long updateInterval = 10000L;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public String getLocation() {
        return this.location;
    }

    public List getMBeans() {
        return this.mbeans;
    }

    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void start() throws Exception {
        this.registry.invoke(this.mbeans, "start", false);
    }

    public void stop() throws Exception {
        this.registry.invoke(this.mbeans, "stop", false);
    }

    public void init() throws Exception {
        if (this.mbeans == null) {
            this.execute();
        }
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        this.registry.invoke(this.mbeans, "init", false);
    }

    public void destroy() throws Exception {
        this.registry.invoke(this.mbeans, "destroy", false);
    }

    public void load() throws Exception {
        this.execute();
    }

    public void execute() throws Exception {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MbeansSource.class);
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            Object object;
            Object object2;
            InputStream inputStream = this.getInputStream();
            long l = System.currentTimeMillis();
            this.document = DomUtil.readXml(inputStream);
            Element element = this.document.getDocumentElement();
            if (element == null) {
                wMSLogger.error("No descriptors found");
                return;
            }
            Node node = DomUtil.getChild((Node)element, null);
            if (node == null) {
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("No child " + element);
                }
                node = element;
            }
            MBeanServer mBeanServer = Registry.getServer();
            if (!loaderLoaded) {
                object2 = new ObjectName("modeler", "loader", "modeler");
                object = new MLet(new URL[0], this.getClass().getClassLoader());
                mBeanServer.registerMBean(object, (ObjectName)object2);
                loaderLoaded = true;
            }
            object2 = node;
            while (object2 != null) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                object = object2.getNodeName();
                if ("mbean".equals(object) || "MLET".equals(object)) {
                    Object object7;
                    Object object8;
                    object6 = DomUtil.getAttribute((Node)object2, "code");
                    object5 = DomUtil.getAttribute((Node)object2, "objectName");
                    if (object5 == null) {
                        object5 = DomUtil.getAttribute((Node)object2, "name");
                    }
                    if (wMSLogger.isDebugEnabled()) {
                        wMSLogger.debug("Processing mbean objectName=" + (String)object5 + " code=" + (String)object6);
                    }
                    if ((object4 = DomUtil.getChild((Node)object2, "constructor")) == null) {
                        object4 = object2;
                    }
                    object3 = this.processArg((Node)object4);
                    try {
                        object8 = new ObjectName((String)object5);
                        if (!mBeanServer.isRegistered((ObjectName)object8)) {
                            object7 = BaseModelMBean.class.getName();
                            if (object3 == null) {
                                mBeanServer.createMBean((String)object7, (ObjectName)object8, new Object[]{object6, this}, new String[]{String.class.getName(), ModelerSource.class.getName()});
                            } else {
                                mBeanServer.createMBean((String)object7, (ObjectName)object8, new Object[]{object6, this, ((ArgsInfo)object3).getValues(), ((ArgsInfo)object3).getSigs()}, new String[]{String.class.getName(), ModelerSource.class.getName(), Object[].class.getName(), String[].class.getName()});
                            }
                            this.mbeans.add(object8);
                        }
                        this.object2Node.put(object8, object2);
                    }
                    catch (Exception exception) {
                        wMSLogger.error("Error creating mbean " + (String)object5, (Throwable)exception);
                    }
                    object7 = object8 = DomUtil.getChild((Node)object2, "attribute");
                    while (object7 != null) {
                        this.processAttribute(mBeanServer, (Node)object7, (String)object5);
                        object7 = DomUtil.getNext((Node)object7);
                    }
                } else if ("jmx-operation".equals(object)) {
                    object6 = DomUtil.getAttribute((Node)object2, "objectName");
                    if (object6 == null) {
                        object6 = DomUtil.getAttribute((Node)object2, "name");
                    }
                    object5 = DomUtil.getAttribute((Node)object2, "operation");
                    if (wMSLogger.isDebugEnabled()) {
                        wMSLogger.debug("Processing invoke objectName=" + (String)object6 + " code=" + (String)object5);
                    }
                    try {
                        object4 = new ObjectName((String)object6);
                        object3 = this.processArg((Node)object2);
                        if (object3 == null) {
                            mBeanServer.invoke((ObjectName)object4, (String)object5, null, null);
                        }
                        mBeanServer.invoke((ObjectName)object4, (String)object5, ((ArgsInfo)object3).getValues(), ((ArgsInfo)object3).getSigs());
                    }
                    catch (Exception exception) {
                        wMSLogger.error("Error in invoke " + (String)object6 + " " + (String)object5);
                    }
                }
                object6 = new ManagedBean();
                DomUtil.setAttributes(object6, (Node)object2);
                object4 = object5 = DomUtil.getChild((Node)object2, "attribute");
                while (object4 != null) {
                    object3 = new AttributeInfo();
                    DomUtil.setAttributes(object3, (Node)object4);
                    ((ManagedBean)object6).addAttribute((AttributeInfo)object3);
                    object4 = DomUtil.getNext((Node)object4);
                }
                object2 = DomUtil.getNext((Node)object2, null, 1);
            }
            long l2 = System.currentTimeMillis();
            wMSLogger.info("Reading mbeans  " + (l2 - l));
            this.loading = false;
        }
        catch (Exception exception) {
            wMSLogger.error("Error reading mbeans ", (Throwable)exception);
        }
    }

    public void updateField(ObjectName objectName, String string, Object object) {
        String string2;
        if (this.loading) {
            return;
        }
        Node node = (Node)this.object2Node.get(objectName);
        if (node == null) {
            WMSLoggerFactory.getLogger(MbeansSource.class).info("Node not found " + objectName);
            return;
        }
        Node node2 = DomUtil.findChildWithAtt(node, "attribute", "name", string);
        if (node2 == null) {
            node2 = node.getOwnerDocument().createElement("attribute");
            DomUtil.setAttribute(node2, "name", string);
            node.appendChild(node2);
        }
        if ((string2 = DomUtil.getAttribute(node2, "value")) != null) {
            DomUtil.removeAttribute(node2, "value");
        }
        DomUtil.setText(node2, object.toString());
    }

    public void save() {
        long l = System.currentTimeMillis();
        if (this.location != null && l - this.lastUpdate > this.updateInterval) {
            this.lastUpdate = l;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.location);
                DomUtil.writeXml(this.document, fileOutputStream);
            }
            catch (TransformerException transformerException) {
                WMSLoggerFactory.getLogger(MbeansSource.class).error("Error writing");
            }
            catch (FileNotFoundException fileNotFoundException) {
                WMSLoggerFactory.getLogger(MbeansSource.class).error("Error writing", (Throwable)fileNotFoundException);
            }
        }
    }

    private void processAttribute(MBeanServer mBeanServer, Node node, String string) {
        String string2 = DomUtil.getAttribute(node, "name");
        String string3 = DomUtil.getAttribute(node, "value");
        String string4 = null;
        if (string3 == null) {
            string3 = DomUtil.getContent(node);
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MbeansSource.class);
        try {
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug("Set attribute " + string + " " + string2 + " " + string3);
            }
            ObjectName objectName = new ObjectName(string);
            if (string4 == null) {
                string4 = this.registry.getType(objectName, string2);
            }
            if (string4 == null) {
                wMSLogger.info("Can't find attribute " + string + " " + string2);
            } else {
                Object object = this.registry.convertValue(string4, string3);
                mBeanServer.setAttribute(objectName, new Attribute(string2, object));
            }
        }
        catch (Exception exception) {
            wMSLogger.error("Error processing attribute " + string + " " + string2 + " " + string3, (Throwable)exception);
        }
    }

    private ArgsInfo processArg(Node node) {
        Node node2 = DomUtil.getChild(node, "arg");
        if (node2 == null) {
            return null;
        }
        ArgsInfo argsInfo = new ArgsInfo();
        Node node3 = node2;
        while (node3 != null) {
            String string = DomUtil.getAttribute(node3, "type");
            String string2 = DomUtil.getAttribute(node3, "value");
            if (string2 == null) {
                string2 = DomUtil.getContent(node3);
            }
            argsInfo.addArgPair(string, this.registry.convertValue(string, string2));
            node3 = DomUtil.getNext(node3);
        }
        return argsInfo;
    }

    private static class ArgsInfo {
        private List sigs = new ArrayList();
        private List values = new ArrayList();

        ArgsInfo() {
        }

        public String[] getSigs() {
            return this.sigs.toArray(new String[this.sigs.size()]);
        }

        public Object[] getValues() {
            return this.values.toArray(new Object[this.values.size()]);
        }

        public void addArgPair(String string, Object object) {
            this.sigs.add(string);
            this.values.add(object);
        }
    }
}

