/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerApplicationContextCupertinoStreamer;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerCupertinoIndexBase
implements IHTTPStreamerCupertinoIndex {
    protected List<IHTTPStreamerCupertinoIndexItem> items = new ArrayList<IHTTPStreamerCupertinoIndexItem>();
    protected String titleStr = "";
    protected CupertinoEncInfo encInfo = null;
    protected IHTTPStreamerApplicationContext appContext = null;
    protected IApplicationInstance appInstance = null;
    protected String streamExt = null;
    protected String streamName = null;
    protected IMediaStream stream = null;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected int chunkDurationTarget = 10000;
    protected boolean init = true;
    protected boolean relativePlaylistItems = true;
    protected boolean relativePlaylistPlaylists = true;
    protected int streamMode = 1;
    protected int audioBitrate = -1;
    protected int audioCodec = 10;
    protected int videoBitrate = -1;
    protected double duration = 0.0;
    protected WMSProperties properties = new WMSProperties();
    protected long playStart = 0L;
    protected long playDuration = -1L;
    protected MediaCodecInfoVideo codecInfoVideo = new MediaCodecInfoVideo();
    protected MediaCodecInfoAudio codecInfoAudio = new MediaCodecInfoAudio();

    @Override
    public void init(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3, long l, long l2) {
        this.appContext = iHTTPStreamerApplicationContext;
        this.appInstance = iHTTPStreamerApplicationContext.getAppInstance();
        this.streamExt = string2;
        this.streamName = string3;
        this.httpStreamerSession = iHTTPStreamerSession;
        this.playStart = l;
        this.playDuration = l2;
        this.codecInfoVideo.setCodecId(7);
        this.codecInfoAudio.setCodecId(10);
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(-64 - -22), (String)"$248.2*8\u000e3!8.*71\u000f3-$9"), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean(FileChunk.startsWith((int)(-10 - 28), (String)"(>0<*66$\u0012/%<*.;=\u0003?) ="), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean(Base64.replace((String)"rgcqgb~vvH~p|jvvdRoe|jn{}C\u007fi`}", (int)(29 + 116)), this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean(Base64.replace((String)"8)-;-thllV`jf|`|n\\aov|xag]aszk", (int)(60 + 63)), this.relativePlaylistItems);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(1317 / 249), (String)"wcki}c}i]bni}{``Ezvaushhn"), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean(FileChunk.startsWith((int)(-20 - 63), (String)"\u007fkcqe{eqEzvaushhMr~9-+006"), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean(FileChunk.startsWith((int)(-63 - -6), (String)"$=9/98$  \u00024>2 < 2\b5;\"04-+\u0010-#:(,53;"), this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean(Base64.replace((String)"paeselpttNxr~thtfTig~d`y\u007f\\aov|xagg", (int)(13 * 31)), this.relativePlaylistPlaylists);
    }

    @Override
    public String getStreamNameByBitrate(long l) {
        return this.streamName;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String adjustStreamName(String string) {
        String string2 = "";
        String string3 = FileChunk.startsWith((int)(-9 - 14), (String)"$:\u007f");
        if ((string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, this.httpStreamerSession)) == null) return string;
        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string3);
        string = stringArray[0];
        string3 = stringArray[1];
        boolean bl = string.indexOf(FileChunk.startsWith((int)(39 - -9), (String)"*>=")) >= 0;
        int n = string.indexOf("?");
        if (bl) return string;
        if (n < 0) return string;
        string2 = string.substring(n + 1);
        return string.substring(0, n);
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public IHTTPStreamerApplicationContext getApplicationContext() {
        return this.appContext;
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.streamName);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        String string = hTTPStreamerCupertinoIndexBase.adjustStreamName(hTTPStreamerCupertinoIndexBase.streamName);
        if (string == null) {
            return arrayList;
        }
        arrayList.add(string);
        return arrayList;
    }

    @Override
    public List<Long> getStreamBitrates() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(Long.valueOf(this.videoBitrate + this.audioBitrate));
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public LiveStreamPacketizerCupertinoChunk getChunk(String string, boolean bl) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = null;
        int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
        if (n <= 0) return liveStreamPacketizerCupertinoChunk;
        int n2 = n - 1;
        IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = n2 < this.items.size() ? this.items.get(n - 1) : null;
        if (iHTTPStreamerCupertinoIndexItem == null) {
            return liveStreamPacketizerCupertinoChunk;
        }
        liveStreamPacketizerCupertinoChunk = new LiveStreamPacketizerCupertinoChunk(n);
        this.fillChunk(iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
        return liveStreamPacketizerCupertinoChunk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (!this.init) {
            return;
        }
        WMSProperties wMSProperties = this.appContext.getProperties();
        WMSProperties wMSProperties2 = this.appContext.getAppInstance().getHTTPStreamerProperties();
        this.chunkDurationTarget = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(51 * 61), (String)"d`|d`Hx|ndx}}@tdp}m"), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties2.getPropertyInt(FileChunk.startsWith((int)(50 - -42), (String)"?5+1+\u000571%1/(&\u001d+9+(:"), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties.getPropertyInt(FileChunk.startsWith((int)(17 + 66), (String)"0!%3%,044\u001f5+1+\u000571%1/(&\u001d+9+(:"), this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties2.getPropertyInt(Base64.replace((String)"leawa`|xx[qouwYkmaukljQguol~", (int)(28 - 13)), this.chunkDurationTarget);
        this.init = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        Object object;
        String string;
        String string2 = null;
        CupertinoEncInfo cupertinoEncInfo = iHTTPStreamerCupertinoIndexItem.getEncInfo();
        if (cupertinoEncInfo == null) {
            return string2;
        }
        int n = cupertinoEncInfo.getEncMethod();
        if (!CupertinoEncInfo.isMethodReportedInPlaylist(n)) {
            return string2;
        }
        if (CupertinoEncInfo.isMethodReportedWithKeyHeader(n)) {
            string = cupertinoEncInfo.getEncUrl();
            if (string == null) {
                return string2;
            }
            object = "";
            byte[] byArray = cupertinoEncInfo.getEncIVBytes();
            if (byArray != null) {
                object = (String)object + FileChunk.startsWith((int)(-26 - 37), (String)"m\u000b\u0015yu>") + BufferUtils.encodeHexString((byte[])byArray);
            }
            if (cupertinoEncInfo.getEncKeyFormat() != null) {
                object = (String)object + Base64.replace((String)"z\u001c\u001d\u0000\u001c\u0014\u000e\u0010\u001f\u000b=#", (int)(117 + 1)) + cupertinoEncInfo.getEncKeyFormat() + "\"";
            }
            if (cupertinoEncInfo.getEncKeyFormatVersion() != null) {
                object = (String)object + Base64.replace((String)"w\u0017\u0018\u0007\u0019OSOBPSCU[@EE1/", (int)(61 * 23)) + cupertinoEncInfo.getEncKeyFormatVersion() + "\"";
            }
            string2 = FileChunk.startsWith((int)(-10 - -18), (String)"+LR_!U#DUH(^QA^X\\$a~r~sztimgy)SUA4(picmduhgaxh4").replace("{encmethod}", CupertinoEncInfo.encMethodToString(cupertinoEncInfo.getEncMethod())) + (String)object + "\n";
            String string3 = "?";
            if (string.indexOf("?") >= 0) {
                string3 = "&";
            }
            string2 = string2.replace(FileChunk.startsWith((int)(714 / 189), (String)"xakelmp\u007fy`p"), string + string3 + FileChunk.startsWith((int)(47 * 51), (String)"&/*%3;>"));
        }
        if (!CupertinoEncInfo.isMethodReportedWithPlayReadyHeader(n)) return string2;
        string = cupertinoEncInfo.getEncPlayReadyHeader();
        if (string == null) {
            return string2;
        }
        string2 = "";
        object = cupertinoEncInfo.getEncIVBytes();
        if (object == null) return string2 + Base64.replace((String)"&C_\\$R&ECG\"@CZWF/mgtxcIy|zfHdcgaw{", (int)(973 / 172)).replace("{playReadyHeader}", string) + "\n";
        string2 = string2 + FileChunk.startsWith((int)(-47 - -23), (String)"k\f\u0012\u001fa\u0015c\u0004\u0015\bh\u007f\u001d\u0003kg ") + BufferUtils.encodeHexString((byte[])object) + "\n";
        return string2 + Base64.replace((String)"&C_\\$R&ECG\"@CZWF/mgtxcIy|zfHdcgaw{", (int)(973 / 172)).replace("{playReadyHeader}", string) + "\n";
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPlaylistStr(boolean bl) {
        this.init();
        StringBuffer stringBuffer = new StringBuffer();
        String string = Math.round(this.chunkDurationTarget / 1000) + "";
        int n = 3;
        if (this.appContext != null && this.appContext instanceof HTTPStreamerApplicationContextCupertinoStreamer) {
            n = ((HTTPStreamerApplicationContextCupertinoStreamer)this.appContext).getExtXVersion();
        }
        stringBuffer.append(Base64.replace((String)" A]RJ;\\\u0000", (int)(845 / 241)));
        if (n > 0) {
            stringBuffer.append(Base64.replace((String)"%BP]'S![K]CX]].nsol4b6jxll).,>", (int)(35 + 3)).replace("{ext-x-version}", n + "") + "\n");
        }
        long l = 10L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {}
        long l2 = 0L;
        Iterator<IHTTPStreamerCupertinoIndexItem> iterator = this.items.iterator();
        if (this.items.size() > 0) {
            l2 = this.items.get(0).getStartTimecode();
        }
        while (iterator.hasNext()) {
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = iterator.next();
            int n2 = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l2) / 1000.0);
            if (n2 <= 0) {
                n2 = 1;
            }
            if ((long)n2 > l) {
                l = n2;
            }
            l2 += (long)(n2 * 1000);
        }
        stringBuffer.append(Base64.replace((String)"%BP]'S!YO]WTFWAGWCQVT!", (int)(18 + 116)) + l + "" + "\n");
        stringBuffer.append(Base64.replace((String)"(IUZ\"H<_VP\\W:K\\KNYS]Z:0\b", (int)(116 + -105)));
        String string2 = "";
        String string3 = Base64.replace((String)"qxzva", (int)(6 + 22));
        long l3 = 0L;
        long l4 = 0L;
        Iterator<IHTTPStreamerCupertinoIndexItem> iterator2 = this.items.iterator();
        if (this.items.size() > 0) {
            l3 = this.items.get(0).getStartTimecode();
        }
        while (true) {
            int n3;
            if (!iterator2.hasNext()) {
                stringBuffer.append(FileChunk.startsWith((int)(5 * 61), (String)"2WK@8N:]W^WUNJ\u0015"));
                return stringBuffer.toString();
            }
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem = iterator2.next();
            String string4 = this.a(iHTTPStreamerCupertinoIndexItem);
            if (string4 != null && !string4.equals(string2)) {
                stringBuffer.append(string4);
                string2 = string4;
            }
            if ((n3 = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l3) / 1000.0)) <= 0) {
                n3 = 1;
            }
            l3 += (long)(n3 * 1000);
            ++l4;
            String string5 = this.relativePlaylistItems ? Base64.replace((String)",>06>2<3:=~921 4>5", (int)(3 * 29)) : Base64.replace((String)"x`jkfagw$wl~\u007f|xqr`|yye6azlmWqsucmg`{(sz~yilcr?jtzxpxvu|g$glkz28?", (int)(723 / 196));
            int n4 = this.streamMode;
            if (bl) {
                switch (this.audioCodec) {
                    case 1: {
                        n4 = 4;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 10: {
                        n4 = 3;
                        break;
                    }
                }
            }
            stringBuffer.append(Base64.replace((String)"8YEJVNG8", (int)(37 * 63)) + n3 + "," + this.titleStr + "\n");
            stringBuffer.append(string5.replace(Base64.replace((String)"(2<:2687>!", (int)(55 * 37)), "{mediaName}{bitrate}_{index}{ext}".replace(FileChunk.startsWith((int)(733 / 165), (String)"\u007fhccahDjahs"), string3).replace(Base64.replace((String)"}nfmosq", (int)(1614 / 250)), l4 + "")).replace(Base64.replace((String)"(1-\"*", (int)(-7 - 6)), LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(n4)) + "\n");
        }
    }

    @Override
    public int addIndexItem(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        this.items.add(iHTTPStreamerCupertinoIndexItem);
        return this.items.size() - 1;
    }

    @Override
    public int getIndexCount() {
        return this.items.size();
    }

    @Override
    public IHTTPStreamerCupertinoIndexItem getIndexItem(int n) {
        if (n >= this.items.size()) {
            return null;
        }
        return this.items.get(n);
    }

    @Override
    public String getTitleStr() {
        return this.titleStr;
    }

    @Override
    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDoEncryption() {
        if (this.encInfo == null) return false;
        return true;
    }

    @Override
    public CupertinoEncInfo getEncInfo() {
        return this.encInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getEncURL() {
        if (this.encInfo == null) {
            return null;
        }
        String string = this.encInfo.getEncUrl();
        return string;
    }

    @Override
    public IHTTPStreamerSession getHttpStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int getStreamMode() {
        return this.streamMode;
    }

    @Override
    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    @Override
    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    @Override
    public int getID3Bitrate(boolean bl) {
        return 0;
    }

    @Override
    public void setAudioBitrate(int n) {
        this.audioBitrate = n;
    }

    @Override
    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    @Override
    public void setVideoBitrate(int n) {
        this.videoBitrate = n;
    }

    @Override
    public int getAudioCodec() {
        return this.audioCodec;
    }

    @Override
    public void setAudioCodec(int n) {
        this.audioCodec = n;
    }

    @Override
    public ID3Frames getID3FramesHeader() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooter() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesHeaderAudio() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooterAudio() {
        return null;
    }

    @Override
    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    @Override
    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getCodecsStr() {
        String string = null;
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        String string2 = hTTPStreamerCupertinoIndexBase.a(hTTPStreamerCupertinoIndexBase.codecInfoAudio);
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase2 = this;
        String string3 = hTTPStreamerCupertinoIndexBase2.a(hTTPStreamerCupertinoIndexBase2.codecInfoVideo);
        if (string3 != null && string2 != null) {
            return string3 + Base64.replace((String)"mb", (int)(19 * 59)) + string2;
        }
        if (string3 != null) {
            return string3;
        }
        if (string2 == null) return null;
        return string2;
    }

    @Override
    public String getCodecsAudioStr() {
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        return hTTPStreamerCupertinoIndexBase.a(hTTPStreamerCupertinoIndexBase.codecInfoAudio);
    }

    @Override
    public String getResolutionStr() {
        HTTPStreamerCupertinoIndexBase hTTPStreamerCupertinoIndexBase = this;
        return hTTPStreamerCupertinoIndexBase.b(hTTPStreamerCupertinoIndexBase.codecInfoVideo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 10: {
                if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
                return FileChunk.startsWith((int)(11 + 11), (String)"{g,x4/,3") + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 2: 
        }
        return Base64.replace((String)"kw<h$?<#", (int)(398 / 59)) + mediaCodecInfoAudio.getAudioObjectType();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String a(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            default: {
                return string;
            }
            case 7: 
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return Base64.replace((String)"cug4(", (int)(45 + 117)) + n2 + "." + n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String b(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double d) {
        this.duration = d;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public long getPlayStart() {
        return this.playStart;
    }

    @Override
    public void setPlayStart(long l) {
        this.playStart = l;
    }

    @Override
    public long getPlayDuration() {
        return this.playDuration;
    }

    @Override
    public void setPlayDuration(long l) {
        this.playDuration = l;
    }

    @Override
    public abstract void fillChunk(IHTTPStreamerCupertinoIndexItem var1, LiveStreamPacketizerCupertinoChunk var2, boolean var3);
}

