/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.medialist.MediaList;
import com.wowza.wms.medialist.MediaListSegment;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupMember;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupRediness;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscoderStreamNameGroup {
    public static final int STATE_PREINIT = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_SHUTDOWN = 3;
    protected Object lock = new Object();
    protected String name = "";
    protected List<TranscoderStreamNameGroupMember> members = new ArrayList<TranscoderStreamNameGroupMember>();
    protected MediaList mediaList = new MediaList();
    protected MediaStreamMapGroup nameGroup = null;
    protected MediaListSegment mediaListSegment = new MediaListSegment();
    protected LiveStreamTranscoder liveStreamTranscoder = null;
    protected TranscoderStream transcodingStream = null;
    protected int lifecycle = 1;
    protected boolean isSent = false;

    public TranscoderStreamNameGroup() {
        this.mediaList.addSegment(this.mediaListSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(LiveStreamTranscoder liveStreamTranscoder) {
        int n;
        Object object = this.lock;
        synchronized (object) {
            if (this.isSent) return;
            if (this.lifecycle != 2) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            LiveStreamTranscoder liveStreamTranscoder2 = liveStreamTranscoder;
            this.validateMemberCodec(liveStreamTranscoder2, liveStreamTranscoder2.getTranscodingStream());
            n = 0;
        }
        synchronized (this.lock) {
            block13: {
                n = this.members.size();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (n > 0) break block13;
                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.split((int)(27 * 3), (String)"\u0005 2:&58<<(\b(/;>-\u000f#.!\u00024(=9d*()\u0007!$4 =59\r") + liveStreamTranscoder.getContextStr() + Base64.lastIndexOf((String)"\rkr\u001d583w?+5.,})>s!llp%gclln',dz/yb2vyebn\"9", (int)(84 + 28)) + this.getName());
                return;
            }
            this.addInternal(liveStreamTranscoder);
            boolean bl = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.lifecycle == 2) {
                    this.isSent = true;
                } else {
                    bl = true;
                }
            }
            if (!bl) return;
            this.removeInternal(liveStreamTranscoder);
            return;
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = new MediaStreamMapGroup();
        mediaStreamMapGroup.setName(this.name);
        mediaStreamMapGroup.setMediaList(this.mediaList);
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            arrayList.addAll(this.members);
        }
        for (Object object : arrayList) {
            String string = ((TranscoderStreamNameGroupMember)object).getName();
            mediaStreamMapGroup.add(string);
        }
        mediaStreamMap.addNameGroup(mediaStreamMapGroup);
        synchronized (this.lock) {
            this.nameGroup = mediaStreamMapGroup;
            // ** MonitorExit[var7_8] (shouldn't be in output)
            liveStreamTranscoder.notifyRegisterStreamNameGroup(this);
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(FileChunk.split((int)(-26 + 108), (String)"\u0006!5;%47=?)\u000f),:!,\f\") \u00015'<:e-)*\u0006>%7!:4:\f") + liveStreamTranscoder.getContextStr() + Base64.lastIndexOf((String)"G!<\\z{ ocna%aug|z1,", (int)(8 - -18)) + mediaStreamMapGroup.getName());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = null;
        Object object = this.lock;
        synchronized (object) {
            mediaStreamMapGroup = this.nameGroup;
            this.nameGroup = null;
        }
        if (mediaStreamMapGroup == null) return;
        mediaStreamMap.removeNameGroup(mediaStreamMapGroup);
        liveStreamTranscoder.notifyUnregisterStreamNameGroup(this);
        WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(FileChunk.split((int)(-60 - 22), (String)"Z}q\u007fap{qseKmh~}pP~-$\u00051+06i:,'$:(\u0007!$4 =59\r") + liveStreamTranscoder.getContextStr() + Base64.lastIndexOf((String)"Q7.]u|}eq5xvu|:|nrkoza", (int)(13 - -31)) + mediaStreamMapGroup.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        this.liveStreamTranscoder = liveStreamTranscoder;
        this.transcodingStream = transcoderStream;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Base64.lastIndexOf((String)"Ze~~nk\\dcwry[wz}", (int)(-63 - 56)), liveStreamTranscoder.getStreamName());
        this.name = SystemUtils.expandEnvironmentVariables((String)this.name, hashMap);
        this.validateMembers(liveStreamTranscoder, transcoderStream);
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(LiveStreamTranscoder liveStreamTranscoder) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 3;
            if (this.isSent) {
                this.isSent = false;
                bl = true;
            }
        }
        if (!bl) return;
        this.removeInternal(liveStreamTranscoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkRediness(TranscoderStreamNameGroupRediness transcoderStreamNameGroupRediness) {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (!this.isSent) {
                arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
                arrayList.addAll(this.members);
            }
        }
        if (arrayList == null) {
            return;
        }
        if (arrayList.size() <= 0) {
            return;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TranscoderStreamNameGroupMember transcoderStreamNameGroupMember = (TranscoderStreamNameGroupMember)iterator.next();
            transcoderStreamNameGroupMember.checkRediness(transcoderStreamNameGroupRediness, this.liveStreamTranscoder, this.transcodingStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void validateMemberCodec(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        block17: {
            block25: {
                block20: {
                    block22: {
                        block21: {
                            block18: {
                                block19: {
                                    block23: {
                                        block24: {
                                            break block24;
                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.split((int)(7 * 19), (String)"Qtffzidhh|\\dcwry[wz}^htim0iamkgeqcJmdhn~~U") + var1_1.getContextStr() + FileChunk.split((int)(827 / 163), (String)"X<'[}xnm`@n}tUa{`fL") + var5_5.getName() + Base64.lastIndexOf((String)"X&qamod,nakur2zg5xxl9lzptz?fnp#jdkb(nxdy}4/", (int)(1276 / 221)) + FLVUtils.videoCodecToString((int)var7_8) + Base64.lastIndexOf((String)"&/", (int)(1603 / 244)) + var8_9 + ")");
                                                var6_7 = true;
                                                ** GOTO lbl30
                                                break;
                                            }
lbl5:
                                            // 1 sources

                                            while (true) {
                                                var8_9 = FileChunk.split((int)(1317 / 218), (String)"sicge|b");
                                                break block17;
                                                break;
                                            }
lbl8:
                                            // 1 sources

                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.lastIndexOf((String)"Y|n~bq|ppdDlk\u007fzqS\u007fr%\u00060,15h1)%#/-9+\u00025<06&&\r", (int)(-30 + 75)) + var1_1.getContextStr() + FileChunk.split((int)(123 + 92), (String)"\nby\t/.8?2\u000e /&\u00037)28\u0012") + var5_5.getName() + FileChunk.split((int)(111 + 108), (String)"\u0006|<+;).b +!#$h 9k\"\":o&0>:0u08*y4:18~8rnws>%") + FLVUtils.audioCodecToString((int)var7_8) + Base64.lastIndexOf((String)"le", (int)(60 + 16)) + var8_9 + ")");
                                                var6_7 = true;
                                                break block18;
                                                break;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                while (true) {
                                                    var3_3.addAll(this.members);
                                                    break block19;
                                                    break;
                                                }
                                            }
                                        }
                                        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
                                        var4_4 = this.lock;
                                        synchronized (var4_4) {
                                            ** continue;
                                        }
lbl22:
                                        // 4 sources

                                        while (true) {
                                            if (!var5_5.isVideo) ** GOTO lbl30
                                            break block20;
lbl25:
                                            // 3 sources

                                            while (var4_4.hasNext()) {
                                                break block21;
                                            }
                                            break block22;
                                            break;
                                        }
lbl28:
                                        // 2 sources

                                        while (true) {
                                            if (var7_8 != 7) ** continue;
lbl30:
                                            // 3 sources

                                            if (!var6_7) ** GOTO lbl25
                                            break block23;
                                            break;
                                        }
lbl32:
                                        // 1 sources

                                        throw var5_6;
lbl34:
                                        // 1 sources

                                        while (true) {
                                            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.split((int)(1288 / 238), (String)"Qtffzidhh|\\dcwry[wz}^htim0iamkgeqcJmdhn~~U") + var1_1.getContextStr() + FileChunk.split((int)(103 + 51), (String)"G!<Njme`oMehc@zf\u007f{W") + var5_5.getName() + Base64.lastIndexOf((String)"\fr2!1?8x:5?9>~6s!llp%pfd`n+jb|/~p\u007fv4rdxmi ;", (int)(60 + 53)) + FLVUtils.audioCodecToString((int)var7_8) + Base64.lastIndexOf((String)"$-", (int)(260 / 56)) + var8_9 + ")");
                                            var6_7 = true;
                                            ** GOTO lbl22
                                            break;
                                        }
lbl38:
                                        // 1 sources

                                        while (true) {
                                            if (var7_8 != 2) {
                                                ** continue;
                                            }
                                            break block18;
                                            break;
                                        }
                                    }
                                    this.removeMember(var5_5);
                                    ** GOTO lbl25
lbl46:
                                    // 1 sources

                                    while (true) {
                                        if (Base64.lastIndexOf((String)"3/4`,74+53", (int)(30 - 32)).equals(var8_9)) ** GOTO lbl22
                                        ** continue;
                                        break;
                                    }
                                }
                                var4_4 = var3_3.iterator();
                                ** GOTO lbl25
                            }
lbl53:
                            // 2 sources

                            while (true) {
                                if (var7_8 != 2) ** GOTO lbl22
                                ** continue;
                                break;
                            }
                            {
                                catch (Throwable var5_6) {
                                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl54 : MonitorExitStatement: MONITOREXIT : var4_4
                                    ** continue;
                                }
                            }
                        }
                        var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                        var6_7 = false;
                        if (var5_5.isAudio) ** break;
                        ** while (true)
                        break block25;
                    }
                    return;
lbl67:
                    // 1 sources

                    while (true) {
                        var8_9 = Base64.lastIndexOf((String)"\"6244+3", (int)(5 + 114));
                        ** GOTO lbl28
                        break;
                    }
                }
                var7_8 = var5_5.geVideoCodec(var1_1, var2_2);
                var8_9 = var5_5.getMediaListRendition().getVideoCodecId();
                if (var8_9 == null) ** break;
                ** while (true)
                ** while (true)
            }
            var7_8 = var5_5.getAudioCodec(var1_1, var2_2);
            ** while ((var8_9 = var5_5.getMediaListRendition().getAudioCodecId()) == null)
        }
        ** while (var7_8 == 10)
lbl81:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateMembers(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
        var4_4 = this.lock;
        synchronized (var4_4) {
            var3_3.addAll(this.members);
        }
        var4_4 = var3_3.iterator();
        ** GOTO lbl29
        while (true) {
            var9_10 = this.lock;
            synchronized (var9_10) {
                if (var7_8.isAudioDisable()) {
                    var5_5.isAudio = false;
                }
                if (var7_8.isVideoDisable()) {
                    var5_5.isVideo = false;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var9_10
                if (true) ** GOTO lbl29
            }
            break;
        }
        while (true) {
            if (var7_8 != null && var8_9 != null) ** continue;
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.lastIndexOf((String)"AdvvjytxxlLtsgbiKgjmNxdy} yq}{wuasZ}tx~nnE", (int)(9 * 45)) + var1_1.getContextStr() + FileChunk.split((int)(30 + 23), (String)"H,7Kmh~}pP~-$\u00051+06g%,'))?n+?4!s::\"w=!3((}71`\u0004, +!#4h%#88wn") + var6_7);
            this.removeMember(var5_5);
lbl29:
            // 4 sources

            while (var4_4.hasNext() != false) {
                var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                var6_7 = var5_5.getName();
                var7_8 = var2_2.getDestination(var6_7);
                var8_9 = var1_1.getTranscodingSession().getSessionDestination(var6_7);
                if (var7_8 == null || var7_8.isEnable()) ** continue;
                this.removeMember(var5_5);
            }
            return;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMemberCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.members.size();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName(String string) {
        String string2 = this.getName();
        if (string2 != null) return string2.replace(Base64.lastIndexOf((String)"x&\r0usafWqtbidDjahs", (int)(-43 - -39)), string);
        string2 = FileChunk.split((int)(41 - -12), (String)"1mDwlhxyNjm% /\r%(#:\u0017") + this.name;
        return string2.replace(Base64.lastIndexOf((String)"x&\r0usafWqtbidDjahs", (int)(-43 - -39)), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.name = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        Object object = this.lock;
        synchronized (object) {
            this.members.add(transcoderStreamNameGroupMember);
            transcoderStreamNameGroupMember.setLock(this.lock);
            this.mediaListSegment.addRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamNameGroupMember removeMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        TranscoderStreamNameGroupMember transcoderStreamNameGroupMember2 = null;
        Object object = this.lock;
        synchronized (object) {
            this.members.remove(transcoderStreamNameGroupMember);
            this.mediaListSegment.removeRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return transcoderStreamNameGroupMember2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TranscoderStreamNameGroupMember> getMembers() {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.members);
            return arrayList;
        }
    }
}

