/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.Serializable;
import java.util.Arrays;

public class ExpiringStack
implements Serializable {
    private static final long serialVersionUID = 3546919169401434168L;
    private static final int DEFAULT_CAPACITY = 4;
    private Object[] items = new Object[4];
    private long[] timestamps = new long[4];
    private int size = 0;

    public void clear() {
        Arrays.fill(this.items, null);
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        int n = this.size - 1;
        Object object = this.items[n];
        this.items[n] = null;
        --this.size;
        return object;
    }

    public void push(Object object) {
        if (this.size == this.items.length) {
            int n = this.items.length;
            Object[] objectArray = new Object[n * 2];
            System.arraycopy(this.items, 0, objectArray, 0, this.size);
            long[] lArray = new long[n * 2];
            System.arraycopy(this.timestamps, 0, lArray, 0, this.size);
            this.items = objectArray;
            this.timestamps = lArray;
        }
        this.items[this.size] = object;
        this.timestamps[this.size] = System.currentTimeMillis();
        ++this.size;
    }

    public void remove(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != object) continue;
            System.arraycopy(this.items, i + 1, this.items, i, this.size - i - 1);
            System.arraycopy(this.timestamps, i + 1, this.timestamps, i, this.size - i - 1);
            this.items[this.size - 1] = null;
            --this.size;
            break;
        }
    }

    public void expireBefore(long l) {
        int n;
        for (n = 0; n < this.size && this.timestamps[n] < l; ++n) {
        }
        if (n > 0) {
            this.size -= n;
            System.arraycopy(this.items, n, this.items, 0, this.size);
            System.arraycopy(this.timestamps, n, this.timestamps, 0, this.size);
            Arrays.fill(this.items, this.size, this.items.length, null);
        }
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.size - 1];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

