/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCodecConfig;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTCO;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSC;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSZ;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTWriterContextTrack {
    public static final int TRACK_UNKNOWN = -1;
    public static final int TRACK_VIDEO = 0;
    public static final int TRACK_AUDIO = 1;
    public static final int TRACK_DATA = 2;
    public static final int SAMPLE_UNKNOWN = -1;
    public static final int SAMPLE_H264 = 0;
    public static final int SAMPLE_AAC = 1;
    public static final int SAMPLE_MP3 = 2;
    public static final int SAMPLE_AMF0 = 3;
    public static final int SAMPLE_AMF3 = 4;
    public static final String DATATYPE_AMF0 = "amf0";
    public static final String DATATYPE_AMF3 = "amf3";
    private int a = -1;
    private int b = -1;
    private int c = -1;
    private int d = 0;
    private QTWriterContext e = null;
    private long f = 90000L;
    private long g = 0L;
    private long h = 0L;
    private long i = 0L;
    private long j = 0L;
    private long k = 0L;
    private long l = -1L;
    private long m = 0L;
    private long n = -1L;
    private List<PacketHolder> o = new ArrayList<PacketHolder>();
    private QTWriterTmpItem p = null;
    private long q = -1L;
    private long r = 0L;
    private long s = 0L;
    private QTWriterContextTrackCTTS t = null;
    private QTWriterContextTrackSTCO u = null;
    private QTWriterContextTrackSTSC v = null;
    private QTWriterContextTrackSTSS w = null;
    private QTWriterContextTrackSTSZ x = null;
    private QTWriterContextTrackSTTS y = null;
    private List<QTWriterContextTrackCodecConfig> z = new ArrayList<QTWriterContextTrackCodecConfig>();

    /*
     * Enabled aggressive block sorting
     */
    public QTWriterContextTrack(QTWriterContext qTWriterContext, int n) {
        this.e = qTWriterContext;
        this.c = n;
        switch (this.c) {
            case 1: {
                this.d = 1;
                break;
            }
            case 0: {
                this.d = 0;
                break;
            }
            case 2: {
                this.d = 3;
                break;
            }
        }
        this.t = new QTWriterContextTrackCTTS(this);
        this.u = new QTWriterContextTrackSTCO(this);
        this.v = new QTWriterContextTrackSTSC(this);
        this.w = new QTWriterContextTrackSTSS(this);
        this.x = new QTWriterContextTrackSTSZ(this);
        this.y = new QTWriterContextTrackSTTS(this);
    }

    public int getCodecConfigCount() {
        int n = 0;
        Iterator<QTWriterContextTrackCodecConfig> iterator = this.z.iterator();
        while (iterator.hasNext()) {
            QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = iterator.next();
            n += qTWriterContextTrackCodecConfig.getItemCount();
        }
        return n;
    }

    public List<QTWriterContextTrackCodecConfig> getCodecConfigs() {
        ArrayList<QTWriterContextTrackCodecConfig> arrayList = new ArrayList<QTWriterContextTrackCodecConfig>();
        arrayList.addAll(this.z);
        return arrayList;
    }

    public void addCodecConfig(QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig) {
        this.z.add(qTWriterContextTrackCodecConfig);
    }

    public QTWriterContextTrackCTTS getCTTS() {
        return this.t;
    }

    public QTWriterContextTrackSTCO getSTCO() {
        return this.u;
    }

    public QTWriterContextTrackSTSC getSTSC() {
        return this.v;
    }

    public QTWriterContextTrackSTSS getSTSS() {
        return this.w;
    }

    public QTWriterContextTrackSTSZ getSTSZ() {
        return this.x;
    }

    public QTWriterContextTrackSTTS getSTTS() {
        return this.y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVideo() {
        if (this.c != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAudio() {
        if (this.c != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isData() {
        if (this.c != 2) return false;
        return true;
    }

    public int getTrackType() {
        return this.c;
    }

    public void setTrackType(int n) {
        this.c = n;
    }

    public QTWriterContext getContext() {
        return this.e;
    }

    public void setContext(QTWriterContext qTWriterContext) {
        this.e = qTWriterContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getOnTimeCoordInfoPacket(double d) {
        byte[] byArray = null;
        try {
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataObj.put(Base64.lastIndexOf((String)"$,+?:1p?=snnvp`", (int)(13 * 19)), (AMFData)new AMFDataItem(d));
            AMFDataList aMFDataList = new AMFDataList();
            aMFDataList.add((AMFData)new AMFDataItem(FileChunk.split((int)(63 + -24), (String)"hf]cfiNa`bu[}rz")));
            aMFDataList.add((AMFData)aMFDataObj);
            return aMFDataList.serialize(0);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(Base64.lastIndexOf((String)"\u0013\u0017\u00137/3-;\t$\"9+7$\u0005 27>x0=-\u00155\b43:Cnmq`LhagYkhghzT", (int)(-62 - -32)) + this.e.getOutPath() + FileChunk.split((int)(-40 - 42), (String)"4xbxfvI/6") + exception.toString());
            return byArray;
        }
    }

    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l) {
        this.addPacket(randomAccessFile, byArray, n, n2, bl, l, 0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l, long l2) {
        this.o.add(new PacketHolder(byArray, n, n2));
        long l3 = l * this.e.getTimescale() / this.f;
        this.e.addPacket(randomAccessFile, n2, l3);
        if (bl) {
            this.w.addSyncSample(this.r + this.k + 1L);
        }
        this.x.addSize(n2);
        this.t.addOffset(l2);
        if (this.l != -1L) {
            if (this.k != 1L) {
                this.n = l - this.l;
                this.y.addDuration(this.n);
            } else {
                this.y.addDuration(l);
            }
        }
        this.m = this.l = l;
        ++this.k;
    }

    /*
     * Unable to fully structure code
     */
    public void flush(RandomAccessFile var1_1, boolean var2_2) {
        block15: {
            block12: {
                block13: {
                    block11: {
                        block14: {
                            if (this.o.size() <= 0) break block13;
                            break block14;
lbl3:
                            // 1 sources

                            while (this.n != -1L) {
                                break block11;
lbl5:
                                // 2 sources

                                return;
                            }
                            break block15;
lbl8:
                            // 1 sources

                            while (true) {
                                var3_3 = var1_1.getFilePointer();
lbl11:
                                // 2 sources

                                while (true) {
                                    this.u.addOffset(var3_3);
                                    this.v.addChunk(this.s + this.g + 1L, this.o.size(), this.z.size());
                                    var5_5 = this.o.iterator();
                                    break block12;
                                    break;
                                }
                                break;
                            }
                        }
                        var3_3 = 0L;
                        ** while (true)
                    }
                    this.y.addDuration(this.n);
                    this.m += this.n;
lbl22:
                    // 2 sources

                    while (true) {
                        this.t.flush();
                        this.u.flush();
                        this.v.flush();
                        this.w.flush();
                        this.x.flush();
                        this.y.flush();
                        ** GOTO lbl5
                        break;
                    }
lbl30:
                    // 1 sources

                    while (true) {
                        ++this.g;
                        this.o.clear();
                        break block13;
                        break;
                    }
lbl34:
                    // 1 sources

                    while (true) {
                        continue;
                        break;
                    }
                    catch (Exception var5_4) {
                        WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(FileChunk.split((int)(6 + 11), (String)"@FDf|brjZuuhxfkTsc`o+`k}zbP") + this.e.getOutPath() + FileChunk.split((int)(41 * 63), (String)"-\u007f|n]uq{Oohlwaw[=(") + var5_4.toString());
                        ** continue;
                    }
                    var6_6 = var5_5.next();
                    try {
                        var1_1.write(var6_6.buffer, var6_6.offset, var6_6.size);
                    }
                    catch (Exception var7_7) {
                        WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(FileChunk.split((int)(48 + 124), (String)"]YY}yewaWzxc}anOn|}tn'.67-\u001d") + this.e.getOutPath() + FileChunk.split((int)(41 + -3), (String)"<pz`~nQ7.") + var7_7.toString());
                    }
                }
                if (var2_2) ** break;
                ** while (true)
                ** GOTO lbl3
            }
            ** while (!var5_5.hasNext())
lbl51:
            // 1 sources

            ** while (true)
        }
        this.y.addDuration(0L);
        ** while (true)
    }

    public long getDuration() {
        long l = this.e.getAppendDuration();
        l = l * this.f / this.e.getTimescale();
        return l + this.m;
    }

    public long getDuration(long l) {
        return this.getDuration() * l / this.f;
    }

    public long getTimescale() {
        return this.f;
    }

    public void setTimescale(long l) {
        this.f = l;
    }

    public long millisToTimecode(long l) {
        return l * this.f / 1000L;
    }

    public long getTotalSampleCount() {
        return this.r + this.k;
    }

    public long getSampleCount() {
        return this.k;
    }

    public int getSampleType() {
        return this.d;
    }

    public void setSampleType(int n) {
        this.d = n;
    }

    public long getAudESDSBufferSize() {
        return this.h;
    }

    public void setAudESDSBufferSize(long l) {
        this.h = l;
    }

    public long getAudESDSMaxRate() {
        return this.i;
    }

    public void setAudESDSMaxRate(long l) {
        this.i = l;
    }

    public long getAudESDSAvgRate() {
        return this.j;
    }

    public void setAudESDSAvgRate(long l) {
        this.j = l;
    }

    public void setWidth(int n) {
        this.a = n;
    }

    public void setHeight(int n) {
        this.b = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getWidth() {
        QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig;
        if (this.a >= 0) {
            return this.a;
        }
        int n = 0;
        Iterator<QTWriterContextTrackCodecConfig> iterator = this.z.iterator();
        do {
            if (!iterator.hasNext()) return n;
        } while ((qTWriterContextTrackCodecConfig = iterator.next()).getVideoWidth() < 0);
        return qTWriterContextTrackCodecConfig.getVideoWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getHeight() {
        QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig;
        if (this.b >= 0) {
            return this.b;
        }
        int n = 0;
        Iterator<QTWriterContextTrackCodecConfig> iterator = this.z.iterator();
        do {
            if (!iterator.hasNext()) return n;
        } while ((qTWriterContextTrackCodecConfig = iterator.next()).getVideoWidth() < 0);
        return qTWriterContextTrackCodecConfig.getVideoHeight();
    }

    public QTWriterTmpItem getTrakAtomTmpItem() {
        return this.p;
    }

    public void setTrakAtomTmpItem(QTWriterTmpItem qTWriterTmpItem) {
        this.p = qTWriterTmpItem;
    }

    public long getAppendDuration() {
        return this.q;
    }

    public void setAppendDuration(long l) {
        this.q = l;
    }

    public long getAppendSampleCount() {
        return this.r;
    }

    public void setAppendSampleCount(long l) {
        this.r = l;
    }

    public long getAppendChunkCount() {
        return this.s;
    }

    public void setAppendChunkCount(long l) {
        this.s = l;
    }

    class PacketHolder {
        public byte[] buffer = null;
        public int offset = 0;
        public int size = 0;

        public PacketHolder(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.offset = n;
            this.size = n2;
        }
    }
}

