/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.ByteOrder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.support.BaseByteBuffer;
import org.apache.mina.util.ExpiringStack;

public class PooledByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;
    private static int threadId = 0;
    private final Expirer expirer;
    private final ExpiringStack[] heapBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private final ExpiringStack[] directBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private int timeout;
    private boolean disposed;

    public PooledByteBufferAllocator() {
        this(60);
    }

    public PooledByteBufferAllocator(int n) {
        this.setTimeout(n);
        this.expirer = new Expirer();
        this.expirer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ExpiringStack expiringStack;
        ExpiringStack expiringStack2;
        int n;
        if (this == ByteBuffer.getAllocator()) {
            throw new IllegalStateException("This allocator is in use.");
        }
        this.expirer.shutdown();
        for (n = this.directBufferStacks.length - 1; n >= 0; --n) {
            expiringStack = expiringStack2 = this.directBufferStacks[n];
            synchronized (expiringStack) {
                expiringStack2.clear();
                continue;
            }
        }
        for (n = this.heapBufferStacks.length - 1; n >= 0; --n) {
            expiringStack = expiringStack2 = this.heapBufferStacks[n];
            synchronized (expiringStack) {
                expiringStack2.clear();
                continue;
            }
        }
        this.disposed = true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMillis() {
        return (long)this.timeout * 1000L;
    }

    public void setTimeout(int n) {
        if (n < 0) {
            n = 0;
        }
        this.timeout = n;
        if (n > 0) {
            // empty if block
        }
    }

    public ByteBuffer allocate(int n, boolean bl) {
        this.ensureNotDisposed();
        UnexpandableByteBuffer unexpandableByteBuffer = this.allocate0(n, bl);
        PooledByteBuffer pooledByteBuffer = this.allocateContainer();
        pooledByteBuffer.init(unexpandableByteBuffer, true);
        return pooledByteBuffer;
    }

    private PooledByteBuffer allocateContainer() {
        return new PooledByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnexpandableByteBuffer allocate0(int n, boolean bl) {
        UnexpandableByteBuffer unexpandableByteBuffer;
        ExpiringStack[] expiringStackArray = bl ? this.directBufferStacks : this.heapBufferStacks;
        int n2 = this.getBufferStackIndex(expiringStackArray, n);
        ExpiringStack expiringStack = expiringStackArray[n2];
        Object object = expiringStack;
        synchronized (object) {
            unexpandableByteBuffer = (UnexpandableByteBuffer)expiringStack.pop();
        }
        if (unexpandableByteBuffer == null) {
            object = bl ? java.nio.ByteBuffer.allocateDirect(1 << n2) : java.nio.ByteBuffer.allocate(1 << n2);
            unexpandableByteBuffer = new UnexpandableByteBuffer((java.nio.ByteBuffer)object);
        }
        unexpandableByteBuffer.init();
        return unexpandableByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release0(UnexpandableByteBuffer unexpandableByteBuffer) {
        ExpiringStack expiringStack;
        ExpiringStack[] expiringStackArray = unexpandableByteBuffer.buf().isDirect() ? this.directBufferStacks : this.heapBufferStacks;
        ExpiringStack expiringStack2 = expiringStack = expiringStackArray[this.getBufferStackIndex(expiringStackArray, unexpandableByteBuffer.buf().capacity())];
        synchronized (expiringStack2) {
            expiringStack.push(unexpandableByteBuffer);
        }
    }

    public ByteBuffer wrap(java.nio.ByteBuffer byteBuffer) {
        this.ensureNotDisposed();
        PooledByteBuffer pooledByteBuffer = this.allocateContainer();
        pooledByteBuffer.init(new UnexpandableByteBuffer(byteBuffer), false);
        pooledByteBuffer.buf.init();
        pooledByteBuffer.setPooled(false);
        return pooledByteBuffer;
    }

    private int getBufferStackIndex(ExpiringStack[] expiringStackArray, int n) {
        int n2 = 0;
        for (int i = 1; n > i; i <<= 1) {
            if (++n2 < expiringStackArray.length) continue;
            throw new IllegalArgumentException("Buffer size is too big: " + n);
        }
        return n2;
    }

    private void ensureNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("This allocator is disposed already.");
        }
    }

    private class Expirer
    extends Thread {
        private boolean timeToStop;

        Expirer() {
            super("PooledByteBufferExpirer-" + threadId++);
            this.setDaemon(true);
        }

        public void shutdown() {
            this.timeToStop = true;
            this.interrupt();
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.timeToStop) {
                ExpiringStack expiringStack;
                ExpiringStack expiringStack2;
                int n;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = PooledByteBufferAllocator.this.getTimeoutMillis();
                if (l <= 0L) continue;
                long l2 = System.currentTimeMillis() - l;
                for (n = PooledByteBufferAllocator.this.directBufferStacks.length - 1; n >= 0; --n) {
                    expiringStack = expiringStack2 = PooledByteBufferAllocator.this.directBufferStacks[n];
                    synchronized (expiringStack) {
                        expiringStack2.expireBefore(l2);
                        continue;
                    }
                }
                for (n = PooledByteBufferAllocator.this.heapBufferStacks.length - 1; n >= 0; --n) {
                    expiringStack = expiringStack2 = PooledByteBufferAllocator.this.heapBufferStacks[n];
                    synchronized (expiringStack) {
                        expiringStack2.expireBefore(l2);
                        continue;
                    }
                }
            }
        }
    }

    private class PooledByteBuffer
    extends BaseByteBuffer {
        private UnexpandableByteBuffer buf;
        private int refCount = 1;
        private Object extra = null;

        protected PooledByteBuffer() {
        }

        public synchronized void init(UnexpandableByteBuffer unexpandableByteBuffer, boolean bl) {
            this.buf = unexpandableByteBuffer;
            if (bl) {
                unexpandableByteBuffer.buf().clear();
            }
            unexpandableByteBuffer.buf().order(ByteOrder.BIG_ENDIAN);
            this.setAutoExpand(false);
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            PooledByteBuffer pooledByteBuffer = this;
            synchronized (pooledByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (PooledByteBufferAllocator.this.disposed) {
                return;
            }
            this.buf.release();
        }

        public Object getExtra() {
            return this.extra;
        }

        public void setExtra(Object object) {
            this.extra = object;
        }

        public java.nio.ByteBuffer buf() {
            return this.buf.buf();
        }

        public boolean isPooled() {
            return this.buf.isPooled();
        }

        public void setPooled(boolean bl) {
            this.buf.setPooled(bl);
        }

        public ByteBuffer duplicate() {
            PooledByteBuffer pooledByteBuffer = PooledByteBufferAllocator.this.allocateContainer();
            pooledByteBuffer.init(new UnexpandableByteBuffer(this.buf().duplicate(), this.buf), false);
            return pooledByteBuffer;
        }

        public ByteBuffer slice() {
            PooledByteBuffer pooledByteBuffer = PooledByteBufferAllocator.this.allocateContainer();
            pooledByteBuffer.init(new UnexpandableByteBuffer(this.buf().slice(), this.buf), false);
            return pooledByteBuffer;
        }

        public ByteBuffer asReadOnlyBuffer() {
            PooledByteBuffer pooledByteBuffer = PooledByteBufferAllocator.this.allocateContainer();
            pooledByteBuffer.init(new UnexpandableByteBuffer(this.buf().asReadOnlyBuffer(), this.buf), false);
            return pooledByteBuffer;
        }

        public byte[] array() {
            return this.buf().array();
        }

        public int arrayOffset() {
            return this.buf().arrayOffset();
        }

        protected void capacity0(int n) {
            UnexpandableByteBuffer unexpandableByteBuffer;
            int n2;
            if (this.buf.isDerived()) {
                throw new IllegalStateException("Derived buffers cannot be expanded.");
            }
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            UnexpandableByteBuffer unexpandableByteBuffer2 = this.buf;
            boolean bl = this.isDirect();
            try {
                unexpandableByteBuffer = PooledByteBufferAllocator.this.allocate0(n2, bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (bl) {
                    unexpandableByteBuffer = PooledByteBufferAllocator.this.allocate0(n2, false);
                }
                throw outOfMemoryError;
            }
            unexpandableByteBuffer.buf().clear();
            unexpandableByteBuffer2.buf().clear();
            unexpandableByteBuffer.buf().put(unexpandableByteBuffer2.buf());
            this.buf = unexpandableByteBuffer;
            unexpandableByteBuffer2.release();
        }
    }

    private class UnexpandableByteBuffer {
        private final java.nio.ByteBuffer buf;
        private final UnexpandableByteBuffer parentBuf;
        private int refCount;
        private boolean pooled;

        protected UnexpandableByteBuffer(java.nio.ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
            this.parentBuf = null;
        }

        protected UnexpandableByteBuffer(java.nio.ByteBuffer byteBuffer, UnexpandableByteBuffer unexpandableByteBuffer) {
            unexpandableByteBuffer.acquire();
            this.buf = byteBuffer;
            this.parentBuf = unexpandableByteBuffer;
        }

        public void init() {
            this.refCount = 1;
            this.pooled = true;
        }

        public synchronized void acquire() {
            if (this.isDerived()) {
                this.parentBuf.acquire();
                return;
            }
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.isDerived()) {
                this.parentBuf.release();
                return;
            }
            UnexpandableByteBuffer unexpandableByteBuffer = this;
            synchronized (unexpandableByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (PooledByteBufferAllocator.this.disposed) {
                return;
            }
            if (this.pooled) {
                if (this.parentBuf != null) {
                    PooledByteBufferAllocator.this.release0(this.parentBuf);
                } else {
                    PooledByteBufferAllocator.this.release0(this);
                }
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return this.pooled;
        }

        public void setPooled(boolean bl) {
            this.pooled = bl;
        }

        public boolean isDerived() {
            return this.parentBuf != null;
        }
    }
}

